/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.enums.PrecisionAccountEnum;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;

public class OrderRepToInWareConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterConvert(e);
        String tgtMainType = this.getTgtMainType().toString();
        for (ExtendedDataEntity extendedDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType)) {
            DynamicObjectCollection rows = (DynamicObjectCollection)extendedDataEntity.getValue("billentry");
            ArrayList<DynamicObject> tgtList = new ArrayList<DynamicObject>(rows.getRowCount());
            for (DynamicObject row : rows) {
                String qualitystatus = row.getString("qualitystatus");
                if (StringUtils.isBlank((CharSequence)qualitystatus)) {
                    this.oneToMany(row, tgtList);
                    continue;
                }
                tgtList.add(row);
            }
            if (tgtList.size() <= 0) continue;
            rows.clear();
            for (DynamicObject tgt : tgtList) {
                rows.add((Object)tgt);
            }
        }
    }

    private void oneToMany(DynamicObject inWareRow, List<DynamicObject> tgtList) {
        boolean isNeedReplace;
        Long srcbillentryid = inWareRow.getLong("srcbillentryid");
        String srcBillEntry = inWareRow.getString("srcbillentity");
        DynamicObject material = inWareRow.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject masterId = material.getDynamicObject("masterid");
        inWareRow.set("unit", (Object)material.getDynamicObject("inventoryunit"));
        if (masterId.getDynamicObject("auxptyunit") != null) {
            inWareRow.set("unit2nd", (Object)masterId.getDynamicObject("auxptyunit"));
        }
        DynamicObject unit = inWareRow.getDynamicObject("unit");
        DynamicObject baseunit = inWareRow.getDynamicObject("baseunit");
        DynamicObject unit2nd = inWareRow.getDynamicObject("unit2nd");
        if (baseunit == null) {
            baseunit = masterId.getDynamicObject("baseunit");
            inWareRow.set("baseunit", (Object)baseunit);
        }
        if (0L == srcbillentryid) {
            return;
        }
        QFilter qFilter = new QFilter("sumentry.id", "=", (Object)srcbillentryid);
        String querySrcEntity = "pom_mftorderreport";
        if ("prop_mftorderreport".equals(srcBillEntry)) {
            querySrcEntity = srcBillEntry;
        }
        DynamicObject srcbillentry = BusinessDataServiceHelper.loadSingle((String)querySrcEntity, (String)"sumentry,sumentry.id,sumentry.qualifybsqty,sumentry.concesionbsqty,sumentry.qualifywareqty,sumentry.scrappedbsqty,sumentry.scrappedwareqty,sumentry.reworkbsqty,sumentry.repairbsqty,sumentry.unqualifywareqty", (QFilter[])new QFilter[]{qFilter});
        String invstatusEntityName = "bd_invstatus";
        long scrappedInvstatusId = 691928796160567296L;
        DynamicObject scrappedInvstatus = BusinessDataServiceHelper.loadSingleFromCache((Object)scrappedInvstatusId, (String)invstatusEntityName);
        DynamicObject unqualifiedInvstatus = BusinessDataServiceHelper.loadSingleFromCache((Object)1536101894978546688L, (String)invstatusEntityName);
        Map customs = this.getOption().getVariables();
        boolean bl = isNeedReplace = customs != null && !customs.isEmpty();
        if (srcbillentry == null && ("sfc_processreportbill".equals(srcBillEntry) || "prop_processreportbill".equals(srcBillEntry))) {
            DynamicObject tempRow;
            Map<String, Map<String, Object>> map = this.getBySfcReportMainBillEntryIds(srcBillEntry, Sets.newHashSet((Object[])new Long[]{srcbillentryid}));
            Map<String, Object> objectMap = map.get(srcbillentryid.toString());
            String manuentryid = inWareRow.getString("manuentryid");
            if (isNeedReplace && customs.get(manuentryid) != null) {
                String value = (String)customs.get(manuentryid);
                Map fieldAndValue = (Map)SerializationUtils.deSerializeFromBase64((String)value);
                this.replaceProcessFieldAndValue(fieldAndValue, objectMap);
            }
            BigDecimal qualifyqty3 = (BigDecimal)objectMap.get("qualifyqty3");
            BigDecimal badqualifyqty3 = (BigDecimal)objectMap.get("badqualifyqty3");
            BigDecimal scrapqty3 = (BigDecimal)objectMap.get("scrapqty3");
            BigDecimal qualifiedinqty3 = (BigDecimal)objectMap.get("qualifiedinqty3");
            BigDecimal badqualifiedinqty3 = (BigDecimal)objectMap.get("badqualifiedinqty3");
            BigDecimal scrapinqty3 = (BigDecimal)objectMap.get("scrapinqty3");
            if (qualifyqty3.compareTo(BigDecimal.ZERO) > 0) {
                tempRow = this.setTempRow(inWareRow, qualifyqty3, qualifiedinqty3, baseunit, masterId, unit, unit2nd, "A");
                tgtList.add(tempRow);
            }
            if (badqualifyqty3.compareTo(BigDecimal.ZERO) > 0) {
                tempRow = this.setTempRow(inWareRow, badqualifyqty3, badqualifiedinqty3, baseunit, masterId, unit, unit2nd, "B");
                tgtList.add(tempRow);
            }
            if (scrapqty3.compareTo(BigDecimal.ZERO) > 0) {
                tempRow = this.setTempRow(inWareRow, scrapqty3, scrapinqty3, baseunit, masterId, unit, unit2nd, "D");
                tempRow.set("invstatus", (Object)scrappedInvstatus);
                tgtList.add(tempRow);
            }
        } else if (srcbillentry == null && "sfc_protransferbill".equals(srcBillEntry)) {
            DynamicObject tempRow;
            Map<String, Map<String, Object>> map = this.getByProtransferMainBillEntryIds(Sets.newHashSet((Object[])new Long[]{srcbillentryid}));
            Map<String, Object> objectMap = map.get(srcbillentryid.toString());
            BigDecimal conformitybaseqty = (BigDecimal)objectMap.get("conformitybaseqty");
            BigDecimal badconformitybaseqty = (BigDecimal)objectMap.get("badconformitybaseqty");
            BigDecimal discardbaseqty = (BigDecimal)objectMap.get("discardbaseqty");
            BigDecimal qualifiedinbaseqty = (BigDecimal)objectMap.get("qualifiedinbaseqty");
            BigDecimal badqualifiedinbaseqty = (BigDecimal)objectMap.get("badqualifiedinbaseqty");
            BigDecimal scrapinbaseqty = (BigDecimal)objectMap.get("scrapinbaseqty");
            if (conformitybaseqty.compareTo(BigDecimal.ZERO) > 0) {
                tempRow = this.setTempRow(inWareRow, conformitybaseqty, qualifiedinbaseqty, baseunit, masterId, unit, unit2nd, "A");
                tgtList.add(tempRow);
            }
            if (badconformitybaseqty.compareTo(BigDecimal.ZERO) > 0) {
                tempRow = this.setTempRow(inWareRow, badconformitybaseqty, badqualifiedinbaseqty, baseunit, masterId, unit, unit2nd, "B");
                tgtList.add(tempRow);
            }
            if (discardbaseqty.compareTo(BigDecimal.ZERO) > 0) {
                tempRow = this.setTempRow(inWareRow, discardbaseqty, scrapinbaseqty, baseunit, masterId, unit, unit2nd, "D");
                tempRow.set("invstatus", (Object)scrappedInvstatus);
                tgtList.add(tempRow);
            }
        } else if (srcbillentry != null) {
            DynamicObjectCollection reportBillEntrys = srcbillentry.getDynamicObjectCollection("sumentry");
            for (DynamicObject reportEntry : reportBillEntrys) {
                Long sumentryId = reportEntry.getLong("id");
                if (sumentryId == 0L || !srcbillentryid.equals(sumentryId)) continue;
                if (isNeedReplace && customs.get(sumentryId.toString()) != null) {
                    String value = (String)customs.get(sumentryId.toString());
                    Map fieldAndValue = (Map)SerializationUtils.deSerializeFromBase64((String)value);
                    this.replaceFieldAndValue(fieldAndValue, reportEntry);
                }
                BigDecimal qualifybsqty = reportEntry.getBigDecimal("qualifybsqty");
                BigDecimal concesionbsqty = reportEntry.getBigDecimal("concesionbsqty");
                BigDecimal qualifywareqty = reportEntry.getBigDecimal("qualifywareqty");
                if (qualifybsqty.compareTo(BigDecimal.ZERO) > 0 || concesionbsqty.compareTo(BigDecimal.ZERO) > 0) {
                    DynamicObject tempRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)inWareRow, (boolean)false, (boolean)true);
                    BigDecimal bsqty = qualifybsqty.add(concesionbsqty).subtract(qualifywareqty);
                    tempRow.set("receivalqty", (Object)this.processPrecision(bsqty, baseunit));
                    tempRow.set("baseqty", (Object)this.processPrecision(bsqty, baseunit));
                    BigDecimal receivedqty = reportEntry.getBigDecimal("qualifywareqty");
                    tempRow.set("receivedqty", (Object)this.processPrecision(receivedqty, baseunit));
                    tempRow.set("qty", (Object)this.getQtyByUnit(masterId, baseunit, unit, bsqty));
                    tempRow.set("qtyunit2nd", (Object)this.getQtyByUnit(masterId, baseunit, unit2nd, bsqty));
                    tempRow.set("qualitystatus", (Object)"A");
                    tgtList.add(tempRow);
                }
                BigDecimal scrappedbsqty = reportEntry.getBigDecimal("scrappedbsqty");
                BigDecimal scrappedwareqty = reportEntry.getBigDecimal("scrappedwareqty");
                if (scrappedbsqty.compareTo(BigDecimal.ZERO) > 0) {
                    DynamicObject tempRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)inWareRow, (boolean)false, (boolean)true);
                    BigDecimal bsqty = scrappedbsqty.subtract(scrappedwareqty);
                    tempRow.set("receivalqty", (Object)this.processPrecision(bsqty, baseunit));
                    tempRow.set("baseqty", (Object)this.processPrecision(bsqty, baseunit));
                    BigDecimal receivedqty = reportEntry.getBigDecimal("scrappedwareqty");
                    tempRow.set("receivedqty", (Object)this.processPrecision(receivedqty, baseunit));
                    tempRow.set("qty", (Object)this.getQtyByUnit(masterId, baseunit, unit, bsqty));
                    tempRow.set("qtyunit2nd", (Object)this.getQtyByUnit(masterId, baseunit, unit2nd, bsqty));
                    tempRow.set("qualitystatus", (Object)"D");
                    tempRow.set("invstatus", (Object)scrappedInvstatus);
                    tgtList.add(tempRow);
                }
                BigDecimal reworkbsqty = this.getPropBigDecimalValue(reportEntry, "reworkbsqty");
                BigDecimal unqualifywareqty = reportEntry.getBigDecimal("unqualifywareqty");
                if (reworkbsqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                DynamicObject tempRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)inWareRow, (boolean)false, (boolean)true);
                BigDecimal bsqty = reworkbsqty.subtract(unqualifywareqty);
                tempRow.set("receivalqty", (Object)this.processPrecision(bsqty, baseunit));
                tempRow.set("baseqty", (Object)this.processPrecision(bsqty, baseunit));
                BigDecimal receivedqty = reportEntry.getBigDecimal("unqualifywareqty");
                tempRow.set("receivedqty", (Object)this.processPrecision(receivedqty, baseunit));
                tempRow.set("qty", (Object)this.getQtyByUnit(masterId, baseunit, unit, bsqty));
                tempRow.set("qtyunit2nd", (Object)this.getQtyByUnit(masterId, baseunit, unit2nd, bsqty));
                tempRow.set("qualitystatus", (Object)"B");
                tempRow.set("invstatus", (Object)unqualifiedInvstatus);
                tgtList.add(tempRow);
            }
        }
    }

    private void replaceProcessFieldAndValue(Map<String, BigDecimal> fieldAndValue, Map<String, Object> objectMap) {
        objectMap.put("qualifyqty3", BigDecimal.ZERO);
        objectMap.put("badqualifyqty3", BigDecimal.ZERO);
        objectMap.put("scrapqty3", BigDecimal.ZERO);
        for (Map.Entry<String, BigDecimal> entry : fieldAndValue.entrySet()) {
            String field = entry.getKey();
            BigDecimal value = entry.getValue();
            if (!objectMap.containsKey(field)) continue;
            objectMap.put(field, value);
        }
    }

    private void replaceFieldAndValue(Map<String, BigDecimal> fieldAndValue, DynamicObject reportEntry) {
        reportEntry.set("qualifybsqty", (Object)BigDecimal.ZERO);
        reportEntry.set("concesionbsqty", (Object)BigDecimal.ZERO);
        reportEntry.set("scrappedbsqty", (Object)BigDecimal.ZERO);
        reportEntry.set("reworkbsqty", (Object)BigDecimal.ZERO);
        for (Map.Entry<String, BigDecimal> entry : fieldAndValue.entrySet()) {
            if (!reportEntry.containsProperty(entry.getKey())) continue;
            reportEntry.set(entry.getKey(), (Object)entry.getValue());
        }
    }

    private DynamicObject setTempRow(DynamicObject inWareRow, BigDecimal baseqty, BigDecimal baseInqty, DynamicObject baseunit, DynamicObject masterId, DynamicObject unit, DynamicObject unit2nd, String qualitystatus) {
        DynamicObject tempRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)inWareRow, (boolean)false, (boolean)true);
        BigDecimal subtract = baseqty.subtract(baseInqty);
        subtract = subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO;
        tempRow.set("baseqty", (Object)this.processPrecision(subtract, baseunit));
        tempRow.set("receivalqty", (Object)this.processPrecision(subtract, baseunit));
        tempRow.set("receivedqty", (Object)this.processPrecision(baseInqty, baseunit));
        tempRow.set("qty", (Object)this.getQtyByUnit(masterId, baseunit, unit, subtract));
        tempRow.set("qtyunit2nd", (Object)this.getQtyByUnit(masterId, baseunit, unit2nd, subtract));
        tempRow.set("qualitystatus", (Object)qualitystatus);
        return tempRow;
    }

    private BigDecimal getQtyByUnit(DynamicObject masterid, DynamicObject baseunit, DynamicObject unit, BigDecimal baseqty) {
        if (unit == null || baseunit == null || masterid == null) {
            return BigDecimal.ZERO;
        }
        return UnitConvertHelper.calculateNewQty((BigDecimal)baseqty, (Long)((Long)unit.getPkValue()), (Long)((Long)baseunit.getPkValue()), (Long)((Long)masterid.getPkValue()), (StringBuilder)new StringBuilder());
    }

    private BigDecimal processPrecision(BigDecimal qty, DynamicObject unit) {
        int precision = unit.getInt("precision");
        String precisionAccount = unit.getString("precisionaccount");
        return qty.setScale(precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount)));
    }

    private Map<String, Map<String, Object>> getBySfcReportMainBillEntryIds(String srcBillEntry, Set<Long> mainBillEntryId) {
        String algoKey = "querySfcReport";
        String selectFields = "id,billno,billstatus,sumentry.id,sumentry.subentryentity1.id,sumentry.subentryentity1.qualifiedinqty3,sumentry.subentryentity1.badqualifiedinqty3,sumentry.subentryentity1.scrapinqty3,sumentry.subentryentity1.qualifyqty3,sumentry.subentryentity1.badqualifyqty3,sumentry.subentryentity1.scrapqty3";
        QFilter filter = new QFilter("sumentry.subentryentity1.id", "in", mainBillEntryId);
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(256);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)srcBillEntry, (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map1 = new HashMap<String, Object>(32);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("qualifiedinqty3", row.getBigDecimal("sumentry.subentryentity1.qualifiedinqty3"));
                map1.put("badqualifiedinqty3", row.getBigDecimal("sumentry.subentryentity1.badqualifiedinqty3"));
                map1.put("scrapinqty3", row.getBigDecimal("sumentry.subentryentity1.scrapinqty3"));
                map1.put("qualifyqty3", row.getBigDecimal("sumentry.subentryentity1.qualifyqty3"));
                map1.put("badqualifyqty3", row.getBigDecimal("sumentry.subentryentity1.badqualifyqty3"));
                map1.put("scrapqty3", row.getBigDecimal("sumentry.subentryentity1.scrapqty3"));
                map.put(row.getString("sumentry.subentryentity1.id"), map1);
            }
        }
        return map;
    }

    private Map<String, Map<String, Object>> getByProtransferMainBillEntryIds(Set<Long> mainBillEntryId) {
        String algoKey = "getByProtransfer";
        String selectFields = "id,billno,billstatus,outentryentity.id,outentryentity.qualifiedinbaseqty,outentryentity.badqualifiedinbaseqty,outentryentity.scrapinbaseqty,outentryentity.conformitybaseqty,outentryentity.badconformitybaseqty,outentryentity.discardbaseqty";
        QFilter filter = new QFilter("outentryentity.id", "in", mainBillEntryId);
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(256);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sfc_protransferbill", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map1 = new HashMap<String, Object>(32);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("qualifiedinbaseqty", row.getBigDecimal("outentryentity.qualifiedinbaseqty"));
                map1.put("badqualifiedinbaseqty", row.getBigDecimal("outentryentity.badqualifiedinbaseqty"));
                map1.put("scrapinbaseqty", row.getBigDecimal("outentryentity.scrapinbaseqty"));
                map1.put("conformitybaseqty", row.getBigDecimal("outentryentity.conformitybaseqty"));
                map1.put("badconformitybaseqty", row.getBigDecimal("outentryentity.badconformitybaseqty"));
                map1.put("discardbaseqty", row.getBigDecimal("outentryentity.discardbaseqty"));
                map.put(row.getString("outentryentity.id"), map1);
            }
        }
        return map;
    }

    private BigDecimal getPropBigDecimalValue(DynamicObject reportEntry, String propKey) {
        return reportEntry.containsProperty(propKey) ? reportEntry.getBigDecimal(propKey) : BigDecimal.ZERO;
    }
}

