/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.CloseDateHelper;
import kd.bd.mpdm.business.helper.InvBillBotpHelper;
import kd.bd.mpdm.common.utils.AuxQtyAndUnitHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class OrderToInBillInvPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        HashSet<Long> orgIds = new HashSet<Long>(entitys.length);
        HashSet<Long> productionorgIds = new HashSet<Long>(entitys.length);
        HashSet<Long> invSchemeIds = new HashSet<Long>(entitys.length);
        for (int i = 0; i < entitys.length; ++i) {
            DynamicObject obj = entitys[i].getDataEntity();
            if (obj.getDynamicObject("org") != null) {
                orgIds.add(obj.getDynamicObject("org").getLong("id"));
            }
            if (obj.getDynamicObject("productionorg") != null) {
                productionorgIds.add(obj.getDynamicObject("productionorg").getLong("id"));
            }
            if (obj.getDynamicObject("invscheme") == null) continue;
            invSchemeIds.add(obj.getDynamicObject("invscheme").getLong("id"));
        }
        HashMap<Long, DynamicObject> shipperMap = new HashMap<Long, DynamicObject>(128);
        HashMap currencyMap = new HashMap(128);
        if (CollectionUtils.isNotEmpty(orgIds)) {
            for (Long orgId : orgIds) {
                shipperMap.put(orgId, InvBillBotpHelper.getAccountByOrg((Long)orgId, (String)"05"));
                Map currencyAndExRateMap = InvBillBotpHelper.getCurrencyAndExRateTable((Long)orgId);
                if (!MapUtils.isNotEmpty((Map)currencyAndExRateMap)) continue;
                currencyMap.put(orgId, currencyAndExRateMap.get("baseCurrencyID"));
            }
        }
        HashSet baseCurrencyIds = new HashSet(currencyMap.values());
        QFilter filter = new QFilter("id", "in", baseCurrencyIds);
        Map bdCurrency = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (QFilter[])new QFilter[]{filter});
        Map invSchemeMap = InvBillBotpHelper.getInvScheme(invSchemeIds);
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            DynamicObject shipper = obj.getDynamicObject("shipper");
            DynamicObject org = obj.getDynamicObject("org");
            if (org != null && shipper == null) {
                obj.set("shipper", shipperMap.get(org.getLong("id")));
            }
            if (org != null) {
                Long currencyId = (Long)currencyMap.get(org.getLong("id"));
                obj.set("settlecurrency", bdCurrency.get(currencyId));
            }
            DynamicObjectCollection entrycols = obj.getDynamicObjectCollection("billentry");
            if (obj.getDynamicObject("invscheme") != null) {
                DynamicObject invScheme = (DynamicObject)invSchemeMap.get(obj.getDynamicObject("invscheme").getPkValue());
                DynamicObjectCollection invTypeEntry = invScheme.getDynamicObjectCollection("invtypeentry");
                List invtypeisdefault = invTypeEntry.stream().filter(var -> var.getBoolean("invtypeisdefault")).collect(Collectors.toList());
                DynamicObjectCollection invStatusEntry = invScheme.getDynamicObjectCollection("invstatusentry");
                List invstatusisdefault = invStatusEntry.stream().filter(var -> var.getBoolean("invstatusisdefault")).collect(Collectors.toList());
                for (DynamicObject dynamicObject : entrycols) {
                    DynamicObject invtype = dynamicObject.getDynamicObject("invtype");
                    if (CollectionUtils.isNotEmpty(invtypeisdefault) && invtype == null) {
                        dynamicObject.set("invtype", ((DynamicObject)invtypeisdefault.get(0)).get("invtype"));
                    }
                    DynamicObject invstatus = dynamicObject.getDynamicObject("invstatus");
                    if (!CollectionUtils.isNotEmpty(invstatusisdefault) || invstatus != null) continue;
                    dynamicObject.set("invstatus", ((DynamicObject)invstatusisdefault.get(0)).get("invstatus"));
                }
            }
            this.convertAuxptyQty(entrycols);
            CloseDateHelper.initBookDate((String)tgtMainType, (DynamicObject)obj, (BillEntityType)this.getSrcMainType());
        }
        if ("im_mdc_mftmanuinbill".equals(tgtMainType)) {
            Map<Long, Long> dataMap = this.getSettleOrgMapByMftOrg(productionorgIds);
            Collection<Long> values = dataMap.values();
            Map bos_orgIdMap = BusinessDataServiceHelper.loadFromCache((Object[])values.toArray(), (String)"bos_org");
            for (int i = 0; i < entitys.length; ++i) {
                Long setId;
                ExtendedDataEntity entity = entitys[i];
                DynamicObject obj = entity.getDataEntity();
                DynamicObject org = obj.getDynamicObject("productionorg");
                if (org == null || (setId = dataMap.get(org.getLong("id"))) == null) continue;
                DynamicObjectCollection entrycols = obj.getDynamicObjectCollection("billentry");
                for (DynamicObject dynamicObject : entrycols) {
                    dynamicObject.set("entrysettleorg", bos_orgIdMap.get(setId));
                }
            }
        }
    }

    private void convertAuxptyQty(DynamicObjectCollection entrycols) {
        for (DynamicObject entry : entrycols) {
            DynamicObject material = entry.getDynamicObject("material");
            if (null == material) continue;
            String selectProperties = "auxptyunit,unitconvertdir";
            material = BusinessDataServiceHelper.loadSingleFromCache((Object)material.getPkValue(), (String)"bd_material", (String)selectProperties);
            DynamicObject auxptyUnit = entry.getDynamicObject("unit2nd");
            AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)entry, (DynamicObject)material, (DynamicObject)auxptyUnit, (String)"baseqty", (String)"baseunit", (String)"qtyunit2nd");
        }
    }

    private Map<Long, Long> getSettleOrgMapByMftOrg(Set<Long> mftOrgId) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        if (mftOrgId == null) {
            return map;
        }
        if (mftOrgId.isEmpty()) {
            return map;
        }
        String algoKey = "query-bos_org";
        QFilter[] qfs = new QFilter[]{new QFilter("id", "in", mftOrgId)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_org", (String)"id,fisaccounting", (QFilter[])qfs, null);){
            while (dataSet.hasNext()) {
                List bizRelationOrgIds;
                Row next = dataSet.next();
                Long orgId = next.getLong("id");
                if (next.getBoolean("fisaccounting").booleanValue()) {
                    map.put(orgId, orgId);
                    continue;
                }
                OrgRelationParam orgParam = new OrgRelationParam();
                orgParam.setToViewType(OrgViewTypeEnum.IS_PRODUCE.getViewType());
                orgParam.setFromViewType(OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
                orgParam.setDirectViewType("fromorg");
                orgParam.setOrgId(orgId.longValue());
                long defaultOrgRelation = OrgUnitServiceHelper.getDefaultOrgRelation((OrgRelationParam)orgParam);
                if (defaultOrgRelation == 0L && (bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)orgParam)) != null && !bizRelationOrgIds.isEmpty()) {
                    defaultOrgRelation = (Long)bizRelationOrgIds.get(0);
                }
                if (defaultOrgRelation == 0L) {
                    Map orgmap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                    Integer fromOrg = orgmap == null || orgmap.isEmpty() ? Integer.valueOf(0) : orgmap.get("id");
                    defaultOrgRelation = (Long)((Object)fromOrg);
                }
                map.put(orgId, defaultOrgRelation);
            }
        }
        return map;
    }
}

