/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.jetbrains.annotations.NotNull;

public class OrderToMergeConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(OrderToMergeConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("treeentryentity.pid");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey("srcentry");
        Map fldProperties = e.getFldProperties();
        block0: for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            String pid;
            Object pidValue;
            DynamicObject targetOrderEntry = billDataEntity.getDataEntity();
            String targetSrcEntryid = targetOrderEntry.getPkValue().toString();
            if (StringUtils.equals((CharSequence)"0", (CharSequence)targetSrcEntryid)) {
                Long newId = ID.genLongId();
                targetSrcEntryid = newId.toString();
                targetOrderEntry.set("id", (Object)newId);
            }
            targetOrderEntry.set("mappingid", targetOrderEntry.getPkValue());
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcEntry = (DynamicObject)srcRows.get(0);
            DynamicProperty dynamicProperty = (DynamicProperty)fldProperties.get("treeentryentity.pid");
            if (dynamicProperty == null || (pidValue = dynamicProperty.getValue((Object)srcEntry)) == null || StringUtils.equals((CharSequence)"0", (CharSequence)(pid = pidValue.toString()))) continue;
            for (ExtendedDataEntity billDataEntity1 : billDataEntitys) {
                String orderId;
                DynamicObject orderEntry;
                DynamicObject targetOrderEntry1 = billDataEntity1.getDataEntity();
                String targetSrcEntryid1 = targetOrderEntry1.getPkValue().toString();
                if (StringUtils.equals((CharSequence)targetSrcEntryid, (CharSequence)targetSrcEntryid1) || (orderEntry = targetOrderEntry1.getDynamicObject("orderentry")) == null || !StringUtils.equals((CharSequence)pid, (CharSequence)(orderId = orderEntry.getPkValue().toString()))) continue;
                targetOrderEntry.set("pid", targetOrderEntry1.getPkValue());
                continue block0;
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>(billDataEntitys.length);
        HashMap<Object, Object> idIpid = new HashMap<Object, Object>(16);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetOrderbill = billDataEntity.getDataEntity();
            saveObjs.add(targetOrderbill);
            String number = CodeRuleServiceHelper.getNumber((String)"pom_ordermerge", (DynamicObject)targetOrderbill, (String)targetOrderbill.getDynamicObject("org").getPkValue().toString());
            if (StringUtils.isEmpty((CharSequence)number)) {
                number = "HBGD-" + String.valueOf(System.currentTimeMillis());
            }
            targetOrderbill.set("billno", (Object)number);
            SaveServiceHelper.saveOperate((String)"pom_ordermerge", (DynamicObject[])new DynamicObject[]{targetOrderbill}, (OperateOption)OperateOption.create());
            ConvertOperationResult pushResult = this.getConvertOperationResult(targetOrderbill);
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"pom_ordermerge");
            List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            DynamicObjectCollection mgEntrys = targetOrderbill.getDynamicObjectCollection("mergeetentry");
            this.copyMergeEntry(targetBillObjs, mgEntrys);
            DynamicObjectCollection srcEntrys = targetOrderbill.getDynamicObjectCollection("srcentry");
            for (DynamicObject srcEntry : srcEntrys) {
                idIpid.put(srcEntry.getPkValue(), srcEntry.get("ipid"));
            }
        }
        this.reSetIpid(saveObjs, idIpid);
        SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reSetIpid(List<DynamicObject> saveObjs, Map<Object, Object> idIpid) {
        try (DataSet dataSet = null;){
            SqlBuilder sql = new SqlBuilder();
            sql.appendIn("select fentryid,fipid from t_pom_mgsrcentry where fentryid ", idIpid.keySet().toArray());
            dataSet = DB.queryDataSet((String)OrderToMergeConvertPlugin.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
            for (Row row : dataSet) {
                idIpid.put(row.get("fentryid"), row.get("fipid"));
            }
        }
        for (DynamicObject saveObj : saveObjs) {
            DynamicObjectCollection srcEntrys = saveObj.getDynamicObjectCollection("srcentry");
            for (DynamicObject srcEntry : srcEntrys) {
                srcEntry.set("ipid", idIpid.get(srcEntry.getPkValue()));
            }
        }
    }

    private void copyMergeEntry(List<DynamicObject> targetBillObjs, DynamicObjectCollection dynamicObjectCollection) {
        dynamicObjectCollection.clear();
        for (DynamicObject mergeTargetBill : targetBillObjs) {
            DynamicObjectCollection mergeEntrys = mergeTargetBill.getDynamicObjectCollection("mergeetentry");
            List mainTypes = mergeEntrys.stream().filter(k -> "C".equals(k.getString("producttypemerge"))).collect(Collectors.toList());
            List otherTypes = mergeEntrys.stream().filter(k -> !"C".equals(k.getString("producttypemerge"))).collect(Collectors.toList());
            for (DynamicObject mainType : mainTypes) {
                dynamicObjectCollection.add((Object)mainType);
                String mappingmgid = mainType.getString("mappingmgid");
                for (DynamicObject otherType : otherTypes) {
                    String mappingmgid1 = otherType.getString("mappingmgid");
                    if (!StringUtils.equals((CharSequence)mappingmgid, (CharSequence)mappingmgid1)) continue;
                    dynamicObjectCollection.add((Object)otherType);
                    otherType.set("pid", mainType.getPkValue());
                }
            }
        }
    }

    @NotNull
    private ConvertOperationResult getConvertOperationResult(DynamicObject targetOrderbill) {
        Object pkValue = targetOrderbill.getPkValue();
        Long targetorderId = Long.parseLong(pkValue.toString());
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow selectedRow = new ListSelectedRow((Object)targetorderId);
        selectedRows.add(selectedRow);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setAutoSave(false);
        ConvertOperationResult pushResult = OrderMergeHelper.pushTo(null, selectedRows, (String)"1484989487363685376", (String)"pom_ordermerge", (String)"pom_ordermerge", (PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            String billMessage = "";
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                billMessage = billReport.getFailMessage();
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u5de5\u5355\u5206\u5f55\u4e0b\u63a8\u76ee\u6807\u5de5\u5355\u5206\u5f55\u5931\u8d25\uff1a%1$s", (String)"OrderToMergeConvertPlugin_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billMessage));
        }
        return pushResult;
    }
}

