/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.botp.EcoCommonHelper;
import kd.bd.mpdm.common.manuftech.utils.ManuftechChangeImportUtils;
import kd.bd.mpdm.opplugin.botp.BotpConvertUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;

public class SfcXManftechBotpConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(SfcXManftechBotpConvertPlugin.class);
    private static final String ENTITY_SFCMANFTECH = "sfc_manftech";
    private static final String ENTITY_OMMANFTECH = "om_mfttechnics";

    public void afterConvert(AfterConvertEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        ORM orm = ORM.create();
        HashSet<Long> allManftechIdSet = new HashSet<Long>(16);
        String entityNumber = ENTITY_SFCMANFTECH;
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            String errors;
            DynamicObject targetOrderbill = billDataEntity.getDataEntity();
            this.setBillNo(targetOrderbill, orm, targetEntityNumber);
            Set<Long> manftechIdSet = this.getSfcManftechIdSet(targetOrderbill);
            if (manftechIdSet.isEmpty()) {
                errors = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8bb0\u5f55-\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355\u8f6c\u6362\u540e\u7684\u5de5\u5e8f\u8ba1\u5212ID\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u914d\u7f6e\u8be5\u5b57\u6bb5\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"SfcXManftechBotpConvertPlugin_01", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("afterConvertValid", errors), new Object[0]);
            }
            if (manftechIdSet.size() > 1) {
                errors = String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8bb0\u5f55-\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355\u8f6c\u6362\u540e\u5b58\u5728\u591a\u4e2a\u5de5\u5e8f\u8ba1\u5212ID\u6570\u636e%1$s\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u5206\u5355\u5904\u7406\u3002", (String)"SfcXManftechBotpConvertPlugin_02", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), manftechIdSet);
                throw new KDBizException(new ErrorCode("afterConvertValid", errors), new Object[0]);
            }
            allManftechIdSet.addAll(manftechIdSet);
            Set<String> oprParentSet = this.getOprParentSet(targetOrderbill);
            if (oprParentSet.isEmpty()) {
                String errors2 = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8bb0\u5f55-\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355\u8f6c\u6362\u540e\u7684\u5de5\u5e8f\u5e8f\u5217\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u914d\u7f6e\u8be5\u5b57\u6bb5\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"SfcXManftechBotpConvertPlugin_03", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("afterConvertValid", errors2), new Object[0]);
            }
            if (oprParentSet.size() > 1) {
                String errors3 = String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8bb0\u5f55-\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355\u8f6c\u6362\u540e\u5b58\u5728\u591a\u4e2a\u5de5\u5e8f\u5e8f\u5217\u6570\u636e%1$s\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u5206\u5355\u5904\u7406\u3002", (String)"SfcXManftechBotpConvertPlugin_04", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), oprParentSet);
                throw new KDBizException(new ErrorCode("afterConvertValid", errors3), new Object[0]);
            }
            entityNumber = this.getManfTechEntityNumber(targetOrderbill);
        }
        HashSet<Long> proOrderEntryIdSet = new HashSet<Long>(16);
        Map<Long, DynamicObject> sfcManftechMap = this.getSfcManftechMap(allManftechIdSet, entityNumber, proOrderEntryIdSet);
        Map<Long, DynamicObject> sfcManftechF7Map = this.getSfcManftechF7Map(allManftechIdSet, "sfc_manftech_head_f7_pro");
        Map<Long, DynamicObject> proOrderEntryF7Map = this.getSfcManftechF7Map(proOrderEntryIdSet, "sfc_mftorder_f7");
        Set<String> notUpdateFieldSet = this.getNoUpdateFieldSet(entityNumber);
        Set<String> updateQtyFieldSet = this.getUpdateQtyFields(entityNumber);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetOrderbill = billDataEntity.getDataEntity();
            Set<Long> manftechIdSet = this.getSfcManftechIdSet(targetOrderbill);
            Long manftechId = manftechIdSet.iterator().next();
            Set<String> oprParentSet = this.getOprParentSet(targetOrderbill);
            String oprParent = oprParentSet.iterator().next();
            DynamicObject manfTech = sfcManftechMap.get(manftechId);
            this.setHeadValue(manfTech, targetOrderbill);
            this.setProentryEntity(manfTech, targetOrderbill, oprParent, sfcManftechF7Map, proOrderEntryF7Map);
            DynamicObject oldXManftechBil = (DynamicObject)OrmUtils.clone((IDataEntityBase)targetOrderbill, (boolean)false, (boolean)true);
            ManuftechChangeImportUtils.setOprEntryEntity((DynamicObject)targetOrderbill, (DynamicObject)manfTech);
            DynamicObjectCollection newXColl = targetOrderbill.getDynamicObjectCollection("oprentryentity");
            DynamicObjectCollection oldXColl = oldXManftechBil.getDynamicObjectCollection("oprentryentity");
            for (int i = 0; i < newXColl.size(); ++i) {
                BotpConvertUtils.convertEntry((DynamicObject)oldXColl.get(i), (DynamicObject)newXColl.get(i), notUpdateFieldSet, updateQtyFieldSet);
            }
            ManuftechChangeImportUtils.autoFillManftchChange((DynamicObject)targetOrderbill, (DynamicObject)manfTech);
        }
    }

    private String getManfTechEntityNumber(DynamicObject xBill) {
        return "sfc_xmanftech".equals(xBill.getDataEntityType().getName()) ? ENTITY_SFCMANFTECH : ENTITY_OMMANFTECH;
    }

    private void setHeadValue(DynamicObject manfTech, DynamicObject xManfTech) {
        Set<String> fieldSet = this.getHeadMappingFieldSet();
        for (String fieldNumber : fieldSet) {
            xManfTech.set(fieldNumber, manfTech.get(fieldNumber));
        }
    }

    private void setProentryEntity(DynamicObject manfTech, DynamicObject xManfTech, String oprParent, Map<Long, DynamicObject> sfcManftechF7Map, Map<Long, DynamicObject> proOrderEntryF7Map) {
        DynamicObjectCollection proentryentityColl = manfTech.getDynamicObjectCollection("proentryentity");
        for (DynamicObject proentryentity : proentryentityColl) {
            if (!oprParent.equals(proentryentity.getString("processseq"))) continue;
            DynamicObjectCollection xColl = xManfTech.getDynamicObjectCollection("proentryentity");
            xColl.clear();
            DynamicObject xProentryentity = xColl.addNew();
            EcoCommonHelper.putHeadProperties((DynamicObject)proentryentity, (DynamicObject)xProentryentity, this.getProEntityUnMappingFieldSet());
            xProentryentity.set("seq", (Object)1);
            xProentryentity.set("prochangetype", (Object)"B");
            DynamicObject promanftech = sfcManftechF7Map.get(manfTech.getPkValue());
            xProentryentity.set("promanftechid", (Object)promanftech);
            xProentryentity.set("proentryid", proentryentity.getPkValue());
            DynamicObject proorderentry = proOrderEntryF7Map.get(manfTech.getDynamicObject("mftentryseq").getPkValue());
            xProentryentity.set("proorderentryid", (Object)proorderentry);
            break;
        }
    }

    private Set<String> getProEntityUnMappingFieldSet() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("id");
        fieldSet.add("seq");
        return fieldSet;
    }

    private Set<String> getHeadMappingFieldSet() {
        HashSet<String> headFieldSet = new HashSet<String>(16);
        headFieldSet.add("org");
        headFieldSet.add("accountingorg");
        headFieldSet.add("material");
        headFieldSet.add("configuredcode");
        headFieldSet.add("qty");
        headFieldSet.add("plantype");
        headFieldSet.add("productionworkshop");
        headFieldSet.add("manufactureorderid");
        headFieldSet.add("mftentryseq");
        headFieldSet.add("transactiontype");
        headFieldSet.add("planstarttime");
        headFieldSet.add("planfinishtime");
        headFieldSet.add("baseunit");
        headFieldSet.add("baseqty");
        headFieldSet.add("bdproject");
        headFieldSet.add("tracknumber");
        headFieldSet.add("auxptyunit");
        headFieldSet.add("auxptyqty");
        headFieldSet.add("schedulplan");
        headFieldSet.add("bomversion");
        headFieldSet.add("processroute");
        return headFieldSet;
    }

    private Map<Long, DynamicObject> getSfcManftechMap(Set<Long> allManftechIdSet, String entityNumber, Set<Long> orderEntryIdSet) {
        DynamicObject[] dys = BusinessDataServiceHelper.load((Object[])allManftechIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dy : dys) {
            dataMap.put((Long)dy.getPkValue(), dy);
            orderEntryIdSet.add((Long)dy.getDynamicObject("mftentryseq").getPkValue());
        }
        return dataMap;
    }

    private Map<Long, DynamicObject> getSfcManftechF7Map(Set<Long> allManftechIdSet, String entityNumber) {
        DynamicObject[] dys = BusinessDataServiceHelper.load((Object[])allManftechIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dy : dys) {
            dataMap.put((Long)dy.getPkValue(), dy);
        }
        return dataMap;
    }

    private Set<Long> getSfcManftechIdSet(DynamicObject targetOrderbill) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        DynamicObjectCollection processColl = targetOrderbill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject processEntry : processColl) {
            Long sfcManftechId = this.getLongId(processEntry, "oprmanftechid");
            if (sfcManftechId == null || sfcManftechId.equals(0L)) continue;
            idSet.add(sfcManftechId);
        }
        return idSet;
    }

    private Set<String> getOprParentSet(DynamicObject targetOrderbill) {
        HashSet<String> oprparentSet = new HashSet<String>(16);
        DynamicObjectCollection processColl = targetOrderbill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject processEntry : processColl) {
            String oprparent = processEntry.getString("oprparent");
            if (oprparent == null || "".equals(oprparent)) continue;
            oprparentSet.add(oprparent);
        }
        return oprparentSet;
    }

    public Long getLongId(DynamicObject dy, String field) {
        Object value = dy.get(field);
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return Long.parseLong(value + "");
            }
            if (value instanceof DynamicObject) {
                return (Long)dy.getDynamicObject(field).getPkValue();
            }
        }
        return 0L;
    }

    private void setBillNo(DynamicObject targetOrderbill, ORM orm, String targetEntityNumber) {
        if (targetOrderbill.get("billno") == null || StringUtils.isEmpty((CharSequence)targetOrderbill.getString("billno"))) {
            String number = CodeRuleServiceHelper.getNumber((String)targetEntityNumber, (DynamicObject)targetOrderbill, (String)targetOrderbill.getDynamicObject("org").getPkValue().toString());
            if (StringUtils.isEmpty((CharSequence)number)) {
                number = String.valueOf("xsfc_" + this.genLongId(orm, targetEntityNumber));
            }
            targetOrderbill.set("billno", (Object)number);
            logger.info("------------SfcXManftechBotpConvertPlugin.afterConvert,setbillno:" + number);
        }
    }

    private Long genLongId(ORM orm, String entityname) {
        return orm.genLongId(entityname);
    }

    public Set<String> getNoUpdateFieldSet(String entityName) {
        Set<String> fieldSet = BotpConvertUtils.getConfigNoUpdateFieldSet(entityName);
        fieldSet.add("id");
        fieldSet.add("oprstatus");
        return fieldSet;
    }

    public Set<String> getUpdateQtyFields(String entityName) {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("oprqty");
        fieldSet.add("oprstandardqty");
        fieldSet.add("headqty");
        fieldSet.add("operationqty");
        fieldSet.add("basebatchqty");
        return fieldSet;
    }
}

