/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class StockBotpSetApplyDeptPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            if (entity == null) continue;
            DynamicObject obj = entity.getDataEntity();
            this.applyUserInit(obj);
        }
    }

    private void applyUserInit(DynamicObject obj) {
        DynamicObject applyOrg = obj.getDynamicObject("org");
        if (applyOrg == null) {
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{qFilter});
        List<DynamicObject> union = this.getUserDeptAndOrgDeptUnion(user, applyOrg);
        if (CollectionUtils.isNotEmpty(union)) {
            obj.set("applydept", (Object)union.get(0));
        } else {
            obj.set("applydept", null);
        }
    }

    private List<DynamicObject> getUserDeptAndOrgDeptUnion(DynamicObject applyUser, DynamicObject applyOrg) {
        List orgDepts = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList((Long)applyOrg.getPkValue()), (boolean)true);
        DynamicObjectCollection deptList = applyUser.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> deptId = new ArrayList<DynamicObject>();
        for (DynamicObject dept : deptList) {
            Boolean isPartJob = dept.getBoolean("ispartjob");
            DynamicObject dpt = dept.getDynamicObject("dpt");
            if (dpt == null) continue;
            Long id = dpt.getLong("id");
            if (!CollectionUtils.isEmpty((Collection)orgDepts) && !orgDepts.contains(id)) continue;
            if (isPartJob.booleanValue()) {
                deptId.add(dpt);
                continue;
            }
            deptId.add(0, dpt);
        }
        return deptId;
    }
}

