/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class StockOrgCurrencyBotpPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            if (entity == null) continue;
            DynamicObject obj = entity.getDataEntity();
            if ("im_mdc_mftreturnapplybill".equals(tgtMainType)) {
                this.setInspectOrg(obj);
            }
            this.setOrg(obj);
            this.setCurrency(obj, obj.getDynamicObject("accountorg").getLong("id"));
            for (DynamicObject dyn : obj.getDynamicObjectCollection("billentry")) {
                dyn.set("unpickqty", (Object)dyn.getBigDecimal("auditqty").subtract(dyn.getBigDecimal("useoutqty")));
                dyn.set("unpickbaseqty", (Object)dyn.getBigDecimal("auditbaseqty").subtract(dyn.getBigDecimal("useoutbaseqty")));
            }
        }
    }

    private void setInspectOrg(DynamicObject obj) {
        for (DynamicObject dyn : obj.getDynamicObjectCollection("billentry")) {
            dyn.set("qcorg", null);
            DynamicObject entryReqOrg = obj.getDynamicObject("invorg");
            if (entryReqOrg == null) {
                return;
            }
            Object invorg = obj.get("invorg");
            Long invOrgId = StockOrgCurrencyBotpPlugin.getDyObjId(invorg);
            if (StockOrgCurrencyBotpPlugin.checkOrgWithFisqc(invOrgId, "fisqc")) {
                dyn.set("qcorg", invorg);
            } else {
                List fromOrgs = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)invOrgId, (boolean)Boolean.TRUE);
                if (fromOrgs.size() > 0) {
                    dyn.set("qcorg", fromOrgs.get(0));
                } else {
                    List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"06", (boolean)Boolean.FALSE);
                    if (orgIds.size() > 0) {
                        dyn.set("qcorg", orgIds.get(0));
                    }
                }
            }
            Object material = dyn.get("materielmasterid");
            Long materialMasterId = StockOrgCurrencyBotpPlugin.getDyObjId(material);
            HashSet<Object> materialMasterIds = new HashSet<Object>(16);
            materialMasterIds.add(materialMasterId);
            Set<String> materialQCIsTrueInfo = StockOrgCurrencyBotpPlugin.queryMaterialQCIsTrueInfo(materialMasterIds, invOrgId);
            if (materialQCIsTrueInfo == null || materialQCIsTrueInfo.size() <= 0) continue;
            dyn.set("checkback", (Object)Boolean.TRUE);
        }
    }

    public static Set<String> queryMaterialQCIsTrueInfo(Set<Object> materialIDSet, Long orgID) {
        if (materialIDSet == null || materialIDSet.size() < 1 || orgID == null || orgID == 0L) {
            return null;
        }
        QFilter qFilter = new QFilter("masterid", "in", materialIDSet);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_inspect_cfg", (Long)orgID));
        Map dyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_inspect_cfg", (String)"id,entryentity,entryentity.inspecttype,entryentity.nocheckflag,masterid", (QFilter[])qFilter.toArray());
        if (dyMap == null) {
            return null;
        }
        HashSet<String> returnMaterialIDSet = new HashSet<String>(10);
        for (Map.Entry entry : dyMap.entrySet()) {
            boolean isUpdateFlag = false;
            DynamicObject inspectObj = (DynamicObject)entry.getValue();
            DynamicObjectCollection entryeEntity = inspectObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : entryeEntity) {
                DynamicObject inspectType = dyn.getDynamicObject("inspecttype");
                Object number = inspectType.get("number");
                boolean nocheckflag = dyn.getBoolean("nocheckflag");
                if (!"qcpp-005_S".equals(number) || nocheckflag) continue;
                isUpdateFlag = true;
            }
            if (!isUpdateFlag) continue;
            returnMaterialIDSet.add(inspectObj.getDynamicObject("masterid").getPkValue() + "_" + orgID);
        }
        return returnMaterialIDSet;
    }

    public static boolean checkOrgWithFisqc(Long orgId, String orgRole) {
        boolean result = false;
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)orgRole);
        if (null != org) {
            result = org.getBoolean(orgRole);
        }
        return result;
    }

    public static Long getDyObjId(Object dyObj) {
        if (dyObj == null) {
            return null;
        }
        if (dyObj instanceof DynamicObject) {
            return ((DynamicObject)dyObj).getLong("id");
        }
        if (dyObj instanceof Long) {
            return (Long)dyObj;
        }
        return null;
    }

    private void setOrg(DynamicObject obj) {
        DynamicObject bizOrg = obj.getDynamicObject("org");
        if (bizOrg != null) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)bizOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            Object settleOrgId = null;
            if (map != null) {
                settleOrgId = map.get("id");
            }
            obj.set("accountorg", (Object)BusinessDataServiceHelper.loadSingle(settleOrgId, (String)"bos_org", (String)"id"));
        }
    }

    private void applyUserInit(DynamicObject obj) {
        DynamicObject applyOrg = obj.getDynamicObject("org");
        if (applyOrg == null) {
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{qFilter});
        List<DynamicObject> union = this.getUserDeptAndOrgDeptUnion(user, applyOrg);
        if (CollectionUtils.isNotEmpty(union)) {
            obj.set("applydept", (Object)union.get(0));
        } else {
            obj.set("applydept", null);
        }
    }

    private List<DynamicObject> getUserDeptAndOrgDeptUnion(DynamicObject applyUser, DynamicObject applyOrg) {
        List orgDepts = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList((Long)applyOrg.getPkValue()), (boolean)true);
        DynamicObjectCollection deptList = applyUser.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> deptId = new ArrayList<DynamicObject>();
        for (DynamicObject dept : deptList) {
            Boolean isPartJob = dept.getBoolean("ispartjob");
            DynamicObject dpt = dept.getDynamicObject("dpt");
            if (dpt == null) continue;
            Long id = dpt.getLong("id");
            if (!CollectionUtils.isEmpty((Collection)orgDepts) && !orgDepts.contains(id)) continue;
            if (isPartJob.booleanValue()) {
                deptId.add(dpt);
                continue;
            }
            deptId.add(0, dpt);
        }
        return deptId;
    }

    private void setCurrency(DynamicObject obj, Long orgId) {
        Long currency;
        Map<String, Long> currencyinfo = StockOrgCurrencyBotpPlugin.getCurrencyAndExRateTable(orgId);
        HashMap<Long, Long> currencyMap = new HashMap<Long, Long>(128);
        if (null != currencyinfo && MapUtils.isNotEmpty(currencyinfo) && (currency = currencyinfo.get("baseCurrencyID")) != null && !currency.equals(0L)) {
            currencyMap.put(orgId, currency);
            HashSet baseCurrencyIds = new HashSet(currencyMap.values());
            QFilter filter = new QFilter("id", "in", baseCurrencyIds);
            Map bdCurrency = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (QFilter[])new QFilter[]{filter});
            if (MapUtils.isNotEmpty((Map)bdCurrency)) {
                Long currencyId = (Long)currencyMap.get(orgId);
                obj.set("settlecurrency", bdCurrency.get(currencyId));
            }
        }
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != 0L && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return Collections.emptyMap();
    }
}

