/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.calendar;

import java.util.Comparator;
import kd.bd.mpdm.common.calendar.CalendarDateCollComparatorImpl;
import kd.bd.mpdm.common.calendar.impl.CalendarServiceImpl;
import kd.bd.mpdm.opplugin.calendar.CalendarSetValidatorPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CalendarSetOpPlugin
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(CalendarSetOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("objecttype");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("org.number");
        e.getFieldKeys().add("org.name");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("workcenter");
        e.getFieldKeys().add("workcenter.number");
        e.getFieldKeys().add("workcenter.name");
        e.getFieldKeys().add("workshop");
        e.getFieldKeys().add("workshop.number");
        e.getFieldKeys().add("workshop.name");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("entryentity.calendar");
        e.getFieldKeys().add("entryentity.iseffectplan");
        e.getFieldKeys().add("entryentity.iseffectproduct");
        e.getFieldKeys().add("entryentity.iseffectproject");
        e.getFieldKeys().add("dateentry");
        e.getFieldKeys().add("dateentry.seq");
        e.getFieldKeys().add("dateentry.workdate");
        e.getFieldKeys().add("dateentry.datetype");
        e.getFieldKeys().add("dateentry.entrycalendar");
        e.getFieldKeys().add("dateentry.entrymodifydate");
        e.getFieldKeys().add("dateentry.entrymodifyer");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new CalendarSetValidatorPlugin());
    }

    private boolean isNumber(String atype) {
        return "number".equals(atype);
    }

    private String genString(DynamicObject data, String atype) {
        String objectType = data.getString("objecttype");
        StringBuilder sb = new StringBuilder();
        sb.append(objectType).append("_");
        if ("A".equals(objectType)) {
            sb.append(data.getDynamicObject("org").getString(this.isNumber(atype) ? "number" : "name"));
        } else if ("B".equals(objectType)) {
            sb.append(data.getDynamicObject("workshop").getString(this.isNumber(atype) ? "number" : "name"));
        } else {
            sb.append(data.getDynamicObject("workcenter").getString(this.isNumber(atype) ? "number" : "name"));
        }
        return sb.toString();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] billDataEntities;
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        for (DynamicObject data : billDataEntities = e.getDataEntities()) {
            if (!"save".equals(operateKey) && !"submit".equals(operateKey)) continue;
            String number = data.getString("number");
            String name = data.getString("name");
            if (StringUtils.isEmpty((String)number)) {
                data.set("number", (Object)this.genString(data, "number"));
            }
            if (StringUtils.isEmpty((String)name)) {
                data.set("name", (Object)this.genString(data, "name"));
            }
            DynamicObjectCollection coll = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : coll) {
                DynamicObjectCollection dtColl = entry.getDynamicObjectCollection("dateentry");
                if (dtColl == null || dtColl.size() <= 1) continue;
                dtColl.sort((Comparator)new CalendarDateCollComparatorImpl());
                for (int i = 0; i < dtColl.size(); ++i) {
                    ((DynamicObject)dtColl.get(i)).set("seq", (Object)(i + 1));
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] billDataEntities;
        super.afterExecuteOperationTransaction(e);
        String operateKey = e.getOperationKey();
        for (DynamicObject data : billDataEntities = e.getDataEntities()) {
            Long setId;
            if (!"save".equals(operateKey) && !"submit".equals(operateKey) || (setId = Long.valueOf(data.getLong("id"))) == null || setId.equals(0L)) continue;
            CalendarServiceImpl.getInstance().syncCalendar(Long.valueOf(0L), setId, "setting_" + operateKey);
        }
    }
}

