/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.calendar;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CalendarSetValidatorPlugin
extends AbstractValidator {
    private static final String APPPARAM = "bd-mpdm-opplugin";

    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<String> repeatDataSet = new HashSet<String>(16);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject data = dataEntities[i].getDataEntity();
            if (!"submit".equals(operate) && !"save".equals(operate)) continue;
            DynamicObject org = data.getDynamicObject("org");
            DynamicObject workCenter = data.getDynamicObject("workcenter");
            DynamicObject workShop = data.getDynamicObject("workshop");
            String type = data.getString("objecttype");
            String orgNamedesc = this.getOrgNameDesc();
            String workShopNamedesc = this.getWorkShopNameDesc();
            String workCenterNamedesc = this.getWorkCenterNameDesc();
            if ("A".equals(type) && org == null) {
                this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u5f53\u4f7f\u7528\u5bf9\u8c61\u7c7b\u578b\u4e3a%1$s\u65f6\uff0c%2$s\u5b57\u6bb5\u5fc5\u5f55\u3002", (String)"CalendarSetValidatorPlugin_09", (String)APPPARAM, (Object[])new Object[0]), orgNamedesc, orgNamedesc));
                continue;
            }
            if ("B".equals(type) && workShop == null) {
                this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u5f53\u4f7f\u7528\u5bf9\u8c61\u7c7b\u578b\u4e3a%1$s\u65f6\uff0c%2$s\u5b57\u6bb5\u5fc5\u5f55\u3002", (String)"CalendarSetValidatorPlugin_09", (String)APPPARAM, (Object[])new Object[0]), workShopNamedesc, workShopNamedesc));
                continue;
            }
            if ("C".equals(type) && workCenter == null) {
                this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u5f53\u4f7f\u7528\u5bf9\u8c61\u7c7b\u578b\u4e3a%1$s\u65f6\uff0c%2$s\u5b57\u6bb5\u5fc5\u5f55\u3002", (String)"CalendarSetValidatorPlugin_09", (String)APPPARAM, (Object[])new Object[0]), workCenterNamedesc, workCenterNamedesc));
                continue;
            }
            Long bizId = this.getBizId(data);
            if (bizId == null || bizId.equals(0L)) {
                this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u4f7f\u7528\u5bf9\u8c61\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"CalendarSetValidatorPlugin_11", (String)APPPARAM, (Object[])new Object[0]), workCenterNamedesc, workCenterNamedesc));
                continue;
            }
            String repeatKey = this.getRepeatKeys(data);
            if (!repeatDataSet.add(repeatKey)) {
                this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u672c\u6b21\u8fdb\u884c\u6279\u91cf\u4fdd\u5b58\u65f6\u5b58\u5728\u91cd\u590d\u7684\u5bf9\u8c61\u7c7b\u578b\u548c\u5bf9\u8c61\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"CalendarSetValidatorPlugin_08", (String)APPPARAM, (Object[])new Object[0]));
                continue;
            }
            Long setId = data.getLong("id");
            if (this.checkHasExistsData(bizId, type, setId)) {
                this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u5bf9\u8c61\u7c7b\u578b\u53ca%1$s\u7684\u65e5\u5386\u8bbe\u7f6e\u6570\u636e\uff0c\u8bf7\u5207\u6362\u8282\u70b9\u540e\u91cd\u8bd5\u3002", (String)"CalendarSetValidatorPlugin_10", (String)APPPARAM, (Object[])new Object[0]), "A".equals(type) ? orgNamedesc : ("B".equals(type) ? workShopNamedesc : workCenterNamedesc)));
                continue;
            }
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            if (entrys == null || entrys.isEmpty()) continue;
            HashSet<Long> canendarIdSet = new HashSet<Long>(16);
            int rowIndex = 0;
            for (DynamicObject entry : entrys) {
                ++rowIndex;
                DynamicObject calendar = entry.getDynamicObject("calendar");
                if (calendar == null) continue;
                if (!canendarIdSet.add(calendar.getLong("id"))) {
                    this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u751f\u4ea7\u65e5\u5386\u7f16\u7801\u201c%2$s\u201d\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"CalendarSetValidatorPlugin_06", (String)APPPARAM, (Object[])new Object[0]), rowIndex, calendar.getString("number")));
                    continue;
                }
                if (!"A".equals(data.getString("objecttype")) || entry.getBoolean("iseffectplan") || entry.getBoolean("iseffectproduct") || entry.getBoolean("iseffectproject")) continue;
                this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u751f\u4ea7\u65e5\u5386\u7f16\u7801\u201c%2$s\u201d\u672a\u52fe\u9009\u9002\u7528\u751f\u4ea7\u3001\u9002\u7528\u8ba1\u5212\u3001\u9002\u7528\u9879\u76ee\u4e2d\u7684\u4efb\u4e00\u9879\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"CalendarSetValidatorPlugin_07", (String)APPPARAM, (Object[])new Object[0]), rowIndex, calendar.getString("number")));
            }
        }
    }

    private boolean checkHasExistsData(Long nodeId, String type, Long setId) {
        if (nodeId == null || nodeId.equals(0L)) {
            return false;
        }
        String queryField = "A".equals(type) ? "org" : ("B".equals(type) ? "workshop" : "workcenter");
        QFilter qfilter = new QFilter("objecttype", "=", (Object)type);
        qfilter.and(new QFilter(queryField, "=", (Object)nodeId));
        if (setId != null && !setId.equals(0L)) {
            qfilter.and(new QFilter("id", "<>", (Object)setId));
        }
        return QueryServiceHelper.exists((String)"mpdm_calendarset", (QFilter[])new QFilter[]{qfilter});
    }

    private String getRepeatKeys(DynamicObject data) {
        return data.getString("objecttype") + "_" + String.valueOf(this.getBizId(data));
    }

    private Long getBizId(DynamicObject data) {
        if ("C".equals(data.getString("objecttype"))) {
            return (Long)data.getDynamicObject("workcenter").getPkValue();
        }
        if ("B".equals(data.getString("objecttype"))) {
            return (Long)data.getDynamicObject("workshop").getPkValue();
        }
        if ("A".equals(data.getString("objecttype"))) {
            return (Long)data.getDynamicObject("org").getPkValue();
        }
        return 0L;
    }

    private String getOrgNameDesc() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"CalendarSetValidatorPlugin_01", (String)APPPARAM, (Object[])new Object[0]);
    }

    private String getWorkShopNameDesc() {
        return ResManager.loadKDString((String)"\u8f66\u95f4", (String)"CalendarSetValidatorPlugin_02", (String)APPPARAM, (Object[])new Object[0]);
    }

    private String getWorkCenterNameDesc() {
        return ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3", (String)"CalendarSetValidatorPlugin_03", (String)APPPARAM, (Object[])new Object[0]);
    }
}

