/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.course;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class CourseValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey) || "audit".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject billObj = dataEntity.getDataEntity();
                String retrainingCourse = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)dataEntity.getDataEntity(), (String)"retrainingcourse");
                BigDecimal classHour = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)dataEntity.getDataEntity(), (String)"classhour");
                if ("true".equals(retrainingCourse)) {
                    BigDecimal retrainingCycles = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)dataEntity.getDataEntity(), (String)"retrainingcycle");
                    if (retrainingCycles.compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u590d\u8bad\u5468\u671f\u201d\u3002", (String)"CourseValidator_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    String cycleunit = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)dataEntity.getDataEntity(), (String)"cycleunit");
                    if (cycleunit.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5468\u671f\u5355\u4f4d\u201d\u3002", (String)"CourseValidator_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    Iterator inventory = billObj.getDynamicObjectCollection("courseinventory");
                    if (inventory.size() == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u590d\u8bad\u8bfe\u7a0b\u5f00\u542f\u540e\uff0c\u590d\u8bad\u8bfe\u7a0b\u6e05\u5355\u5e94\u81f3\u5c11\u67091\u9879\u8bfe\u7a0b\u3002", (String)"CourseValidator_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                int i = 0;
                DynamicObjectCollection stageEntitys = billObj.getDynamicObjectCollection("coursestage");
                for (DynamicObject stageEntity : stageEntitys) {
                    String exam = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)stageEntity, (String)"exam");
                    ++i;
                    if (!"true".equals(exam)) continue;
                    BigDecimal topicaMount = stageEntity.getBigDecimal("topicamountqty");
                    BigDecimal passingScores = stageEntity.getBigDecimal("passingscores");
                    BigDecimal examTimes = stageEntity.getBigDecimal("examtimes");
                    if (topicaMount.compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bfe\u7a0b\u9636\u6bb5\u7b2c %1$s \u884c\u52fe\u9009\u4e86\u8003\u8bd5\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c %1$s \u884c\u4e2d\u201c\u9898\u76ee\u6570\uff08\u9053\uff09\u201d\u3002", (String)"CourseValidator_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i));
                        return;
                    }
                    if (passingScores.compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bfe\u7a0b\u9636\u6bb5\u7b2c %1$s \u884c\u52fe\u9009\u4e86\u8003\u8bd5\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c %1$s \u884c\u4e2d\u201c\u53ca\u683c\u7ebf\uff08\u5206\uff09\u201d\u3002", (String)"CourseValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i, i + 1));
                        return;
                    }
                    if (examTimes.compareTo(BigDecimal.ZERO) != 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bfe\u7a0b\u9636\u6bb5\u7b2c %1$s \u884c\u52fe\u9009\u4e86\u8003\u8bd5\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c %1$s \u884c\u4e2d\u201c\u8003\u8bd5\u65f6\u957f\uff08\u5206\u949f\uff09\u201d\u3002", (String)"CourseValidator_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i));
                    return;
                }
                BigDecimal classTime = new BigDecimal("0");
                DynamicObjectCollection stages = billObj.getDynamicObjectCollection("coursestage");
                for (DynamicObject stage : stages) {
                    BigDecimal stageClassHour = stage.getBigDecimal("stageclasshour");
                    classTime = classTime.add(stageClassHour);
                }
                if (classHour.compareTo(classTime) == 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9636\u6bb5\u8bfe\u65f6\u6570\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u603b\u8bfe\u65f6\u6570\u3002", (String)"CourseValidator_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }
}

