/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.fixdata;

import kd.bd.mpdm.business.helper.MaterialInvInfoHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class FixInvInfo
extends AbstractOperationServicePlugIn {
    private static String KEY_MATERIALINVINFO = "materielinv";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        MainEntityType type = this.billEntityType;
        String billname = type.getName();
        if (this.isStockBill(billname)) {
            e.getFieldKeys().add("stockentry");
            e.getFieldKeys().add("stockentry.supplyorgid");
            e.getFieldKeys().add("stockentry.materielmasterid");
            e.getFieldKeys().add("stockentry.materielinv");
        } else {
            e.getFieldKeys().add("treeentryentity");
            e.getFieldKeys().add("treeentryentity.inwardept");
            e.getFieldKeys().add("treeentryentity.materielmasterid");
            e.getFieldKeys().add("treeentryentity.materielinv");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills;
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObject invinfo;
            DynamicObjectCollection entrys;
            MainEntityType type = this.billEntityType;
            String billname = type.getName();
            if (this.isStockBill(billname)) {
                entrys = bill.getDynamicObjectCollection("stockentry");
                for (DynamicObject entry : entrys) {
                    invinfo = (DynamicObject)entry.get(KEY_MATERIALINVINFO);
                    if (invinfo != null) continue;
                    DynamicObject supplyorgfield = entry.getDynamicObject("supplyorgid");
                    DynamicObject materielmasterid = entry.getDynamicObject("materielmasterid");
                    DynamicObject materialInvInfo2 = MaterialInvInfoHelper.getMaterialInvInfo((DynamicObject)supplyorgfield, (DynamicObject)materielmasterid);
                    entry.set(KEY_MATERIALINVINFO, (Object)materialInvInfo2);
                }
                continue;
            }
            entrys = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrys) {
                invinfo = (DynamicObject)entry.get(KEY_MATERIALINVINFO);
                if (invinfo != null) continue;
                DynamicObject inwardept = entry.getDynamicObject("inwardept");
                DynamicObject master = entry.getDynamicObject("materielmasterid");
                DynamicObject materialInvInfo = MaterialInvInfoHelper.getMaterialInvInfo((DynamicObject)inwardept, (DynamicObject)master);
                entry.set(KEY_MATERIALINVINFO, (Object)materialInvInfo);
            }
        }
        SaveServiceHelper.update((DynamicObject[])bills);
    }

    private boolean isStockBill(String billname) {
        switch (billname) {
            case "pom_mftorder": 
            case "pom_xmftorder": 
            case "om_mftorder": 
            case "om_xmftorder": {
                return false;
            }
            case "pom_mftstock": 
            case "pom_xmftstock": 
            case "om_componentlist": 
            case "om_xcomponentlist": 
            case "om_mftstock": 
            case "om_xmftstock": {
                return true;
            }
        }
        return false;
    }
}

