/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.utils.StockCulUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OmOldStockUpdateQtyOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OmOldStockUpdateQtyOp.class);
    private static final String KEY_BILLENTRY = "stockentry";
    private static final String KEY_ORDERID = "orderid";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add(KEY_BILLENTRY);
        filds.add("billstatus");
        filds.add(KEY_ORDERID);
        filds.add("orderentryid");
        filds.add("transactiontypeid");
        filds.add("stockentry.rejectedqty");
        filds.add("stockentry.actissueqty");
        filds.add("stockentry.cansendqty");
        filds.add("stockentry.unissueqty");
        filds.add("stockentry.outqty");
        filds.add("stockentry.extraratioqty");
        filds.add("stockentry.demandqty");
        filds.add("stockentry.feedingqty");
        filds.add("stockentry.scrapqty");
        filds.add("iscannegative");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataArray = e.getDataEntities();
        ArrayList<Long> stockEntryList = new ArrayList<Long>(16);
        HashMap<Long, DynamicObject> stockEntryMap = new HashMap<Long, DynamicObject>(16);
        for (int i = 0; i < dataArray.length; ++i) {
            DynamicObject obj = dataArray[i];
            DynamicObjectCollection stockEntrys = obj.getDynamicObjectCollection(KEY_BILLENTRY);
            for (DynamicObject stockEntry : stockEntrys) {
                stockEntryList.add((Long)stockEntry.getPkValue());
                stockEntryMap.put((Long)stockEntry.getPkValue(), stockEntry);
            }
        }
        String entityName = "im_mdc_omproorder";
        String fieldName = "billtype.billformid";
        String selectFieldName = "billentry.baseqty,billentry.mainbillentryid";
        QFilter filter = new QFilter("billentry.mainbillentryid", "in", stockEntryList);
        logger.info("----------------------------\u8ba1\u7b97\u5173\u8054\u6570\u91cf\u5f00\u59cb\uff1a");
        Long startdate = System.currentTimeMillis();
        DynamicObjectCollection actissuebills = QueryServiceHelper.query((String)entityName, (String)selectFieldName, (QFilter[])new QFilter[]{filter, new QFilter(fieldName, "=", (Object)entityName), new QFilter("billstatus", "=", (Object)"C")});
        this.calQty(actissuebills, stockEntryMap, "actissueqty");
        logger.info("----------------------------\u8ba1\u7b97\u5b9e\u53d1\u6570\u91cf\u7ed3\u675f,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startdate) + "ms----------------------------");
        DynamicObjectCollection outbills = QueryServiceHelper.query((String)entityName, (String)selectFieldName, (QFilter[])new QFilter[]{filter, new QFilter(fieldName, "=", (Object)entityName)});
        this.calQty(outbills, stockEntryMap, "outqty");
        logger.info("----------------------------\u8ba1\u7b97\u4e0b\u63a8\u9886\u6599\u6570\u91cf\u7ed3\u675f,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startdate) + "ms-----------------------------");
        DynamicObjectCollection rejectedbills = QueryServiceHelper.query((String)entityName, (String)selectFieldName, (QFilter[])new QFilter[]{filter, new QFilter(fieldName, "=", (Object)"im_mdc_omreturnorder"), new QFilter("billstatus", "=", (Object)"C")});
        this.calQty(rejectedbills, stockEntryMap, "rejectedqty");
        logger.info("----------------------------\u8ba1\u7b97\u9000\u6599\u6570\u91cf\u7ed3\u675f,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startdate) + "ms------------------------------");
        DynamicObjectCollection feedingbills = QueryServiceHelper.query((String)entityName, (String)selectFieldName, (QFilter[])new QFilter[]{filter, new QFilter(fieldName, "=", (Object)"im_mdc_omfeedorder"), new QFilter("billstatus", "=", (Object)"C")});
        this.calQty(feedingbills, stockEntryMap, "feedingqty");
        logger.info("----------------------------\u8ba1\u7b97\u8865\u6599\u6570\u91cf\u7ed3\u675f,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startdate) + "ms-------------------------------");
        for (Map.Entry result : stockEntryMap.entrySet()) {
            DynamicObject stockEntry = (DynamicObject)result.getValue();
            stockEntry.set("cansendqty", OmOldStockUpdateQtyOp.aculCanSendQty(stockEntry));
            stockEntry.set("unissueqty", OmOldStockUpdateQtyOp.aculUnSendQty(stockEntry));
        }
        Long enddate = System.currentTimeMillis() - startdate;
        logger.info("----------------------------\u8ba1\u7b97\u4e0b\u63a8\u672a\u53d1\u6570\u91cf\u7ed3\u675f,\u8017\u65f6\uff1a" + enddate + "ms------------------------------");
        SaveServiceHelper.save((DynamicObject[])dataArray);
        logger.info("----------------------------\u4fdd\u5b58\u7ec4\u4ef6\u6e05\u5355\u6570\u91cf\u7ed3\u675f,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startdate) + "ms---------------------------------");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] stocks;
        Long startdate = System.currentTimeMillis();
        ArrayList<Long> orderEntryIdList = new ArrayList<Long>(16);
        for (DynamicObject stock : stocks = e.getDataEntities()) {
            DynamicObject orderentry = stock.getDynamicObject("orderentryid");
            if (orderentry == null) continue;
            orderEntryIdList.add((Long)orderentry.getPkValue());
        }
        StockCulUtils.batchCulUseQtyByOrderEntryId(orderEntryIdList, (String)"pm_om_purorderbill");
        Long enddate = System.currentTimeMillis() - startdate;
        logger.info("----------------------------\u8ba1\u7b97\u4e0b\u63a8\u5df2\u6d88\u8017\u6570\u91cf\u7ed3\u675f,\u8017\u65f6\uff1a" + enddate + "ms---------------------------------");
    }

    private void calQty(DynamicObjectCollection bills, Map<Long, DynamicObject> stockEntryMap, String qtyName) {
        HashMap<Long, BigDecimal> actissueqtyRes = new HashMap<Long, BigDecimal>();
        for (DynamicObject bill : bills) {
            Long mainbillentryid = bill.getLong("billentry.mainbillentryid");
            BigDecimal baseqty = bill.getBigDecimal("billentry.baseqty");
            BigDecimal actissueqty = (BigDecimal)actissueqtyRes.get(mainbillentryid);
            actissueqty = actissueqty == null ? baseqty : actissueqty.add(baseqty);
            actissueqtyRes.put(mainbillentryid, actissueqty);
        }
        for (Map.Entry<Long, DynamicObject> result : stockEntryMap.entrySet()) {
            Long key = result.getKey();
            DynamicObject stockEntry = result.getValue();
            BigDecimal qty = (BigDecimal)actissueqtyRes.get(key);
            if (qty == null) {
                qty = BigDecimal.ZERO;
            }
            if (qty.compareTo(BigDecimal.ZERO) < 0) {
                qty = BigDecimal.ZERO.subtract(qty);
            }
            stockEntry.set(qtyName, (Object)qty);
            if (!stockEntry.getBoolean("iscannegative") || !"actissueqty".equals(qtyName)) continue;
            stockEntry.set(qtyName, stockEntry.get("demandqty"));
        }
    }

    public static Object aculCanSendQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal demand = stockEntry.getBigDecimal("extraratioqty");
            BigDecimal actissue = stockEntry.getBigDecimal("actissueqty");
            BigDecimal rejecte = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal feeding = stockEntry.getBigDecimal("feedingqty");
            BigDecimal scrap = stockEntry.getBigDecimal("scrapqty");
            BigDecimal cansend = BigDecimal.ZERO;
            cansend = cansend.add(demand == null ? BigDecimal.ZERO : demand);
            cansend = cansend.add(rejecte == null ? BigDecimal.ZERO : rejecte);
            cansend = cansend.subtract(actissue == null ? BigDecimal.ZERO : actissue);
            cansend = cansend.subtract(feeding == null ? BigDecimal.ZERO : feeding);
            if ((cansend = cansend.subtract(scrap == null ? BigDecimal.ZERO : scrap)).compareTo(BigDecimal.ZERO) < 0) {
                cansend = BigDecimal.ZERO;
            }
            return cansend;
        }
        return BigDecimal.ZERO;
    }

    public static Object aculUnSendQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal demand = stockEntry.getBigDecimal("demandqty");
            BigDecimal actissue = stockEntry.getBigDecimal("actissueqty");
            BigDecimal rejecte = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal feeding = stockEntry.getBigDecimal("feedingqty");
            BigDecimal scrap = stockEntry.getBigDecimal("scrapqty");
            BigDecimal cansend = BigDecimal.ZERO;
            cansend = cansend.add(demand == null ? BigDecimal.ZERO : demand);
            cansend = cansend.add(rejecte == null ? BigDecimal.ZERO : rejecte);
            cansend = cansend.subtract(actissue == null ? BigDecimal.ZERO : actissue);
            cansend = cansend.subtract(feeding == null ? BigDecimal.ZERO : feeding);
            cansend = cansend.subtract(scrap == null ? BigDecimal.ZERO : scrap);
            return cansend;
        }
        return BigDecimal.ZERO;
    }
}

