/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class OrderDeleteEndOptOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map<Object, DynamicObject> orders = this.loadMtfOrders(e.getDataEntities());
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        this.delStock(orders, successObjs);
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private void delStock(Map<Object, DynamicObject> orders, List<DynamicObject> successObjs) {
        HashMap<Object, Object> orderEntryIdtoBillIds = new HashMap<Object, Object>(orders.size());
        HashMap<Object, Object> delStockIdtoOrderEntryIds = new HashMap<Object, Object>(orders.size());
        HashMap<Object, String> failOrderEntryIds = new HashMap<Object, String>(orders.size());
        for (DynamicObject order : orders.values()) {
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject col : entryCol) {
                Object orderEntryId = col.getPkValue();
                orderEntryIdtoBillIds.put(orderEntryId, order.getPkValue());
            }
        }
        if (orderEntryIdtoBillIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        String stockname = this.getOption().getVariableValue("manustock");
        QFilter stockqfilter = new QFilter("orderentryid", "in", (Object)orderEntryIdtoBillIds.keySet().toArray());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"OrderDeleteEndOptOp.delStock", (String)stockname, (String)"id,billstatus,orderentryid", (QFilter[])new QFilter[]{stockqfilter}, (String)"");
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                delStockIdtoOrderEntryIds.put(row.get("id"), row.get("orderentryid"));
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (delStockIdtoOrderEntryIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)stockname, (Object[])delStockIdtoOrderEntryIds.keySet().toArray(), (OperateOption)option);
        HashSet delSuccessIds = new HashSet(delResult.getSuccessPkIds());
        if (delSuccessIds.isEmpty()) {
            this.setFailMes(delResult, delStockIdtoOrderEntryIds, failOrderEntryIds);
        } else {
            for (Map.Entry stockIdtoOrderEntryId : delStockIdtoOrderEntryIds.entrySet()) {
                Object stockId = stockIdtoOrderEntryId.getKey();
                Object orderEntryId = stockIdtoOrderEntryId.getValue();
                if (delSuccessIds.contains(stockId)) continue;
                failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, delResult));
            }
        }
        if (!failOrderEntryIds.isEmpty()) {
            for (DynamicObject order : orders.values()) {
                boolean errBoolean = false;
                DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
                for (int i = 1; i <= entryCol.size(); ++i) {
                    Object orderEntryId = ((DynamicObject)entryCol.get(i - 1)).getPkValue();
                    String ids = (String)failOrderEntryIds.get(orderEntryId);
                    if (ids == null) continue;
                    errBoolean = true;
                    this.operationResult.addErrorInfo(this.buildErrMessage(order, ids, i));
                }
                if (errBoolean) continue;
                successObjs.add(order);
            }
        } else {
            successObjs.addAll(orders.values());
        }
    }

    private Map<Object, DynamicObject> loadMtfOrders(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashMap<Object, DynamicObject>(0);
        }
        HashMap<Object, DynamicObject> orders = new HashMap<Object, DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            orders.put(dataEntity.getPkValue(), dataEntity);
        }
        return orders;
    }

    private void setFailMes(OperationResult submitResult, Map<Object, Object> submitStockIdtoOrderEntryIds, Map<Object, String> failOrderEntryIds) {
        HashSet submitSuccessIds = new HashSet(submitResult.getSuccessPkIds());
        for (Map.Entry<Object, Object> stockIdtoOrderEntryId : submitStockIdtoOrderEntryIds.entrySet()) {
            Object stockId = stockIdtoOrderEntryId.getKey();
            Object orderEntryId = stockIdtoOrderEntryId.getValue();
            if (submitSuccessIds.contains(stockId)) continue;
            failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, submitResult));
        }
    }

    private String getErrorBystockId(Object stockId, OperationResult submitResult) {
        for (IOperateInfo errInfo : submitResult.getAllErrorOrValidateInfo()) {
            if (!errInfo.getPkValue().toString().equals(stockId.toString())) continue;
            return errInfo.getMessage();
        }
        return "";
    }

    private OperateErrorInfo buildErrMessage(DynamicObject order, String err, int i) {
        Object pkId = order.getPkValue();
        int dataIndex = 0;
        int rowIndex = i - 1;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u7684\u7b2c%2$s\u884c\u5206\u5f55\uff0c\u7ec4\u4ef6\u6e05\u5355\u81ea\u52a8\u5220\u9664\u5931\u8d25\uff1a%3$s", (String)"OrderDeleteEndOptOp_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), order.getString("billno"), i, err);
        return new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "OrderDeleteEndOptOp_delStock_Fail", ResManager.loadKDString((String)"\u5220\u9664", (String)"OrderDeleteEndOptOp_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), msg, errorLevel);
    }
}

