/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import com.alibaba.fastjson.JSONArray;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.mftorder.OrderBookDateService;
import kd.bd.mpdm.business.mftorder.OrderCommonService;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.opplugin.manufacturemodel.validator.OrderModBookDateVal;
import kd.bd.mpdm.opplugin.manufacturemodel.validator.OrderModTimeVal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class OrderModTimeOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("transactiontype");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("treeentryentity.seq");
        e.getFieldKeys().add("treeentryentity.producttype");
        e.getFieldKeys().add("treeentryentity.closetime");
        e.getFieldKeys().add("treeentryentity.transmittime");
        e.getFieldKeys().add("treeentryentity.beginbookdate");
        e.getFieldKeys().add("treeentryentity.closebookdate");
        e.getFieldKeys().add("treeentryentity.inwardept");
        e.getFieldKeys().add("treeentryentity.bizstatus");
        e.getFieldKeys().add("treeentryentity.taskstatus");
        e.getFieldKeys().add("treeentryentity.planstatus");
        e.getFieldKeys().add("treeentryentity.startworktime");
        e.getFieldKeys().add("treeentryentity.endworktime");
        e.getFieldKeys().add("treeentryentity.transmittime");
        e.getFieldKeys().add("treeentryentity.pid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OrderModTimeVal());
        e.addValidator((AbstractValidator)new OrderModBookDateVal());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String opKey = e.getOperationKey();
        String toBeModEntrysIdsStr = this.getOption().getVariableValue("toBeModEntrysIds");
        if (StringUtils.isNotBlank((CharSequence)toBeModEntrysIdsStr)) {
            List toBeModEntrysIds = JSONArray.parseArray((String)toBeModEntrysIdsStr, String.class);
            String dateValue = this.getOption().getVariableValue("modCloseTimeOp");
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = null;
            try {
                if (StringUtils.isNotEmpty((CharSequence)dateValue)) {
                    date = sf.parse(dateValue);
                }
            }
            catch (ParseException e2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4fee\u6539\u5173\u95ed\u65f6\u95f4/\u4e0b\u8fbe\u65f6\u95f4\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff0c\u64cd\u4f5c\u7ec8\u6b62\u3002", (String)"OrderModTimeOp_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            DynamicObject[] dataEntities = e.getDataEntities();
            String entityName = dataEntities[0].getDataEntityType().getName();
            Map<Long, Boolean> transactiontypeMap = this.getTransactiontype(dataEntities);
            boolean bookDateEqualsBizDate = false;
            Map productOrgAndBookDateMap = null;
            HashMap maxInvOrgAndBookDateMap = new HashMap(1);
            if (!bookDateEqualsBizDate && (StringUtils.equals((CharSequence)"modclosetimeop", (CharSequence)opKey) || StringUtils.equals((CharSequence)"modtransmittimeop", (CharSequence)opKey))) {
                HashSet<Long> entryIds = new HashSet<Long>(10);
                for (String string : toBeModEntrysIds) {
                    entryIds.add(Long.parseLong(string));
                }
                DynamicObject[] manuBills = OrderCommonService.queryManuBills(entryIds, (String)this.billEntityType.getName());
                Map bookdates = OrderBookDateService.makeupOrgDates(entryIds, (DynamicObject[])manuBills);
                productOrgAndBookDateMap = (Map)bookdates.get("productOrgAndBookDateMap");
            }
            Map mainProIdAndBookDateMaps = new HashMap(16);
            if ("modclosetimeop".equals(opKey)) {
                mainProIdAndBookDateMaps = OrderBookDateService.orderEntryIdAndOldBookDateMap((DynamicObject[])dataEntities, (String)"closebookdate");
            } else if ("modtransmittimeop".equals(opKey)) {
                mainProIdAndBookDateMaps = OrderBookDateService.orderEntryIdAndOldBookDateMap((DynamicObject[])dataEntities, (String)"beginbookdate");
            }
            for (DynamicObject manubill : dataEntities) {
                DynamicObjectCollection dynamicObjectCollection = manubill.getDynamicObjectCollection("treeentryentity");
                DynamicObject transactiontype = manubill.getDynamicObject("transactiontype");
                Long transactiontypeId = transactiontype == null ? 0L : transactiontype.getLong("id");
                for (DynamicObject entry : dynamicObjectCollection) {
                    Date oldBookDate = null;
                    String pkValue = entry.getPkValue().toString();
                    for (String toBeModEntrysId : toBeModEntrysIds) {
                        if (!StringUtils.equals((CharSequence)pkValue, (CharSequence)toBeModEntrysId)) continue;
                        DynamicObject entryTemp = null;
                        switch (opKey) {
                            case "modclosetimeop": {
                                oldBookDate = (Date)mainProIdAndBookDateMaps.get(entry.getLong("id"));
                                entry.set("closetime", (Object)date);
                                Date closeBookDate = null;
                                if (bookDateEqualsBizDate) {
                                    closeBookDate = date;
                                    entry.set("closebookdate", (Object)(closeBookDate != null ? DateUtils.getShortDate((Date)closeBookDate) : null));
                                    break;
                                }
                                entryTemp = OrderCommonService.matchEntryInfo((DynamicObject)entry, (DynamicObjectCollection)dynamicObjectCollection);
                                closeBookDate = OrderBookDateService.queryBookDateWithCompare((DynamicObject)manubill, (DynamicObject)entryTemp, (Map)productOrgAndBookDateMap, maxInvOrgAndBookDateMap, (Date)date, (String)"closebookdate", (boolean)true, (Date)oldBookDate, (boolean)false);
                                if (null == closeBookDate) break;
                                entry.set("closebookdate", (Object)(closeBookDate != null ? DateUtils.getShortDate((Date)closeBookDate) : null));
                                break;
                            }
                            case "modtransmittimeop": {
                                entry.set("transmittime", (Object)date);
                                if (!transactiontypeMap.containsKey(transactiontypeId) || !transactiontypeMap.get(transactiontypeId).booleanValue()) break;
                                entry.set("startworktime", (Object)date);
                                break;
                            }
                            case "modbeginbookdateop": {
                                entry.set("beginbookdate", (Object)(date != null ? DateUtils.getShortDate((Date)date) : null));
                                break;
                            }
                            case "modclosebookdateop": {
                                entry.set("closebookdate", (Object)(date != null ? DateUtils.getShortDate((Date)date) : null));
                                break;
                            }
                        }
                    }
                }
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
            OperationResult result = this.getOperationResult();
            if (result.isSuccess()) {
                result.setShowMessage(true);
            }
        }
    }

    private Map<Long, Boolean> getTransactiontype(DynamicObject[] dataEntities) {
        HashMap<Long, Boolean> transactiontypeMap = new HashMap<Long, Boolean>(16);
        HashSet<Long> transactionIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject transactiontype = dynamicObject.getDynamicObject("transactiontype");
            if (transactiontype == null) continue;
            transactionIds.add(transactiontype.getLong("id"));
        }
        Map tt = TransactionTypeQueryHelper.getDataCacheBySet(transactionIds);
        for (Map.Entry entrys : tt.entrySet()) {
            DynamicObject trans = (DynamicObject)entrys.getValue();
            transactiontypeMap.put(trans.getLong("id"), trans.getBoolean("transmitbeginwork"));
        }
        return transactiontypeMap;
    }
}

