/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.PlanScopeHelper;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrderPlanScopeVal
extends AbstractValidator {
    public void validate() {
        if (!"pom_mftorder".equals(this.entityKey) && !"om_mftorder".equals(this.entityKey)) {
            return;
        }
        this.setPlanScopeInfo();
        for (ExtendedDataEntity dataEntiy : this.getDataEntities()) {
            Map planMaterialMap;
            DynamicObject obj = dataEntiy.getDataEntity();
            DynamicObject entrustdept = obj.getDynamicObject("entrustdept");
            DynamicObject mtfOrg = obj.getDynamicObject("org");
            DynamicObjectCollection treeentrys = obj.getDynamicObjectCollection("treeentryentity");
            HashSet<Long> masterIdSet = new HashSet<Long>(16);
            HashSet<Long> entrustSet = new HashSet<Long>(16);
            for (DynamicObject entry : treeentrys) {
                DynamicObject material = entry.getDynamicObject("material");
                String supplyrule = entry.getString("supplyrule");
                if ("C".equals(supplyrule) && entrustdept != null && material != null) {
                    entrustSet.add((Long)material.getDynamicObject("masterid").getPkValue());
                }
                if ("C".equals(supplyrule) || material == null) continue;
                masterIdSet.add((Long)material.getDynamicObject("masterid").getPkValue());
            }
            HashMap<Long, Map> orgplanMaterialMap = new HashMap<Long, Map>(16);
            HashMap supplynetworkMap = new HashMap(16);
            if (!entrustSet.isEmpty()) {
                planMaterialMap = MaterialPlanQueryHelper.getDataCacheByMaterialSet(entrustSet, (Long)entrustdept.getLong("id"));
                orgplanMaterialMap.put(entrustdept.getLong("id"), planMaterialMap);
                supplynetworkMap.putAll(PlanScopeHelper.getSupplynetworkMap(planMaterialMap.values()));
            }
            if (!masterIdSet.isEmpty()) {
                planMaterialMap = MaterialPlanQueryHelper.getDataCacheByMaterialSet(masterIdSet, (Long)mtfOrg.getLong("id"));
                orgplanMaterialMap.put(mtfOrg.getLong("id"), planMaterialMap);
                supplynetworkMap.putAll(PlanScopeHelper.getSupplynetworkMap(planMaterialMap.values()));
            }
            StringBuilder sbInfo = new StringBuilder();
            for (int i = 0; i < treeentrys.size(); ++i) {
                DynamicObject material;
                DynamicObject entry = (DynamicObject)treeentrys.get(i);
                String errorInfo = PlanScopeHelper.validateAfterMaterialChanged((DynamicObject)entry, (DynamicObject)(material = entry.getDynamicObject("material")), orgplanMaterialMap, supplynetworkMap, (DynamicObject)mtfOrg, (DynamicObject)entrustdept);
                if ("".equals(errorInfo)) continue;
                sbInfo.append(errorInfo);
            }
            if ("".equals(sbInfo.toString())) continue;
            this.addErrorMessage(dataEntiy, sbInfo.toString());
        }
    }

    private void setPlanScopeInfo() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, Set> orgMaterialIdMap = new HashMap<Long, Set>(16);
        for (ExtendedDataEntity extendedData : dataEntities) {
            DynamicObject order = extendedData.getDataEntity();
            Long orgid = order.get("org") == null ? 0L : order.getDynamicObject("org").getLong("id");
            Long l = order.get("entrustdept") == null ? 0L : order.getDynamicObject("entrustdept").getLong("id");
            Long isOrgId = "0".equals(l.toString()) ? (Object)orgid : (Object)l;
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                DynamicObject material = orderEntry.getDynamicObject("material");
                if (material == null) continue;
                Long masterId = material.getDynamicObject("masterid").getLong("id");
                if (orderEntry.get("inwardept") != null && orderEntry.get("planscope") != null) continue;
                orgMaterialIdMap.computeIfAbsent(isOrgId, k -> new HashSet(10)).add(masterId);
            }
        }
        HashMap<Long, Map> orgMasterPlanScopeInfoMap = new HashMap<Long, Map>(16);
        HashSet<Long> planScopeSet = new HashSet<Long>(16);
        HashSet<Long> inwardeptSet = new HashSet<Long>(16);
        HashSet<Long> warehouseSet = new HashSet<Long>(16);
        HashSet<Long> locationSet = new HashSet<Long>(16);
        for (Map.Entry entry : orgMaterialIdMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Set masterIdSet = (Set)entry.getValue();
            Map mtfMessage = PlanScopeHelper.getMaterialInwareInfo((Long)orgId, (Set)masterIdSet);
            for (Map.Entry mftInfo : mtfMessage.entrySet()) {
                Map mftInfoMap = (Map)mftInfo.getValue();
                if (mftInfoMap == null) continue;
                planScopeSet.add((Long)mftInfoMap.get("planscope"));
                inwardeptSet.add((Long)mftInfoMap.get("inwarorg"));
                warehouseSet.add((Long)mftInfoMap.get("inwarehouse"));
                locationSet.add((Long)mftInfoMap.get("inwarelocation"));
            }
            orgMasterPlanScopeInfoMap.put(orgId, mtfMessage);
        }
        Map planscopeMap = BusinessDataServiceHelper.loadFromCache((String)"msplan_planscope", (String)"number,type", (QFilter[])new QFilter[]{new QFilter("id", "in", planScopeSet)});
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"number,fisaccounting", (QFilter[])new QFilter[]{new QFilter("id", "in", inwardeptSet)});
        Map warehouseMap = BusinessDataServiceHelper.loadFromCache((String)"bd_warehouse", (String)"number,isopenlocation", (QFilter[])new QFilter[]{new QFilter("id", "in", warehouseSet)});
        Map locationMap = BusinessDataServiceHelper.loadFromCache((String)"bd_location", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", locationSet)});
        for (ExtendedDataEntity extendedData : dataEntities) {
            DynamicObject order = extendedData.getDataEntity();
            Long orgid = order.get("org") == null ? 0L : order.getDynamicObject("org").getLong("id");
            Long entrustdeptid = order.get("entrustdept") == null ? 0L : order.getDynamicObject("entrustdept").getLong("id");
            Long isOrgId = "0".equals(entrustdeptid.toString()) ? orgid : entrustdeptid;
            Map masterInwarehoseInfoMap = (Map)orgMasterPlanScopeInfoMap.get(isOrgId);
            if (masterInwarehoseInfoMap == null) continue;
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                Long masterId;
                Map inwarehoseInfoMap;
                DynamicObject material = orderEntry.getDynamicObject("material");
                if (material == null || (inwarehoseInfoMap = (Map)masterInwarehoseInfoMap.get(masterId = Long.valueOf(material.getDynamicObject("masterid").getLong("id")))) == null) continue;
                if (orderEntry.get("inwardept") == null) {
                    orderEntry.set("inwardept", map.get(inwarehoseInfoMap.get("inwarorg")));
                    orderEntry.set("warehouse", warehouseMap.get(inwarehoseInfoMap.get("inwarehouse")));
                    orderEntry.set("location", locationMap.get(inwarehoseInfoMap.get("inwarelocation")));
                }
                if (orderEntry.get("planscope") != null) continue;
                orderEntry.set("planscope", planscopeMap.get(inwarehoseInfoMap.get("planscope")));
            }
        }
    }
}

