/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OrderSaveAfterExeOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrderSaveAfterExeOp.class);
    private List<DynamicObject> savedataEntities = new ArrayList<DynamicObject>();
    private List<DynamicObject> updatedataEntities = new ArrayList<DynamicObject>();
    private Set<Long> deleteStockIds = new HashSet<Long>();

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String billEntityType = this.billEntityType.getName();
        if (StringUtils.equals((CharSequence)"pom_mftorder", (CharSequence)billEntityType)) {
            HashSet<String> mergeOrderNos = new HashSet<String>(16);
            List validExtDataEntities = e.getValidExtDataEntities();
            for (ExtendedDataEntity validExtDataEntity : validExtDataEntities) {
                DynamicObject manubill = validExtDataEntity.getDataEntity();
                DynamicObjectCollection orderEntrys = manubill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject orderEntry : orderEntrys) {
                    if (orderEntry.get("sourcebillnumber") == null) continue;
                    mergeOrderNos.add(orderEntry.getString("sourcebillnumber"));
                }
            }
            Set existsMergeOrderNos = OrderMergeHelper.queryMergeOrder(mergeOrderNos);
            ArrayList<ExtendedDataEntity> removeData = new ArrayList<ExtendedDataEntity>(10);
            block2: for (ExtendedDataEntity validExtDataEntity : validExtDataEntities) {
                DynamicObject manubill = validExtDataEntity.getDataEntity();
                DynamicObjectCollection orderEntrys = manubill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject orderEntry : orderEntrys) {
                    if (orderEntry.get("sourcebillnumber") == null || !existsMergeOrderNos.contains(orderEntry.getString("sourcebillnumber"))) continue;
                    removeData.add(validExtDataEntity);
                    continue block2;
                }
            }
            if (removeData.size() > 0) {
                e.getValidExtDataEntities().removeAll(removeData);
            }
            if ((validExtDataEntities = e.getValidExtDataEntities()) == null || validExtDataEntities.size() < 1) {
                e.getValidExtDataEntities().addAll(removeData);
                return;
            }
        }
        String stockname = this.getOption().getVariableValue("manustock");
        OperationResult op = this.getOperationResult();
        int length = e.getDataEntities().length;
        if (!OrderOpUtils.isGenStockByEvent((String)stockname, (int)length)) {
            Long startdate = System.currentTimeMillis();
            logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a\u5f00\u59cb");
            OrderOpUtils.beforeExeData((BeforeOperationArgs)e, this.savedataEntities, this.updatedataEntities, this.deleteStockIds, (Log)logger, (String)stockname, (OperationResult)op);
            logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startdate));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String stockname = this.getOption().getVariableValue("manustock");
        int length = e.getDataEntities().length;
        if (!OrderOpUtils.isGenStockByEvent((String)stockname, (int)length)) {
            OrderOpUtils.updateStock((EndOperationTransactionArgs)e, this.savedataEntities, this.updatedataEntities);
            Long startdate = System.currentTimeMillis();
            logger.info("\u4fdd\u5b58\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\uff1a\u5f00\u59cb");
            OrderOpUtils.handleStock((String)stockname, this.savedataEntities, this.updatedataEntities, this.deleteStockIds, (Log)logger);
            logger.info("\u4fdd\u5b58\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\uff1a\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startdate));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String stockname = this.getOption().getVariableValue("manustock");
        int length = e.getDataEntities().length;
        if (OrderOpUtils.isGenStockByEvent((String)stockname, (int)length)) {
            HashSet<String> billNos = new HashSet<String>(16);
            DynamicObject[] bills = e.getDataEntities();
            if (bills != null && bills.length > 0) {
                for (DynamicObject bill : bills) {
                    billNos.add(bill.getString("billno"));
                }
            }
            OrderOpUtils.sendEventGenStock(billNos);
        }
    }
}

