/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.util.Map;
import kd.bd.mpdm.business.mftorder.validate.OrderAutoSetDefaultValueService;
import kd.bd.mpdm.opplugin.manufacturemodel.OrderAutoFillData;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OrderSaveBeforeExeOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrderSaveBeforeExeOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject obj = objs[i];
            String billno = obj.getString("billno");
            DynamicObject transactiontype = (DynamicObject)obj.get("transactiontype");
            String stockmaterials = "";
            if (transactiontype != null) {
                stockmaterials = transactiontype.getString("stockmaterials");
            }
            DynamicObjectCollection col = obj.getDynamicObjectCollection("treeentryentity");
            this.loopEntries(billno, col, stockmaterials);
        }
        String opVar = this.getOption().getVariableValue("planInvokeOrderSave", "defaultValue");
        if (StringUtils.equals((CharSequence)"planInvokeOrderSave", (CharSequence)opVar)) {
            logger.info("planInvokeOrderSave:begin->");
            this.autoFillEntry(objs);
            logger.info("planInvokeOrderSave:end.");
        } else if (StringUtils.equals((CharSequence)"restructInvokeOrderSave", (CharSequence)opVar)) {
            logger.info("restructInvokeOrderSave:begin->");
            OrderAutoSetDefaultValueService.assignPlanQty((DynamicObject[])objs);
            OrderAutoSetDefaultValueService.assignQualityOrg((DynamicObject[])objs);
            Map mftmaterialMap = OrderAutoSetDefaultValueService.querymftmaterials((DynamicObject[])objs);
            OrderAutoSetDefaultValueService.assignIndeptQty((DynamicObject[])objs, (Map)mftmaterialMap);
            OrderAutoSetDefaultValueService.assignRptQty((DynamicObject[])objs, (Map)mftmaterialMap);
            OrderAutoFillData.setInv(objs);
            logger.info("restructInvokeOrderSave:end.");
        }
    }

    public void autoFillEntry(DynamicObject[] objs) {
        OrderAutoSetDefaultValueService.assignPlanQty((DynamicObject[])objs);
        OrderAutoSetDefaultValueService.autoGenEntryByBom((DynamicObject[])objs, this.billEntityType == null ? null : this.billEntityType.getName());
        OrderAutoSetDefaultValueService.assignQualityOrg((DynamicObject[])objs);
        Map mftmaterialMap = OrderAutoSetDefaultValueService.querymftmaterials((DynamicObject[])objs);
        OrderAutoSetDefaultValueService.assignIndeptQty((DynamicObject[])objs, (Map)mftmaterialMap);
        OrderAutoSetDefaultValueService.assignRptQty((DynamicObject[])objs, (Map)mftmaterialMap);
        OrderAutoFillData.setInv(objs);
    }

    private void loopEntries(String billno, DynamicObjectCollection col, String stockmaterials) {
        for (int j = 0; j < col.size(); ++j) {
            DynamicObject entry = (DynamicObject)col.get(j);
            entry.set("headbillno", (Object)billno);
        }
    }
}

