/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.opplugin.manufacturemodel.OrderSaveAfterExeOp;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OrderSubmitAfterExeOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrderSaveAfterExeOp.class);
    private List<DynamicObject> savedataEntities = new ArrayList<DynamicObject>();
    private List<DynamicObject> updatedataEntities = new ArrayList<DynamicObject>();
    private Set<Long> deleteStockIds = new HashSet<Long>();

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String stockname = this.getOption().getVariableValue("manustock");
        int length = e.getDataEntities().length;
        if (!OrderOpUtils.isGenStockByEvent((String)stockname, (int)length)) {
            OperationResult op = this.getOperationResult();
            OrderOpUtils.beforeExeData((BeforeOperationArgs)e, this.savedataEntities, this.updatedataEntities, this.deleteStockIds, (Log)logger, (String)stockname, (OperationResult)op);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        int length = e.getDataEntities().length;
        String stockname = this.getOption().getVariableValue("manustock");
        if (!OrderOpUtils.isGenStockByEvent((String)stockname, (int)length)) {
            OrderOpUtils.updateStock((EndOperationTransactionArgs)e, this.savedataEntities, this.updatedataEntities);
            OrderOpUtils.handleStock((String)stockname, this.savedataEntities, this.updatedataEntities, this.deleteStockIds, (Log)logger);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String stockname = this.getOption().getVariableValue("manustock");
        int length = e.getDataEntities().length;
        if (OrderOpUtils.isGenStockByEvent((String)stockname, (int)length)) {
            HashSet<String> billNos = new HashSet<String>(16);
            DynamicObject[] bills = e.getDataEntities();
            if (bills != null && bills.length > 0) {
                for (DynamicObject bill : bills) {
                    billNos.add(bill.getString("billno"));
                }
            }
            OrderOpUtils.sendEventGenStock(billNos);
        }
    }
}

