/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.collections4.map.HashedMap;

public class OrderUnAuditBeginOptOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map<Object, DynamicObject> orders = this.loadMtfOrders(e.getDataEntities());
        HashSet<Object> transactionTypeIds = new HashSet<Object>(16);
        for (DynamicObject order : orders.values()) {
            if (order.getDynamicObject("transactiontype") != null) {
                transactionTypeIds.add(order.getDynamicObject("transactiontype").getPkValue());
            }
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entry = (DynamicObject)entryCol.get(j);
                entry.set("planstatus", (Object)ManuBillPlanStatusEnum.PLAN.getValue());
                entry.set("plansuretime", null);
            }
        }
        Map transactionTypeMap = TransactionTypeQueryHelper.getDataCacheBySet(transactionTypeIds);
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        this.unauditStock(orders, successObjs, transactionTypeMap);
        if (successObjs.size() > 0) {
            Map<Object, DynamicObject> order = this.loadMtfOrders(successObjs.toArray(new DynamicObject[0]));
            ArrayList<DynamicObject> success = new ArrayList<DynamicObject>();
            this.unauditManuftechs(order, success, transactionTypeMap);
            if (success.size() == 0) {
                OperateOption operateOption = this.buildOption();
                Map<Object, Object> objectObjectMap = this.buildAuditData(order, transactionTypeMap);
                String stockname = this.getOption().getVariableValue("manustock");
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)stockname, (Object[])objectObjectMap.keySet().toArray(), (OperateOption)operateOption);
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)stockname, (Object[])objectObjectMap.keySet().toArray(), (OperateOption)operateOption);
            }
            e.setDataEntities(success.toArray(new DynamicObject[success.size()]));
        } else {
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }

    private void unauditStock(Map<Object, DynamicObject> orders, List<DynamicObject> successObjs, Map<Object, DynamicObject> transactionTypeMap) {
        Object orderEntryId;
        HashedMap orderEntryIdtoBillIds = new HashedMap(orders.size());
        HashedMap unauditStockIdtoOrderEntryIds = new HashedMap(orders.size());
        HashedMap failOrderEntryIds = new HashedMap(orders.size());
        for (DynamicObject order : orders.values()) {
            boolean isAuditStock;
            DynamicObject transactiontype = order.getDynamicObject("transactiontype");
            if (!transactiontype.getDataEntityType().getProperties().containsKey((Object)"isauditstock")) {
                transactiontype = transactionTypeMap.get(transactiontype.getPkValue());
            }
            if (!(isAuditStock = transactiontype.getBoolean("isauditstock"))) continue;
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject col : entryCol) {
                orderEntryId = col.getPkValue();
                orderEntryIdtoBillIds.put(orderEntryId, order.getPkValue());
            }
        }
        if (orderEntryIdtoBillIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        String stockname = this.getOption().getVariableValue("manustock");
        QFilter stockqfilter = new QFilter("orderentryid", "in", (Object)orderEntryIdtoBillIds.keySet().toArray());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrdereAuditAfterExeOp.auditStock", (String)stockname, (String)"id,billstatus,orderentryid", (QFilter[])new QFilter[]{stockqfilter}, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Object stockId = row.get("id");
                Object orderEntryId2 = row.get("orderentryid");
                if (!"C".equals(row.get("billstatus"))) continue;
                unauditStockIdtoOrderEntryIds.put(stockId, orderEntryId2);
            }
        }
        if (unauditStockIdtoOrderEntryIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)stockname, (Object[])unauditStockIdtoOrderEntryIds.keySet().toArray(), (OperateOption)this.buildOption());
        HashSet unauditSuccessIds = new HashSet(unauditResult.getSuccessPkIds());
        if (unauditSuccessIds.isEmpty()) {
            this.setFailMes(unauditResult, (Map<Object, Object>)unauditStockIdtoOrderEntryIds, (Map<Object, String>)failOrderEntryIds);
        } else {
            for (Map.Entry stockIdtoOrderEntryId : unauditStockIdtoOrderEntryIds.entrySet()) {
                Object stockId = stockIdtoOrderEntryId.getKey();
                orderEntryId = stockIdtoOrderEntryId.getValue();
                if (unauditSuccessIds.contains(stockId)) continue;
                failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, unauditResult));
            }
        }
        if (!failOrderEntryIds.isEmpty()) {
            for (DynamicObject order : orders.values()) {
                boolean errBoolean = false;
                DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
                for (int i = 1; i <= entryCol.size(); ++i) {
                    Object orderEntryId3 = ((DynamicObject)entryCol.get(i - 1)).getPkValue();
                    String ids = (String)failOrderEntryIds.get(orderEntryId3);
                    if (ids == null) continue;
                    errBoolean = true;
                    this.operationResult.addErrorInfo(this.buildErrMessage(order, ids, i));
                }
                if (errBoolean) continue;
                successObjs.add(order);
            }
        } else {
            successObjs.addAll(orders.values());
        }
    }

    private Map<Object, Object> buildAuditData(Map<Object, DynamicObject> orders, Map<Object, DynamicObject> transactionTypeMap) {
        HashedMap orderEntryIdtoBillIds = new HashedMap();
        HashedMap unauditStockIdtoOrderEntryIds = new HashedMap();
        for (DynamicObject order : orders.values()) {
            boolean isAuditStock;
            DynamicObject transactiontype = order.getDynamicObject("transactiontype");
            if (!transactiontype.getDataEntityType().getProperties().containsKey((Object)"isauditstock")) {
                transactiontype = transactionTypeMap.get(transactiontype.getPkValue());
            }
            if (!(isAuditStock = transactiontype.getBoolean("isauditstock"))) continue;
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject col : entryCol) {
                Object orderEntryId = col.getPkValue();
                orderEntryIdtoBillIds.put(orderEntryId, order.getPkValue());
            }
        }
        String stockname = this.getOption().getVariableValue("manustock");
        QFilter stockqfilter = new QFilter("orderentryid", "in", (Object)orderEntryIdtoBillIds.keySet().toArray());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrdereAuditAfterExeOp.auditStock", (String)stockname, (String)"id,billstatus,orderentryid", (QFilter[])new QFilter[]{stockqfilter}, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Object stockId = row.get("id");
                Object orderEntryId = row.get("orderentryid");
                if ("C".equals(row.get("billstatus"))) continue;
                unauditStockIdtoOrderEntryIds.put(stockId, orderEntryId);
            }
        }
        return unauditStockIdtoOrderEntryIds;
    }

    private void unauditManuftechs(Map<Object, DynamicObject> orders, List<DynamicObject> successObjs, Map<Object, DynamicObject> transactionTypeMap) {
        Object orderEntryId;
        Object entryCol;
        HashedMap orderEntryIdtoBillIds = new HashedMap(orders.size());
        HashedMap unauditStockIdtoOrderEntryIds = new HashedMap(orders.size());
        HashedMap failOrderEntryIds = new HashedMap(orders.size());
        for (DynamicObject order : orders.values()) {
            boolean isAuditStock;
            DynamicObject transactiontype = order.getDynamicObject("transactiontype");
            if (!transactiontype.getDataEntityType().getProperties().containsKey((Object)"isaudittechnis")) {
                transactiontype = transactionTypeMap.get(transactiontype.getPkValue());
            }
            if (!(isAuditStock = transactiontype.getBoolean("isaudittechnis"))) continue;
            entryCol = order.getDynamicObjectCollection("treeentryentity");
            Iterator iterator = entryCol.iterator();
            while (iterator.hasNext()) {
                DynamicObject col = (DynamicObject)iterator.next();
                orderEntryId = col.getPkValue();
                orderEntryIdtoBillIds.put(orderEntryId, order.getPkValue());
            }
        }
        if (orderEntryIdtoBillIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        QFilter filter = new QFilter("mftentryseq", "in", (Object)orderEntryIdtoBillIds.keySet().toArray());
        QFilter filter1 = new QFilter("billstatus", "=", (Object)"C");
        String manuftech = this.getOption().getVariableValue("manuftech");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"OrdereAuditAfterExeOp.unauditManuftechs", (String)manuftech, (String)"id,billstatus,mftentryseq", (QFilter[])new QFilter[]{filter, filter1}, (String)"");
        entryCol = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                Object stockId = row.get("id");
                orderEntryId = row.get("mftentryseq");
                unauditStockIdtoOrderEntryIds.put(stockId, orderEntryId);
            }
        }
        catch (Throwable throwable) {
            entryCol = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (entryCol != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)entryCol).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (unauditStockIdtoOrderEntryIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)manuftech, (Object[])unauditStockIdtoOrderEntryIds.keySet().toArray(), (OperateOption)this.buildOption());
        HashSet unauditSuccessIds = new HashSet(unauditResult.getSuccessPkIds());
        if (unauditSuccessIds.isEmpty()) {
            this.setFailMes(unauditResult, (Map<Object, Object>)unauditStockIdtoOrderEntryIds, (Map<Object, String>)failOrderEntryIds);
        } else {
            for (Map.Entry stockIdtoOrderEntryId : unauditStockIdtoOrderEntryIds.entrySet()) {
                Object stockId = stockIdtoOrderEntryId.getKey();
                Object orderEntryId2 = stockIdtoOrderEntryId.getValue();
                if (unauditSuccessIds.contains(stockId)) continue;
                failOrderEntryIds.put(orderEntryId2, this.getErrorBystockId(stockId, unauditResult));
            }
        }
        if (!failOrderEntryIds.isEmpty()) {
            for (DynamicObject order : orders.values()) {
                boolean errBoolean = false;
                DynamicObjectCollection entryCol2 = order.getDynamicObjectCollection("treeentryentity");
                for (int i = 1; i <= entryCol2.size(); ++i) {
                    Object orderEntryId3 = ((DynamicObject)entryCol2.get(i - 1)).getPkValue();
                    String ids = (String)failOrderEntryIds.get(orderEntryId3);
                    if (ids == null) continue;
                    errBoolean = true;
                    this.operationResult.addErrorInfo(this.buildManuftechsErrMessage(order, ids, i));
                }
                if (errBoolean) continue;
                successObjs.add(order);
            }
        } else {
            successObjs.addAll(orders.values());
        }
    }

    private Map<Object, DynamicObject> loadMtfOrders(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashedMap(0);
        }
        HashedMap orders = new HashedMap(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            orders.put(dataEntity.getPkValue(), dataEntity);
        }
        return orders;
    }

    private void setFailMes(OperationResult submitResult, Map<Object, Object> submitStockIdtoOrderEntryIds, Map<Object, String> failOrderEntryIds) {
        HashSet submitSuccessIds = new HashSet(submitResult.getSuccessPkIds());
        for (Map.Entry<Object, Object> stockIdtoOrderEntryId : submitStockIdtoOrderEntryIds.entrySet()) {
            Object stockId = stockIdtoOrderEntryId.getKey();
            Object orderEntryId = stockIdtoOrderEntryId.getValue();
            if (submitSuccessIds.contains(stockId)) continue;
            failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, submitResult));
        }
    }

    private String getErrorBystockId(Object stockId, OperationResult submitResult) {
        for (IOperateInfo errInfo : submitResult.getAllErrorOrValidateInfo()) {
            if (!errInfo.getPkValue().toString().equals(stockId.toString())) continue;
            return errInfo.getMessage();
        }
        return "";
    }

    private OperateErrorInfo buildErrMessage(DynamicObject order, String err, int i) {
        Object pkId = order.getPkValue();
        int dataIndex = 0;
        int rowIndex = i - 1;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u7684\u7b2c%2$s\u884c\u5206\u5f55\uff0c\u7ec4\u4ef6\u6e05\u5355\u81ea\u52a8\u53cd\u5ba1\u6838\u5931\u8d25\uff1a%3$s", (String)"OrderUnAuditBeginOptOp_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), order.getString("billno"), i, err);
        String name = order.getDynamicObjectType().getName();
        if ("prop_mftorder".equals(name)) {
            msg = String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u7684\u7b2c%2$s\u884c\u5206\u5f55\uff0c\u6d41\u7a0b\u7528\u6599\u6e05\u5355\u81ea\u52a8\u53cd\u5ba1\u6838\u5931\u8d25\uff1a%3$s", (String)"OrderUnAuditBeginOptOp_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), order.getString("billno"), i, err);
        }
        return new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "OrderUnAuditBeginOptOp_auditStock_Fail", "order", msg, errorLevel);
    }

    private OperateErrorInfo buildManuftechsErrMessage(DynamicObject order, String err, int i) {
        Object pkId = order.getPkValue();
        int dataIndex = 0;
        int rowIndex = i - 1;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u7684\u7b2c%2$s\u884c\u5206\u5f55\uff0c\u5de5\u5e8f\u8ba1\u5212\u81ea\u52a8\u53cd\u5ba1\u6838\u5931\u8d25\uff1a%3$s", (String)"OrderUnAuditBeginOptOp_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), order.getString("billno"), i, err);
        return new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "OrderUnAuditBeginOptOp_unauditManuftechs_Fail", "order", msg, errorLevel);
    }

    private OperateOption buildOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("autounaudit", "1");
        return option;
    }
}

