/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.math.BigDecimal;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bd.mpdm.opplugin.manufacturemodel.StockCalUseQtyOnAddVal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StockCalUseQtyOp
extends AbstractOperationServicePlugIn {
    private static final String KEY_BILLENTRY = "stockentry";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(KEY_BILLENTRY);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("orderentryid");
        e.getFieldKeys().add("transactiontypeid");
        e.getFieldKeys().add("stockentry.actissueqty");
        e.getFieldKeys().add("stockentry.feedingqty");
        e.getFieldKeys().add("stockentry.rejectedqty");
        e.getFieldKeys().add("stockentry.useqty");
        e.getFieldKeys().add("stockentry.wipqty");
        e.getFieldKeys().add("stockentry.iscannegative");
        e.getFieldKeys().add("stockentry.qtytype");
        e.getFieldKeys().add("stockentry.demandqty");
        e.getFieldKeys().add("stockentry.processseq");
        e.getFieldKeys().add("stockentry.oprno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new StockCalUseQtyOnAddVal());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataArray = e.getDataEntities();
        String stockName = this.billEntityType.getName();
        for (int i = 0; i < dataArray.length; ++i) {
            DynamicObject obj = dataArray[i];
            DynamicObjectCollection stockEntrys = obj.getDynamicObjectCollection(KEY_BILLENTRY);
            boolean isupdate = false;
            for (DynamicObject stockEntry : stockEntrys) {
                BigDecimal wipQty;
                BigDecimal olduseqty = stockEntry.getBigDecimal("useqty") == null ? BigDecimal.ZERO : stockEntry.getBigDecimal("useqty");
                BigDecimal oldwipqty = stockEntry.getBigDecimal("wipqty") == null ? BigDecimal.ZERO : stockEntry.getBigDecimal("wipqty");
                BigDecimal useQty = MPDMMftGenStocksUtils.aculUseQty((DynamicObject)stockEntry, (Object)obj.getDynamicObject("orderentryid").getPkValue(), (DynamicObject)obj.getDynamicObject("transactiontypeid"), (String)EntityNameUtils.getEntityName((int)1, (int)0, (String)stockName));
                if (olduseqty.compareTo(useQty) != 0) {
                    stockEntry.set("useqty", (Object)useQty);
                    isupdate = true;
                }
                if (oldwipqty.compareTo(wipQty = MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)stockEntry)) == 0) continue;
                stockEntry.set("wipqty", (Object)wipQty);
                isupdate = true;
            }
            if (!isupdate) continue;
            SaveServiceHelper.update((DynamicObject)obj);
        }
    }
}

