/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class StockUpdateOnAddVal
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(StockUpdateOnAddVal.class);

    public void validate() {
        Object dataEntity;
        HashSet<Long> orderEntryIds = new HashSet<Long>(10);
        HashSet<Long> orderEntryIdsNoExBom = new HashSet<Long>(10);
        HashMap<String, ExtendedDataEntity> stockIds = new HashMap<String, ExtendedDataEntity>(16);
        String entityType = "pom_mftorder";
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject orderentryf7;
            DynamicObject dataEntity2 = extendedDataEntity.getDataEntity();
            if ("om_mftstock".equals(dataEntity2.getDataEntityType().getName())) {
                entityType = "om_mftorder";
            }
            if (null != (orderentryf7 = dataEntity2.getDynamicObject("orderentryid"))) {
                orderEntryIds.add(orderentryf7.getLong("id"));
            }
            stockIds.put(String.valueOf(dataEntity2.getPkValue()), extendedDataEntity);
        }
        List stockLockIdList = OrderOpUtils.getStockLock(new ArrayList(stockIds.keySet()));
        if (!stockLockIdList.isEmpty()) {
            for (String stockId : stockLockIdList) {
                dataEntity = ((ExtendedDataEntity)stockIds.get(stockId)).getDataEntity();
                this.addErrorMessage((ExtendedDataEntity)stockIds.get(stockId), String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355[%1$s]\u6b63\u5728\u88ab\u7f16\u8f91\u6216\u64cd\u4f5c\u3002", (String)"StockUpdateOnAddVal_12", (String)"", (Object[])new Object[0]), dataEntity.getString("billno")));
            }
        }
        if (orderEntryIds.size() > 0) {
            Boolean noextendbom;
            Long orderEntryid;
            QFilter qf = new QFilter("treeentryentity.id", "in", orderEntryIds);
            if ("pom_mftorder".equals(entityType)) {
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"StockSplitVal", (String)entityType, (String)"treeentryentity.id,treeentryentity.noextendbom,treeentryentity.sourcebilltype,treeentryentity.totalsplitqty,treeentryentity.srcsplitbillseq", (QFilter[])qf.toArray(), null);
                dataEntity = null;
                try {
                    for (Row row : dataSet) {
                        orderEntryid = row.getLong("treeentryentity.id");
                        noextendbom = row.getBoolean("treeentryentity.noextendbom");
                        if (!noextendbom.booleanValue()) continue;
                        orderEntryIdsNoExBom.add(orderEntryid);
                    }
                }
                catch (Throwable dataEntity2) {
                    dataEntity = dataEntity2;
                    throw dataEntity2;
                }
                finally {
                    if (dataSet != null) {
                        if (dataEntity != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable dataEntity2) {
                                ((Throwable)dataEntity).addSuppressed(dataEntity2);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            if ("om_mftorder".equals(entityType)) {
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"StockSplitVal", (String)entityType, (String)"treeentryentity.id,treeentryentity.noextendbom,treeentryentity.sourcebilltype,treeentryentity.srcsplitbillseq", (QFilter[])qf.toArray(), null);
                dataEntity = null;
                try {
                    for (Row row : dataSet) {
                        orderEntryid = row.getLong("treeentryentity.id");
                        noextendbom = row.getBoolean("treeentryentity.noextendbom");
                        if (!noextendbom.booleanValue()) continue;
                        orderEntryIdsNoExBom.add(orderEntryid);
                    }
                }
                catch (Throwable dataEntity2) {
                    dataEntity = dataEntity2;
                    throw dataEntity2;
                }
                finally {
                    if (dataSet != null) {
                        if (dataEntity != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable dataEntity2) {
                                ((Throwable)dataEntity).addSuppressed(dataEntity2);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
        }
        String entityName = null;
        HashSet<Long> stockid = new HashSet<Long>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            long orderEntryid;
            DynamicObject orderentryf7;
            StringBuilder err = new StringBuilder(300);
            DynamicObject stock = this.dataEntities[i].getDataEntity();
            entityName = stock.getDataEntityType().getName();
            if ("om_componentlist".equals(entityName)) {
                logger.info("\u662f\u7b80\u5355\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u3002");
                return;
            }
            this.validMftOrder(stock, err);
            boolean isPush = false;
            if ("".equals(err.toString()) && BFTrackerServiceHelper.isPush((String)entityName, (Long)((Long)stock.getPkValue()))) {
                err.append(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e", (String)"StockUpdateOnAddVal_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                isPush = true;
            }
            if (!isPush) {
                stockid.add(stock.getLong("id"));
            }
            if (("pom_mftstock".equals(entityName) || "om_mftstock".equals(entityName)) && null != (orderentryf7 = stock.getDynamicObject("orderentryid")) && orderEntryIdsNoExBom.contains(orderEntryid = orderentryf7.getLong("id"))) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u884c\u7684\u201c\u4e0d\u5c55\u5f00BOM\u201d\u4e3a\u662f", (String)"StockUpdateOnAddVal_15", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if ("".equals(err.toString())) continue;
            err.append("\uff0c");
            err.append(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\u3002", (String)"StockUpdateOnAddVal_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            this.addErrorMessage(this.dataEntities[i], err.toString());
        }
        if (!stockid.isEmpty() && !"pom_mrostock".equals(entityName)) {
            HashSet<Long> hasStockChangeId = new HashSet<Long>(16);
            SqlBuilder sql = new SqlBuilder();
            Set collect = stockid.stream().map(k -> k.toString()).collect(Collectors.toSet());
            if (StringUtils.equals((CharSequence)"pom_mftstock", (CharSequence)entityName)) {
                sql.appendIn("select fstockid from t_pom_xmanustockentry_b where fstockid", collect.toArray());
            } else if (StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)entityName)) {
                sql.appendIn("select fstockid from t_om_xmftstockentry_a where fstockid", collect.toArray());
            }
            try (DataSet dataSet = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "validate"), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);){
                for (Row row : dataSet) {
                    hasStockChangeId.add(Long.parseLong(row.getString("fstockid")));
                }
            }
            if (!hasStockChangeId.isEmpty()) {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    StringBuilder err = new StringBuilder(100);
                    DynamicObject stock = this.dataEntities[i].getDataEntity();
                    if (!hasStockChangeId.contains(stock.getLong("id"))) continue;
                    err.append(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5b58\u5728\uff0c\u66f4\u65b0\u5931\u8d25\u3002", (String)"StockUpdateOnAddVal_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                    this.addErrorMessage(this.dataEntities[i], err.toString());
                }
            }
        }
    }

    private void addError(StringBuilder err, String errorStr) {
        if ("".equals(err.toString())) {
            err.append(errorStr);
        } else {
            err.append("\uff0c");
            err.append(errorStr);
        }
    }

    private void validMftOrder(DynamicObject stock, StringBuilder err) {
        String entityName = stock.getDataEntityType().getName();
        DynamicObject orderEntry = stock.getDynamicObject("orderentryid");
        DynamicObject transactionType = stock.getDynamicObject("transactiontypeid");
        String stockmaterials = transactionType.getString("stockmaterials");
        String bizstatus = "";
        if (orderEntry != null) {
            bizstatus = orderEntry.getString("bizstatus");
        }
        if (!"A".equals(bizstatus)) {
            this.addError(err, ResManager.loadKDString((String)"\u5de5\u5355\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u6b63\u5e38\u201d", (String)"StockUpdateOnAddVal_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
        if (entityName.equals("pom_mrostock")) {
            if (!"A".equals(transactionType.getString("expandstock"))) {
                this.addError(err, ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5c55\u5f00\u4e0d\u4e3a\u5de5\u5361", (String)"StockUpdateOnAddVal_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
        } else if (!"A".equals(stockmaterials)) {
            this.addError(err, ResManager.loadKDString((String)"\u7528\u6599\u6e05\u5355\u4e0d\u4e3a\u201c\u6309BOM\u5c55\u5f00\u201d", (String)"StockUpdateOnAddVal_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
    }
}

