/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.mftorderbom.utils.CreateStockCardUtils;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bd.mpdm.opplugin.manufacturemodel.StockUpdateOnAddVal;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class StockUpdateOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(StockUpdateOp.class);
    private List<DynamicObject> updatedataEntities = new ArrayList<DynamicObject>();
    private static final String KEY_BILLENTRY = "stockentry";
    private static final String KEY_ORDERID = "orderid";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String EXPENDBOMTIME = "expendbomtime";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add(KEY_BILLENTRY);
        filds.add("billstatus");
        filds.add(KEY_ORDERID);
        filds.add("orderentryid");
        filds.add("transactiontypeid");
        String[] stockchange = StockUpdateOp.getStockchangeentryfields();
        for (int i = 0; i < stockchange.length; ++i) {
            filds.add("stockentry." + stockchange[i]);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new StockUpdateOnAddVal());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        if (objs == null) {
            return;
        }
        String stockname = this.billEntityType.getName();
        ArrayList<DynamicObject> orderList = new ArrayList<DynamicObject>(16);
        this.loadMtfOrders(e.getValidExtDataEntities(), stockname, orderList);
        Map<Object, DynamicObject> stocks = this.loadMtfStocks(e.getValidExtDataEntities(), stockname);
        this.updatedataEntities.clear();
        ArrayList<DynamicObject> saveBomStocks = new ArrayList<DynamicObject>(16);
        OrderBaseData baseData = new OrderBaseData();
        this.setExpendBomTime(baseData);
        CreateStockUtils.putOrderMap(orderList, (OrderBaseData)baseData, (String)stockname);
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            DynamicObject stock = dataEntity.getDataEntity();
            DynamicObject newstock = stocks.get(stock.getPkValue());
            this.deleteStock(newstock);
            saveBomStocks.add(newstock);
        }
        if (!saveBomStocks.isEmpty()) {
            baseData.setSaveStocks(saveBomStocks);
            logger.info("\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\u6309bom\u5c55\u5f00\u5f00\u59cb\u3002");
            if (stockname.equals("pom_mrostock")) {
                CreateStockCardUtils.expandGKStocks(saveBomStocks, (OrderBaseData)baseData, (String)stockname);
            } else {
                CreateStockByBomUtils.expandBomStocks(saveBomStocks, (OrderBaseData)baseData);
            }
            logger.info("\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\u6309bom\u5c55\u5f00\u7ed3\u675f\u3002");
            for (DynamicObject saveBomStock : saveBomStocks) {
                this.updateStockNewSeq(saveBomStock);
                this.updatedataEntities.add(saveBomStock);
            }
        }
    }

    private void setExpendBomTime(OrderBaseData baseData) {
        try {
            String expendBomTimeStr;
            if (this.operateOption.containsVariable(EXPENDBOMTIME) && StringUtils.isNotEmpty((String)(expendBomTimeStr = this.operateOption.getVariableValue(EXPENDBOMTIME)))) {
                baseData.setExpendBomTime(sdf.parse(expendBomTimeStr));
            }
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void updateStockNewSeq(DynamicObject stockNew) {
        DynamicObject stockentry;
        int i;
        DynamicObjectCollection stockentrys = stockNew.getDynamicObjectCollection(KEY_BILLENTRY);
        if (stockentrys == null) {
            return;
        }
        int maxSeq = 0;
        for (i = 0; i < stockentrys.size(); ++i) {
            stockentry = (DynamicObject)stockentrys.get(i);
            if (!stockentry.getBoolean("isbomextend")) continue;
            stockentry.set("seq", (Object)(++maxSeq));
        }
        for (i = 0; i < stockentrys.size(); ++i) {
            stockentry = (DynamicObject)stockentrys.get(i);
            if (stockentry.getBoolean("isbomextend")) continue;
            stockentry.set("seq", (Object)(++maxSeq));
        }
        for (DynamicObject stockEntry : stockentrys) {
            BigDecimal useQty = MPDMMftGenStocksUtils.aculUseQty((DynamicObject)stockEntry, (Object)stockNew.getDynamicObject("orderentryid").getPkValue(), (DynamicObject)stockNew.getDynamicObject("transactiontypeid"), (String)EntityNameUtils.getEntityName((int)1, (int)0, (String)stockNew.getDataEntityType().getName()));
            stockEntry.set("useqty", (Object)useQty);
            BigDecimal wipQty = MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)stockEntry);
            stockEntry.set("wipqty", (Object)wipQty);
        }
    }

    private void deleteStock(DynamicObject stock) {
        stock.set("modifytime", (Object)TimeServiceHelper.now());
        stock.set("modifier", (Object)UserServiceHelper.getCurrentUser((String)"id"));
        DynamicObjectCollection stockentrys = stock.getDynamicObjectCollection(KEY_BILLENTRY);
        if (stockentrys != null) {
            HashSet<DynamicObject> stockentryIndex = new HashSet<DynamicObject>(stockentrys.size());
            for (int i = 0; i < stockentrys.size(); ++i) {
                DynamicObject stockentry = (DynamicObject)stockentrys.get(i);
                if (!stockentry.getBoolean("isbomextend")) continue;
                stockentryIndex.add(stockentry);
                if (stockentry.getDynamicObject("replaceplan") == null) continue;
                stockentryIndex.addAll(this.getRelStockEntry(stockentrys, stockentry.getPkValue()));
            }
            if (!stockentryIndex.isEmpty()) {
                stockentrys.removeAll(stockentryIndex);
                this.stockentrysSort(stockentrys);
            }
        }
    }

    private void stockentrysSort(DynamicObjectCollection stockentrys) {
        if (stockentrys != null && !stockentrys.isEmpty()) {
            for (int i = 0; i < stockentrys.size(); ++i) {
                DynamicObject stockentry = (DynamicObject)stockentrys.get(i);
                stockentry.set("seq", (Object)(i + 1));
            }
        }
    }

    private Set<DynamicObject> getRelStockEntry(DynamicObjectCollection stockentrys, Object pkValue) {
        HashSet<DynamicObject> stockentryIndex = new HashSet<DynamicObject>(stockentrys.size());
        for (DynamicObject stockentry : stockentrys) {
            if (!pkValue.toString().equals(stockentry.get("pid").toString())) continue;
            stockentryIndex.add(stockentry);
        }
        return stockentryIndex;
    }

    private Map<Object, DynamicObject> loadMtfOrders(List<ExtendedDataEntity> list, String entityName, List<DynamicObject> orderList) {
        HashMap<Object, DynamicObject> orders = new HashMap<Object, DynamicObject>(list.size());
        ArrayList<Long> orderIdList = new ArrayList<Long>(list.size());
        for (ExtendedDataEntity data : list) {
            DynamicObject stock = data.getDataEntity();
            orderIdList.add(Long.parseLong(stock.getString(KEY_ORDERID)));
        }
        QFilter qf = new QFilter("id", "in", orderIdList);
        DynamicObject[] orderLoad = BusinessDataServiceHelper.load((String)StockChangeUtils.getEntityName((int)1, (int)0, (String)entityName), (String)"seq,transactiontype,org,bomid,planbegintime,planendtime,baseqty,qty,billno,bomid,material,batchno,auxproperty,inwardept,warehouse,location,iscontrolqty,producttype,biztype,replaceno,treeentryentity,processroute,treeentryentity.seq,treeentryentity.workcenter,unit,producedept,headbillno,materielmasterid,expendbomtime,treeentryentity.configuredcode,treeentryentity.manuversion", (QFilter[])new QFilter[]{qf});
        if (orderLoad == null) {
            return null;
        }
        for (ExtendedDataEntity data : list) {
            DynamicObject stock = data.getDataEntity();
            DynamicObject orderByStock = this.getOrderByStock(orderLoad, stock);
            orders.put(stock.getPkValue(), orderByStock);
            orderList.add(orderByStock);
        }
        return orders;
    }

    private Map<Object, DynamicObject> loadMtfStocks(List<ExtendedDataEntity> list, String entityName) {
        HashMap<Object, DynamicObject> orders = new HashMap<Object, DynamicObject>(list.size());
        ArrayList<Long> orderIdList = new ArrayList<Long>(list.size());
        for (ExtendedDataEntity data : list) {
            DynamicObject stock = data.getDataEntity();
            orderIdList.add(Long.parseLong(stock.getPkValue().toString()));
        }
        ORM orm = ORM.create();
        DynamicObject orderStock = orm.newDynamicObject(entityName);
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])orderIdList.toArray(new Object[orderIdList.size()]), (DynamicObjectType)orderStock.getDynamicObjectType());
        if (load == null) {
            return orders;
        }
        for (ExtendedDataEntity data : list) {
            DynamicObject stock = data.getDataEntity();
            orders.put(stock.getPkValue(), this.getStock(load, stock.getPkValue()));
        }
        return orders;
    }

    private DynamicObject getStock(DynamicObject[] load, Object pkValue) {
        for (int i = 0; i < load.length; ++i) {
            if (!pkValue.toString().equals(load[i].getPkValue().toString())) continue;
            return load[i];
        }
        return null;
    }

    private DynamicObject getOrderByStock(DynamicObject[] orderLoad, DynamicObject stock) {
        for (DynamicObject order : orderLoad) {
            if (!order.getPkValue().toString().equals(stock.getString(KEY_ORDERID))) continue;
            return order;
        }
        return null;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (!this.updatedataEntities.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.updatedataEntities.toArray(new DynamicObject[this.updatedataEntities.size()]));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (!this.updatedataEntities.isEmpty()) {
            HashSet<Long> stockId = new HashSet<Long>(16);
            for (DynamicObject updatedataEntitie : this.updatedataEntities) {
                stockId.add((Long)updatedataEntitie.getPkValue());
            }
            try {
                OperateOption create = OperateOption.create();
                create.setVariableValue("autosavestock", "updateomstock");
                OperationServiceHelper.executeOperate((String)"save", (String)this.billEntityType.getName(), (Object[])stockId.toArray(new Long[0]), (OperateOption)create);
            }
            catch (Exception e1) {
                logger.error("stock_error" + e1);
            }
        }
    }

    public static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    public static final String[] getStockchangeentryfields() {
        return new String[]{"id", "seq", "materialid", "materielmasterid", "materialunitid", "bomreversion", "qtytype", "useratio", "fixscrap", "scraprate", "standqty", "demandqty", "actissueqty", "unissueqty", "iscannegative", "childbomid", "childbomversion", "childauxpropertyid", "supplymode", "supplierid", "batchno", "supplyorgid", "warehouseid", "location", "outorgunitid", "outwarehouseid", "issuemode", "backflushtime", "iskeypart", "overissuecontrl", "issinhighlimit", "extraratioqty", "issinlowlimit", "lackraitioqty", "leadtime", "demanddate", "childremarks", "rejectedqty", "feedingqty", "scrapqty", "wipqty", "cansendqty", "oprno", "allotqty", "qtynumerator", "qtydenominator", "isbackflush", "wastagerateformula", "isstockallot", "isbomextend", "workprocedureid", "processseq", "oprworkcenter", "machiningtype", "outsupplier", "setuplocation", "isbulkmaterial", "entrychangetype", "stockentryid", "stockid", "stockno", "productbaseqty", "productbaseunit", "stockentryseq", "producttransid", "useqty", "outlocation"};
    }
}

