/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class StockUpdateSplitValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> orderEntryIds = new HashSet<Long>(10);
        HashSet<Long> orderSplitEntryIds = new HashSet<Long>(10);
        HashSet<Long> orderEntryIdsBySplit = new HashSet<Long>(10);
        HashSet<Long> orderEntryIdsSourcePlan = new HashSet<Long>(10);
        String entityType = "pom_mftorder";
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject orderentryf7;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if ("om_mftstock".equals(dataEntity.getDataEntityType().getName())) {
                entityType = "om_mftorder";
            }
            if (null == (orderentryf7 = dataEntity.getDynamicObject("orderentryid"))) continue;
            orderEntryIds.add(orderentryf7.getLong("id"));
        }
        if (orderEntryIds.size() > 0) {
            QFilter qf = new QFilter("treeentryentity.id", "in", orderEntryIds);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"StockSplitVal", (String)entityType, (String)"treeentryentity.id,treeentryentity.noextendbom,treeentryentity.sourcebilltype,treeentryentity.totalsplitqty,treeentryentity.srcsplitbillseq,treeentryentity.omsrcsplitbillseq,treeentryentity.srcsplitbillnumber", (QFilter[])qf.toArray(), null);){
                for (Row row : dataSet) {
                    String sourceBillType;
                    String srcsplitbillnumber;
                    BigDecimal totalsplitqty = row.getBigDecimal("treeentryentity.totalsplitqty");
                    Long orderEntryid = row.getLong("treeentryentity.id");
                    if (totalsplitqty.compareTo(BigDecimal.ZERO) > 0) {
                        orderSplitEntryIds.add(orderEntryid);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(srcsplitbillnumber = row.getString("treeentryentity.srcsplitbillnumber")))) {
                        orderEntryIdsBySplit.add(orderEntryid);
                    }
                    if (!StringUtils.equals((CharSequence)"mps_scheduleplan", (CharSequence)(sourceBillType = row.getString("treeentryentity.sourcebilltype")))) continue;
                    orderEntryIdsSourcePlan.add(orderEntryid);
                }
            }
        }
        String entityName = null;
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject orderentryf7;
            QFilter qFilter;
            boolean exists;
            StringBuilder err = new StringBuilder(300);
            DynamicObject stock = this.dataEntities[i].getDataEntity();
            entityName = stock.getDataEntityType().getName();
            String disPlayName = stock.getDataEntityType().getDisplayName().getLocaleValue();
            if ("om_componentlist".equals(entityName)) {
                return;
            }
            long orderid = stock.get("orderid") == null || StringUtils.equals((CharSequence)"", (CharSequence)stock.getString("orderid").trim()) ? 0L : Long.parseLong(stock.getString("orderid"));
            if (orderid != 0L && (exists = QueryServiceHelper.exists((String)"pom_ordermerge", (QFilter[])(qFilter = new QFilter("mergeorderid", "=", (Object)orderid)).toArray()))) {
                err.append(ResManager.loadKDString((String)"\u5408\u5e76\u5de5\u5355\u4ea7\u751f\u7684\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\u4e0d\u5141\u8bb8\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355", (String)"StockUpdateSplitValidator_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (null != (orderentryf7 = stock.getDynamicObject("orderentryid"))) {
                long orderEntryid = orderentryf7.getLong("id");
                if (orderEntryIdsBySplit.contains(orderEntryid) && !orderEntryIdsSourcePlan.contains(orderEntryid)) {
                    err.append(ResManager.loadKDString((String)"\u62c6\u5206\u4ea7\u751f\u7684\u7ec4\u4ef6\u6e05\u5355\u4e0d\u5141\u8bb8\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355", (String)"StockUpdateSplitValidator_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
                if (orderSplitEntryIds.contains(orderEntryid)) {
                    err.append(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u8fc7\u7684%s\u4e0d\u5141\u8bb8\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355", (String)"StockUpdateSplitValidator_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), disPlayName));
                }
            }
            if ("".equals(err.toString())) continue;
            err.append("\uff0c");
            err.append(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\u3002", (String)"StockUpdateSplitValidator_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            this.addErrorMessage(this.dataEntities[i], err.toString());
        }
    }
}

