/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.ManuftechUtil;
import kd.bd.mpdm.common.manuftech.utils.ChangeEntryStartOrCompletionTimeUtil;
import kd.bd.mpdm.common.utils.CheckManuOrderUtil;
import kd.bd.mpdm.opplugin.manufacturemodel.TechnicsTplValidators;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DispatchServiceHelper;

public class TechnicsTplOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ManuftechUtil.setEntityColumn((PreparePropertysEventArgs)e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        switch (operateKey) {
            case "save": {
                this.setOprNo(bills);
                break;
            }
            case "submit": {
                this.setOprNo(bills);
                break;
            }
            case "audit": {
                String stockBillType = this.getStockBillType();
                HashMap<Long, DynamicObject> mftechMap = new HashMap<Long, DynamicObject>(bills.length);
                HashSet<Long> mftSeqIDSet = new HashSet<Long>(bills.length);
                for (DynamicObject load : bills) {
                    Long pkvalue;
                    DynamicObjectCollection oprentrys = load.getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject entry : oprentrys) {
                        if (!"10".equals(entry.getString("oprno"))) continue;
                        entry.set("oprtotalinqty", entry.get("oprqty"));
                        break;
                    }
                    if ((pkvalue = (Long)((DynamicObject)load.get("mftentryseq")).getPkValue()) == null || this.getOrderBillType().equals("pom_mroorder")) continue;
                    mftechMap.put(pkvalue, load);
                    mftSeqIDSet.add(pkvalue);
                }
                CheckManuOrderUtil.updateManuStock((String)stockBillType, mftechMap, mftSeqIDSet);
                break;
            }
            case "unaudit": {
                for (DynamicObject load : bills) {
                    DynamicObjectCollection oprentrys = load.getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject entry : oprentrys) {
                        entry.set("oprtotalinqty", (Object)0);
                        entry.set("oprtotaloutqty", (Object)0);
                    }
                }
                break;
            }
            case "donothing_cancel": {
                this.changeStatus("", true, "donothing_cancel", bills);
                break;
            }
            case "donothing_uncancel": {
                this.changeStatus("", false, "donothing_uncancel", bills);
                break;
            }
            case "donothing_confirm": {
                this.changeStatus("C", false, "donothing_confirm", bills);
                break;
            }
            case "donothing_release": {
                this.changeStatus("D", false, "donothing_release", bills);
                break;
            }
            case "donothing_start": {
                this.changeStatus("E", false, "donothing_start", bills);
                break;
            }
            case "donothing_finish": {
                this.changeStatus("F", false, "donothing_finish", bills);
                break;
            }
            case "donothing_closed": {
                this.changeStatus("G", false, "donothing_closed", bills);
                break;
            }
            case "donothing_unconfirm": {
                this.changeStatus("C", false, "donothing_unconfirm", bills);
                break;
            }
            case "donothing_unrelease": {
                this.changeStatus("D", false, "donothing_unrelease", bills);
                break;
            }
            case "donothing_unstart": {
                this.changeStatus("E", false, "donothing_unstart", bills);
                break;
            }
            case "donothing_unfinish": {
                this.changeStatus("F", false, "donothing_unfinish", bills);
                break;
            }
            case "donothing_unplan": {
                this.changeStatus("B", false, "donothing_unplan", bills);
                break;
            }
        }
        e.setDataEntities(bills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey;
        super.afterExecuteOperationTransaction(e);
        switch (operationKey = e.getOperationKey()) {
            case "donothing_cancel": 
            case "donothing_uncancel": 
            case "donothing_confirm": 
            case "donothing_release": 
            case "donothing_start": 
            case "donothing_finish": 
            case "donothing_closed": 
            case "donothing_unconfirm": 
            case "donothing_unrelease": 
            case "donothing_unstart": 
            case "donothing_unfinish": 
            case "donothing_unplan": {
                Set unBeginWorkOrderEntryIds;
                Set beginWorkOrderEntryIds;
                String accountId = RequestContext.get().getAccountId();
                String cacheKey = accountId + "bd-mpdm-technicstplop";
                DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(cacheKey);
                String beginWorkOrderEntryIdsStr = (String)cache.get("beginWorkOrderEntryIds");
                String unBeginWorkOrderEntryIdsStr = (String)cache.get("unBeginWorkOrderEntryIds");
                if (StringUtils.isNotEmpty((CharSequence)beginWorkOrderEntryIdsStr) && !(beginWorkOrderEntryIds = (Set)JSONObject.parseObject((String)beginWorkOrderEntryIdsStr, HashSet.class)).isEmpty()) {
                    DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"OrderBookDateService", (String)"modBookDate", (Object[])new Object[]{beginWorkOrderEntryIds, "beginbookdate", "om_mftorder", "beginwork"});
                    cache.put("beginWorkOrderEntryIds", (Object)"");
                }
                if (!StringUtils.isNotEmpty((CharSequence)unBeginWorkOrderEntryIdsStr) || (unBeginWorkOrderEntryIds = (Set)JSONObject.parseObject((String)unBeginWorkOrderEntryIdsStr, HashSet.class)).isEmpty()) break;
                DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"OrderBookDateService", (String)"modBookDate", (Object[])new Object[]{unBeginWorkOrderEntryIds, "beginbookdate", "om_mftorder", "unbeginwork"});
                cache.put("unBeginWorkOrderEntryIds", (Object)"");
                break;
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TechnicsTplValidators());
    }

    private void changeStatus(String status, boolean cancel, String operateKey, DynamicObject[] bills) {
        String sb = this.getOption().getVariableValue("operateOption");
        if (sb == null || "".equals(sb) || bills == null || "pom_mroorder".equals(this.getOrderBillType())) {
            return;
        }
        List message = JSON.parseArray((String)sb, Object.class);
        String entityName = this.getOrderBillType();
        String orderName = this.getOrderBillName();
        ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTime((Date)new Date(), (String)operateKey, message.stream().map(x -> Long.parseLong(x + "")).collect(Collectors.toSet()), (DynamicObject[])bills);
        for (Object object : message) {
            for (DynamicObject technicsBill : bills) {
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                CheckManuOrderUtil.changeEntryStatus((String)entityName, (String)status, (boolean)cancel, (String)operateKey, object, (DynamicObject)technicsBill, (DynamicObjectCollection)entryCol, (String)orderName);
            }
        }
    }

    private void setOprNo(DynamicObject[] bills) {
        for (DynamicObject load : bills) {
            for (DynamicObject entry : load.getDynamicObjectCollection("oprentryentity")) {
                entry.set("oprparentnum", (Object)entry.getInt("oprparent"));
                entry.set("oprnonum", (Object)entry.getInt("oprno"));
            }
        }
    }

    protected String getOrderBillType() {
        String name = "pom_mftorder";
        if (this.getOption().containsVariable("orderBillType")) {
            name = this.getOption().getVariableValue("orderBillType");
        }
        return name;
    }

    protected String getOrderBillName() {
        String name = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"TechnicsTplOp_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
        if (this.getOption().containsVariable("orderBillName")) {
            name = this.getOption().getVariableValue("orderBillName");
        }
        return name;
    }

    protected String getStockBillType() {
        String name = "pom_mftstock";
        if (this.getOption().containsVariable("stockBillType")) {
            name = this.getOption().getVariableValue("stockBillType");
        }
        return name;
    }
}

