/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.query.mservice.helper.MsProcessRouteQueryHelper;
import kd.bd.mpdm.common.utils.CheckManuOrderUtil;
import kd.bd.mpdm.common.utils.ReportUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class TechnicsTplValidators
extends AbstractValidator {
    private static final String CHECK_TASK_STATUS = "checkTaskStatus";
    private static final String CHECK_BIZ_STATUS = "checkBizStatus";
    private static final Log logger = LogFactory.getLog(TechnicsTplValidators.class);

    public void validate() {
        String operate;
        switch (operate = this.getOperateKey()) {
            case "audit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.auditCheck(i);
                }
                break;
            }
            case "delete": {
                Set<Long> ids = this.getParentPlanIds();
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.deleteCheck(i, ids);
                }
                break;
            }
            case "unaudit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    List<String> list = TechnicsTplValidators.mftOrderBizStatus(this.dataEntities[i].getDataEntity(), this.dataEntities[i].getDataEntity().getDataEntityType().getName());
                    for (String msg : list) {
                        this.addErrorMessage(this.dataEntities[i], msg);
                    }
                    this.unauditCheck(i, this.getParentPlanIds());
                }
                break;
            }
            case "save": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.saveCheck(operate, i);
                }
                break;
            }
            case "submit": {
                this.submitCheck(operate);
                break;
            }
            case "donothing_confirm": {
                this.row_operation("donothing_confirm");
                break;
            }
            case "donothing_release": {
                this.row_operation("donothing_release");
                break;
            }
            case "donothing_start": {
                this.row_operation("donothing_start");
                break;
            }
            case "donothing_finish": {
                this.row_operation("donothing_finish");
                break;
            }
            case "donothing_closed": {
                this.row_operation("donothing_closed");
                break;
            }
            case "donothing_unplan": {
                this.row_operation("donothing_unplan");
                break;
            }
            case "donothing_unconfirm": {
                this.row_operation("donothing_unconfirm");
                break;
            }
            case "donothing_unrelease": {
                this.row_operation("donothing_unrelease");
                break;
            }
            case "donothing_unstart": {
                this.row_operation("donothing_unstart");
                break;
            }
            case "donothing_unfinish": {
                this.row_operation("donothing_unfinish");
                break;
            }
            case "donothing_cancel": {
                this.row_operation("donothing_cancel");
                break;
            }
            case "donothing_uncancel": {
                this.row_operation("donothing_uncancel");
                break;
            }
        }
    }

    private void row_operation(String operatekey) {
        if ("pom_mroorder".equals(this.getOrderBillType())) {
            return;
        }
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            for (int i = 0; i < this.dataEntities.length; ++i) {
                this.addErrorMessage(this.getDataEntities()[i], ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u201c\u5de5\u5e8f\u201d\u6570\u636e\u3002", (String)"TechnicsTplValidators_355", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            return;
        }
        switch (operatekey) {
            case "donothing_confirm": {
                this.validDonothingConfirm();
                break;
            }
            case "donothing_release": {
                this.validDonothingRelease();
                break;
            }
            case "donothing_start": {
                this.validDonothingStart();
                break;
            }
            case "donothing_finish": {
                this.validDonothingFinish();
                break;
            }
            case "donothing_closed": {
                this.validDonothingClosed();
                break;
            }
            case "donothing_unplan": {
                this.validDonothingUnplan();
                break;
            }
            case "donothing_unconfirm": {
                this.validDonothingUnconfirm();
                break;
            }
            case "donothing_unrelease": {
                this.validDonothingUnrelase();
                break;
            }
            case "donothing_unstart": {
                this.validDonothingUnstart();
                break;
            }
            case "donothing_unfinish": {
                this.validDonothingUnfinish();
                break;
            }
            case "donothing_cancel": {
                this.validDonothingCancel();
                break;
            }
            case "donothing_uncancel": {
                this.validDonothingUnCancel();
                break;
            }
        }
    }

    private void validDonothingConfirm() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK)) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            if (!"C".equals(technicsBill.get("billstatus"))) {
                errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"TechnicsTplValidators_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                errors.add("\n");
                list.add(billPK);
            } else {
                obj = technicsBill.getDynamicObject("mftentryseq");
                StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_TASK_STATUS, (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u786e\u8ba4", (String)"TechnicsTplValidators_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName());
                if (error.length() > 0) {
                    errors.add(error.toString());
                }
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                block1: for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                    for (Object object : message) {
                        if (!entryObj.getPkValue().equals(object)) continue;
                        ArrayList<String> status = new ArrayList<String>(Arrays.asList("B", "A"));
                        if (entryObj.getBoolean("oprinvalid")) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"TechnicsTplValidators_455", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u786e\u8ba4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_155", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            errors.add("\n");
                            continue block1;
                        }
                        if ("1002".equals(entryObj.getString("machiningtype"))) {
                            // empty if block
                        }
                        if (status.contains(entryObj.getString("oprstatus"))) continue block1;
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u521b\u5efa\u201d\u6216\u8005\u201c\u8ba1\u5212\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"TechnicsTplValidators_457", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u521b\u5efa\u201d\u6216\u8005\u201c\u8ba1\u5212\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u786e\u8ba4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_157", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        errors.add("\n");
                        continue block1;
                    }
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private List<Object> getManftechEntryID() {
        String sb = this.getOption().getVariableValue("operateOption", "");
        if (sb == null || "".equals(sb)) {
            return null;
        }
        List message = JSON.parseArray((String)sb, Object.class);
        return message;
    }

    private void addErrorMessage(int i, List<String> errors) {
        for (String error : errors) {
            this.addErrorMessage(this.getDataEntities()[i], error);
        }
    }

    private void validDonothingRelease() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        HashSet oprEntryIds = new HashSet(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            oprEntryIds.addAll(entryCol.stream().map(x -> x.getString("id")).collect(Collectors.toSet()));
        }
        Map processReportMap = ReportUtil.getProcessReportByOprEntryId(oprEntryIds, (String)"om_processreport");
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK)) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            if (!"C".equals(technicsBill.get("billstatus"))) {
                errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"TechnicsTplValidators_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                errors.add("\n");
                list.add(billPK);
            } else {
                StringBuffer error1;
                obj = technicsBill.getDynamicObject("mftentryseq");
                StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_TASK_STATUS, (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"TechnicsTplValidators_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName());
                if (error.length() > 0) {
                    errors.add(error.toString());
                }
                if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_BIZ_STATUS, (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"TechnicsTplValidators_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName())).length() > 0) {
                    errors.add(error1.toString());
                }
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                block2: for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                    for (Object object : message) {
                        ArrayList<String> status;
                        if (!entryObj.getPkValue().equals(object)) continue;
                        if (entryObj.getBoolean("oprinvalid")) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"TechnicsTplValidators_458", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_158", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            errors.add("\n");
                        }
                        if ("1002".equals(entryObj.getString("machiningtype"))) {
                            // empty if block
                        }
                        if (!(status = new ArrayList<String>(Arrays.asList("A", "B", "C"))).contains(entryObj.getString("oprstatus"))) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u8ba1\u5212\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"TechnicsTplValidators_541", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u8ba1\u5212\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_241", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            errors.add("\n");
                        }
                        if (!processReportMap.containsValue(entryObj.getString("id"))) continue block2;
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u7ecf\u6c47\u62a5\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"TechnicsTplValidators_656", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u7ecf\u6c47\u62a5\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_356", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        errors.add("\n");
                        continue block2;
                    }
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private void isDataChange(List<String> errors, DynamicObjectCollection col) {
        if (col.size() == 0) {
            errors.add(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u53d1\u751f\u6539\u53d8,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"TechnicsTplValidators_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            errors.add("\n");
        }
    }

    private void validDonothingStart() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK)) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            if (!"C".equals(technicsBill.get("billstatus"))) {
                errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"TechnicsTplValidators_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                errors.add("\n");
                list.add(billPK);
            } else {
                StringBuffer error1;
                obj = technicsBill.getDynamicObject("mftentryseq");
                StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_TASK_STATUS, (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5f00\u5de5", (String)"TechnicsTplValidators_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName());
                if (error.length() > 0) {
                    errors.add(error.toString());
                }
                if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_BIZ_STATUS, (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5f00\u5de5", (String)"TechnicsTplValidators_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName())).length() > 0) {
                    errors.add(error1.toString());
                }
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                block1: for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                    for (Object object : message) {
                        if (!entryObj.getPkValue().equals(object)) continue;
                        if (entryObj.getBoolean("oprinvalid")) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"TechnicsTplValidators_542", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5f00\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_242", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                        }
                        if ("1002".equals(entryObj.getString("machiningtype"))) {
                            // empty if block
                        }
                        if ("D".contains(entryObj.getString("oprstatus"))) continue block1;
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"TechnicsTplValidators_544", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            continue block1;
                        }
                        errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u5f00\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_244", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        continue block1;
                    }
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private void validDonothingFinish() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK) || obj.getDataEntityType().getName() == null) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            if (!"C".equals(technicsBill.get("billstatus"))) {
                errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5b8c\u5de5\u3002", (String)"TechnicsTplValidators_16", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                errors.add("\n");
                list.add(billPK);
            } else {
                StringBuffer error1;
                obj = technicsBill.getDynamicObject("mftentryseq");
                StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_TASK_STATUS, (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"TechnicsTplValidators_17", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName());
                if (error.length() > 0) {
                    errors.add(error.toString());
                }
                if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_BIZ_STATUS, (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"TechnicsTplValidators_17", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName())).length() > 0) {
                    errors.add(error1.toString());
                }
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                block1: for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                    for (Object object : message) {
                        ArrayList<String> status;
                        if (!entryObj.getPkValue().equals(object)) continue;
                        if (entryObj.getBoolean("oprinvalid")) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5b8c\u5de5\u3002", (String)"TechnicsTplValidators_545", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5b8c\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_245", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            errors.add("\n");
                        }
                        if ("1002".equals(entryObj.getString("machiningtype"))) {
                            // empty if block
                        }
                        if ((status = new ArrayList<String>(Arrays.asList("D", "E"))).contains(entryObj.getString("oprstatus"))) continue block1;
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\u6216\u8005\u201c\u5f00\u5de5\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u5b8c\u5de5\u3002", (String)"TechnicsTplValidators_547", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\u6216\u8005\u201c\u5f00\u5de5\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u5b8c\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_247", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        errors.add("\n");
                        continue block1;
                    }
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private void validDonothingClosed() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK) || obj.getDataEntityType().getName() == null) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            if (!"C".equals(technicsBill.get("billstatus"))) {
                errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5173\u95ed\u3002", (String)"TechnicsTplValidators_21", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                errors.add("\n");
                list.add(billPK);
            } else {
                StringBuffer error1;
                obj = technicsBill.getDynamicObject("mftentryseq");
                StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_TASK_STATUS, (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5173\u95ed", (String)"TechnicsTplValidators_22", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName());
                if (error.length() > 0) {
                    errors.add(error.toString());
                }
                if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_BIZ_STATUS, (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5173\u95ed", (String)"TechnicsTplValidators_22", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName())).length() > 0) {
                    errors.add(error1.toString());
                }
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                block1: for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                    for (Object object : message) {
                        if (!entryObj.getPkValue().equals(object)) continue;
                        if (entryObj.getBoolean("oprinvalid")) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5173\u95ed\u3002", (String)"TechnicsTplValidators_548", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5173\u95ed\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_248", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            errors.add("\n");
                        }
                        if ("1002".equals(entryObj.getString("machiningtype"))) {
                            // empty if block
                        }
                        if ("F".contains(entryObj.getString("oprstatus"))) continue block1;
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u5b8c\u5de5\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u5173\u95ed\u3002", (String)"TechnicsTplValidators_550", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u5b8c\u5de5\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u5173\u95ed\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_250", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        errors.add("\n");
                        continue block1;
                    }
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private void validDonothingUnplan() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK) || obj.getDataEntityType().getName() == null) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            if (!"C".equals(technicsBill.get("billstatus"))) {
                errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u8ba1\u5212\u3002", (String)"TechnicsTplValidators_26", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                errors.add("\n");
                list.add(billPK);
            } else {
                obj = technicsBill.getDynamicObject("mftentryseq");
                StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_TASK_STATUS, (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u8ba1\u5212", (String)"TechnicsTplValidators_27", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName());
                if (error.length() > 0) {
                    errors.add(error.toString());
                }
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                block1: for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                    for (Object object : message) {
                        ArrayList<String> status;
                        if (!entryObj.getPkValue().equals(object)) continue;
                        if (entryObj.getBoolean("oprinvalid")) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u8ba1\u5212\u3002", (String)"TechnicsTplValidators_551", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u8ba1\u5212\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_251", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            errors.add("\n");
                        }
                        if ("1002".equals(entryObj.getString("machiningtype"))) {
                            // empty if block
                        }
                        if ((status = new ArrayList<String>(Arrays.asList("C", "D", "E", "F", "G"))).contains(entryObj.getString("oprstatus"))) continue block1;
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u3001\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u8ba1\u5212\u3002", (String)"TechnicsTplValidators_553", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u3001\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u8ba1\u5212\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_253", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        errors.add("\n");
                        continue block1;
                    }
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private void validDonothingUnconfirm() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK) || obj.getDataEntityType().getName() == null) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            if (!"C".equals(technicsBill.get("billstatus"))) {
                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"TechnicsTplValidators_31", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                errors.add("\n");
                list.add(billPK);
            } else {
                obj = technicsBill.getDynamicObject("mftentryseq");
                StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_TASK_STATUS, (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u786e\u8ba4", (String)"TechnicsTplValidators_32", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName());
                if (error.length() > 0) {
                    errors.add(error.toString());
                }
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                block1: for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                    for (Object object : message) {
                        ArrayList<String> status;
                        if (!entryObj.getPkValue().equals(object)) continue;
                        if (entryObj.getBoolean("oprinvalid")) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"TechnicsTplValidators_554", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u786e\u8ba4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_254", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            errors.add("\n");
                        }
                        if ("1002".equals(entryObj.getString("machiningtype"))) {
                            // empty if block
                        }
                        if ((status = new ArrayList<String>(Arrays.asList("D", "E", "F", "G"))).contains(entryObj.getString("oprstatus"))) continue block1;
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"TechnicsTplValidators_556", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u786e\u8ba4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_256", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        errors.add("\n");
                        continue block1;
                    }
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private void validDonothingUnrelase() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK) || obj.getDataEntityType().getName() == null) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            if (!"C".equals(technicsBill.get("billstatus"))) {
                errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"TechnicsTplValidators_36", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                errors.add("\n");
                list.add(billPK);
            } else {
                obj = technicsBill.getDynamicObject("mftentryseq");
                StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_TASK_STATUS, (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"TechnicsTplValidators_37", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName());
                if (error.length() > 0) {
                    errors.add(error.toString());
                }
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                block1: for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                    for (Object object : message) {
                        ArrayList<String> status;
                        if (!entryObj.getPkValue().equals(object)) continue;
                        if (entryObj.getBoolean("oprinvalid")) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"TechnicsTplValidators_557", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_257", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            errors.add("\n");
                        }
                        if ("1002".equals(entryObj.getString("machiningtype"))) {
                            // empty if block
                        }
                        if ((status = new ArrayList<String>(Arrays.asList("E", "F", "G"))).contains(entryObj.getString("oprstatus"))) continue block1;
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"TechnicsTplValidators_559", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_259", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        errors.add("\n");
                        continue block1;
                    }
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private void validDonothingUnstart() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK) || obj.getDataEntityType().getName() == null) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            if (!"C".equals(technicsBill.get("billstatus"))) {
                errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"TechnicsTplValidators_41", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                errors.add("\n");
                list.add(billPK);
            } else {
                obj = technicsBill.getDynamicObject("mftentryseq");
                StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_TASK_STATUS, (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u5f00\u5de5", (String)"TechnicsTplValidators_42", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName());
                if (error.length() > 0) {
                    errors.add(error.toString());
                }
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                block1: for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                    for (Object object : message) {
                        ArrayList<String> status;
                        if (!entryObj.getPkValue().equals(object)) continue;
                        if (entryObj.getBoolean("oprinvalid")) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"TechnicsTplValidators_560", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5f00\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_260", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            errors.add("\n");
                        }
                        if ("1002".equals(entryObj.getString("machiningtype"))) {
                            // empty if block
                        }
                        if ((status = new ArrayList<String>(Arrays.asList("F", "G"))).contains(entryObj.getString("oprstatus"))) continue block1;
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"TechnicsTplValidators_562", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u5f00\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_262", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        errors.add("\n");
                        continue block1;
                    }
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private void validDonothingUnfinish() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            if (list.contains(billPK) || obj.getDataEntityType().getName() == null) continue;
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            if (!"C".equals(technicsBill.get("billstatus"))) {
                errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5b8c\u5de5\u3002", (String)"TechnicsTplValidators_46", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                errors.add("\n");
                list.add(billPK);
            } else {
                obj = technicsBill.getDynamicObject("mftentryseq");
                StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)this.getOrderBillType(), (String)CHECK_TASK_STATUS, (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u5b8c\u5de5", (String)"TechnicsTplValidators_47", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), (Object)obj.getPkValue(), (String)this.getOrderBillName());
                if (error.length() > 0) {
                    errors.add(error.toString());
                }
                DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
                block1: for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                    for (Object object : message) {
                        if (!entryObj.getPkValue().equals(object)) continue;
                        if (entryObj.getBoolean("oprinvalid")) {
                            if (this.isPropManftech()) {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5b8c\u5de5\u3002", (String)"TechnicsTplValidators_563", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            } else {
                                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5b8c\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_263", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            errors.add("\n");
                        }
                        if ("1002".equals(entryObj.getString("machiningtype"))) {
                            // empty if block
                        }
                        if ("G".contains(entryObj.getString("oprstatus"))) continue block1;
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u5b8c\u5de5\u3002", (String)"TechnicsTplValidators_565", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u5b8c\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_265", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        errors.add("\n");
                        continue block1;
                    }
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private void validDonothingCancel() {
        LinkedHashSet list = new LinkedHashSet();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK) || obj.getDataEntityType().getName() == null) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
            block1: for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                for (Object object : message) {
                    if (!entryObj.getPkValue().equals(object)) continue;
                    ArrayList<String> status = new ArrayList<String>(Arrays.asList("A", "B", "C"));
                    if (!status.contains(entryObj.getString("oprstatus"))) {
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u72b6\u6001\u4e3a\u201c\u521b\u5efa\u201d\u3001\u201c\u8ba1\u5212\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u65f6\uff0c\u624d\u53ef\u4f5c\u5e9f\u3002", (String)"TechnicsTplValidators_566", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u521b\u5efa\u201d\u3001\u201c\u8ba1\u5212\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u65f6\uff0c\u624d\u53ef\u4f5c\u5e9f\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_266", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                    }
                    if ("1002".equals(entryObj.getString("machiningtype"))) {
                        // empty if block
                    }
                    if (!entryObj.getBoolean("oprinvalid")) continue block1;
                    if (this.isPropManftech()) {
                        errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u4f5c\u5e9f\u3002", (String)"TechnicsTplValidators_568", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        continue block1;
                    }
                    errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u4f5c\u5e9f\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_268", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    continue block1;
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    private void validDonothingUnCancel() {
        LinkedHashSet list = new LinkedHashSet();
        List<Object> message = this.getManftechEntryID();
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            QFilter qfilter = new QFilter("id", "=", billPK);
            if (list.contains(billPK) || obj.getDataEntityType().getName() == null) continue;
            DynamicObjectCollection col = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"id");
            this.isDataChange(errors, col);
            DynamicObject technicsBill = BusinessDataServiceHelper.loadSingle((Object)billPK, (String)obj.getDataEntityType().getName());
            DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
            block1: for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                String oprparent = "prop_manftech".equalsIgnoreCase(this.getEntityKey()) ? "" : "[" + entryObj.getString("oprparent") + "]";
                for (Object object : message) {
                    if (!entryObj.getPkValue().equals(object)) continue;
                    if (!entryObj.getBoolean("oprinvalid")) {
                        if (this.isPropManftech()) {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u672a\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u4f5c\u5e9f\u3002", (String)"TechnicsTplValidators_569", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u672a\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u4f5c\u5e9f\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_269", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                    }
                    if ("1002".equals(entryObj.getString("machiningtype"))) continue block1;
                }
            }
            this.addErrorMessage(i, errors);
        }
    }

    public Set<String> preparePropertys() {
        return super.preparePropertys();
    }

    private void saveCheck(String operate, int i) {
        DynamicObjectCollection entryCol;
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        DynamicObject material = obj.getDynamicObject("material");
        String orderEntityName = this.getOrderBillType();
        DynamicObject processroute = obj.getDynamicObject("processroute");
        if ("prop_mftorder".equalsIgnoreCase(orderEntityName)) {
            processroute = obj.getDynamicObject("programme");
        }
        this.checkHead(obj, operate, i);
        if (!this.dataEntities[i].getDataEntity().getDataEntityType().getName().equals("sfc_mromanuftech") && (entryCol = obj.getDynamicObjectCollection("oprentryentity")).size() > 0) {
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObjectCollection subEntryCol;
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (this.isNull(entryObj.get("headqty")) || entryObj.getBigDecimal("headqty").compareTo(BigDecimal.ZERO) == 0) {
                    if (this.isPropManftech()) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u201c\u8868\u5934\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_490", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                    } else {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8868\u5934\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_190", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                }
                if (this.isNull(entryObj.get("operationqty")) || entryObj.getBigDecimal("operationqty").compareTo(BigDecimal.ZERO) == 0) {
                    if (this.isPropManftech()) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u201c\u5de5\u5e8f\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_491", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                    } else {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_191", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                }
                if (this.isNull(entryObj.getDynamicObject("headunit"))) {
                    if (this.isPropManftech()) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u201c\u8868\u5934\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_571", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    } else {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8868\u5934\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_271", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                }
                if (!this.isNull(obj.getDynamicObject("transactiontype"))) {
                    subEntryCol = entryObj.getDynamicObjectCollection("actsubentryentity");
                    if (!(obj.getDataEntityType().getName().equals("sfc_mromanuftech") || "prop_manftech".equalsIgnoreCase(obj.getDataEntityType().getName()) && !entryObj.getBoolean("isstage") || subEntryCol.size() != 0)) {
                        if ("prop_manftech".equalsIgnoreCase(obj.getDataEntityType().getName())) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u6d3b\u52a8\u3002", (String)"TechnicsTplValidators_326", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u6d3b\u52a8\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_306", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                    }
                }
                if ("prop_manftech".equalsIgnoreCase(obj.getDataEntityType().getName())) {
                    if (!entryObj.getBoolean("isstage")) continue;
                    if (entryObj.getDynamicObject("oprctrlstrategy") == null) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%1$s]\u5de5\u5e8f\u63a7\u5236\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_320", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                    }
                }
                subEntryCol = entryObj.getDynamicObjectCollection("actsubentryentity");
                for (int k = 0; k < subEntryCol.size(); ++k) {
                    DynamicObject subEntryObj = (DynamicObject)subEntryCol.get(k);
                    if (this.isPropManftech()) {
                        if (this.isNull(subEntryObj.getString("processstage"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f%1$s\uff1a\u5de5\u5e8f\u6d3b\u52a8-\u8ba1\u5212\u7684\u201c\u5de5\u5e8f\u9636\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_494", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(subEntryObj.getDynamicObject("actstandardformula"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f%1$s\uff1a\u5de5\u5e8f\u6d3b\u52a8\u201c\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_495", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (!this.isNull(subEntryObj.getDynamicObject("actstandardformula1"))) continue;
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f%1$s\uff1a\u5de5\u5e8f\u6d3b\u52a8\u201c\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_495", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        continue;
                    }
                    if (this.isNull(subEntryObj.getString("processstage"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217%1$s\u4e0b\u5de5\u5e8f%2$s\uff1a\u5de5\u5e8f\u6d3b\u52a8-\u8ba1\u5212\u7684\u201c\u5de5\u5e8f\u9636\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_194", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                    if (this.isNull(subEntryObj.getDynamicObject("actstandardformula"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217%1$s\u5de5\u5e8f%2$s\uff1a\u5de5\u5e8f\u6d3b\u52a8\u201c\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_195", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                    if (!this.isNull(subEntryObj.getDynamicObject("actstandardformula1"))) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217%1$s\u5de5\u5e8f%2$s\uff1a\u5de5\u5e8f\u6d3b\u52a8\u201c\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_195", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
            }
        }
    }

    private void checkHead(DynamicObject obj, String operate, int i) {
        if (this.isNull(obj.getDynamicObject("org"))) {
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_129", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
        if (this.isNull(obj.getString("billno"))) {
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u201c\u5355\u636e\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_130", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
        if (this.isNull(obj.getDynamicObject("billtype"))) {
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u201c\u5355\u636e\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_131", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
        if (this.isNull(obj.getDynamicObject("mftentryseq"))) {
            String info = String.format(ResManager.loadKDString((String)"%1$s\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_310", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), this.getOrderBillName());
            this.addErrorMessage(this.dataEntities[i], info);
        }
        if (!this.isNull(obj.getDynamicObject("mftentryseq")) && this.isExistsManuftech(obj)) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"%1$s\u884c\u53f7\u5df2\u5b58\u5728\u5de5\u5e8f\u8ba1\u5212\u3002", (String)"TechnicsTplValidators_196", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), this.getOrderBillName()));
        }
        this.checkUnit(obj, operate, i);
    }

    private void checkUnit(DynamicObject obj, String operate, int i) {
        DynamicObject processRoute = obj.getDynamicObject("processroute");
        if (processRoute == null) {
            return;
        }
        processRoute = MsProcessRouteQueryHelper.getDataCacheByID((Object)processRoute.getPkValue());
        DynamicObject mftEntrySeq = obj.getDynamicObject("mftentryseq");
        if (mftEntrySeq == null) {
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)obj.getLong("manufactureorderid"));
        filter.and(new QFilter("treeentryentity.id", "=", mftEntrySeq.getPkValue()));
        DynamicObject object = QueryServiceHelper.queryOne((String)this.getOrderBillType(), (String)"treeentryentity.materielmasterid,treeentryentity.baseunit", (QFilter[])new QFilter[]{filter});
        DynamicObject baseUnit = obj.getDynamicObject("baseunit");
        if (baseUnit == null && object != null && object.getLong("treeentryentity.baseunit") > 0L) {
            baseUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)object.getLong("treeentryentity.baseunit"), (String)"bd_measureunits");
        }
        String baseUnitName = baseUnit == null || baseUnit.getString("name") == null ? " " : baseUnit.getString("name");
        DynamicObjectCollection processEntry = processRoute.getDynamicObjectCollection("processentry");
        for (DynamicObject process : processEntry) {
            DynamicObject headUnit = process.getDynamicObject("headunit");
            String headUnitName = headUnit == null || headUnit.getString("name") == null ? " " : headUnit.getString("name");
            BigDecimal unitRateConvert = MPDMMftGenStocksUtils.getUnitRateConvert((Long)(object == null ? null : Long.valueOf(object.getLong("treeentryentity.materielmasterid"))), (Long)(baseUnit == null ? null : Long.valueOf(baseUnit.getLong("id"))), headUnit == null ? null : Long.valueOf(headUnit.getLong("id")));
            if (BigDecimal.ZERO.compareTo(unitRateConvert) != 0) continue;
            String value = "save".equals(operate) ? ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"TechnicsTplValidators_66", (String)"bd-mpdm-opplugin", (Object[])new Object[0]) : ("submit".equals(operate) ? ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"TechnicsTplValidators_67", (String)"bd-mpdm-opplugin", (Object[])new Object[0]) : ("audit".equals(operate) ? ResManager.loadKDString((String)"\u5ba1\u6838", (String)"TechnicsTplValidators_68", (String)"bd-mpdm-opplugin", (Object[])new Object[0]) : ("unaudit".equals(operate) ? ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"TechnicsTplValidators_69", (String)"bd-mpdm-opplugin", (Object[])new Object[0]) : ("delete".equals(operate) ? ResManager.loadKDString((String)"\u5220\u9664", (String)"TechnicsTplValidators_70", (String)"bd-mpdm-opplugin", (Object[])new Object[0]) : ""))));
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7684\u8868\u5934\u5355\u4f4d\uff08%1$s\uff09\u548c\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\uff08%2$s\uff09\u4e0d\u5b58\u5728\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\uff0c%3$s\u5931\u8d25\u3002", (String)"TechnicsTplValidators_197", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), headUnitName, baseUnitName, value));
        }
    }

    private void unauditCheck(int i, Set<Long> ids) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        if (ids.contains(Long.parseLong(obj.getPkValue().toString()))) {
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5de5\u5e8f\u8ba1\u5212,\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"TechnicsTplValidators_72", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
    }

    private void deleteCheck(int i, Set<Long> ids) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        if (ids.contains(Long.parseLong(obj.getPkValue().toString()))) {
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5de5\u5e8f\u8ba1\u5212,\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TechnicsTplValidators_74", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
    }

    private Set<Long> getParentPlanIds() {
        HashSet<String> technicsIds = new HashSet<String>(16);
        HashSet<Long> ids = new HashSet<Long>();
        for (int i = 0; i < this.dataEntities.length; ++i) {
            technicsIds.add(this.dataEntities[i].getDataEntity().getPkValue().toString());
        }
        if (technicsIds.isEmpty()) {
            return ids;
        }
        String algoKey = "kd.bd.mpdm.opplugin.manufacturemodel.TechnicsTplValidators.getParentPlanIds";
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)this.dataEntities[0].getDataEntity().getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter("parentplanid", "in", technicsIds).toArray(), null);){
            for (Row row : dataset) {
                ids.add(row.getLong("id"));
            }
        }
        return ids;
    }

    private void auditCheck(int i) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        if (this.getOption().containsVariable("autoAudit")) {
            return;
        }
        QFilter filter = new QFilter("treeentryentity.id", "in", obj.getDynamicObject("mftentryseq").getPkValue());
        QFilter filter1 = new QFilter("billstatus", "=", (Object)"C");
        boolean isExist = ORM.create().exists(this.getOrderBillType(), new QFilter[]{filter, filter1});
        if (!isExist) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4e0a\u6e38%1$s\u672a\u5ba1\u6838\u3002", (String)"TechnicsTplValidators_198", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), this.getOrderBillName()));
        }
    }

    private void submitCheck(String operate) {
        HashSet entitys = Sets.newHashSet((Object[])new String[]{"om_mfttechnics", "sfc_mromanuftech"});
        String entityName = "";
        if (this.dataEntities.length > 0) {
            entityName = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject subEntryObj;
            DynamicObjectCollection subEntryCol;
            DynamicObject entryObj;
            int j;
            DynamicObjectCollection entryCol;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            this.checkHead(obj, operate, i);
            if (this.isNull(obj.getBigDecimal("qty")) || obj.getBigDecimal("qty").compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u201c\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_132", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (this.isNull(obj.getDynamicObject("transactiontype"))) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u201c\u4e8b\u52a1\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_133", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (this.isNull(obj.get("planstarttime"))) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_134", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (this.isNull(obj.get("planfinishtime"))) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5b8c\u5de5\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_135", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (this.isNull(obj.getString("plantype"))) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_136", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (!"prop_manftech".equalsIgnoreCase(entityName)) {
                entryCol = obj.getDynamicObjectCollection("proentryentity");
                if (entryCol.size() == 0) {
                    this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_81", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
                for (j = 0; j < entryCol.size(); ++j) {
                    entryObj = (DynamicObject)entryCol.get(j);
                    if (this.isNull(entryObj.getString("processseq"))) {
                        this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5217\u8868\u7b2c%1$s\u884c\u5206\u5f55\u7684\u201c\u5e8f\u5217\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_137", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                    }
                    if (this.isNull(entryObj.getString("processseqname"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u5e8f\u5e8f\u5217\uff08%1$s\uff09\u7684\u201c\u5e8f\u5217\u540d\u79f0\u201d\u3002", (String)"TechnicsTplValidators_199", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                    }
                    String processSeq = entryObj.getString("processseq");
                    subEntryCol = obj.getDynamicObjectCollection("oprentryentity");
                    boolean isExist = false;
                    for (int k = 0; k < subEntryCol.size(); ++k) {
                        subEntryObj = (DynamicObject)subEntryCol.get(k);
                        if (!processSeq.equals(subEntryObj.getString("oprparent"))) continue;
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff08%s\uff09\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u3002", (String)"TechnicsTplValidators_200", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                }
            }
            if ((entryCol = obj.getDynamicObjectCollection("oprentryentity")).size() == 0) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u5217\u8868\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_85", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            for (j = 0; j < entryCol.size(); ++j) {
                int k;
                entryObj = (DynamicObject)entryCol.get(j);
                if (this.isPropManftech()) {
                    if (entryObj.getInt("oprno") % 1 != 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u53f7\u4e0d\u5408\u6cd5\u3002", (String)"TechnicsTplValidators_572", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                    }
                } else if (entryObj.getInt("oprno") % 1 != 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u53f7\u4e0d\u5408\u6cd5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_272", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                boolean flag = false;
                if (!"prop_manftech".equalsIgnoreCase(entityName) && this.isNull(entryObj.get("oprparent"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u7684\u5de5\u5e8f\u5e8f\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_206", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                } else {
                    for (int j2 = 0; j2 < obj.getDynamicObjectCollection("proentryentity").size(); ++j2) {
                        if (!entryObj.get("oprparent").equals(((DynamicObject)obj.getDynamicObjectCollection("proentryentity").get(j2)).getString("processseq"))) continue;
                        flag = true;
                        break;
                    }
                }
                if (!flag && !"prop_manftech".equalsIgnoreCase(entityName)) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0d\u5b58\u5728\u3002", (String)"TechnicsTplValidators_207", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent")));
                }
                if (this.isPropManftech()) {
                    if (this.isNull(entryObj.getString("oprorg"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u201c\u52a0\u5de5\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_577", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                    }
                    if (this.isNull(entryObj.getString("oprno"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u7b2c%2$s\u884c\u5206\u5f55\u7684\u201c\u5de5\u5e8f\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_579", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno"), j + 1));
                    }
                    if (this.isNull(entryObj.getString("oprstatus"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u7684\u201c\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_582", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                } else {
                    if (this.isNull(entryObj.getString("oprorg"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u52a0\u5de5\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_277", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                    if (this.isNull(entryObj.getString("oprno"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff08%1$s\uff09\u4e0b\u5de5\u5e8f\u5217\u8868\u7b2c%2$s\u884c\u5206\u5f55\u7684\u201c\u5de5\u5e8f\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_279", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), j + 1));
                    }
                    if (this.isNull(entryObj.getString("oprstatus"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u201c\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_282", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                }
                if (!obj.getDataEntityType().getName().equals("sfc_mromanuftech")) {
                    if (this.isPropManftech()) {
                        BigDecimal qty;
                        if (this.isNull(entryObj.get("oprstandardqty")) || entryObj.getBigDecimal("oprstandardqty").compareTo(BigDecimal.ZERO) == 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5de5\u5e8f\u6807\u51c6\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_583", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("headqty")) || entryObj.getBigDecimal("headqty").compareTo(BigDecimal.ZERO) == 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u8868\u5934\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_589", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("operationqty")) || entryObj.getBigDecimal("operationqty").compareTo(BigDecimal.ZERO) == 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5de5\u5e8f\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_590", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("basebatchqty")) || entryObj.getBigDecimal("basebatchqty").compareTo(BigDecimal.ZERO) == 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u57fa\u672c\u6279\u91cf\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_591", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.getString("oprdescription"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%1$s]\u5de5\u5e8f\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_328", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.getDynamicObject("oprunit"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5de5\u5e8f\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_584", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("oprplanbegintime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_585", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("oprplanfinishtime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_586", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("upperratio")) || entryObj.getBigDecimal("upperratio").compareTo(BigDecimal.ZERO) < 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u6c47\u62a5\u4e0a\u9650\u6bd4\u4f8b\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"TechnicsTplValidators_587", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("floorratio")) || entryObj.getBigDecimal("floorratio").compareTo(BigDecimal.ZERO) < 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u6c47\u62a5\u4e0b\u9650\u6bd4\u4f8b\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"TechnicsTplValidators_588", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.getDynamicObject("headunit"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u8868\u5934\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_592", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (entryObj.getDate("oprearliestbegintime") != null && entryObj.getDate("oprlatestbegintime") != null && entryObj.getDate("oprearliestbegintime").after(entryObj.getDate("oprlatestbegintime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u6700\u65e9\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u6700\u665a\u5f00\u59cb\u65f6\u95f4\u3002", (String)"TechnicsTplValidators_593", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (entryObj.getDate("oprearliestfinishtime") != null && entryObj.getDate("oprlatestfinishtime") != null && entryObj.getDate("oprearliestfinishtime").after(entryObj.getDate("oprlatestfinishtime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u6700\u65e9\u5b8c\u5de5\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u6700\u665a\u5b8c\u5de5\u65f6\u95f4\u3002", (String)"TechnicsTplValidators_594", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (entryObj.getDate("oprearliestbegintime") != null && entryObj.getDate("oprearliestfinishtime") != null && entryObj.getDate("oprearliestbegintime").after(entryObj.getDate("oprearliestfinishtime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u6700\u65e9\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u6700\u65e9\u5b8c\u5de5\u65f6\u95f4\u3002", (String)"TechnicsTplValidators_595", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (entryObj.getDate("oprlatestbegintime") != null && entryObj.getDate("oprlatestfinishtime") != null && entryObj.getDate("oprlatestbegintime").after(entryObj.getDate("oprlatestfinishtime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u6700\u665a\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u6700\u665a\u5b8c\u5de5\u65f6\u95f4\u3002", (String)"TechnicsTplValidators_596", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (entryObj.getBoolean("oprissplit")) {
                            qty = entryObj.getBigDecimal("oprsuggestsplitqty");
                            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u542f\u7528\u62c6\u5206\u6392\u7a0b\uff0c\u5efa\u8bae\u62c6\u5206\u6570\u91cf\u987b\u5927\u4e8e0\u3002", (String)"TechnicsTplValidators_597", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            }
                            if ((qty = entryObj.getBigDecimal("oprminworktime")).compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5de5\u5e8f\u542f\u7528\u62c6\u5206\u6392\u7a0b\uff0c\u6700\u5c0f\u52a0\u5de5\u65f6\u95f4\u987b\u5927\u4e8e0\u3002", (String)"TechnicsTplValidators_598", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            }
                        } else {
                            qty = entryObj.getBigDecimal("oprsuggestsplitqty");
                            if (qty.compareTo(BigDecimal.ZERO) < 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5efa\u8bae\u62c6\u5206\u6570\u91cf\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"TechnicsTplValidators_599", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            }
                            if ((qty = entryObj.getBigDecimal("oprminworktime")).compareTo(BigDecimal.ZERO) < 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u6700\u5c0f\u52a0\u5de5\u65f6\u95f4\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"TechnicsTplValidators_600", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            }
                        }
                        if (entryObj.getBoolean("oprisprocessoverlap")) {
                            qty = entryObj.getBigDecimal("oprminoverlaptime");
                            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u91cd\u53e0\u5de5\u5e8f\uff0c\u91cd\u53e0\u6700\u5c0f\u65f6\u95f4\u987b\u5927\u4e8e0\u3002", (String)"TechnicsTplValidators_601", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            }
                            if ((qty = entryObj.getBigDecimal("oproverlapqty")).compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u91cd\u53e0\u5de5\u5e8f\uff0c\u91cd\u53e0\u6279\u91cf\u987b\u5927\u4e8e0\u3002", (String)"TechnicsTplValidators_602", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            }
                        } else {
                            qty = entryObj.getBigDecimal("oprminoverlaptime");
                            if (qty.compareTo(BigDecimal.ZERO) < 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u91cd\u53e0\u6700\u5c0f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"TechnicsTplValidators_603", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            }
                            if ((qty = entryObj.getBigDecimal("oproverlapqty")).compareTo(BigDecimal.ZERO) < 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u91cd\u53e0\u6279\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"TechnicsTplValidators_604", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            }
                        }
                    } else {
                        BigDecimal qty;
                        if (!obj.getDataEntityType().getName().equals("prop_manftech") && this.isNull(entryObj.getDynamicObject("oprworkcenter"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u4f5c\u4e2d\u5fc3\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_278", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (!"prop_manftech".equalsIgnoreCase(obj.getDataEntityType().getName()) && this.isNull(entryObj.getDynamicObject("oprctrlstrategy"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u63a7\u5236\u7b56\u7565\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_281", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("oprstandardqty")) || entryObj.getBigDecimal("oprstandardqty").compareTo(BigDecimal.ZERO) == 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u5de5\u5e8f\u6807\u51c6\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_283", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("headqty")) || entryObj.getBigDecimal("headqty").compareTo(BigDecimal.ZERO) == 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u8868\u5934\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_289", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("operationqty")) || entryObj.getBigDecimal("operationqty").compareTo(BigDecimal.ZERO) == 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u5de5\u5e8f\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_290", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("basebatchqty")) || entryObj.getBigDecimal("basebatchqty").compareTo(BigDecimal.ZERO) == 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u57fa\u672c\u6279\u91cf\u201d\u4e0d\u80fd\u4e3a0\u3002", (String)"TechnicsTplValidators_291", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.getString("oprdescription"))) {
                            if (!"prop_manftech".equalsIgnoreCase(obj.getDataEntityType().getName())) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u8bf4\u660e\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_280", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            } else {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%1$s]\u5de5\u5e8f\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_328", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                            }
                        }
                        if (this.isNull(entryObj.getDynamicObject("oprunit"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_284", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("oprplanbegintime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_285", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("oprplanfinishtime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_286", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("upperratio")) || entryObj.getBigDecimal("upperratio").compareTo(BigDecimal.ZERO) < 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u6c47\u62a5\u4e0a\u9650\u6bd4\u4f8b\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_287", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.get("floorratio")) || entryObj.getBigDecimal("floorratio").compareTo(BigDecimal.ZERO) < 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u6c47\u62a5\u4e0b\u9650\u6bd4\u4f8b\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_288", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (this.isNull(entryObj.getDynamicObject("headunit"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8868\u5934\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_292", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (entryObj.getDate("oprearliestbegintime") != null && entryObj.getDate("oprlatestbegintime") != null && entryObj.getDate("oprearliestbegintime").after(entryObj.getDate("oprlatestbegintime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u6700\u65e9\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u6700\u665a\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"TechnicsTplValidators_293", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (entryObj.getDate("oprearliestfinishtime") != null && entryObj.getDate("oprlatestfinishtime") != null && entryObj.getDate("oprearliestfinishtime").after(entryObj.getDate("oprlatestfinishtime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u201c\u6700\u65e9\u5b8c\u5de5\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u6700\u665a\u5b8c\u5de5\u65f6\u95f4\u201d\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_294", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (entryObj.getDate("oprearliestbegintime") != null && entryObj.getDate("oprearliestfinishtime") != null && entryObj.getDate("oprearliestbegintime").after(entryObj.getDate("oprearliestfinishtime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u201c\u6700\u65e9\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u6700\u65e9\u5b8c\u5de5\u65f6\u95f4\u201d\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_295", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (entryObj.getDate("oprlatestbegintime") != null && entryObj.getDate("oprlatestfinishtime") != null && entryObj.getDate("oprlatestbegintime").after(entryObj.getDate("oprlatestfinishtime"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u201c\u6700\u665a\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u6700\u665a\u5b8c\u5de5\u65f6\u95f4\u201d\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_296", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                        if (entryObj.getBoolean("oprissplit")) {
                            qty = entryObj.getBigDecimal("oprsuggestsplitqty");
                            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u542f\u7528\u62c6\u5206\u6392\u7a0b\uff0c\u201c\u5efa\u8bae\u62c6\u5206\u6570\u91cf\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_297", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            if ((qty = entryObj.getBigDecimal("oprminworktime")).compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u542f\u7528\u62c6\u5206\u6392\u7a0b\uff0c\u201c\u6700\u5c0f\u52a0\u5de5\u65f6\u95f4\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_298", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                        } else {
                            qty = entryObj.getBigDecimal("oprsuggestsplitqty");
                            if (qty.compareTo(BigDecimal.ZERO) < 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5efa\u8bae\u62c6\u5206\u6570\u91cf\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_299", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            if ((qty = entryObj.getBigDecimal("oprminworktime")).compareTo(BigDecimal.ZERO) < 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u6700\u5c0f\u52a0\u5de5\u65f6\u95f4\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_300", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                        }
                        if (entryObj.getBoolean("oprisprocessoverlap")) {
                            qty = entryObj.getBigDecimal("oprminoverlaptime");
                            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u91cd\u53e0\u5de5\u5e8f\uff0c\u201c\u91cd\u53e0\u6700\u5c0f\u65f6\u95f4\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_301", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            if ((qty = entryObj.getBigDecimal("oproverlapqty")).compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u91cd\u53e0\u5de5\u5e8f\uff0c\u201c\u91cd\u53e0\u6279\u91cf\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_302", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                        } else {
                            qty = entryObj.getBigDecimal("oprminoverlaptime");
                            if (qty.compareTo(BigDecimal.ZERO) < 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u91cd\u53e0\u6700\u5c0f\u65f6\u95f4\u201d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"TechnicsTplValidators_303", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                            if ((qty = entryObj.getBigDecimal("oproverlapqty")).compareTo(BigDecimal.ZERO) < 0) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u91cd\u53e0\u6279\u91cf\u201d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"TechnicsTplValidators_304", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                            }
                        }
                    }
                }
                subEntryCol = entryObj.getDynamicObjectCollection("ressubentryentity");
                if (this.isPropManftech()) {
                    for (k = 0; k < subEntryCol.size(); ++k) {
                        subEntryObj = (DynamicObject)subEntryCol.get(k);
                        if (!this.isNull(subEntryObj.getDynamicObject("schresource"))) continue;
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5de5\u5e8f\u6392\u7a0b\u5b50\u5206\u5f55,\u8d44\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_605", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                    }
                } else {
                    for (k = 0; k < subEntryCol.size(); ++k) {
                        subEntryObj = (DynamicObject)subEntryCol.get(k);
                        if (!this.isNull(subEntryObj.getDynamicObject("schresource"))) continue;
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u5de5\u5e8f\u6392\u7a0b\u201d\u5b50\u5206\u5f55,\u201c\u8d44\u6e90\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_305", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                }
                if (!this.isNull(obj.getDynamicObject("transactiontype"))) {
                    subEntryCol = entryObj.getDynamicObjectCollection("actsubentryentity");
                    if (!(obj.getDataEntityType().getName().equals("sfc_mromanuftech") || "prop_manftech".equalsIgnoreCase(obj.getDataEntityType().getName()) && !entryObj.getBoolean("isstage") || subEntryCol.size() != 0)) {
                        if ("prop_manftech".equalsIgnoreCase(obj.getDataEntityType().getName())) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u6d3b\u52a8\u3002", (String)"TechnicsTplValidators_326", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        } else {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u6d3b\u52a8\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_306", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                        }
                    }
                }
                if ("prop_manftech".equalsIgnoreCase(obj.getDataEntityType().getName())) {
                    if (!entryObj.getBoolean("isstage")) continue;
                    if (entryObj.getDynamicObject("oprctrlstrategy") == null) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%1$s]\u5de5\u5e8f\u63a7\u5236\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_320", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                    }
                }
                if (this.isPropManftech()) {
                    for (k = 0; k < subEntryCol.size(); ++k) {
                        subEntryObj = (DynamicObject)subEntryCol.get(k);
                        if (!obj.getDataEntityType().getName().equals("sfc_mromanuftech")) {
                            if (this.isNull(subEntryObj.getString("processstage"))) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%2$s\u884c\u5de5\u5e8f\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_607", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno"), k + 1));
                            }
                            if (this.isNull(subEntryObj.getDynamicObject("actstandardformula"))) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%2$s\u884c\u6807\u51c6\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_608", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno"), k + 1));
                            }
                            if (this.isNull(subEntryObj.getDynamicObject("actstandardformula1"))) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%2$s\u884c\u6807\u51c6\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TechnicsTplValidators_608", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno"), k + 1));
                            }
                        }
                        if (subEntryObj.getBigDecimal("actqty").compareTo(BigDecimal.ZERO) < 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"TechnicsTplValidators_609", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                        }
                        if (subEntryObj.getDate("actplanbegintime") == null || subEntryObj.getDate("actplanfinishtime") == null || !subEntryObj.getDate("actplanbegintime").after(subEntryObj.getDate("actplanfinishtime"))) continue;
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%1$s\uff09\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%2$s\u884c\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u3002", (String)"TechnicsTplValidators_611", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprno"), k + 1));
                    }
                    continue;
                }
                for (k = 0; k < subEntryCol.size(); ++k) {
                    subEntryObj = (DynamicObject)subEntryCol.get(k);
                    if (!obj.getDataEntityType().getName().equals("sfc_mromanuftech")) {
                        if (this.isNull(subEntryObj.getString("processstage"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u5de5\u5e8f\u9636\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_307", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                        }
                        if (this.isNull(subEntryObj.getDynamicObject("actstandardformula"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_308", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                        }
                        if (this.isNull(subEntryObj.getDynamicObject("actstandardformula1"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_308", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                        }
                    }
                    if (subEntryObj.getBigDecimal("actqty").compareTo(BigDecimal.ZERO) < 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u57fa\u672c\u6570\u91cf\u201d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"TechnicsTplValidators_309", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                    if (subEntryObj.getDate("actplanbegintime") == null || subEntryObj.getDate("actplanfinishtime") == null || !subEntryObj.getDate("actplanbegintime").after(subEntryObj.getDate("actplanfinishtime"))) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"TechnicsTplValidators_311", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                }
            }
        }
    }

    private boolean isExistsManuftech(DynamicObject obj) {
        return ORM.create().exists(obj.getDataEntityType().getName(), new QFilter[]{new QFilter("mftentryseq", "=", obj.getDynamicObject("mftentryseq").getPkValue()), new QFilter("id", "!=", obj.getPkValue())});
    }

    private boolean isPropManftech() {
        return "prop_manftech".equalsIgnoreCase(this.getEntityKey());
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj == null || obj.toString().trim().length() == 0;
        }
        return obj == null;
    }

    public static List<String> mftOrderBizStatus(DynamicObject dataEntity, String entity) {
        List<String> list = new ArrayList<String>();
        try {
            list = (List)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"IPomMftOrderService", (String)"mftOrderBizstatus", (Object[])new Object[]{dataEntity, entity});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }

    protected String getOrderBillType() {
        String name = "pom_mftorder";
        if (this.getOption().containsVariable("orderBillType")) {
            name = this.getOption().getVariableValue("orderBillType");
        } else {
            String entityKey = this.getEntityKey();
            if ("om_mfttechnics".equals(entityKey)) {
                name = "om_mftorder";
            } else if ("prop_manftech".equals(entityKey)) {
                name = "prop_mftorder";
            }
        }
        return name;
    }

    protected String getOrderBillName() {
        String name = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"TechnicsTplValidators_151", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
        if (this.getOption().containsVariable("orderBillName")) {
            name = this.getOption().getVariableValue("orderBillName");
        }
        return name;
    }
}

