/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.inv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bd.mpdm.business.helper.MaterialInvInfoHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;

public class StockSaveGetInv
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("stockentry.supplyorgid");
        e.getFieldKeys().add("stockentry.materialid");
        e.getFieldKeys().add("stockentry.materielinv");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        HashMap<Long, ArrayList<Long>> orgMasterMap = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection stockEntrys = obj.getDynamicObjectCollection("stockentry");
            if (stockEntrys == null) {
                return;
            }
            for (DynamicObject stockEntry : stockEntrys) {
                DynamicObject material = stockEntry.getDynamicObject("materialid");
                DynamicObject supply = stockEntry.getDynamicObject("supplyorgid");
                if (material == null || supply == null || material.getDynamicObject("masterid") == null) continue;
                DynamicObject masterid = material.getDynamicObject("masterid");
                Long orgId = (Long)supply.getPkValue();
                ArrayList<Long> list = (ArrayList<Long>)orgMasterMap.get(orgId);
                if (list == null) {
                    list = new ArrayList<Long>(16);
                }
                list.add((Long)masterid.getPkValue());
                orgMasterMap.put(orgId, list);
            }
        }
        Map res = MaterialInvInfoHelper.batchGetMaterialInvInfo(orgMasterMap);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection stockEntrys = obj.getDynamicObjectCollection("stockentry");
            if (stockEntrys == null) {
                return;
            }
            for (DynamicObject stockEntry : stockEntrys) {
                DynamicObject material = stockEntry.getDynamicObject("materialid");
                DynamicObject supply = stockEntry.getDynamicObject("supplyorgid");
                if (material == null || supply == null || material.getDynamicObject("masterid") == null) continue;
                DynamicObject masterid = material.getDynamicObject("masterid");
                Long orgId = (Long)supply.getPkValue();
                Long masterId = (Long)masterid.getPkValue();
                stockEntry.set("materielinv", (Object)MaterialInvInfoHelper.getMaterialByRes((Map)res, (Long)orgId, (Long)masterId));
            }
        }
    }
}

