/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class ConfigureCodeRequiredVal
extends AbstractValidator {
    private static final Set<String> ORDER = new HashSet<String>(16);
    private static final Set<String> STOCK = new HashSet<String>(16);

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            String entityName = entity.getDataEntityType().getName();
            DynamicObjectCollection collection = null;
            String message = "";
            if (ORDER.contains(entityName)) {
                collection = entity.getDynamicObjectCollection("treeentryentity");
            } else if (STOCK.contains(entityName)) {
                collection = entity.getDynamicObjectCollection("stockentry");
            }
            if (collection == null) continue;
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject materialInConfig;
                DynamicObject material = ((DynamicObject)collection.get(i)).getDynamicObject("materielmasterid");
                DynamicObject configureCode = null;
                if (ORDER.contains(entityName)) {
                    configureCode = ((DynamicObject)collection.get(i)).getDynamicObject("configuredcode");
                    message = ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"ConfigureCodeRequiredVal_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                } else if (STOCK.contains(entityName)) {
                    configureCode = ((DynamicObject)collection.get(i)).getDynamicObject("entryconfiguredcode");
                    message = ResManager.loadKDString((String)"\u7ec4\u4ef6\u914d\u7f6e\u53f7", (String)"ConfigureCodeRequiredVal_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                }
                if (material == null) continue;
                if (configureCode == null && "2".equals(material.getString("configproperties"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5206\u5f55%2$s\u5fc5\u5f55\u3002", (String)"ConfigureCodeRequiredVal_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1, message));
                    continue;
                }
                if (null == configureCode || null == (materialInConfig = configureCode.getDynamicObject("material")) || material.getLong("id") == materialInConfig.getLong("id") && !"0".equals(configureCode.getString("enable")) && "C".equals(configureCode.getString("status"))) continue;
                String info = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5206\u5f55%2$s\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"ConfigureCodeRequiredVal_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1, message);
                this.addErrorMessage(dataEntity, info);
            }
        }
    }

    static {
        ORDER.add("pom_mftorder");
        ORDER.add("pom_xmftorder");
        STOCK.add("pom_mftstock");
        STOCK.add("pom_xmftstock");
        ORDER.add("om_mftorder");
        ORDER.add("om_xmftorder");
        STOCK.add("om_mftstock");
        STOCK.add("om_xmftstock");
        STOCK.add("om_componentlist");
        STOCK.add("om_xxcomponentlist");
    }
}

