/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.BotpUtils;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrderDeleteOnPushVal
extends AbstractValidator {
    private String mfttechnicsEntityId = "sfc_manftech";
    private String billName = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"OrderDeleteOnPushVal_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
    private static final Set<String> IGNOREBILLS = new HashSet(16){
        {
            this.add("pom_mftstock");
            this.add("sfc_manftech");
            this.add("om_mftstock");
            this.add("om_mfttechnics");
            this.add("pom_mrostock");
            this.add("sfc_mromanuftech");
            this.add("pom_mrotool");
            this.add("prop_mftstock");
            this.add("prop_manftech");
        }
    };

    public void validate() {
        Map map;
        long orderBillId;
        DynamicObject orderBill;
        HashSet<Long> targetOrders = new HashSet<Long>(16);
        HashSet<Long> targetOmOrders = new HashSet<Long>(16);
        Map maps = new HashMap(16);
        ArrayList<Long> orderBillIds = new ArrayList<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            orderBill = dataEntity.getDataEntity();
            orderBillId = Long.parseLong(orderBill.getPkValue().toString());
            orderBillIds.add(orderBillId);
        }
        maps = BotpUtils.findTargetBillsBatch((String)this.getEntityKey(), (Long[])orderBillIds.toArray(new Long[1]));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            HashSet om_mftorder;
            orderBill = dataEntity.getDataEntity();
            orderBillId = Long.parseLong(orderBill.getPkValue().toString());
            map = (Map)maps.get(orderBillId);
            if (map == null) continue;
            Set targetEntitys = map.keySet();
            if (!StringUtils.equals((CharSequence)"pom_mftorder", (CharSequence)this.getEntityKey()) || !targetEntitys.contains("pom_mftorder") && !targetEntitys.contains("om_mftorder")) continue;
            HashSet pom_mftorder = (HashSet)map.get("pom_mftorder");
            if (pom_mftorder != null && pom_mftorder.size() > 0) {
                targetOrders.addAll((Collection)map.get("pom_mftorder"));
            }
            if ((om_mftorder = (HashSet)map.get("om_mftorder")) == null || om_mftorder.size() <= 0) continue;
            targetOmOrders.addAll((Collection)map.get("om_mftorder"));
        }
        HashSet<Long> childOrderIds = new HashSet<Long>(16);
        this.getChildOrderIds(targetOrders, targetOmOrders, childOrderIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orderBill2;
            Long orderBillId2;
            this.billName = dataEntity.getDataEntity().getDataEntityType().getDisplayName().getLocaleValue();
            if (StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)this.getEntityKey())) {
                this.mfttechnicsEntityId = "om_mfttechnics";
            }
            if (StringUtils.equals((CharSequence)"pom_mroorder", (CharSequence)this.getEntityKey())) {
                this.mfttechnicsEntityId = "sfc_mromanuftech";
            }
            if (null == (map = (Map)maps.get(orderBillId2 = Long.valueOf(Long.parseLong((orderBill2 = dataEntity.getDataEntity()).getPkValue().toString())))) || map.size() <= 0) continue;
            map.keySet().removeIf(key -> IGNOREBILLS.contains(key));
            if (childOrderIds.size() > 0) {
                HashSet targetOrderids = map.get("pom_mftorder") == null ? new HashSet(1) : (HashSet)map.get("pom_mftorder");
                HashSet targetOmOrderids = map.get("om_mftorder") == null ? new HashSet(1) : (HashSet)map.get("om_mftorder");
                targetOrderids.removeIf(key -> childOrderIds.contains(key));
                targetOmOrderids.removeIf(key -> childOrderIds.contains(key));
                if (targetOrderids.size() < 1) {
                    map.remove("pom_mftorder");
                }
                if (targetOmOrderids.size() < 1) {
                    map.remove("om_mftorder");
                }
            }
            if (map.size() <= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"OrderDeleteOnPushVal_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
        this.checkPushMfttechnicsStatus();
    }

    private void getChildOrderIds(Set<Long> targetOrders, Set<Long> targetOmOrders, Set<Long> childOrderIds) {
        try (AlgoContext algo = Algo.newContext();){
            QFilter qFilter;
            DataSet dataSet = null;
            DataSet omDataSet = null;
            DataSet allDataSet = null;
            if (targetOrders.size() > 0) {
                qFilter = new QFilter("id", "in", targetOrders);
                dataSet = QueryServiceHelper.queryDataSet((String)(OrderDeleteOnPushVal.class.getName() + "validate"), (String)"pom_mftorder", (String)"id,billno,parentorderid", (QFilter[])qFilter.toArray(), null);
            }
            if (targetOmOrders.size() > 0) {
                qFilter = new QFilter("id", "in", targetOmOrders);
                omDataSet = QueryServiceHelper.queryDataSet((String)(OrderDeleteOnPushVal.class.getName() + "validate"), (String)"om_mftorder", (String)"id,billno,parentorderid", (QFilter[])qFilter.toArray(), null);
            }
            if (dataSet != null && omDataSet != null) {
                allDataSet = dataSet.union(omDataSet);
            } else if (dataSet != null) {
                allDataSet = dataSet;
            } else if (omDataSet != null) {
                allDataSet = omDataSet;
            }
            if (allDataSet != null) {
                HashMap<String, Long> params = new HashMap<String, Long>(16);
                params.put("parentid", 0L);
                allDataSet = allDataSet.filter("parentorderid > parentid", params);
                for (Row row : allDataSet) {
                    childOrderIds.add(row.getLong("id"));
                }
            }
        }
    }

    private void checkPushMfttechnicsStatus() {
        ArrayList<String> manufactureOrderIds = new ArrayList<String>(10);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            manufactureOrderIds.add(extendedDataEntity.getBillPkId().toString());
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)"A");
        qFilterList.add(qFilter);
        QFilter qFilter1 = new QFilter("manufactureorderid", "in", manufactureOrderIds);
        qFilterList.add(qFilter1);
        DynamicObjectCollection query = QueryServiceHelper.query((String)this.mfttechnicsEntityId, (String)"manufactureorderid", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
        HashSet<String> set = new HashSet<String>(16);
        if (null != query && query.size() > 0) {
            for (DynamicObject dynamicObject : query) {
                String manufactureorderid = dynamicObject.getString("manufactureorderid");
                if (set.contains(manufactureorderid)) continue;
                for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                    String orderId = extendedDataEntity.getBillPkId().toString();
                    if (!StringUtils.equals((CharSequence)manufactureorderid, (CharSequence)orderId)) continue;
                    set.add(orderId);
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\u5b58\u5728\u975e\u6682\u5b58\u72b6\u6001\uff0c%1$s\u5220\u9664\u5931\u8d25\u3002", (String)"OrderDeleteOnPushVal_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), this.billName));
                }
            }
        }
    }
}

