/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bd.mpdm.common.mftorder.utils.JsonUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OrderMergeValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(OrderMergeValidator.class);

    public void validate() {
        String billSelectRowList = this.getOption().getVariableValue("billSelectRowList");
        HashSet orderIds = new HashSet(JsonUtils.jsonToList((String)billSelectRowList));
        Set orderOutResult = OrderMergeHelper.queryOrderOut(orderIds);
        Map orderTechResult = OrderMergeHelper.queryTechMap(orderIds);
        Set hasMergeOrders = OrderMergeHelper.queryMergeOrderOut(orderIds);
        HashSet<String> orderStatus = new HashSet<String>(this.dataEntities.length);
        HashSet<Long> orderOrg = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> entrustdeptOrg = new HashSet<Long>(this.dataEntities.length);
        Set exisstockChange = OrderMergeHelper.queryStockChange(orderIds);
        HashSet<String> orderBillType = new HashSet<String>(this.dataEntities.length);
        HashSet<Long> orderTrasaction = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            List techBills;
            DynamicObject transactiontype;
            if (null == dataEntity || null == dataEntity.getDataEntity()) continue;
            DynamicObject orderBill = dataEntity.getDataEntity();
            long pkValue = Long.parseLong(orderBill.getPkValue().toString());
            if (exisstockChange.contains(pkValue)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u5355\u5bf9\u5e94\u7ec4\u4ef6\u6e05\u5355\u4e2d\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\uff0c\u65e0\u6cd5\u5408\u5e76\u3002", (String)"OrderMergeValidator_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (hasMergeOrders.size() > 0 && hasMergeOrders.contains(pkValue)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5408\u5e76\u5de5\u5355\uff0c\u65e0\u6cd5\u5408\u5e76\u3002", (String)"OrderMergeValidator_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if ((transactiontype = orderBill.getDynamicObject("transactiontype")) != null && transactiontype.getBoolean("isinnerprocess")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e3a\u5185\u534f\u52a0\u5de5\u3002", (String)"OrderMergeValidator_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            long transactiontypePk = transactiontype == null ? 0L : Long.parseLong(transactiontype.getPkValue().toString());
            orderTrasaction.add(transactiontypePk);
            long orgPk = orderBill.getDynamicObject("org") == null ? 0L : Long.parseLong(orderBill.getDynamicObject("org").getPkValue().toString());
            orderOrg.add(orgPk);
            long entrustdeptorgPk = orderBill.getDynamicObject("entrustdept") == null ? 0L : Long.parseLong(orderBill.getDynamicObject("entrustdept").getPkValue().toString());
            entrustdeptOrg.add(entrustdeptorgPk);
            String billType = orderBill.getString("billtype");
            orderBillType.add(billType);
            String billStatus = orderBill.getString("billstatus");
            if (StringUtils.equals((CharSequence)"D", (CharSequence)billStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u5df2\u4f5c\u5e9f\uff0c\u53ea\u80fd\u5408\u5e76\u6682\u5b58\u3001\u63d0\u4ea4\u3001\u5ba1\u6838\u72b6\u6001\u7684\u5de5\u5355\u3002", (String)"OrderMergeValidator_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            orderStatus.add(billStatus);
            Long orderId = Long.parseLong(orderBill.getPkValue().toString());
            if (orderOutResult.contains(orderId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u5b58\u5728\u5ba1\u6838\u72b6\u6001\u7684\u751f\u4ea7\u9886\u6599\u5355\u3001\u751f\u4ea7\u9000\u6599\u5355\u6216\u8005\u751f\u4ea7\u8865\u6599\u5355\uff0c\u65e0\u6cd5\u5408\u5e76\u3002", (String)"OrderMergeValidator_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (transactiontype != null && transactiontype.getBoolean("isprocedure") && (techBills = (List)orderTechResult.get(orderId)) != null && techBills.size() > 0) {
                for (DynamicObject techBill : techBills) {
                    if (techBill.get("oprentryentity") == null) continue;
                    DynamicObjectCollection oprentryentitys = techBill.getDynamicObjectCollection("oprentryentity");
                    boolean flag = false;
                    for (DynamicObject oprentryentity : oprentryentitys) {
                        String oprstatus = oprentryentity.getString("oprstatus");
                        if (StringUtils.equals((CharSequence)"A", (CharSequence)oprstatus) || StringUtils.equals((CharSequence)"B", (CharSequence)oprstatus) || StringUtils.equals((CharSequence)"C", (CharSequence)oprstatus)) continue;
                        flag = true;
                    }
                    if (!flag) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u542f\u7528\u5de5\u5e8f\u7ba1\u7406\uff0c\u5de5\u5e8f\u72b6\u6001\u4e0d\u4e3a\u201c\u521b\u5efa\u201d\u3001\u201c\u8ba1\u5212\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u65f6\uff0c\u65e0\u6cd5\u5408\u5e76\u3002", (String)"OrderMergeValidator_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
            }
            DynamicObjectCollection orderEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                int seq = orderEntry.getInt("seq");
                String producttype = orderEntry.getString("producttype");
                String taskstatus = orderEntry.getString("taskstatus");
                if (!StringUtils.equals((CharSequence)"A", (CharSequence)taskstatus)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u672a\u5f00\u5de5\u3002", (String)"OrderMergeValidator_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String planstatus = orderEntry.getString("planstatus");
                String bizstatus = orderEntry.getString("bizstatus");
                if (StringUtils.equals((CharSequence)bizstatus, (CharSequence)"A")) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e1a\u52a1\u72b6\u6001\u4e0d\u6b63\u5e38\u3002", (String)"OrderMergeValidator_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (orderTrasaction.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e0d\u76f8\u540c\uff0c\u65e0\u6cd5\u751f\u4ea7\u5408\u5e76\u5de5\u5355\u3002", (String)"OrderMergeValidator_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (orderOrg.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u76f8\u540c\uff0c\u65e0\u6cd5\u751f\u6210\u5408\u5e76\u5de5\u5355\u3002", (String)"OrderMergeValidator_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (orderBillType.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u76f8\u540c\uff0c\u65e0\u6cd5\u751f\u6210\u5408\u5e76\u5de5\u5355\u3002", (String)"OrderMergeValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (orderStatus.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u72b6\u6001\u4e0d\u76f8\u540c\uff0c\u65e0\u6cd5\u751f\u6210\u5408\u5e76\u5de5\u5355\u3002", (String)"OrderMergeValidator_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (entrustdeptOrg.size() <= 1) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7\u4e0d\u76f8\u540c\uff0c\u65e0\u6cd5\u751f\u6210\u5408\u5e76\u5de5\u5355\u3002", (String)"OrderMergeValidator_13", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
    }
}

