/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.MftOrderModTimeUtils;
import kd.bd.mpdm.common.mftorder.entity.ModTimeRowInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;

public class OrderModBookDateVal
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if (!"modbeginbookdateop".equals(operateKey) && !"modclosebookdateop".equals(operateKey)) {
            return;
        }
        String dateValue = this.getOption().getVariableValue("modCloseTimeOp");
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String billAndSelectRowMapListStr = this.getOption().getVariableValue("billAndSelectRowMapList");
        Date fillDate = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)dateValue)) {
                fillDate = sf.parse(dateValue);
            }
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4fee\u6539\u5173\u95ed\u65f6\u95f4\u3001\u4e0b\u8fbe\u65f6\u95f4\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff0c\u64cd\u4f5c\u7ec8\u6b62\u3002", (String)"OrderModBookDateVal_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
        if (fillDate == null && !"modbeginbookdateop".equals(operateKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4fee\u6539\u5173\u95ed\u65f6\u95f4\u3001\u4e0b\u8fbe\u65f6\u95f4\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff0c\u64cd\u4f5c\u7ec8\u6b62\u3002", (String)"OrderModBookDateVal_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
        List billAndSelectRows = MftOrderModTimeUtils.modTimeRowsMapTransStringToMap((String)billAndSelectRowMapListStr);
        List billAndSelectRowMapList = MftOrderModTimeUtils.selectsToBillAndSelectRowMapList((List)billAndSelectRows, (ExtendedDataEntity[])this.dataEntities);
        Map modTimeRowsMap = new HashMap(16);
        if (billAndSelectRowMapList.size() > 0) {
            modTimeRowsMap = MftOrderModTimeUtils.handleMatchModTimeRows((List)billAndSelectRowMapList);
        }
        Set modTimeHandleRows = (Set)modTimeRowsMap.get("modTimeHandleRows");
        HashSet<Long> mftEntryIds = new HashSet<Long>(16);
        for (ModTimeRowInfo billAndSelectRow : modTimeHandleRows) {
            String entryId = billAndSelectRow.getEntryId();
            mftEntryIds.add(Long.valueOf(entryId));
        }
        String mftOrderEntity = this.getEntityKey();
        Map mftEntryId_minInvBookDateMap = MftOrderModTimeUtils.getMaxOrMinInvBookDateMap((boolean)false, (String)mftOrderEntity, mftEntryIds);
        if (mftEntryId_minInvBookDateMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection mftOrderEntrys = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject mftOrderEntry : mftOrderEntrys) {
                String msg;
                String fillDateStr;
                String maxStr;
                String seq;
                Long billEntryId = mftOrderEntry.getLong("id");
                Date minInvBookDate = (Date)mftEntryId_minInvBookDateMap.get(billEntryId);
                if (minInvBookDate == null || fillDate == null) continue;
                long maxInvBookTime = OrderModBookDateVal.getShortDate(minInvBookDate).getTime();
                long fillDateTime = OrderModBookDateVal.getShortDate(fillDate).getTime();
                if ("modbeginbookdateop".equals(operateKey) && fillDateTime > maxInvBookTime) {
                    seq = mftOrderEntry.getString("seq");
                    maxStr = OrderModBookDateVal.transDate(minInvBookDate);
                    fillDateStr = OrderModBookDateVal.transDate(fillDate);
                    msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u5f53\u524d\u4fee\u6539\u540e\u7684\u5de5\u5355\u8bb0\u8d26\u65e5\u671f\uff08%2$s\uff09\u5927\u4e8e\u4e0b\u6e38\u5355\u636e\u7684\u6700\u5c0f\u8bb0\u8d26\u65e5\u671f\uff08%3$s\uff09\uff0c\u4fee\u6539\u5931\u8d25\u3002", (String)"OrderModBookDateVal_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq, fillDateStr, maxStr);
                    this.addErrorMessage(extendedDataEntity, msg);
                }
                if (!"modclosebookdateop".equals(operateKey) || fillDateTime >= maxInvBookTime) continue;
                seq = mftOrderEntry.getString("seq");
                maxStr = OrderModBookDateVal.transDate(minInvBookDate);
                fillDateStr = OrderModBookDateVal.transDate(fillDate);
                msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u5f53\u524d\u4fee\u6539\u540e\u7684\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\uff08%2$s\uff09\u5c0f\u4e8e\u4e0b\u6e38\u5355\u636e\u7684\u6700\u5c0f\u8bb0\u8d26\u65e5\u671f\uff08%3$s\uff09\uff0c\u4fee\u6539\u5931\u8d25\u3002", (String)"OrderModBookDateVal_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq, fillDateStr, maxStr);
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }

    private static Date getShortDate(Date source) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(source);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static String transDate(Date value) {
        return new SimpleDateFormat("yyyy-MM-dd").format(value);
    }
}

