/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsProcessRouteQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class OrderSaveOnAddVal
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(OrderSaveOnAddVal.class);

    public void validate() {
        HashSet<Object> bomIds = new HashSet<Object>(16);
        HashSet<Object> processRouteIds = new HashSet<Object>(16);
        HashSet<Object> materielMasterIds = new HashSet<Object>(16);
        HashSet<Object> materielMftIds = new HashSet<Object>(16);
        HashMap<Object, DynamicObject> transactionTypeMap = new HashMap<Object, DynamicObject>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject order = this.dataEntities[i].getDataEntity();
            DynamicObject transactionType = null;
            if (order.getDynamicObject("transactiontype") != null) {
                Object transactionTypeID = order.getDynamicObject("transactiontype").getPkValue();
                transactionType = this.getTransactionType(transactionTypeMap, transactionTypeID, order.getDynamicObject("transactiontype"));
            }
            boolean isprocedure = this.isProcedure(transactionType);
            DynamicObjectCollection dynamicObjectCollection = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String producttype = dynamicObject.getString("producttype");
                if (dynamicObject.getDynamicObject("bomid") != null) {
                    bomIds.add(dynamicObject.getDynamicObject("bomid").getPkValue());
                }
                if (StringUtils.equals((CharSequence)"C", (CharSequence)producttype) && isprocedure && dynamicObject.getDynamicObject("processroute") != null) {
                    processRouteIds.add(dynamicObject.getDynamicObject("processroute").getPkValue());
                }
                if (dynamicObject.getDynamicObject("materielmasterid") != null) {
                    materielMasterIds.add(dynamicObject.getDynamicObject("materielmasterid").getPkValue());
                } else {
                    DynamicObject mftmaterial = dynamicObject.getDynamicObject("material");
                    if (mftmaterial != null) {
                        DynamicObject masterid = (DynamicObject)mftmaterial.get("masterid");
                        materielMasterIds.add(masterid.getPkValue());
                    }
                }
                if (dynamicObject.getDynamicObject("material") == null) continue;
                materielMftIds.add(dynamicObject.getDynamicObject("material").getPkValue());
            }
        }
        String bomSelectPropertirs = "id,type,material";
        Map bomMap = MsBomQueryHelper.getBomDataBySelectPropertirs(bomIds, (String)bomSelectPropertirs);
        Map processRouteMap = MsProcessRouteQueryHelper.getDataCacheBySet(processRouteIds);
        String materialSelectProperties = "id,baseunit";
        Map materielMasterMap = MaterialQueryHelper.getDataBySelectProperties(materielMasterIds, (String)materialSelectProperties);
        String materialmftSelectProperties = "id,enable,status";
        Map materielMftMap = MaterialMftQueryHelper.getDataBySelectProperties(materielMftIds, (String)materialmftSelectProperties);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            this.validateBOMType(extendedDataEntity, bomMap);
            this.validateRoute(extendedDataEntity, transactionTypeMap);
            this.validateMUConv(extendedDataEntity, processRouteMap, materielMasterMap);
            this.validateMaterialMftInfo(extendedDataEntity, materielMftMap);
            DynamicObject order = extendedDataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = order.getDynamicObjectCollection("treeentryentity");
            int entryRow = 0;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                ++entryRow;
                if (this.valideUnit(dynamicObject.getDynamicObject("material"), dynamicObject.getDynamicObject("unit"), materielMasterMap)) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\u4e0e\u8ba1\u91cf\u5355\u4f4d\u65e0\u6362\u7b97\u5173\u7cfb\u3002", (String)"OrderSaveOnAddVal_16", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryRow));
            }
        }
    }

    private void validateMaterialMftInfo(ExtendedDataEntity extendedDataEntity, Map<Object, DynamicObject> materielMftMap) {
        DynamicObject manubill = extendedDataEntity.getDataEntity();
        ArrayList<Integer> entryrows = new ArrayList<Integer>();
        DynamicObjectCollection dyCol = manubill.getDynamicObjectCollection("treeentryentity");
        for (int j = 0; j < dyCol.size(); ++j) {
            DynamicObject entry = (DynamicObject)dyCol.get(j);
            DynamicObject mftInfo = (DynamicObject)entry.get("material");
            if (mftInfo == null || (mftInfo = materielMftMap.get(mftInfo.getPkValue())) != null && mftInfo.getBoolean("enable") && "C".equalsIgnoreCase(mftInfo.getString("status"))) continue;
            entryrows.add(j + 1);
        }
        if (!entryrows.isEmpty()) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u672a\u627e\u5230\u5df2\u5ba1\u6838\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f", (String)"OrderSaveOnAddVal_15", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)entryrows).toString()));
        }
    }

    private void validateBOMType(ExtendedDataEntity extendedDataEntity, Map<Object, DynamicObject> bomMap) {
        String errorMsg = OrderOpUtils.validateBOMType((ExtendedDataEntity)extendedDataEntity, bomMap);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            this.addErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    private void validateRoute(ExtendedDataEntity extendedDataEntity, Map<Object, DynamicObject> transactionTypeMap) {
        DynamicObject transactionType;
        boolean isprocedure;
        DynamicObject manubill = extendedDataEntity.getDataEntity();
        ArrayList<Integer> entryrows = new ArrayList<Integer>(16);
        ArrayList<String> materialName = new ArrayList<String>(16);
        DynamicObject transtype = manubill.getDynamicObject("transactiontype");
        if (transtype != null && (isprocedure = this.isProceduremust(transactionType = transactionTypeMap.get(transtype.getPkValue())))) {
            DynamicObjectCollection dyCol = manubill.getDynamicObjectCollection("treeentryentity");
            for (int j = 0; j < dyCol.size(); ++j) {
                DynamicObject entry = (DynamicObject)dyCol.get(j);
                String producttype = entry.getString("producttype");
                DynamicObject route = (DynamicObject)entry.get("processroute");
                if (entry.getDynamicObject("materielmasterid") == null || route != null || !ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) continue;
                entryrows.add(j + 1);
                materialName.add(entry.getDynamicObject("materielmasterid").getString("number"));
            }
        }
        if (!entryrows.isEmpty()) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u5206\u5f55\u5de5\u827a\u8def\u7ebf\u5fc5\u5f55", (String)"OrderSaveOnAddVal_17", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)entryrows).toString(), ((Object)materialName).toString()));
        }
    }

    private void validateMUConv(ExtendedDataEntity extendedDataEntity, Map<Object, DynamicObject> processRouteMap, Map<Object, DynamicObject> materielMasterMap) {
        DynamicObject manubill = extendedDataEntity.getDataEntity();
        DynamicObject transactiontype = manubill.getDynamicObject("transactiontype");
        if (this.isProcedure(transactiontype)) {
            DynamicObjectCollection manuBillEntrys = manubill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject manuBillEntry : manuBillEntrys) {
                DynamicObject material;
                String producttype = manuBillEntry.getString("producttype");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)producttype) || null == (material = manuBillEntry.getDynamicObject("material"))) continue;
                if (null == (material = material.getDynamicObject("masterid"))) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5bf9\u5e94\u7269\u6599\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"OrderSaveOnAddVal_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), manuBillEntry.getInt("seq")));
                    continue;
                }
                if (null == (material = materielMasterMap.get(material.getPkValue()))) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5bf9\u5e94\u7269\u6599\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"OrderSaveOnAddVal_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), manuBillEntry.getInt("seq")));
                    continue;
                }
                DynamicObject materialBaseunit = material.getDynamicObject("baseunit");
                if (null == materialBaseunit) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5bf9\u5e94\u7269\u6599\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"OrderSaveOnAddVal_13", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), manuBillEntry.getInt("seq")));
                    continue;
                }
                DynamicObject pdmRoute = manuBillEntry.getDynamicObject("processroute");
                if (null == pdmRoute || (pdmRoute = processRouteMap.get(pdmRoute.getPkValue())) == null) continue;
                DynamicObjectCollection pdmRouteProcessentrys = pdmRoute.getDynamicObjectCollection("processentry");
                for (DynamicObject pdmRouteProcessEntry : pdmRouteProcessentrys) {
                    DynamicObject headunit = pdmRouteProcessEntry.getDynamicObject("headunit");
                    if (null == headunit) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5de5\u827a\u8def\u7ebf\u5206\u5f55\u7b2c%2$s\u884c\u8868\u5934\u5355\u4f4d\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"OrderSaveOnAddVal_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), manuBillEntry.getInt("seq"), pdmRouteProcessEntry.getInt("seq")));
                        continue;
                    }
                    if (((Long)materialBaseunit.getPkValue()).equals((Long)headunit.getPkValue())) continue;
                    DynamicObject muConv = null;
                    try {
                        muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)materialBaseunit.getPkValue()), (Long)((Long)headunit.getPkValue()));
                        if (muConv != null && muConv.getInt("denominator") != 0) continue;
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u5206\u5f55\u5de5\u827a\u8def\u7ebf\u3010%2$s\u3011\u8868\u5934\u5355\u4f4d\u548c\u7269\u6599\u3010%3$s\u3011\u57fa\u672c\u5355\u4f4d\u4e0d\u5b58\u5728\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"OrderSaveOnAddVal_14", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), manuBillEntry.getInt("seq"), pdmRoute.getString("number"), material.getString("number")));
                    }
                    catch (Exception e) {
                        logger.info("\u8c03\u7528\u7269\u6599\u57fa\u672c\u5355\u4f4d\u4e0e\u5de5\u827a\u8def\u7ebf\u8868\u5934\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u5f02\u5e38\uff1a" + e);
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u5206\u5f55\u5de5\u827a\u8def\u7ebf\u3010%2$s\u3011\u8868\u5934\u5355\u4f4d\u548c\u7269\u6599\u3010%3$s\u3011\u57fa\u672c\u5355\u4f4d\u4e0d\u5b58\u5728\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"OrderSaveOnAddVal_14", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), manuBillEntry.getInt("seq"), pdmRoute.getString("number"), material.getString("number")));
                    }
                }
            }
        }
    }

    private DynamicObject getTransactionType(Map<Object, DynamicObject> transactionTypeMap, Object transactionTypeID, DynamicObject oldTransactionType) {
        DynamicObject transactionType = transactionTypeMap.get(transactionTypeID);
        if (transactionType == null) {
            transactionType = oldTransactionType != null && oldTransactionType.containsProperty("isproceduremust") && oldTransactionType.containsProperty("isprocedure") ? oldTransactionType : TransactionTypeQueryHelper.getDataCacheByID((Object)transactionTypeID);
            transactionTypeMap.put(transactionTypeID, transactionType);
        }
        return transactionType;
    }

    private boolean isProceduremust(DynamicObject transactionType) {
        if (transactionType == null) {
            return false;
        }
        return transactionType.getBoolean("isproceduremust");
    }

    private boolean isProcedure(DynamicObject transactionType) {
        if (transactionType == null) {
            return false;
        }
        return transactionType.getBoolean("isprocedure");
    }

    private boolean valideUnit(DynamicObject materialMft, DynamicObject unit, Map<Object, DynamicObject> materielMasterMap) {
        if (materialMft == null || unit == null) {
            return true;
        }
        DynamicObject material = materialMft.getDynamicObject("masterid");
        if (material == null) {
            return true;
        }
        if ((material = materielMasterMap.get(material.getPkValue())) == null) {
            return true;
        }
        DynamicObject materialBaseunit = material.getDynamicObject("baseunit");
        if (materialBaseunit == null) {
            return true;
        }
        if (materialBaseunit.getPkValue().equals(unit.getPkValue())) {
            return true;
        }
        List fixconunitlist = BaseDataServiceHelper.getAssistMUListResult((Long)material.getLong("id"), (Long)materialBaseunit.getLong("id"), (String)"1", (Boolean)Boolean.FALSE);
        return fixconunitlist.contains(unit.getLong("id"));
    }
}

