/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsProcessRouteQueryHelper;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class OrderSubmitOnAddVal
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(OrderSubmitOnAddVal.class);
    private static final String KEY_BD_MPDM_OPPLUGIN = "bd-mpdm-opplugin";

    public void validate() {
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList<Integer> listroute = new ArrayList<Integer>();
        HashSet<Object> bomIds = new HashSet<Object>(16);
        HashSet<Object> processRouteIds = new HashSet<Object>(16);
        HashSet<Object> materielMasterIds = new HashSet<Object>(16);
        HashSet<Object> orgIds = new HashSet<Object>(16);
        HashSet<Object> materielMftIds = new HashSet<Object>(16);
        HashMap<Object, DynamicObject> transactionTypeMap = new HashMap<Object, DynamicObject>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            String name;
            DynamicObject order = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = order.getDynamicObjectCollection("treeentryentity");
            if (dynamicObjectCollection == null || dynamicObjectCollection.size() < 1) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrderSubmitOnAddVal_1", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]));
            }
            if ("pom_mroorder".equals(name = order.getDataEntityType().getName())) {
                return;
            }
            if (order.getDynamicObject("org") != null) {
                orgIds.add(order.getDynamicObject("org").getPkValue());
            }
            DynamicObject transactionType = null;
            if (order.getDynamicObject("transactiontype") != null) {
                Object transactionTypeID = order.getDynamicObject("transactiontype").getPkValue();
                transactionType = this.getTransactionType(transactionTypeMap, transactionTypeID, order.getDynamicObject("transactiontype"));
            }
            boolean isprocedure = this.isProcedure(transactionType);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String producttype;
                if (dynamicObject.getDynamicObject("bomid") != null) {
                    bomIds.add(dynamicObject.getDynamicObject("bomid").getPkValue());
                }
                if (StringUtils.equals((CharSequence)"C", (CharSequence)(producttype = dynamicObject.getString("producttype")))) {
                    if (isprocedure && dynamicObject.getDynamicObject("processroute") != null) {
                        processRouteIds.add(dynamicObject.getDynamicObject("processroute").getPkValue());
                    }
                    if (dynamicObject.getDynamicObject("materielmasterid") != null) {
                        materielMasterIds.add(dynamicObject.getDynamicObject("materielmasterid").getPkValue());
                    } else {
                        DynamicObject mftmaterial = dynamicObject.getDynamicObject("material");
                        if (mftmaterial != null) {
                            DynamicObject masterid = (DynamicObject)mftmaterial.get("masterid");
                            materielMasterIds.add(masterid.getPkValue());
                        }
                    }
                }
                if (dynamicObject.getDynamicObject("material") == null) continue;
                materielMftIds.add(dynamicObject.getDynamicObject("material").getPkValue());
            }
        }
        String bomSelectPropertirs = "id,type,material";
        Map bomMap = MsBomQueryHelper.getBomDataBySelectPropertirs(bomIds, (String)bomSelectPropertirs);
        Map processRouteMap = MsProcessRouteQueryHelper.getDataCacheBySet(processRouteIds);
        String materialSelectProperties = "id,baseunit";
        Map materielMasterMap = MaterialQueryHelper.getDataBySelectProperties(materielMasterIds, (String)materialSelectProperties);
        String materialmftSelectProperties = "id,enable,status";
        Map materielMftMap = MaterialMftQueryHelper.getDataBySelectProperties(materielMftIds, (String)materialmftSelectProperties);
        HashMap<Object, DynamicObject> bomVersionMap = new HashMap<Object, DynamicObject>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            StringJoiner stringJoiner;
            DynamicObject manufactureBill = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection dyCol = manufactureBill.getDynamicObjectCollection("treeentryentity");
            list1.clear();
            list2.clear();
            listroute.clear();
            DynamicObject transactiontype = (DynamicObject)manufactureBill.get("transactiontype");
            String stockmaterials = "";
            if (transactiontype != null) {
                stockmaterials = transactiontype.getString("stockmaterials");
            } else {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrderSubmitOnAddVal_0", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]));
            }
            String name = manufactureBill.getDataEntityType().getName();
            if ("pom_mroorder".equals(name)) {
                return;
            }
            DynamicObject dept = (DynamicObject)manufactureBill.get("org");
            this.validateBOMType(this.dataEntities[i], bomMap);
            ArrayList<String> materialName = new ArrayList<String>(16);
            this.checkRouteMustInput(manufactureBill, listroute, transactionTypeMap, materialName);
            if (!listroute.isEmpty()) {
                stringJoiner = new StringJoiner("\u3001");
                listroute.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5de5\u827a\u8def\u7ebf\u5fc5\u5f55\u3002", (String)"OrderSubmitOnAddVal_29", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]), stringJoiner));
            }
            this.twofor(dyCol, stockmaterials, list1, list2, bomVersionMap);
            if (!list2.isEmpty()) {
                stringJoiner = new StringJoiner("\u3001");
                list2.stream().forEach(t -> stringJoiner.add(t.toString()));
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u5c55BOM\u65f6\u95f4\u4e0d\u5728\u6709\u6548\u671f\u5185\u3002", (String)"OrderSubmitOnAddVal_22", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]), stringJoiner.toString()));
            }
            if (!list1.isEmpty()) {
                stringJoiner = new StringJoiner("\u3001");
                list1.stream().forEach(t -> stringJoiner.add(t.toString()));
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55BOM\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrderSubmitOnAddVal_23", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]), stringJoiner.toString()));
            }
            this.validateMUConv(this.dataEntities[i], processRouteMap, materielMasterMap);
            this.validateMaterialMftInfo(this.dataEntities[i], materielMftMap);
        }
    }

    private void validateMaterialMftInfo(ExtendedDataEntity extendedDataEntity, Map<Object, DynamicObject> materielMftMap) {
        DynamicObject manubill = extendedDataEntity.getDataEntity();
        ArrayList<Integer> entryrows = new ArrayList<Integer>();
        DynamicObjectCollection dyCol = manubill.getDynamicObjectCollection("treeentryentity");
        for (int j = 0; j < dyCol.size(); ++j) {
            DynamicObject entry = (DynamicObject)dyCol.get(j);
            DynamicObject mftInfo = (DynamicObject)entry.get("material");
            if (mftInfo == null || (mftInfo = materielMftMap.get(mftInfo.getPkValue())) != null && mftInfo.getBoolean("enable") && "C".equalsIgnoreCase(mftInfo.getString("status"))) continue;
            entryrows.add(j + 1);
        }
        if (!entryrows.isEmpty()) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u672a\u627e\u5230\u5df2\u5ba1\u6838\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f", (String)"OrderSubmitOnAddVal_28", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]), ((Object)entryrows).toString()));
        }
    }

    private void validateMUConv(ExtendedDataEntity extendedDataEntity, Map<Object, DynamicObject> processRouteMap, Map<Object, DynamicObject> materielMasterMap) {
        DynamicObject manubill = extendedDataEntity.getDataEntity();
        DynamicObject transactiontype = manubill.getDynamicObject("transactiontype");
        if (this.isProcedure(transactiontype)) {
            DynamicObjectCollection manuBillEntrys = manubill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject manuBillEntry : manuBillEntrys) {
                DynamicObject material;
                String producttype = manuBillEntry.getString("producttype");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)producttype) || null == (material = manuBillEntry.getDynamicObject("material"))) continue;
                if (null == (material = material.getDynamicObject("masterid"))) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u5206\u5f55\u201c\u7269\u6599\u201d\u3002", (String)"OrderSubmitOnAddVal_25", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]), manuBillEntry.getInt("seq")));
                    continue;
                }
                DynamicObject materialBaseunit = (material = materielMasterMap.get(material.getPkValue())).getDynamicObject("baseunit");
                if (null == materialBaseunit) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u5206\u5f55\u7684\u201c\u7269\u6599\u57fa\u672c\u5355\u4f4d\u201d\u3002", (String)"OrderSubmitOnAddVal_26", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]), manuBillEntry.getInt("seq")));
                    continue;
                }
                DynamicObject pdmRoute = manuBillEntry.getDynamicObject("processroute");
                if (null == pdmRoute || (pdmRoute = processRouteMap.get(pdmRoute.getPkValue())) == null) continue;
                DynamicObjectCollection pdmRouteProcessentrys = pdmRoute.getDynamicObjectCollection("processentry");
                for (DynamicObject pdmRouteProcessEntry : pdmRouteProcessentrys) {
                    DynamicObject headunit = pdmRouteProcessEntry.getDynamicObject("headunit");
                    if (null == headunit) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5de5\u827a\u8def\u7ebf\u5206\u5f55\u7b2c%2$s\u884c\u8868\u5934\u5355\u4f4d\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"OrderSubmitOnAddVal_7", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]), manuBillEntry.getInt("seq"), pdmRouteProcessEntry.getInt("seq")));
                        continue;
                    }
                    DynamicObject muConv = null;
                    try {
                        muConv = BaseDataServiceHelper.getMUConv((Long)material.getLong("id"), (Long)materialBaseunit.getLong("id"), (Long)headunit.getLong("id"));
                        if (muConv != null && muConv.getInt("denominator") != 0) continue;
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u5206\u5f55\u5de5\u827a\u8def\u7ebf\u3010%2$s\u3011\u8868\u5934\u5355\u4f4d\u548c\u7269\u6599\u3010%3$s\u3011\u57fa\u672c\u5355\u4f4d\u4e0d\u5b58\u5728\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"OrderSubmitOnAddVal_27", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]), manuBillEntry.getInt("seq"), pdmRoute.getString("number"), material.getString("number")));
                    }
                    catch (Exception e) {
                        logger.info("\u8c03\u7528\u7269\u6599\u57fa\u672c\u5355\u4f4d\u4e0e\u5de5\u827a\u8def\u7ebf\u8868\u5934\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u5f02\u5e38\uff1a" + e);
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u5206\u5f55\u5de5\u827a\u8def\u7ebf\u3010%2$s\u3011\u8868\u5934\u5355\u4f4d\u548c\u7269\u6599\u3010%3$s\u3011\u57fa\u672c\u5355\u4f4d\u4e0d\u5b58\u5728\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"OrderSubmitOnAddVal_27", (String)KEY_BD_MPDM_OPPLUGIN, (Object[])new Object[0]), manuBillEntry.getInt("seq"), pdmRoute.getString("number"), material.getString("number")));
                    }
                }
            }
        }
    }

    private void twofor(DynamicObjectCollection dyCol, String stockmaterials, List<Integer> list1, List<Integer> list2, Map<Object, DynamicObject> bomVersionMap) {
        this.setBomVersionLst(dyCol, bomVersionMap);
        for (int j = 0; j < dyCol.size(); ++j) {
            DynamicObject entry = (DynamicObject)dyCol.get(j);
            DynamicObject bom = (DynamicObject)entry.get("bomid");
            if (bom == null && "A".equals(stockmaterials) && !entry.getBoolean("noextendbom") && "C".equals(entry.get("producttype"))) {
                list1.add(j + 1);
                continue;
            }
            if (bom == null) continue;
            this.sumList(bom, entry, list2, j, bomVersionMap);
        }
    }

    private void sumList(DynamicObject bom, DynamicObject entry, List<Integer> list2, int j, Map<Object, DynamicObject> bomVersionMap) {
        DynamicObject bomversion = (DynamicObject)bom.get("version");
        if (bomversion != null) {
            bomversion = this.getBomVersion(bomVersionMap, bomversion.getPkValue());
            Date effectdate = bomversion.getDate("effectdate");
            Date invaliddate = bomversion.getDate("invaliddate");
            Date expendbomtime = (Date)entry.get("expendbomtime");
            if (expendbomtime != null && (expendbomtime.compareTo(effectdate) < 0 || expendbomtime.compareTo(invaliddate) >= 0)) {
                list2.add(j + 1);
            }
        }
    }

    private void checkRouteMustInput(DynamicObject manubill, List<Integer> listroute, Map<Object, DynamicObject> transactionTypeMap, List<String> materialName) {
        DynamicObject transtype = manubill.getDynamicObject("transactiontype");
        if (transtype != null) {
            DynamicObject transactionType = transactionTypeMap.get(transtype.getPkValue());
            boolean isprocedure = this.isProceduremust(transactionType);
            DynamicObjectCollection dyCol = manubill.getDynamicObjectCollection("treeentryentity");
            for (int j = 0; j < dyCol.size(); ++j) {
                DynamicObject entry = (DynamicObject)dyCol.get(j);
                String producttype = entry.getString("producttype");
                DynamicObject processroute = (DynamicObject)entry.get("processroute");
                if (!isprocedure || processroute != null || !ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) continue;
                listroute.add(j + 1);
                if (entry.getDynamicObject("materielmasterid") == null) continue;
                materialName.add(entry.getDynamicObject("materielmasterid").getString("number"));
            }
        }
    }

    private void validateBOMType(ExtendedDataEntity extendedDataEntity, Map<Object, DynamicObject> bomMap) {
        String errorMsg = OrderOpUtils.validateBOMType((ExtendedDataEntity)extendedDataEntity, bomMap);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            this.addErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    private DynamicObject getTransactionType(Map<Object, DynamicObject> transactionTypeMap, Object transactionTypeID, DynamicObject oldTransactionType) {
        DynamicObject transactionType = transactionTypeMap.get(transactionTypeID);
        if (transactionType == null) {
            transactionType = oldTransactionType != null && oldTransactionType.containsProperty("isproceduremust") && oldTransactionType.containsProperty("stockmaterials") && oldTransactionType.containsProperty("isprocedure") ? oldTransactionType : TransactionTypeQueryHelper.getDataCacheByID((Object)transactionTypeID);
            transactionTypeMap.put(transactionTypeID, transactionType);
        }
        return transactionType;
    }

    private boolean isProceduremust(DynamicObject transactionType) {
        if (transactionType == null) {
            return false;
        }
        return transactionType.getBoolean("isproceduremust");
    }

    private boolean isProcedure(DynamicObject transactionType) {
        if (transactionType == null) {
            return false;
        }
        return transactionType.getBoolean("isprocedure");
    }

    private DynamicObject getBomVersion(Map<Object, DynamicObject> bomVersionMap, Object bomversionID) {
        DynamicObject bomVersion = bomVersionMap.get(bomversionID);
        if (bomVersion == null) {
            String selectFields = "effectdate,invaliddate";
            bomVersion = BusinessDataServiceHelper.loadSingleFromCache((Object)bomversionID, (String)"bd_bomversion", (String)selectFields);
            bomVersionMap.put(bomversionID, bomVersion);
        }
        return bomVersion;
    }

    private boolean valideUnit(DynamicObject materialMft, DynamicObject unit, Map<Object, DynamicObject> materielMasterMap) {
        if (materialMft == null || unit == null) {
            return true;
        }
        DynamicObject material = materialMft.getDynamicObject("masterid");
        if (material == null) {
            return true;
        }
        if ((material = materielMasterMap.get(material.getPkValue())) == null) {
            return true;
        }
        DynamicObject materialBaseunit = material.getDynamicObject("baseunit");
        if (materialBaseunit == null) {
            return true;
        }
        if (materialBaseunit.getPkValue().equals(unit.getPkValue())) {
            return true;
        }
        List fixconunitlist = BaseDataServiceHelper.getAssistMUListResult((Long)material.getLong("id"), (Long)materialBaseunit.getLong("id"), (String)"1", (Boolean)Boolean.FALSE);
        return fixconunitlist.contains(unit.getLong("id"));
    }

    private void setBomVersionLst(DynamicObjectCollection orderRows, Map<Object, DynamicObject> bomVersionMap) {
        Map<Object, DynamicObject> curBomVerMap = this.getBomVersionLst(orderRows);
        if (curBomVerMap.size() > 0) {
            bomVersionMap.putAll(curBomVerMap);
        }
    }

    private Map<Object, DynamicObject> getBomVersionLst(DynamicObjectCollection orderRows) {
        HashSet<Long> bomVerIDs = new HashSet<Long>(16);
        for (DynamicObject orderRow : orderRows) {
            DynamicObject bomversion;
            DynamicObject bom = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)orderRow, (String)"bomid");
            if (bom == null || (bomversion = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"version")) == null) continue;
            bomVerIDs.add((Long)bomversion.getPkValue());
        }
        Map bomVerMap = null;
        if (bomVerIDs.size() > 0) {
            QFilter qf = new QFilter("id", "in", bomVerIDs);
            String selectFields = "effectdate,invaliddate";
            bomVerMap = BusinessDataServiceHelper.loadFromCache((String)"bd_bomversion", (String)selectFields, (QFilter[])qf.toArray());
        }
        if (bomVerMap == null) {
            bomVerMap = new HashMap(16);
        }
        return bomVerMap;
    }
}

