/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.validator;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class OrderUnAuditOnAddVal
extends AbstractValidator {
    private static final Set<String> BILLTYPES = ImmutableSet.of((Object)"pom_mftstock", (Object)"sfc_manftech", (Object)"om_mftstock", (Object)"om_mfttechnics", (Object)"pom_mrostock", (Object)"sfc_mromanuftech", (Object[])new String[]{"pom_mrotool", "pom_mroeleccontrol", "prop_mftstock", "prop_manftech"});

    public void validate() {
        ArrayList<Integer> rowlist1 = new ArrayList<Integer>();
        HashSet<String> orderIds = new HashSet<String>(this.dataEntities.length);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject manufactureBill = this.dataEntities[i].getDataEntity();
            orderIds.add(manufactureBill.getPkValue().toString());
        }
        Set<Long> hasTargetOrderIds = this.getHasTargetOrderIds(orderIds);
        Set<Long> hasEightTargetOrderIds = this.getHasEightTargetOrderIds(orderIds);
        Map<Long, String> idAndErrorMsg = this.getIdAndErrorMsg(orderIds);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            String checkPushBillResult;
            DynamicObject manufactureBill = this.dataEntities[i].getDataEntity();
            Object orderid = manufactureBill.getPkValue();
            DynamicObjectCollection dyCol = manufactureBill.getDynamicObjectCollection("treeentryentity");
            rowlist1.clear();
            for (int j = 0; j < dyCol.size(); ++j) {
                DynamicObject entry = (DynamicObject)dyCol.get(j);
                String planstatus = (String)entry.get("planstatus");
                if (ManuBillPlanStatusEnum.PLANSURE.getValue().equals(planstatus) || ManuBillPlanStatusEnum.PLAN.getValue().equals(planstatus)) continue;
                rowlist1.add(j + 1);
            }
            if (!rowlist1.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                rowlist1.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e0d\u662f\u201c\u8ba1\u5212\u201d\u6216\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u72b6\u6001\u3002", (String)"OrderUnAuditOnAddVal_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), stringJoiner));
                continue;
            }
            if (hasTargetOrderIds.contains(Long.parseLong(orderid.toString()))) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"OrderUnAuditOnAddVal_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.isNotBlank((CharSequence)(checkPushBillResult = this.checkPushBills(manufactureBill, hasEightTargetOrderIds, idAndErrorMsg)))) continue;
            this.addErrorMessage(this.dataEntities[i], checkPushBillResult);
        }
    }

    private Set<Long> getHasEightTargetOrderIds(Set<String> orderIds) {
        List<Long> orderids = orderIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList());
        HashSet<Long> hasEightTargetOrderIds = new HashSet<Long>(orderIds.size());
        Map idAndLinkDownNode = BFTrackerServiceHelper.loadBillLinkDownNodes((String)this.getEntityKey(), (Long[])orderids.toArray(new Long[0]), (boolean)false);
        HashMap<Long, String> typeCache = new HashMap<Long, String>();
        for (Map.Entry entry : idAndLinkDownNode.entrySet()) {
            Long id = (Long)entry.getKey();
            BFRowLinkDownNode bf = (BFRowLinkDownNode)entry.getValue();
            HashSet<Object> targetBillIds = new HashSet<Object>();
            Map tNodes = bf.getTNodes();
            this.dealForEight(targetBillIds, tNodes, typeCache);
            if (targetBillIds.isEmpty()) continue;
            hasEightTargetOrderIds.add(id);
        }
        return hasEightTargetOrderIds;
    }

    private void dealForEight(Set<Object> targetBillIds, Map<BFRowId, BFRowLinkDownNode> tNodes, Map<Long, String> typeCache) {
        if (tNodes != null && tNodes.size() > 0) {
            for (Map.Entry<BFRowId, BFRowLinkDownNode> entry : tNodes.entrySet()) {
                BFRowId bfRowId = entry.getKey();
                String billType = OrderUnAuditOnAddVal.findType(bfRowId, typeCache);
                if (!BILLTYPES.contains(billType)) {
                    targetBillIds.add(bfRowId.getBillId());
                }
                this.dealForEight(targetBillIds, entry.getValue().getTNodes(), typeCache);
            }
        }
    }

    private static String findType(BFRowId rowId, Map<Long, String> typeCache) {
        long tableId = 0L;
        if (rowId != null) {
            tableId = rowId.getMainTableId();
        }
        String type = null;
        if (typeCache.get(tableId) != null) {
            type = typeCache.get(tableId);
        } else {
            TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId);
            type = tableDefine.getEntityNumber();
            typeCache.put(tableId, type);
        }
        return type;
    }

    private Set<Long> getHasTargetOrderIds(Set<String> orderIds) {
        HashSet<Long> hasTargetOrderIds = new HashSet<Long>(orderIds.size());
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".getHasTargetOrderIds";
        HashMap<Long, Long> idAndOrderid = new HashMap<Long, Long>();
        DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pom_mftstock", (String)"id,orderid", (QFilter[])new QFilter("orderid", "in", orderIds).toArray(), null);
        Object object = null;
        try {
            for (Row row : dataset) {
                idAndOrderid.put(row.getLong("id"), row.getLong("orderid"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataset != null) {
                if (object != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataset.close();
                }
            }
        }
        Map idAndLinkDownNode = BFTrackerServiceHelper.loadBillLinkDownNodes((String)"pom_mftstock", (Long[])idAndOrderid.keySet().toArray(new Long[0]), (boolean)false);
        for (Map.Entry entry : idAndLinkDownNode.entrySet()) {
            Long id = (Long)entry.getKey();
            Long orderid = (Long)idAndOrderid.get(id);
            if (this.hasTargetOrderIds(hasTargetOrderIds, orderid)) continue;
            BFRowLinkDownNode bf = (BFRowLinkDownNode)entry.getValue();
            HashSet<Object> targetBillIds = new HashSet<Object>();
            Map tNodes = bf.getTNodes();
            this.deal(targetBillIds, tNodes);
            if (targetBillIds.isEmpty()) continue;
            hasTargetOrderIds.add(orderid);
        }
        return hasTargetOrderIds;
    }

    private boolean hasTargetOrderIds(Set<Long> hasTargetOrderIds, Long orderid) {
        return hasTargetOrderIds.contains(orderid);
    }

    private void deal(Set<Object> targetBillIds, Map<BFRowId, BFRowLinkDownNode> tNodes) {
        if (tNodes != null && tNodes.size() > 0) {
            for (Map.Entry<BFRowId, BFRowLinkDownNode> entry : tNodes.entrySet()) {
                targetBillIds.add(entry.getKey().getBillId());
                this.deal(targetBillIds, entry.getValue().getTNodes());
            }
        }
    }

    private String checkPushBills(DynamicObject manufactureBill, Set<Long> hasEightTargetOrderIds, Map<Long, String> idAndErrorMsg) {
        String result = "";
        Long pkValueId = Long.parseLong(manufactureBill.getPkValue().toString());
        result = hasEightTargetOrderIds.contains(pkValueId) ? ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"OrderUnAuditOnAddVal_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]) : idAndErrorMsg.get(pkValueId);
        return result;
    }

    private boolean checkIsNormalBillPush(DynamicObject manufactureBill) {
        Map map;
        boolean result = false;
        if (null != manufactureBill && null != (map = BFTrackerServiceHelper.findTargetBills((String)this.getEntityKey(), (Long[])new Long[]{manufactureBill.getLong("id")}))) {
            map.keySet().removeIf(key -> StringUtils.equals((CharSequence)"pom_mftstock", (CharSequence)key) || StringUtils.equals((CharSequence)"sfc_manftech", (CharSequence)key) || StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)key) || StringUtils.equals((CharSequence)"om_mfttechnics", (CharSequence)key) || StringUtils.equals((CharSequence)"pom_mrostock", (CharSequence)key) || StringUtils.equals((CharSequence)"sfc_mromanuftech", (CharSequence)key) || StringUtils.equals((CharSequence)"pom_mrotool", (CharSequence)key) || StringUtils.equals((CharSequence)"pom_mroeleccontrol", (CharSequence)key));
            if (map.size() > 0) {
                result = true;
            }
        }
        return result;
    }

    private Map<Long, String> getIdAndErrorMsg(Set<String> orderIds) {
        HashMap<Long, String> idAndErrorMsg = new HashMap<Long, String>(orderIds.size());
        List orderids = orderIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList());
        HashSet<String> isNotAuditStockIds = new HashSet<String>();
        HashSet<String> isNotAuditTechnis = new HashSet<String>();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".getIdAndErrorMsg";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityKey(), (String)"id,transactiontype.isauditstock isauditstock,transactiontype.isaudittechnis isaudittechnis", (QFilter[])new QFilter("id", "in", orderids).toArray(), null);){
            for (Row row : dataSet) {
                String id = row.getString("id");
                if (!row.getBoolean("isauditstock").booleanValue()) {
                    isNotAuditStockIds.add(id);
                }
                if (row.getBoolean("isaudittechnis").booleanValue()) continue;
                isNotAuditTechnis.add(id);
            }
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billstatus", "!=", (Object)"A"));
        qFilters.add(new QFilter("orderid", "in", isNotAuditStockIds));
        String billId = "pom_mftstock";
        String billName = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"OrderUnAuditOnAddVal_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
        String stockBillName = ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355", (String)"OrderUnAuditOnAddVal_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)this.getEntityKey())) {
            billName = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"OrderUnAuditOnAddVal_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            stockBillName = ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355", (String)"OrderUnAuditOnAddVal_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            billId = "om_mftstock";
        } else if (StringUtils.equals((CharSequence)"prop_mftorder", (CharSequence)this.getEntityKey())) {
            billName = ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355", (String)"OrderUnAuditOnAddVal_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            stockBillName = ResManager.loadKDString((String)"\u6d41\u7a0b\u7528\u6599\u6e05\u5355", (String)"OrderUnAuditOnAddVal_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            billId = "prop_mftstock";
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)billId, (String)"orderid", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                idAndErrorMsg.put(row.getLong("orderid"), String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684%1$s\u5b58\u5728\u975e\u6682\u5b58\u72b6\u6001\uff0c%2$s\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"OrderUnAuditOnAddVal_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), stockBillName, billName));
            }
        }
        qFilters.clear();
        qFilters.add(new QFilter("billstatus", "!=", (Object)"A"));
        qFilters.add(new QFilter("manufactureorderid", "in", isNotAuditTechnis));
        billId = "sfc_manftech";
        billName = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"OrderUnAuditOnAddVal_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)this.getEntityKey())) {
            billName = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"OrderUnAuditOnAddVal_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            billId = "om_mfttechnics";
        } else if (StringUtils.equals((CharSequence)"prop_mftorder", (CharSequence)this.getEntityKey())) {
            billName = ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355", (String)"OrderUnAuditOnAddVal_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            billId = "prop_manftech";
        }
        dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)billId, (String)"manufactureorderid", (QFilter[])qFilters.toArray(new QFilter[0]), null);
        var12_15 = null;
        try {
            for (Row row : dataSet) {
                idAndErrorMsg.put(row.getLong("manufactureorderid"), String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\u5b58\u5728\u975e\u6682\u5b58\u72b6\u6001\uff0c%1$s\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"OrderUnAuditOnAddVal_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billName));
            }
        }
        catch (Throwable throwable) {
            var12_15 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var12_15 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var12_15.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return idAndErrorMsg;
    }

    private String checkIsParticularBillPush(DynamicObject manufactureBill) {
        String result = "";
        if (null != manufactureBill) {
            String billName;
            String billId;
            QFilter qFilter1;
            QFilter qFilter;
            ArrayList<QFilter> qFilterList;
            DynamicObject transactiontype = manufactureBill.getDynamicObject("transactiontype");
            boolean isauditstock = true;
            boolean isaudittechnis = true;
            if (null != transactiontype) {
                isauditstock = transactiontype.getBoolean("isauditstock");
                isaudittechnis = transactiontype.getBoolean("isaudittechnis");
            }
            if (!isauditstock) {
                qFilterList = new ArrayList<QFilter>();
                qFilter = new QFilter("billstatus", "!=", (Object)"A");
                qFilterList.add(qFilter);
                qFilter1 = new QFilter("orderid", "=", (Object)manufactureBill.getPkValue().toString());
                qFilterList.add(qFilter1);
                billId = "pom_mftstock";
                billName = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"OrderUnAuditOnAddVal_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                String stockBillName = ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355", (String)"OrderUnAuditOnAddVal_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                if (StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)this.getEntityKey())) {
                    billName = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"OrderUnAuditOnAddVal_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    stockBillName = ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355", (String)"OrderUnAuditOnAddVal_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    billId = "om_mftstock";
                } else if (StringUtils.equals((CharSequence)"prop_mftorder", (CharSequence)this.getEntityKey())) {
                    billName = ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355", (String)"OrderUnAuditOnAddVal_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    stockBillName = ResManager.loadKDString((String)"\u6d41\u7a0b\u7528\u6599\u6e05\u5355", (String)"OrderUnAuditOnAddVal_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    billId = "prop_mftstock";
                }
                boolean isExist = QueryServiceHelper.exists((String)billId, (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
                if (isExist) {
                    return String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684%1$s\u5b58\u5728\u975e\u6682\u5b58\u72b6\u6001\uff0c%2$s\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"OrderUnAuditOnAddVal_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), stockBillName, billName);
                }
            }
            if (!isaudittechnis) {
                qFilterList = new ArrayList();
                qFilter = new QFilter("billstatus", "!=", (Object)"A");
                qFilterList.add(qFilter);
                qFilter1 = new QFilter("manufactureorderid", "=", (Object)manufactureBill.getPkValue().toString());
                qFilterList.add(qFilter1);
                billId = "sfc_manftech";
                billName = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"OrderUnAuditOnAddVal_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                if (StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)this.getEntityKey())) {
                    billName = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"OrderUnAuditOnAddVal_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    billId = "om_mfttechnics";
                } else if (StringUtils.equals((CharSequence)"prop_mftorder", (CharSequence)this.getEntityKey())) {
                    billName = ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355", (String)"OrderUnAuditOnAddVal_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    billId = "prop_manftech";
                }
                boolean isExist = QueryServiceHelper.exists((String)billId, (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
                if (isExist) {
                    return String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\u5b58\u5728\u975e\u6682\u5b58\u72b6\u6001\uff0c%1$s\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"OrderUnAuditOnAddVal_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billName);
                }
            }
        }
        return result;
    }
}

