/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringJoiner;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class StockAuxproOnAddVal
extends AbstractValidator {
    private Map<Object, DynamicObject> masterMaterials = null;

    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject manufactureStock = rowDataEntity.getDataEntity();
            DynamicObjectCollection listdym = manufactureStock.getDynamicObjectCollection("stockentry");
            int rowcount = listdym.size();
            ArrayList<Integer> childauxpropertyList = new ArrayList<Integer>();
            for (int index = 0; index < rowcount; ++index) {
                DynamicObject material;
                DynamicObject stockdym = (DynamicObject)listdym.get(index);
                boolean isbomextend = stockdym.getBoolean("isbomextend");
                DynamicObject mateMft = stockdym.getDynamicObject("materialid");
                if (isbomextend || (material = this.loadMasterMaterial(mateMft)) == null) continue;
                boolean isuseauxpty = material.getBoolean("isuseauxpty");
                DynamicObject auxpro = stockdym.getDynamicObject("childauxpropertyid");
                if (!isuseauxpty || auxpro != null && !"0".equals(auxpro.getPkValue())) continue;
                childauxpropertyList.add(index + 1);
            }
            StringBuilder err = new StringBuilder();
            if (!childauxpropertyList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                childauxpropertyList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7269\u6599\u542f\u7528\u8f85\u52a9\u5c5e\u6027,\u8f85\u52a9\u5c5e\u6027\u5fc5\u586b\u3002", (String)"StockAuxproOnAddVal_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), stringJoiner));
            }
            if (err.length() <= 0) continue;
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)err.toString(), (String)"ManufacturestockEdit_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject loadMasterMaterial(DynamicObject mateMft) {
        if (mateMft == null) {
            return null;
        }
        if (this.masterMaterials == null) {
            Map masterObjs;
            HashSet<Object> masterIds = new HashSet<Object>();
            for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
                DynamicObject manufactureStock = rowDataEntity.getDataEntity();
                DynamicObjectCollection listdym = manufactureStock.getDynamicObjectCollection("stockentry");
                int rowcount = listdym.size();
                for (int index = 0; index < rowcount; ++index) {
                    DynamicObject stockdym = (DynamicObject)listdym.get(index);
                    DynamicObject materialObj = stockdym.getDynamicObject("materialid");
                    DynamicObject masterObj = materialObj.getDynamicObject("masterid");
                    masterIds.add(masterObj.getPkValue());
                }
            }
            this.masterMaterials = masterIds.isEmpty() ? new HashMap<Object, DynamicObject>(0) : ((masterObjs = MaterialQueryHelper.getDataBySelectProperties(masterIds, (String)"isuseauxpty")) == null || masterObjs.isEmpty() ? new HashMap<Object, DynamicObject>(0) : new HashMap<Object, DynamicObject>(masterObjs));
        }
        Object masterId = mateMft.getDynamicObject("masterid").getPkValue();
        return this.masterMaterials.get(masterId);
    }
}

