/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.validator;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class StockReformVal
extends AbstractValidator {
    private static final Set<String> mftstock = Sets.newHashSet((Object[])new String[]{"pom_mftstock", "om_mftstock"});
    private static final Set<String> xmftstock = Sets.newHashSet((Object[])new String[]{"pom_xmftstock", "om_xmftstock"});

    public void validate() {
        block23: {
            ExtendedDataEntity[] dataEntities;
            String entityKey;
            String operateKey;
            block22: {
                ExtendedDataEntity[] dataEntities2;
                operateKey = this.getOperateKey();
                entityKey = this.getEntityKey();
                if (!"submit".equals(operateKey) || !mftstock.contains(entityKey)) break block22;
                for (ExtendedDataEntity dataEntity : dataEntities2 = this.getDataEntities()) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObject transactionType = entity.getDynamicObject("transactiontypeid");
                    if (!transactionType.containsProperty("producttype")) {
                        return;
                    }
                    if (!"D".equals(transactionType.getString("producttype"))) continue;
                    DynamicObjectCollection stockEntryColl = entity.getDynamicObjectCollection("stockentry");
                    int reworkSize = 0;
                    for (DynamicObject entry : stockEntryColl) {
                        boolean isRework = entry.getBoolean("rework");
                        if (!isRework) continue;
                        ++reworkSize;
                    }
                    if (reworkSize != 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7c7b\u578b\u4e3a\u201c\u5e93\u5b58\u6539\u5236\u201d\u65f6\uff0c\u9700\u6ee1\u8db3\u81f3\u5c11\u4e00\u884c\u7ec4\u4ef6\u7684\u201c\u8fd4\u5de5\u201d\u6807\u8bc6\u4e3a\u201c\u662f\u201d\u3002", (String)"StockSubmitVal_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                }
                break block23;
            }
            if (!"audit".equals(operateKey) || !xmftstock.contains(entityKey)) break block23;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject entity = dataEntity.getDataEntity();
                DynamicObject transactionType = entity.getDynamicObject("transactiontypeid");
                if (!transactionType.containsProperty("producttype")) {
                    return;
                }
                if (!"D".equals(transactionType.getString("producttype"))) continue;
                DynamicObjectCollection stockEntryColl = entity.getDynamicObjectCollection("stockentry");
                HashMap<String, Boolean> xstockSourceMap = new HashMap<String, Boolean>(16);
                HashMap<String, Boolean> stockSourceMap = new HashMap<String, Boolean>(16);
                HashMap<String, Integer> stockNoMap = new HashMap<String, Integer>(16);
                for (DynamicObject entry : stockEntryColl) {
                    stockNoMap.put(entry.getString("stockno"), 0);
                    if ("B".equals(entry.getString("entrychangetype"))) {
                        xstockSourceMap.put(entry.getString("stockno") + "@@" + entry.getString("stockentryid"), entry.getBoolean("rework"));
                        continue;
                    }
                    xstockSourceMap.put(entry.getString("stockno") + "@@new" + entry.getPkValue(), entry.getBoolean("rework"));
                }
                QFilter filter = new QFilter("billno", "in", stockNoMap.keySet());
                String selectFields = "billno, stockentry.rework AS rework, stockentry.id AS entryid";
                String mftName = "om_xmftstock".equals(entityKey) ? "om_mftstock" : "pom_mftstock";
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryReworkFromStock", (String)mftName, (String)selectFields, (QFilter[])new QFilter[]{filter}, null);){
                    for (Row row : dataSet) {
                        stockSourceMap.put(row.getString("billno") + "@@" + row.getString("entryid"), row.getBoolean("rework"));
                    }
                }
                stockSourceMap.putAll(xstockSourceMap);
                for (Map.Entry entry : stockSourceMap.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    String[] split = ((String)entry.getKey()).split("@@");
                    stockNoMap.put(split[0], (Integer)stockNoMap.get(split[0]) + 1);
                }
                if (!stockNoMap.containsValue(0)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7c7b\u578b\u4e3a\u201c\u5e93\u5b58\u6539\u5236\u201d\u65f6\uff0c\u9700\u6ee1\u8db3\u81f3\u5c11\u4e00\u884c\u7ec4\u4ef6\u7684\u201c\u8fd4\u5de5\u201d\u6807\u8bc6\u4e3a\u201c\u662f\u201d\u3002", (String)"StockSubmitVal_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
    }

    public Set<String> preparePropertys() {
        Set prepares = super.preparePropertys();
        prepares.add("transactiontypeid");
        prepares.add("stockentry");
        return prepares;
    }
}

