/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manufacturemodel.validator;

import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class StockSubmitVMIVal
extends AbstractValidator {
    public void validate() {
        this.validateSupplierVMI();
    }

    private void validateSupplierVMI() {
        HashSet supplierIds = new HashSet(16);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject head = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entry = head.getDynamicObjectCollection("stockentry");
            supplierIds.addAll(entry.stream().filter(x -> x.getDynamicObject("supplierid") != null && "bd_supplier".equals(x.getString("supplymode"))).map(x -> x.getDynamicObject("supplierid").getLong("id")).collect(Collectors.toSet()));
        }
        Map supplierMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,enablevmi", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject head = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entry = head.getDynamicObjectCollection("stockentry");
            for (DynamicObject row : entry) {
                DynamicObject supplierid = row.getDynamicObject("supplierid");
                if (supplierid == null || supplierMap.get(supplierid.getPkValue()) == null || ((DynamicObject)supplierMap.get(supplierid.getPkValue())).getBoolean("enablevmi")) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u8d27\u4e3b\u201d\u4e0d\u6ee1\u8db3\u4f9b\u5e94\u5546\u7684\u53efVMI\u6761\u4ef6\uff0c\u8bf7\u5f00\u542f\u4f9b\u5e94\u5546\u53efVMI\u3002", (String)"StockSubmitVMIVal_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
            }
        }
    }
}

