/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manuftech;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bd.mpdm.common.mftorder.entity.OrderManuftechTypeInfo;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.opplugin.manutemplet.AtomServiceUtilsOp;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CreateManftechBill
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CreateManftechBill.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("asyncstatussfc");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String option = this.getOption().getVariableValue("operateKey");
        DynamicObject[] objs = e.getDataEntities();
        if (objs.length == 0) {
            return;
        }
        HashSet<Object> transactionTypeIds = new HashSet<Object>(16);
        if (option.equals("transmit") || option.equals("untransmit")) {
            for (int i = 0; i < objs.length; ++i) {
                DynamicObject obj = objs[i];
                if (obj.getDynamicObject("transactiontype") == null) continue;
                transactionTypeIds.add(obj.getDynamicObject("transactiontype").getPkValue());
            }
        }
        Map transactionTypeMap = TransactionTypeQueryHelper.getDataCacheBySet(transactionTypeIds);
        HashSet<String> orderEntryids = new HashSet();
        if (this.getOption().containsVariable("operateoption")) {
            String selectRowStr = this.getOption().getVariableValue("operateoption");
            logger.info("selectRowStr:" + selectRowStr);
            orderEntryids = AtomServiceUtilsOp.getBillSelectRowInfoSet(selectRowStr);
        }
        block9: for (int i = 0; i < objs.length; ++i) {
            DynamicObject obj = objs[i];
            DynamicObject transaction = obj.getDynamicObject("transactiontype");
            switch (option) {
                case "transmit": {
                    this.autoDoRelease(orderEntryids, obj, (DynamicObject)transactionTypeMap.get(transaction.getPkValue()), "autoDoRelease");
                    continue block9;
                }
                case "untransmit": {
                    this.autoDoRelease(orderEntryids, obj, (DynamicObject)transactionTypeMap.get(transaction.getPkValue()), "autoDoUnRelease");
                    continue block9;
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (objs.length == 0) {
            return;
        }
        String option = this.getOption().getVariableValue("operateKey");
        ErrorCode ec = null;
        switch (option) {
            case "save": 
            case "submit": 
            case "audit": {
                String billEntityType = this.billEntityType.getName();
                if (StringUtils.equals((CharSequence)"pom_mftorder", (CharSequence)billEntityType)) {
                    HashSet<String> mergeOrderNos = new HashSet<String>(16);
                    ArrayList<DynamicObject> passCheckObjs = new ArrayList<DynamicObject>(10);
                    for (DynamicObject manubill : objs) {
                        passCheckObjs.add(manubill);
                        DynamicObjectCollection orderEntrys = manubill.getDynamicObjectCollection("treeentryentity");
                        for (DynamicObject orderEntry : orderEntrys) {
                            if (orderEntry.get("sourcebillnumber") == null) continue;
                            mergeOrderNos.add(orderEntry.getString("sourcebillnumber"));
                        }
                    }
                    Set existsMergeOrderids = OrderMergeHelper.queryMergeOrder(mergeOrderNos);
                    block14: for (DynamicObject manubill : objs) {
                        DynamicObjectCollection orderEntrys = manubill.getDynamicObjectCollection("treeentryentity");
                        for (DynamicObject orderEntry : orderEntrys) {
                            if (orderEntry.get("sourcebillnumber") == null || !existsMergeOrderids.contains(orderEntry.getString("sourcebillnumber"))) continue;
                            passCheckObjs.remove(manubill);
                            continue block14;
                        }
                    }
                    objs = passCheckObjs.toArray(new DynamicObject[passCheckObjs.size()]);
                }
                ArrayList<DynamicObject> innerOrder = new ArrayList<DynamicObject>(10);
                ArrayList<DynamicObject> order = new ArrayList<DynamicObject>(10);
                Set<Long> isGenTechnisIds = this.getIsGenTechnisIds();
                for (int i = 0; i < objs.length; ++i) {
                    DynamicObject obj = objs[i];
                    if (obj.getDynamicObject("transactiontype") == null || !obj.getDynamicObject("transactiontype").getBoolean("isprocedure") || !isGenTechnisIds.contains(obj.getDynamicObject("transactiontype").getLong("id"))) continue;
                    Set collect = obj.getDynamicObjectCollection("treeentryentity").stream().filter(x -> x.containsProperty("oprentryid") && x.getLong("oprentryid") > 0L && x.getLong("srcorderentryid") > 0L).collect(Collectors.toSet());
                    if (CollectionUtils.isEmpty(collect)) {
                        order.add(obj);
                        continue;
                    }
                    innerOrder.add(obj);
                }
                if (CollectionUtils.isNotEmpty(order)) {
                    ec = this.createMftOrderTechnicsBill(order.toArray(new DynamicObject[order.size()]), "audit");
                }
                if (!CollectionUtils.isNotEmpty(innerOrder)) break;
                try {
                    DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"MftOrderTechnicsService", (String)"createInnerTechnicsBill", (Object[])new Object[]{innerOrder.toArray(new DynamicObject[innerOrder.size()]), "audit"});
                    break;
                }
                catch (Throwable throwable) {
                    logger.error("\u8c03\u7528\u5de5\u5e8f\u8ba1\u5212\u751f\u6210\u670d\u52a1\u51fa\u73b0\u5f02\u5e38" + throwable.getMessage(), throwable);
                    throw new KDBizException(throwable.getMessage());
                }
            }
            case "delete": {
                ec = this.deleteMftOrderTechnicsBill(objs, "delete");
                if (ec == null) break;
                throw new KDBizException(ec, new Object[0]);
            }
        }
    }

    private Set<Long> getIsGenTechnisIds() {
        HashSet<Long> isGenTechnisIds = new HashSet<Long>(16);
        String algoKey = "kd.bd.mpdm.opplugin.manuftech.CreateManftechBill.getIsGenTechnisIds";
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_transactproduct", (String)"id", (QFilter[])new QFilter("isgentechnis", "=", (Object)Character.valueOf('1')).toArray(), null);){
            for (Row row : dataset) {
                isGenTechnisIds.add(row.getLong("id"));
            }
        }
        return isGenTechnisIds;
    }

    private ErrorCode createMftOrderTechnicsBill(DynamicObject[] object, String option) {
        logger.info("\u5f00\u59cb\u8c03\u7528sfc\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u670d\u52a1 ");
        ErrorCode ec = null;
        try {
            ec = (ErrorCode)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"MftOrderTechnicsService", (String)"createMftOrderTechnicsBill", (Object[])new Object[]{object, option});
            logger.info("\u8c03\u7528sfc\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u670d\u52a1\u7ed3\u675f ");
        }
        catch (Throwable throwable) {
            logger.error("\u8c03\u7528\u5de5\u5e8f\u8ba1\u5212\u751f\u6210\u670d\u52a1\u51fa\u73b0\u5f02\u5e38" + throwable.getMessage(), throwable);
            throw new KDBizException(throwable.getMessage());
        }
        return ec;
    }

    private ErrorCode deleteMftOrderTechnicsBill(DynamicObject[] object, String option) {
        ErrorCode ec = null;
        try {
            logger.info("\u5f00\u59cb\u8c03\u7528sfc\u5224\u65ad\u662f\u5426\u5b58\u6ee1\u8db3\u5220\u9664\u6761\u4ef6\u670d\u52a1 ");
            ec = (ErrorCode)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"MftOrderTechnicsService", (String)"createMftOrderTechnicsBill", (Object[])new Object[]{object, "delete"});
            logger.info("\u8c03\u7528sfc\u5224\u65ad\u662f\u5426\u5b58\u6ee1\u8db3\u5220\u9664\u6761\u4ef6\u670d\u52a1\u7ed3\u675f ");
        }
        catch (Exception ex) {
            logger.error("\u8c03\u7528\u5de5\u5e8f\u8ba1\u5212\u5220\u9664\u670d\u52a1\u51fa\u73b0\u5f02\u5e38" + ex.getMessage(), (Throwable)ex);
        }
        return ec;
    }

    private void autoDoRelease(Set<String> orderEntryids, DynamicObject obj, DynamicObject transaction, String function) {
        String manuftechType = "sfc_manftech";
        if (obj != null && transaction != null && transaction.getBoolean("isreleasetechnis")) {
            DynamicObject[] count;
            manuftechType = new OrderManuftechTypeInfo(obj.getDataEntityType().getName()).getTarname();
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject order : obj.getDynamicObjectCollection("treeentryentity")) {
                String entryid = order.getPkValue().toString();
                if (!orderEntryids.contains(entryid)) continue;
                idList.add((Long)order.getPkValue());
            }
            QFilter qfilter = new QFilter("mftentryseq", "in", idList);
            QFilter qfilter1 = new QFilter("oprentryentity.oprinvalid", "=", (Object)Character.valueOf('0'));
            String selectProperties = "id,oprentryentity,mftentryseq,billno,billstatus,modifier,modifytime,oprentryentity.id,oprentryentity.oprinvalid,oprentryentity.oprparent,oprentryentity.oprno,oprentryentity.oprstatus,oprentryentity.oprmodifytime,oprentryentity.oprmodifier";
            for (DynamicObject manuftech : count = BusinessDataServiceHelper.load((String)manuftechType, (String)selectProperties, (QFilter[])new QFilter[]{qfilter, qfilter1})) {
                this.doRelease(manuftech, function);
            }
        }
    }

    private void doRelease(DynamicObject object, String function) {
        logger.info("\u5f00\u59cb\u8c03\u7528sfc\u81ea\u52a8\u4e0b\u8fbe\u5de5\u5e8f\u8ba1\u5212\u670d\u52a1 ");
        List returnList = (List)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"MftOrderTechnicsService", (String)function, (Object[])new Object[]{object});
        if (returnList != null && returnList.size() > 0) {
            StringBuilder errorInfo = new StringBuilder();
            for (int i = 0; i < returnList.size(); ++i) {
                errorInfo.append((String)returnList.get(i));
                if (i == returnList.size() - 1) continue;
                errorInfo.append("\n");
            }
            throw new KDBizException(new ErrorCode("CreateManftechBill_doRelease", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5bf9\u5de5\u5e8f\u8ba1\u5212\u8fdb\u884c\u64cd\u4f5c\u53d1\u751f\u9519\u8bef\uff1a%s", (String)"CreateManftechBill_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), errorInfo)), new Object[0]);
        }
        logger.info("\u8c03\u7528sfc\u81ea\u52a8\u4e0b\u8fbe\u5de5\u5e8f\u8ba1\u5212\u670d\u52a1\u7ed3\u675f ");
    }
}

