/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manuftech;

import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.manuftech.ManuftechUtil;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ManuftechSyncProcessrouteOp
extends AbstractOperationServicePlugIn {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ManuftechUtil.setEntityColumn((PreparePropertysEventArgs)e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ArrayList<DynamicObject> manuFactureTechnicsDyObjs = new ArrayList<DynamicObject>();
        List manuFactureTechnicsObjs = e.getSelectedRows();
        Date expendTime = this.getExpendTime();
        if (manuFactureTechnicsObjs != null && manuFactureTechnicsObjs.size() > 0) {
            HashMap entrymap = new HashMap(16);
            HashSet<Long> entryIds = new HashSet<Long>(16);
            HashSet<Object> processRouteIds = new HashSet<Object>(16);
            for (ExtendedDataEntity manuFactureTechnicsObj : manuFactureTechnicsObjs) {
                DynamicObject manuFactureTechnicsDyObj = manuFactureTechnicsObj.getDataEntity();
                if (null != manuFactureTechnicsDyObj.getDynamicObject("mftentryseq")) {
                    Long orderEntryId = (Long)manuFactureTechnicsDyObj.getDynamicObject("mftentryseq").getPkValue();
                    entryIds.add(orderEntryId);
                }
                if (null == manuFactureTechnicsDyObj.getDynamicObject("processroute")) continue;
                processRouteIds.add(manuFactureTechnicsDyObj.getDynamicObject("processroute").getPkValue());
            }
            Map processRoutes = BusinessDataServiceHelper.loadFromCache((Object[])processRouteIds.toArray(new Object[processRouteIds.size()]), (String)"pdm_route");
            String name = this.billEntityType.getName();
            String entity = "pom_mftorder";
            if ("om_mfttechnics".equals(name)) {
                entity = "om_mftorder";
            }
            ManuftechCreateBillUtil.getOrderEntityMap((String)entity, entryIds, entrymap);
            for (ExtendedDataEntity manuFactureTechnicsObj : manuFactureTechnicsObjs) {
                DynamicObject manuFactureTechnicsDyObj = manuFactureTechnicsObj.getDataEntity();
                DynamicObject processRouteObj = manuFactureTechnicsDyObj.getDynamicObject("processroute");
                if (null == processRouteObj || null == manuFactureTechnicsDyObj.getDynamicObject("mftentryseq")) continue;
                DynamicObject orderEntryObj = (DynamicObject)entrymap.get(manuFactureTechnicsDyObj.getDynamicObject("mftentryseq").getPkValue());
                this.syncProcessRoute(manuFactureTechnicsDyObj, orderEntryObj, (DynamicObject)processRoutes.get(processRouteObj.getPkValue()), expendTime);
                Boolean validateManuftech = this.validateManuftech(manuFactureTechnicsDyObj, manuFactureTechnicsObj);
                if (!validateManuftech.booleanValue()) continue;
                manuFactureTechnicsDyObjs.add(manuFactureTechnicsDyObj);
            }
        }
        if (manuFactureTechnicsDyObjs.size() > 0) {
            DynamicObject[] dynamicObjects = manuFactureTechnicsDyObjs.toArray(new DynamicObject[manuFactureTechnicsDyObjs.size()]);
            if ("sfc_manftech".equals(this.billEntityType.getName())) {
                ManuftechUtil.setAccountingOrg((DynamicObject[])dynamicObjects);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    private Date getExpendTime() {
        try {
            String expendTimeStr = this.operateOption.getVariableValue("expandtime");
            return sdf.parse(expendTimeStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Boolean validateManuftech(DynamicObject manuFactureTechnicsDyObj, ExtendedDataEntity manuFactureTechnicsObj) {
        DynamicObjectCollection proentryentitys = manuFactureTechnicsDyObj.getDynamicObjectCollection("proentryentity");
        ArrayList<String> proList = new ArrayList<String>();
        for (int i = 0; i < proentryentitys.size(); ++i) {
            DynamicObject proentryentity = (DynamicObject)proentryentitys.get(i);
            String processseq = proentryentity.getString("processseq");
            if (proList.contains(processseq)) {
                this.addErrMessage(manuFactureTechnicsObj, ResManager.loadKDString((String)"\u540c\u6b65\u540e\u5b58\u5728\u76f8\u540c\u5e8f\u5217\u53f7\u7684\u6570\u636e\uff0c\u540c\u6b65\u5931\u8d25\u3002", (String)"ManuftechSyncProcessrouteOp_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                return false;
            }
            proList.add(processseq);
        }
        DynamicObjectCollection oprentryentitys = manuFactureTechnicsDyObj.getDynamicObjectCollection("oprentryentity");
        for (int i = 0; i < proentryentitys.size(); ++i) {
            ArrayList<String> list = new ArrayList<String>();
            DynamicObject proentryentity = (DynamicObject)proentryentitys.get(i);
            for (DynamicObject oprentry : oprentryentitys) {
                String oprparent = oprentry.getString("oprparent");
                String oprno = oprentry.getString("oprno");
                if (oprparent == null || !oprparent.equals(proentryentity.getString("processseq"))) continue;
                if (!list.contains(oprno)) {
                    list.add(oprno);
                    continue;
                }
                this.addErrMessage(manuFactureTechnicsObj, ResManager.loadKDString((String)"\u540c\u6b65\u540e\u5b58\u5728\u540c\u4e00\u5e8f\u5217\u76f8\u540c\u5de5\u5e8f\u53f7\u7684\u6570\u636e\uff0c\u540c\u6b65\u5931\u8d25\u3002", (String)"ManuftechSyncProcessrouteOp_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void syncProcessRoute(DynamicObject manuFactureTechnicsDyObj, DynamicObject orderEntryObj, DynamicObject processRouteObj, Date expendTime) {
        DynamicObjectCollection entryCol = processRouteObj.getDynamicObjectCollection("entryentity");
        this.updateOrDelProentryentity(manuFactureTechnicsDyObj, orderEntryObj, entryCol);
        this.updateOrAddProentryentity(manuFactureTechnicsDyObj, orderEntryObj, entryCol);
        entryCol = processRouteObj.getDynamicObjectCollection("processentry");
        HashMap<Long, Long> oprEntryId_srcId = new HashMap<Long, Long>(8);
        this.excludeOutDateRoute(expendTime, entryCol, oprEntryId_srcId);
        ArrayList<Long> notDel = new ArrayList<Long>();
        this.updateOrDelOprentryentity(manuFactureTechnicsDyObj, orderEntryObj, entryCol, notDel, oprEntryId_srcId);
        this.updateOrAddOprentryentity(manuFactureTechnicsDyObj, orderEntryObj, entryCol, notDel);
        ManuftechCreateBillUtil.setPorValue((DynamicObject)manuFactureTechnicsDyObj, (String)"processseq");
    }

    private void excludeOutDateRoute(Date expendTime, DynamicObjectCollection processentry, Map<Long, Long> oprEntryId_srcId) {
        if (expendTime != null) {
            ArrayList invalidRoute = new ArrayList();
            processentry.forEach(obj -> {
                oprEntryId_srcId.put(obj.getLong("id"), obj.getLong("srcopentryid"));
                Date validaDate = obj.getDate("entryvaliddate");
                Date invalidaDate = obj.getDate("entryinvaliddate");
                if (!(validaDate == null || invalidaDate == null || validaDate.before(expendTime) && invalidaDate.after(expendTime))) {
                    invalidRoute.add(obj);
                }
            });
            for (DynamicObject del : invalidRoute) {
                processentry.remove((Object)del);
            }
        }
    }

    private Boolean isDelProentryentity(DynamicObject manuFactureTechnicsDyObj, DynamicObject proentryentity) {
        Boolean flag = Boolean.TRUE;
        String processseq = (String)proentryentity.get("processseq");
        HashSet statusSet = Sets.newHashSet((Object[])new String[]{"D", "E", "F", "G"});
        DynamicObjectCollection oprs = manuFactureTechnicsDyObj.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : oprs) {
            if (!processseq.equals(opr.getString("oprparent"))) continue;
            String oprstatus = opr.getString("oprstatus");
            Boolean oprinvalid = opr.getBoolean("oprinvalid");
            if (!oprinvalid.booleanValue() && !statusSet.contains(oprstatus)) continue;
            flag = Boolean.FALSE;
            break;
        }
        return flag;
    }

    private void updateOrDelProentryentity(DynamicObject manuFactureTechnicsDyObj, DynamicObject orderEntryObj, DynamicObjectCollection entryCol) {
        DynamicObjectCollection proentryentitys = manuFactureTechnicsDyObj.getDynamicObjectCollection("proentryentity");
        ArrayList<DynamicObject> delRows = new ArrayList<DynamicObject>();
        for (int i = 0; i < proentryentitys.getRowCount(); ++i) {
            Boolean isDel = Boolean.TRUE;
            DynamicObject proentryentity = (DynamicObject)proentryentitys.get(i);
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject obj = (DynamicObject)entryCol.get(j);
                if (!obj.getPkValue().toString().equals(proentryentity.get("sourceseqid"))) continue;
                ManuftechCreateBillUtil.setProEntryEntityValue((DynamicObject)obj, (DynamicObject)orderEntryObj, (DynamicObject)proentryentity);
                isDel = Boolean.FALSE;
            }
            if (!isDel.booleanValue() || !this.isDelProentryentity(manuFactureTechnicsDyObj, proentryentity).booleanValue()) continue;
            delRows.add(proentryentity);
        }
        if (!delRows.isEmpty()) {
            proentryentitys.removeAll(delRows);
        }
    }

    private void updateOrAddProentryentity(DynamicObject manuFactureTechnicsDyObj, DynamicObject orderEntryObj, DynamicObjectCollection entryCol) {
        DynamicObjectCollection proentryentitys = manuFactureTechnicsDyObj.getDynamicObjectCollection("proentryentity");
        for (int j = 0; j < entryCol.size(); ++j) {
            DynamicObject obj = (DynamicObject)entryCol.get(j);
            Boolean isAdd = Boolean.TRUE;
            for (int i = 0; i < proentryentitys.getRowCount(); ++i) {
                DynamicObject proentryentity = (DynamicObject)proentryentitys.get(i);
                if (!obj.getPkValue().toString().equals(proentryentity.get("sourceseqid"))) continue;
                isAdd = Boolean.FALSE;
            }
            if (!isAdd.booleanValue()) continue;
            DynamicObject newEntryObj = proentryentitys.addNew();
            ManuftechCreateBillUtil.setProEntryEntityValue((DynamicObject)obj, (DynamicObject)orderEntryObj, (DynamicObject)newEntryObj);
            newEntryObj.set("seq", (Object)proentryentitys.getRowCount());
        }
    }

    private void updateOrDelOprentryentity(DynamicObject manuFactureTechnicsDyObj, DynamicObject orderEntryObj, DynamicObjectCollection entryCol, List<Long> cannotDelOprRouteEntryId, Map<Long, Long> oprEntryId_srcId) {
        DynamicObjectCollection oprentryentitys = manuFactureTechnicsDyObj.getDynamicObjectCollection("oprentryentity");
        ArrayList<DynamicObject> delRows = new ArrayList<DynamicObject>();
        HashSet statusSet = Sets.newHashSet((Object[])new String[]{"A", "B", "C"});
        for (int i = 0; i < oprentryentitys.getRowCount(); ++i) {
            Boolean isDel = Boolean.TRUE;
            DynamicObject oprentryentity = (DynamicObject)oprentryentitys.get(i);
            String oprstatus = oprentryentity.getString("oprstatus");
            boolean oprinvalid = oprentryentity.getBoolean("oprinvalid");
            if (!oprinvalid && statusSet.contains(oprstatus)) {
                for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject obj = (DynamicObject)entryCol.get(j);
                    if (!obj.getPkValue().toString().equals(oprentryentity.get("oprsourceentryid"))) continue;
                    this.createOprentryentityRow(manuFactureTechnicsDyObj, oprentryentity, orderEntryObj, obj, 0);
                    isDel = Boolean.FALSE;
                }
            } else {
                cannotDelOprRouteEntryId.add(oprEntryId_srcId.get(oprentryentity.getLong("oprsourceentryid")));
                isDel = Boolean.FALSE;
            }
            if (!isDel.booleanValue()) continue;
            delRows.add(oprentryentity);
        }
        if (!delRows.isEmpty()) {
            oprentryentitys.removeAll(delRows);
        }
    }

    private void updateOrAddOprentryentity(DynamicObject manuFactureTechnicsDyObj, DynamicObject orderEntryObj, DynamicObjectCollection entryCol, List<Long> cannotDelOprRouteEntryId) {
        DynamicObjectCollection oprentryentitys = manuFactureTechnicsDyObj.getDynamicObjectCollection("oprentryentity");
        for (int j = 0; j < entryCol.size(); ++j) {
            DynamicObject obj = (DynamicObject)entryCol.get(j);
            Boolean isAdd = Boolean.TRUE;
            for (int i = 0; i < oprentryentitys.getRowCount(); ++i) {
                DynamicObject oprentryentity = (DynamicObject)oprentryentitys.get(i);
                if (!obj.getPkValue().toString().equals(oprentryentity.get("oprsourceentryid"))) continue;
                isAdd = Boolean.FALSE;
            }
            if (cannotDelOprRouteEntryId.contains(obj.getLong("srcopentryid"))) {
                isAdd = Boolean.FALSE;
            }
            if (!isAdd.booleanValue()) continue;
            DynamicObject newEntryObj = oprentryentitys.addNew();
            this.createOprentryentityRow(manuFactureTechnicsDyObj, newEntryObj, orderEntryObj, obj, oprentryentitys.getRowCount());
        }
    }

    private void createOprentryentityRow(DynamicObject orderTechnicsObj, DynamicObject oprentryentity, DynamicObject orderEntryObj, DynamicObject obj, int seq) {
        oprentryentity.set("oprproductionqty", (Object)orderTechnicsObj.getBigDecimal("qty"));
        ManuftechCreateBillUtil.setOprEntryEntityValue((DynamicObject)obj, (DynamicObject)orderEntryObj, (DynamicObject)oprentryentity);
        if (seq != 0) {
            oprentryentity.set("seq", (Object)seq);
        }
        oprentryentity.getDynamicObjectCollection("actsubentryentity").removeAll((Collection)oprentryentity.getDynamicObjectCollection("actsubentryentity"));
        oprentryentity.getDynamicObjectCollection("ressubentryentity").removeAll((Collection)oprentryentity.getDynamicObjectCollection("ressubentryentity"));
        ManuftechCreateBillUtil.setActSubEntryEntityValue((DynamicObject)obj, (DynamicObject)orderEntryObj, (DynamicObject)oprentryentity);
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        String billNo = dataEntity.getBillNo();
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            errMsg = billNo + ":" + errMsg;
        }
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "ManuftechSyncProcessrouteOp", "", errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

