/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manuftech.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class ChargeAgainstValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ChargeAgainstValidator.class);
    private boolean existOtherBill = false;

    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            String entryid = this.getOption().getVariableValue("entryid");
            String error = null;
            error = this.checkBill(obj, entryid);
            if (error == null) continue;
            this.addErrorMessage(extendedDataEntity, error);
        }
        this.checkDownPickBill();
    }

    private String checkBill(DynamicObject dataEntity, String entryid) {
        String error = null;
        String billStatusKey = ((BillEntityType)dataEntity.getDataEntityType()).getBillStatus();
        String billStatus = dataEntity.getString(billStatusKey);
        if ("A".equals(billStatus) || "B".equals(billStatus)) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\uff0c\u624d\u80fd\u8fdb\u884c\u51b2\u9500\u3002", (String)"ChargeAgainstValidator_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
        }
        boolean caBill = dataEntity.getBoolean("ischargeoff");
        if (caBill) {
            return ResManager.loadKDString((String)"\u51b2\u9500\u5355\u636e\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValidator_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
        }
        DynamicObjectCollection objCols = dataEntity.getDynamicObjectCollection("sumentry");
        for (int i = 0; i < objCols.size(); ++i) {
            DynamicObject sumentry = (DynamicObject)objCols.get(i);
            if (!sumentry.getPkValue().toString().equals(entryid)) continue;
            boolean caBilled = sumentry.getBoolean("ischargeoffed");
            if (caBilled) {
                return ResManager.loadKDString((String)"\u5df2\u88ab\u51b2\u9500\u5206\u5f55\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValidator_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            }
            DynamicObject entry = sumentry.getDynamicObject("manufactureentryid");
            if ("B".equals(entry.getString("bizstatus")) || "C".equals(entry.getString("bizstatus"))) {
                return ResManager.loadKDString((String)"\u5de5\u5355\u6302\u8d77\u6216\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValidator_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            }
            error = this.checkDownBill(dataEntity);
            if (!"sfc_processreportbill".equals(dataEntity.getDataEntityType().getName())) break;
            String manftechentry = sumentry.getString("oprentryid");
            QFilter proFilter = new QFilter("sumentry.manftechentry", "=", (Object)manftechentry);
            if (QueryServiceHelper.exists((String)"sfc_reportresource_adjust", (QFilter[])new QFilter[]{proFilter})) {
                return ResManager.loadKDString((String)"\u5bf9\u5e94\u5de5\u5e8f\u8ba1\u5212\u5df2\u7ecf\u5b58\u5728\u6c47\u62a5\u8d44\u6e90\u8c03\u6574\u5355\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            }
            if (!this.existOtherBill) break;
            return String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5de5\u5e8f\u6c47\u62a5\u5355\u7b2c%2$s\u884c\u5206\u5f55\u5b58\u5728\u4e0b\u6e38\u68c0\u9a8c\u5355\u636e\uff0c\u4e0d\u652f\u6301\u51b2\u9500\u3002", (String)"ChargeAgainstValidator_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), dataEntity.getString("billno"), i + 1);
        }
        return error;
    }

    private String checkDownBill(DynamicObject dataEntity) {
        String billNumber = dataEntity.getDataEntityType().getName();
        Long pkValue = (Long)dataEntity.getPkValue();
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)billNumber, (Long[])new Long[]{pkValue});
        logger.info("dirtTargetBills: " + dirtTargetBills.toString());
        if (CollectionUtils.isEmpty((Map)dirtTargetBills)) {
            return null;
        }
        String error = null;
        List bfRows = (List)dirtTargetBills.get(pkValue);
        if (bfRows != null) {
            Iterator iterator = bfRows.iterator();
            while (iterator.hasNext()) {
                BFRow row = (BFRow)iterator.next();
                BFRowId bfRowId = row.getId();
                Long tableId = bfRowId.getMainTableId();
                ConvertDataService reader = new ConvertDataService();
                Long billId = bfRowId.getBillId();
                String entityNumber = reader.loadTableDefine(tableId).getEntityNumber();
                String appId = EntityMetadataCache.getDataEntityType((String)entityNumber).getAppId();
                logger.info("entityNumber: " + entityNumber);
                if ("im".equals(appId)) {
                    DynamicObject caData = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityNumber, (String)"ischargeoffed,ischargeoff");
                    boolean isCaEd = caData.getBoolean("ischargeoffed");
                    boolean isCa = caData.getBoolean("ischargeoff");
                    if (!isCaEd && !isCa) {
                        error = ResManager.loadKDString((String)"\u4e0b\u6e38\u5b8c\u5de5\u5165\u5e93\u5355\u5168\u90e8\u88ab\u51b2\u9500\u624d\u80fd\u51b2\u9500\u3002", (String)"ChargeAgainstValidator_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                        continue;
                    }
                    iterator.remove();
                    continue;
                }
                logger.info("appId = " + appId);
                this.existOtherBill = true;
            }
        }
        return error;
    }

    private void checkDownPickBill() {
        HashSet<Long> pkValueSet = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("sumentry");
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(i);
                Long epkValue = (Long)entryObj.getPkValue();
                logger.info("chargeagainst:" + epkValue);
                pkValueSet.add(epkValue);
            }
        }
        HashMap<Long, Long> mapSrcId = new HashMap<Long, Long>(16);
        if (!pkValueSet.isEmpty() && pkValueSet.size() > 0) {
            ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
            QFilter qfilter = new QFilter("billentry.srcbillentryid", "in", pkValueSet);
            QFilter qfilter2 = new QFilter("ischargeoffed", "=", (Object)Boolean.FALSE);
            qfilterList.add(qfilter);
            qfilterList.add(qfilter2);
            String outBillEntity = "im_mdc_mftproorder";
            if ("om_processreport".equals(this.getEntityKey())) {
                outBillEntity = "im_mdc_omoutbill";
            }
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryProorder", (String)outBillEntity, (String)"billentry.srcbillentryid", (QFilter[])qfilterList.toArray(new QFilter[qfilterList.size()]), (String)"");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    mapSrcId.put(row.getLong("billentry.srcbillentryid"), row.getLong("billentry.srcbillentryid"));
                }
            }
        }
        logger.info("chargeagainst:" + mapSrcId);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("sumentry");
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(i);
                Long pkid = (Long)entryObj.getPkValue();
                logger.info("chargeagainst:" + pkid);
                if (!mapSrcId.containsKey(pkid)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u51b2\u9500\u5931\u8d25\uff0c\u7b2c%s\u884c\u5206\u5f55\u5012\u51b2\u9886\u6599\u5355\u672a\u5168\u90e8\u51b2\u9500\u3002", (String)"ChargeAgainstValidator_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
            }
        }
    }
}

