/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manuftech.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ManuftechSyncValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> orderEntryIds = new HashSet<Long>(10);
        String entityType = "pom_mftorder";
        HashSet<Long> orderEntryIdsBySplit = new HashSet<Long>(10);
        HashSet<Long> orderEntryIdsNoExBom = new HashSet<Long>(10);
        HashSet<Long> orderEntryIdsSourcePlan = new HashSet<Long>(10);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if ("om_mfttechnics".equals(dataEntity.getDataEntityType().getName())) {
                entityType = "om_mftorder";
            } else if ("prop_manftech".equals(dataEntity.getDataEntityType().getName())) {
                entityType = "prop_mftorder";
            }
            DynamicObject orderentryf7 = dataEntity.getDynamicObject("mftentryseq");
            if (null == orderentryf7) continue;
            orderEntryIds.add(orderentryf7.getLong("id"));
        }
        if (orderEntryIds.size() > 0) {
            QFilter qf = new QFilter("treeentryentity.id", "in", orderEntryIds);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ManuftechSyncValidator", (String)entityType, (String)"treeentryentity.id,treeentryentity.noextendbom,treeentryentity.sourcebilltype,treeentryentity.srcsplitbillnumber", (QFilter[])qf.toArray(), null);){
                for (Row row : dataSet) {
                    String sourceBillType;
                    Boolean noextendbom;
                    String srcsplitbillnumber = row.getString("treeentryentity.srcsplitbillnumber");
                    Long orderEntryid = row.getLong("treeentryentity.id");
                    if (StringUtils.isNotEmpty((CharSequence)srcsplitbillnumber)) {
                        orderEntryIdsBySplit.add(orderEntryid);
                    }
                    if ((noextendbom = row.getBoolean("treeentryentity.noextendbom")).booleanValue()) {
                        orderEntryIdsNoExBom.add(orderEntryid);
                    }
                    if (!StringUtils.equals((CharSequence)"mps_scheduleplan", (CharSequence)(sourceBillType = row.getString("treeentryentity.sourcebilltype")))) continue;
                    orderEntryIdsSourcePlan.add(orderEntryid);
                }
            }
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            QFilter qFilter;
            boolean exists;
            DynamicObject orderentryf7;
            long orderEntryid;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            if (!"A".equals(obj.get("billstatus"))) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u6682\u5b58\u3002", (String)"ManuftechSyncValidator_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection oprentryentitys = obj.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentitys) {
                if (oprentry.getBigDecimal("oprtotalsplitqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u5de5\u5e8f\u62c6\u5206\u7684\u5de5\u5e8f\u8ba1\u5212\u4e0d\u5141\u8bb8\u540c\u6b65\u5de5\u827a\u8def\u7ebf\u3002", (String)"ManuftechSyncValidator_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                break;
            }
            if (orderEntryIdsNoExBom.contains(orderEntryid = (orderentryf7 = obj.getDynamicObject("mftentryseq")).getLong("id"))) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u884c\u7684\u201c\u4e0d\u5c55\u5f00BOM\u201d\u4e3a\u662f\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u5de5\u827a\u8def\u7ebf\u3002", (String)"ManuftechSyncValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            } else if (null != orderentryf7 && orderEntryIdsBySplit.contains(orderentryf7.getLong("id")) && !orderEntryIdsSourcePlan.contains(orderEntryid)) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u62c6\u5206\u4ea7\u751f\u7684\u5de5\u5e8f\u8ba1\u5212\u4e0d\u5141\u8bb8\u540c\u6b65\u5de5\u827a\u8def\u7ebf\u3002", (String)"ManuftechSyncValidator_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            long orderid = obj.get("manufactureorderid") == null || StringUtils.equals((CharSequence)"", (CharSequence)obj.getString("manufactureorderid").trim()) ? 0L : Long.parseLong(obj.getString("manufactureorderid"));
            if (0L == orderid || !(exists = QueryServiceHelper.exists((String)"pom_ordermerge", (QFilter[])(qFilter = new QFilter("mergeorderid", "=", (Object)orderid)).toArray()))) continue;
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5408\u5e76\u5de5\u5355\u4ea7\u751f\u7684\u5de5\u5e8f\u8ba1\u5212\u4e0d\u5141\u8bb8\u540c\u6b65\u5de5\u827a\u8def\u7ebf\u3002", (String)"ManuftechSyncValidator_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
    }
}

