/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manutemplet;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.opplugin.manutemplet.AtomServiceUtilsOp;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.EventServiceHelper;

public class AtomMftOrderOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AtomMftOrderOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = this.getOption().getVariableValue("status");
        DynamicObject[] dataEntities2 = e.getDataEntities();
        logger.info("\u5f00\u59cb\u4fee\u6539\u5de5\u5355\u72b6\u6001\uff1a" + key);
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject mftorder : dataEntities2) {
            ids.add(mftorder.getLong("id"));
        }
        String entityNum = this.billEntityType.getName();
        long start = System.currentTimeMillis();
        Map orderMap = OrderOpUtils.getMftOrderDataMap(ids, (String)entityNum);
        long end = System.currentTimeMillis();
        logger.info("save query data:" + (end - start));
        start = System.currentTimeMillis();
        AtomServiceUtilsOp.saveData(orderMap, dataEntities2, key, this.getOption(), entityNum);
        end = System.currentTimeMillis();
        logger.info("save  data:" + (end - start));
        logger.info("\u4fee\u6539\u5de5\u5355\u72b6\u6001\u5b8c\u6210\uff1a" + key);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        AtomServiceUtilsOp.setEntityColumn(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("transmit".equals(operationKey)) {
            String entityNum = this.billEntityType.getName();
            AtomServiceUtilsOp.transBeginWork(e.getDataEntities(), this.getOption(), entityNum);
        }
        if (!"shut".equals(operationKey) && !"calmaterial".equals(operationKey)) {
            return;
        }
        String forceclose = "";
        if (this.getOption().containsVariable("forceclose")) {
            forceclose = this.getOption().getVariableValue("forceclose");
        }
        HashSet<String> orderids = new HashSet<String>(16);
        String selectRowStr = this.getOption().getVariableValue("operateOption");
        logger.info("selectRowStr:" + selectRowStr);
        Set<String> orderEntryids = AtomServiceUtilsOp.getBillSelectRowInfoSet(selectRowStr);
        logger.info("\u5de5\u5355\u5173\u95ed\uff0cID\u96c6\u5408" + orderEntryids);
        HashSet<String> successEntryids = new HashSet<String>(orderEntryids.size());
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            orderids.add(dynamicObject.getPkValue().toString());
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entryrow : entry) {
                String entryid = entryrow.getPkValue().toString();
                if (!orderEntryids.contains(entryid) || forceclose.indexOf(entryid) >= 0) continue;
                successEntryids.add(entryid);
            }
        }
        logger.info("\u5de5\u5355\u5173\u95ed\u540e\u8c03\u7528\u6807\u51c6\u6210\u672c\u8ba1\u7b97\u670d\u52a1begin\uff0csuccessEntryids\u96c6\u5408" + successEntryids);
        if (this.getOption().containsVariable("autoclose")) {
            String[] split;
            successEntryids = new HashSet(16);
            String autoclose = this.getOption().getVariableValue("autoclose");
            for (String entryid : split = autoclose.split("@@@")) {
                if (!StringUtils.isNotEmpty((CharSequence)entryid)) continue;
                successEntryids.add(entryid);
            }
            logger.info("\u5de5\u5355\u5173\u95ed\u5b58\u5728\u591a\u884c\u4e3b\u4ea7\u54c1\u5173\u95ed\uff0csuccessEntryids\u96c6\u5408" + successEntryids);
        }
        this.showError("valclose");
        this.showError("tplvalclose");
        if (!successEntryids.isEmpty()) {
            HashMap<String, Object> calparam = new HashMap<String, Object>(16);
            calparam.put("orderentryids", successEntryids);
            calparam.put("orderids", orderids);
            calparam.put("operate", operationKey);
            if ("shut".equals(operationKey)) {
                calparam.put("iscloseorder", "1");
            } else if ("calmaterial".equals(operationKey)) {
                calparam.put("iscloseorder", "0");
            }
            calparam.put("isautocal", "1");
            calparam.put("isautoflag", "1");
            String pageId = this.getOption().getVariableValue("operatePageId", "0");
            calparam.put("pageId", pageId);
            calparam.put("appId", "mpdm");
            calparam.put("modetype", "1");
            if (!"pom_mftorder".equals(this.billEntityType.getName())) {
                calparam.put("modetype", "2");
            }
            if ("pom_mroorder".equals(this.billEntityType.getName())) {
                calparam.put("modetype", "7");
            }
            if ("prop_mftorder".equals(this.billEntityType.getName())) {
                calparam.put("modetype", "9");
            }
            String jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
        }
    }

    private void showError(String closeflag) {
        String valclose;
        if (this.getOption().containsVariable(closeflag) && StringUtils.isNotEmpty((CharSequence)(valclose = this.getOption().getVariableValue(closeflag)))) {
            JSONArray parseArray = JSONArray.parseArray((String)valclose);
            for (int i = 0; i < parseArray.size(); ++i) {
                JSONObject obj = (JSONObject)parseArray.get(i);
                OperateErrorInfo errorInfo = new OperateErrorInfo("AtomMftOrderOp", ErrorLevel.Error, obj.get((Object)"id"));
                String billno = obj.get((Object)"billno").toString();
                errorInfo.setMessage(billno + "\uff1a" + obj.get((Object)"msg").toString());
                errorInfo.setTitle(ResManager.loadKDString((String)"\u5de5\u5355\u5173\u95ed", (String)"AtomMftOrderOp_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                this.operationResult.addErrorInfo(errorInfo);
            }
        }
    }
}

