/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.manutemplet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.opplugin.manutemplet.AtomServiceUtilsOp;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AtomStatusOp
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(AtomStatusOp.class);

    public void validate() {
        String key = this.getOption().getVariableValue("status");
        boolean containsVariable = this.getOption().containsVariable("operateOption");
        if (!containsVariable) {
            logger.info((Object)"[operateOption] not include");
            this.autoSelectAllRows();
        } else {
            String operateOption = this.getOption().getVariableValue("operateOption");
            if (operateOption.isEmpty()) {
                logger.info((Object)"[operateOption] is empty");
                this.autoSelectAllRows();
            } else {
                logger.info((Object)("[operateOption]\uff1a" + operateOption));
            }
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        String entitynum = "pom_mftorder";
        for (ExtendedDataEntity dataet : this.getDataEntities()) {
            DynamicObject row = dataet.getDataEntity();
            entitynum = row.getDataEntityType().getName();
            ids.add(row.getLong("id"));
        }
        long start = System.currentTimeMillis();
        Map orderMap = OrderOpUtils.getMftOrderDataMap(ids, (String)entitynum);
        long end = System.currentTimeMillis();
        logger.info((Object)("validate query orderMap:" + (end - start)));
        start = System.currentTimeMillis();
        Set<Long> orderEntryIdsWithUnAuditXBill = null;
        if ("beginwork".equals(key)) {
            orderEntryIdsWithUnAuditXBill = this.queryOrderEntryIdsWithUnAuditXBill();
        }
        if ("untransmit".equals(key)) {
            HashSet<Object> allEntryIds = new HashSet<Object>(16);
            for (DynamicObject manubill : orderMap.values()) {
                DynamicObjectCollection entryCol = manubill.getDynamicObjectCollection("treeentryentity");
                allEntryIds.addAll(entryCol.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
            }
            AtomServiceUtilsOp.searchDownOrderIds(this.getOption(), allEntryIds);
        }
        Set<Long> mftOrderEntryIds = this.getAllOrderEntryIds();
        HashMap<Long, String> unAuditStockBillInfos = new HashMap(16);
        if ("transmit".equals(key)) {
            unAuditStockBillInfos = this.queryUnAuditStockBillInfos(mftOrderEntryIds);
        }
        JSONArray jarray = new JSONArray();
        String selectRowStr = this.getOption().getVariableValue("operateOption");
        Map<String, List<String>> selectRowMap = AtomServiceUtilsOp.getBillSelectRowInfoMap(selectRowStr);
        for (int i = 0; i < this.getDataEntities().length; ++i) {
            this.getOption().setVariableValue("opkeyname", this.getOperationName());
            String message = AtomServiceUtilsOp.AtomUtilsOp(orderMap, this.getDataEntities()[i], key, this.getOption(), i, orderEntryIdsWithUnAuditXBill, selectRowMap);
            if (message.length() > 0) {
                if ("shut".equals(key)) {
                    ExtendedDataEntity extendedDataEntity = this.getDataEntities()[i];
                    String billNo = extendedDataEntity.getBillNo();
                    JSONObject json = new JSONObject();
                    json.put("id", extendedDataEntity.getBillPkId());
                    json.put("msg", (Object)message);
                    json.put("billno", (Object)billNo);
                    jarray.add((Object)json);
                    continue;
                }
                this.addErrorMessage(this.getDataEntities()[i], message);
                continue;
            }
            if (!"transmit".equals(key) || CollectionUtils.isEmpty(unAuditStockBillInfos)) continue;
            ExtendedDataEntity dataEntity = this.getDataEntities()[i];
            this.checkIsExistUnAuditStock(dataEntity, orderMap, unAuditStockBillInfos);
        }
        if ("shut".equals(key) && !jarray.isEmpty()) {
            this.getOption().setVariableValue("valclose", jarray.toJSONString());
        }
        end = System.currentTimeMillis();
        logger.info((Object)("validate data:" + (end - start)));
    }

    private boolean isCheckOrderTransmitValStockAudit(DynamicObject billType) {
        boolean result = true;
        if (null != billType) {
            result = (Boolean)SystemParamServiceHelper.getBillParameter((String)this.getEntityKey(), (String)"ischeckstockaudit");
            logger.info((Object)("isCheckOrderTransmitValStockAudit:" + result));
        }
        return result;
    }

    private void checkIsExistUnAuditStock(ExtendedDataEntity dataEntity, Map<Long, DynamicObject> orderMap, Map<Long, String> unAuditStockBillInfos) {
        String selectRowStr = this.getOption().getVariableValue("operateOption");
        DynamicObject mftOrderBill = dataEntity.getDataEntity();
        String orderEntity = this.getEntityKey();
        String billno = mftOrderBill.getString("billno");
        List<String> entityentryidList = AtomServiceUtilsOp.getBillSelectRowInfo(selectRowStr, billno);
        Long billPkId = (Long)mftOrderBill.getPkValue();
        DynamicObject manubill = orderMap.get(billPkId);
        DynamicObject billtype = manubill.getDynamicObject("billtype");
        boolean isCheckOrderTransmitValStockAuditFlag = this.isCheckOrderTransmitValStockAudit(billtype);
        if (isCheckOrderTransmitValStockAuditFlag) {
            DynamicObjectCollection entryCol = manubill.getDynamicObjectCollection("treeentryentity");
            for (String entityentryid : entityentryidList) {
                for (int j = 0; j < entryCol.size(); ++j) {
                    String stockNo;
                    DynamicObject entry = (DynamicObject)entryCol.get(j);
                    if (entry == null || !entry.getPkValue().toString().equals(entityentryid) || !StringUtils.isNotBlank((CharSequence)(stockNo = unAuditStockBillInfos.get(entry.getLong("id"))))) continue;
                    if ("prop_mftorder".equals(orderEntity)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e0b\u8fbe\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5173\u8054\u7684\u7528\u6599\u6e05\u5355%2$s\u672a\u5ba1\u6838\u3002", (String)"AtomStatusOp_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), j + 1, stockNo));
                        continue;
                    }
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e0b\u8fbe\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5173\u8054\u7684\u7ec4\u4ef6\u6e05\u5355%2$s\u672a\u5ba1\u6838\u3002", (String)"AtomStatusOp_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), j + 1, stockNo));
                }
            }
        }
    }

    private Set<Long> getAllOrderEntryIds() {
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject orderBill = extendedDataEntity.getDataEntity();
            if (null == orderBill) continue;
            DynamicObjectCollection orderBillEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : orderBillEntrys) {
                orderEntryIds.add(entry.getLong("id"));
            }
        }
        return orderEntryIds;
    }

    private Map<Long, String> queryUnAuditStockBillInfos(Set<Long> orderEntryIds) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        if (!CollectionUtils.isEmpty(orderEntryIds)) {
            QFilter qfilter = new QFilter("orderentryid", "in", orderEntryIds);
            QFilter qfilter1 = new QFilter("billstatus", "!=", (Object)Character.valueOf('C'));
            QFilter[] filters = new QFilter[]{qfilter, qfilter1};
            String entitystockid = this.getOption().getVariableValue("entrystockid");
            try (DataSet queryMainData = QueryServiceHelper.queryDataSet((String)"queryMftStockData", (String)entitystockid, (String)"id,billno,orderentryid", (QFilter[])filters, (String)"");){
                for (Row row1 : queryMainData) {
                    result.put(row1.getLong("orderentryid"), row1.getString("billno"));
                }
            }
        }
        return result;
    }

    private void autoSelectAllRows() {
        StringBuilder sb = new StringBuilder();
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String billno = dataEntity.getString("billno");
            DynamicObjectCollection entrycol = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrycol) {
                String productty = entry.getString("producttype");
                if (!"C".equals(productty)) continue;
                Object entryPK = entry.getPkValue();
                sb.append(billno).append(',').append(entryPK).append("@@@");
            }
        }
        this.getOption().setVariableValue("operateOption", sb.toString());
    }

    private Set<Long> queryOrderEntryIdsWithUnAuditXBill() {
        HashSet<Long> orderEntryIdsWithUnAuditXBill = new HashSet<Long>(16);
        HashSet<String> orderEntryIds = new HashSet<String>(16);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject orderBill = extendedDataEntity.getDataEntity();
            if (null == orderBill) continue;
            DynamicObjectCollection orderBillEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : orderBillEntrys) {
                String entryId = entry.getString("id");
                orderEntryIds.add(entryId);
            }
        }
        if (!orderEntryIds.isEmpty()) {
            String xBillEntityId = "pom_xmftorder";
            if ("om_mftorder".equals(this.getEntityKey())) {
                xBillEntityId = "om_xmftorder";
            } else if ("prop_mftorder".equals(this.getEntityKey())) {
                return orderEntryIdsWithUnAuditXBill;
            }
            QFilter qFilter = new QFilter("treeentryentity.srcbillentryid", "in", orderEntryIds);
            qFilter.and(new QFilter("billstatus", "!=", (Object)"C"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryOrderEntryIdsWithUnAuditXBill", (String)xBillEntityId, (String)"treeentryentity.srcbillentryid", (QFilter[])qFilter.toArray(), null);){
                for (Row row : dataSet) {
                    orderEntryIdsWithUnAuditXBill.add(row.getLong("treeentryentity.srcbillentryid"));
                }
            }
        }
        return orderEntryIdsWithUnAuditXBill;
    }
}

