/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.materialplan;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bd.mpdm.opplugin.materialplan.MaterialPlanValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MaterialPlanOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MaterialPlanOp.class);
    private static final ThreadLocal<SimpleDateFormat> DATETIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private static final String DYNAMIC_CYCLE = "dynamiccycle";
    private static final String FIXED_PERIOD = "fixedperiod";
    private static final String SPEC_PERIOD = "specifiedperiod";
    private static final String POLICY = "lotpolicy";
    private static Set<String> prop = new HashSet<String>();
    private static final String PLAN_ISLOG = "plan_islog";
    private Map<Object, List<DynamicObject>> updateLogMap = new HashMap<Object, List<DynamicObject>>();
    private String opName;
    private String isLog;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("masterid");
        e.getFieldKeys().add("masterid.id");
        e.getFieldKeys().add("masterid.number");
        e.getFieldKeys().add("batchqty");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("createorg.id");
        e.getFieldKeys().add("maxlotsize");
        e.getFieldKeys().add("minlotsize");
        e.getFieldKeys().add("partitionbase");
        e.getFieldKeys().add("manufacturegroup");
        e.getFieldKeys().add("manufacture");
        e.getFieldKeys().add(DYNAMIC_CYCLE);
        e.getFieldKeys().add(FIXED_PERIOD);
        e.getFieldKeys().add(SPEC_PERIOD);
        e.getFieldKeys().add(POLICY);
        e.getFieldKeys().add("ctrlstrategy");
        e.getFieldKeys().add("materialattr");
        e.getFieldKeys().add("supplynetwork");
        e.getFieldKeys().add("planmode");
        e.getFieldKeys().add("reorderpoint");
        e.getFieldKeys().add("max");
        e.getFieldKeys().add("min");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataArray = e.getDataEntities();
        String opetateKey = e.getOperationKey();
        if ("save".equals(opetateKey) || "submit".equals(opetateKey) || "audit".equals(opetateKey)) {
            for (DynamicObject dyn : dataArray) {
                String lotpolicy = dyn.getString(POLICY);
                if ("A".equals(lotpolicy)) {
                    dyn.set(DYNAMIC_CYCLE, (Object)0);
                    dyn.set(FIXED_PERIOD, (Object)0);
                    dyn.set(SPEC_PERIOD, null);
                    continue;
                }
                if (!"B".equals(lotpolicy)) continue;
                dyn.set(DYNAMIC_CYCLE, (Object)0);
                dyn.set(FIXED_PERIOD, (Object)0);
                dyn.set(SPEC_PERIOD, null);
                dyn.set("minlotsize", (Object)0);
                dyn.set("maxlotsize", (Object)0);
                BigDecimal batchqty = dyn.getBigDecimal("batchqty");
                dyn.set("partitionbase", (Object)batchqty);
            }
        }
        if ("save".equals(opetateKey)) {
            DynamicObject[] oldPlanInfos;
            boolean containsIslog;
            String name = this.billEntityType.getName();
            boolean containsBatchUpdate = this.operateOption.containsVariable("batchUpdate");
            if (containsBatchUpdate) {
                this.opName = this.operateOption.getVariableValue("batchUpdate");
            }
            this.isLog = (containsIslog = this.operateOption.containsVariable(PLAN_ISLOG)) ? this.operateOption.getVariableValue(PLAN_ISLOG) : null;
            if (StringUtils.isBlank((CharSequence)this.isLog)) {
                return;
            }
            this.opName = "batchUpdate".equals(this.opName) ? ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539", (String)"MaterialPlanOp_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6539", (String)"MaterialPlanOp_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            DynamicObject[] dataEntities = e.getDataEntities();
            BillEntityType dataEntityType = (BillEntityType)dataEntities[0].getDataEntityType();
            ArrayList<Object> infoIds = new ArrayList<Object>(dataEntities.length);
            HashMap<Object, DynamicObject> orderMap = new HashMap<Object, DynamicObject>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                DataEntityState dataEntityState = dataEntity.getDataEntityState();
                Boolean isFromDB = dataEntityState.getFromDatabase();
                if (!isFromDB.booleanValue() && !Objects.equals(dataEntity.getPkValue(), 0L)) continue;
                infoIds.add(dataEntity.getPkValue());
                orderMap.put(dataEntity.getPkValue(), dataEntity);
            }
            if (infoIds.isEmpty()) {
                return;
            }
            Map fieldDatas = BusinessDataServiceHelper.loadFromCache((String)"mpdm_batch_edit", (String)"id,field", (QFilter[])new QFilter[]{new QFilter("source", "=", (Object)name)});
            for (DynamicObject fieldData : fieldDatas.values()) {
                prop.add(fieldData.getString("field"));
            }
            for (DynamicObject oldPlanInfo : oldPlanInfos = BusinessDataServiceHelper.load((Object[])infoIds.toArray(new Object[0]), (DynamicObjectType)dataEntityType)) {
                Object pkValue = oldPlanInfo.getPkValue();
                DynamicObject newPlanInfo = (DynamicObject)orderMap.get(pkValue);
                this.compare(newPlanInfo, oldPlanInfo, (MainEntityType)dataEntityType);
            }
        }
    }

    private void compare(DynamicObject newPlanInfo, DynamicObject oldPlanInfo, MainEntityType dataEntityType) {
        long starttime = System.currentTimeMillis();
        for (String pro : prop) {
            String[] props = pro.split("\\.");
            int level = 0;
            if (props.length > 2) continue;
            this.dealUpdateLog(props, level, dataEntityType, newPlanInfo, oldPlanInfo);
        }
        logger.info("MaterialPlanOp.compare\u6bd4\u8f83\u65f6\u957f\uff1a" + (System.currentTimeMillis() - starttime) / 1000L + "s");
    }

    private void dealUpdateLog(String[] props, int level, MainEntityType dataEntityType, DynamicObject newPlanInfo, DynamicObject oldPlanInfo) {
        IDataEntityProperty property = dataEntityType.findProperty(props[level]);
        if (property == null) {
            return;
        }
        Long planInfoId = newPlanInfo.getLong("id");
        DynamicObject material = newPlanInfo.getDynamicObject("masterid");
        String materialNumber = material.getString("number");
        String materialName = material.getLocaleString("name").getLocaleValue();
        if (property instanceof DynamicCollectionProperty) {
            return;
        }
        this.recordLogInfo(oldPlanInfo, newPlanInfo, props[level], property, planInfoId, materialNumber, materialName, null);
    }

    private void recordLogInfo(DynamicObject oldEntry, DynamicObject newData, String prop, IDataEntityProperty property, Long planInfoId, String materialNumber, String materialName, DynamicObject unit) {
        String oldValue = this.getValue(oldEntry, prop, property, unit);
        String newValue = this.getValue(newData, prop, property, unit);
        logger.info("\u8ba1\u5212\u4fe1\u606f" + materialNumber + "\u8bb0\u5f55\u6bd4\u8f83\u6570\u636e\uff1a\u4fee\u6539\u5b57\u6bb5" + prop + "\u4fee\u6539\u524d" + oldValue + "\u4fee\u6539\u540e" + newValue);
        if (!Objects.equals(oldValue, newValue)) {
            DynamicObject updateLog = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_planupt_datelog");
            updateLog.set("prevalue", (Object)oldValue);
            updateLog.set("nextvalue", (Object)newValue);
            updateLog.set("propname", (Object)property.getDisplayName().getLocaleValue());
            updateLog.set("opname", (Object)this.opName);
            updateLog.set("materialnumber", (Object)materialNumber);
            updateLog.set("materialname", (Object)materialName);
            updateLog.set("planinfoid", (Object)planInfoId);
            this.updateLogMap.computeIfAbsent(planInfoId, k -> new ArrayList()).add(updateLog);
        }
    }

    public String getValue(DynamicObject data, String prop, IDataEntityProperty property, DynamicObject unit) {
        if (data == null) {
            return "";
        }
        if (property instanceof BasedataProp) {
            BasedataProp baseDataProp = (BasedataProp)property;
            String displayProp = baseDataProp.getDisplayProp();
            DynamicObject dobj = data.getDynamicObject(prop);
            if (dobj == null) {
                return "";
            }
            return data.getDynamicObject(prop).getString(displayProp);
        }
        if (property instanceof TextProp) {
            return data.getString(prop);
        }
        if (property instanceof DateProp || property instanceof DateTimeProp) {
            Date date = data.getDate(prop);
            if (date == null) {
                return "";
            }
            return this.formatDateTime(date);
        }
        if (property instanceof QtyProp) {
            if (unit == null) {
                return "";
            }
            BigDecimal value = data.getBigDecimal(prop).setScale(unit.getInt("precision"), 4);
            if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
                return "";
            }
            return value.toString();
        }
        if (property instanceof DecimalProp) {
            BigDecimal value = data.getBigDecimal(prop);
            if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
                return "";
            }
            return value.toString();
        }
        if (property instanceof BooleanProp) {
            Boolean value = data.getBoolean(prop);
            return value.toString();
        }
        if (property instanceof ComboProp) {
            String value = data.getString(prop);
            List comboItems = ((ComboProp)property).getComboItems();
            String name = "";
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(value)) continue;
                name = comboItem.getName().getLocaleValue();
                break;
            }
            return name;
        }
        return "";
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String opetateKey;
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("audit".equals(operationKey)) {
            Boolean enableplanscope = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPlanScopeService", (String)"isEnablePlanScope", (Object[])new Object[0]);
            if (!enableplanscope.booleanValue()) {
                return;
            }
            dataEntities = e.getDataEntities();
            HashMap<Long, Map> map = new HashMap<Long, Map>();
            for (DynamicObject dynamicObject : dataEntities) {
                DynamicObject createorg = dynamicObject.getDynamicObject("createorg");
                if (createorg == null) continue;
                Long l = createorg.getLong("id");
                DynamicObject material = dynamicObject.getDynamicObject("masterid");
                if (material == null) continue;
                Long materialId = material.getLong("id");
                String materialattr = dynamicObject.getString("materialattr");
                Map materialMap = map.computeIfAbsent(l, k -> new HashMap());
                materialMap.put(materialId, materialattr);
            }
            ArrayList<DynamicObject> loads = new ArrayList<DynamicObject>(16);
            Set createOrgIdEntrySet = map.entrySet();
            int count = 0;
            int batch = 1000;
            for (Map.Entry entry : createOrgIdEntrySet) {
                Long createOrgId = (Long)entry.getKey();
                Map materialMap = (Map)entry.getValue();
                Set materialIds = materialMap.keySet();
                Iterator iterator = materialIds.iterator();
                HashSet<Long> materials = new HashSet<Long>(batch);
                QFilter qFilter = new QFilter("createorg", "=", (Object)createOrgId);
                do {
                    count = 0;
                    materials.clear();
                    while (iterator.hasNext()) {
                        Long id = (Long)iterator.next();
                        materials.add(id);
                        if (++count != batch) continue;
                        break;
                    }
                    QFilter idQflter = new QFilter("material", "in", materials);
                    DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"msplan_matplanscop", (String)"createorg,material,materialattr,entrymatplanscop,entrymatplanscop.supplynetwork", (QFilter[])new QFilter[]{qFilter, idQflter});
                    loads.addAll(Arrays.asList(dynamicObjects));
                } while (count >= batch);
            }
            if (loads.size() == 0) {
                return;
            }
            ArrayList<DynamicObject> needUpdate = new ArrayList<DynamicObject>(16);
            for (DynamicObject dynamicObject : loads) {
                DynamicObject createorg = dynamicObject.getDynamicObject("createorg");
                DynamicObject material = dynamicObject.getDynamicObject("material");
                if (createorg == null || material == null) continue;
                Long createorgId = createorg.getLong("id");
                long materialId = material.getLong("id");
                String materialattr = dynamicObject.getString("materialattr");
                Map materialMap = map.getOrDefault(createorgId, new HashMap());
                String newValue = materialMap.getOrDefault(materialId, "");
                if (newValue.equals(materialattr)) continue;
                if ("10060".equals(materialattr) && !"10060".equals(newValue)) {
                    DynamicObjectCollection entrymatplanscop = dynamicObject.getDynamicObjectCollection("entrymatplanscop");
                    for (DynamicObject entry : entrymatplanscop) {
                        entry.set("supplynetwork", (Object)0L);
                    }
                }
                dynamicObject.set("materialattr", materialMap.get(materialId));
                needUpdate.add(dynamicObject);
            }
            if (needUpdate.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])needUpdate.toArray(new DynamicObject[0]));
            }
        }
        if ("save".equals(opetateKey = e.getOperationKey())) {
            dataEntities = e.getDataEntities();
            ArrayList<DynamicObject> updateLogs = new ArrayList<DynamicObject>(dataEntities.length);
            for (DynamicObject data : dataEntities) {
                Object pkValue = data.getPkValue();
                List<DynamicObject> list = this.updateLogMap.get(pkValue);
                if (list == null) continue;
                Date opdate = data.getDate("modifytime");
                String userName = RequestContext.get().getUserName();
                for (DynamicObject updateLog : list) {
                    updateLog.set("opdate", (Object)opdate);
                    updateLog.set("username", (Object)userName);
                }
                updateLogs.addAll(list);
            }
            SaveServiceHelper.save((DynamicObject[])updateLogs.toArray(new DynamicObject[0]));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MaterialPlanValidator());
    }

    public String formatDateTime(Date date) {
        return DATETIME.get().format(date);
    }

    static {
        prop.add("fixedleadtime");
    }
}

