/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.materialplan;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MaterialPlanValidator
extends AbstractValidator {
    private static final String DYNAMIC_CYCLE = "dynamiccycle";
    private static final String FIXED_PERIOD = "fixedperiod";
    private static final String SPEC_PERIOD = "specifiedperiod";
    private static final String POLICY = "lotpolicy";
    private static final String POLICY_DIRECT = "A";
    private static final String POLICY_FIX = "B";
    private static final String POLICY_PERIOD = "C";

    public void validate() {
        String operate = this.getOperateKey();
        OperateOption operateOption = this.getOption();
        boolean containsBatchUpdate = operateOption.containsVariable("batchUpdate");
        String opName = "";
        if (containsBatchUpdate) {
            opName = operateOption.getVariableValue("batchUpdate");
        }
        if ("save".equals(operate)) {
            if ("batchUpdate".equals(opName)) {
                this.checkBatchUpdate();
                this.check();
            }
            this.checkInvLevel();
            this.checkPolicy();
            this.checkCtrlPolicy();
            this.checkSupplyNetwork();
        } else if ("submit".equals(operate)) {
            this.check();
            this.checkInvLevel();
            this.checkPolicy();
            this.checkCtrlPolicy();
            this.checkSupplyNetwork();
        } else if ("audit".equals(operate)) {
            this.checkCtrlPolicy();
        }
    }

    private void checkBatchUpdate() {
        for (ExtendedDataEntity exdataEntity : this.dataEntities) {
            BigDecimal batchqty;
            String error;
            DynamicObject dataEntity = exdataEntity.getDataEntity();
            String lotpolicy = dataEntity.getString(POLICY);
            String leadtimetype = dataEntity.getString("leadtimetype");
            if (POLICY_FIX.equals(leadtimetype)) {
                BigDecimal changebatch;
                BigDecimal changeleadtime = dataEntity.getBigDecimal("changeleadtime");
                if (changeleadtime.compareTo(BigDecimal.ZERO) <= 0) {
                    error = ResManager.loadKDString((String)"\u63d0\u524d\u671f\u7c7b\u578b\u4e3a\u53d8\u52a8\u63d0\u524d\u671f\uff0c\u53d8\u52a8\u63d0\u524d\u671f\u9700\u5927\u4e8e0\u3002", (String)"MaterialPlanValidator_35", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(exdataEntity, error);
                }
                if ((changebatch = dataEntity.getBigDecimal("changebatch")).compareTo(BigDecimal.ZERO) <= 0) {
                    String error2 = ResManager.loadKDString((String)"\u63d0\u524d\u671f\u7c7b\u578b\u4e3a\u53d8\u52a8\u63d0\u524d\u671f\uff0c\u53d8\u52a8\u6279\u91cf\u9700\u5927\u4e8e0\u3002", (String)"MaterialPlanValidator_36", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(exdataEntity, error2);
                }
            }
            if (!POLICY_FIX.equals(lotpolicy) || (batchqty = dataEntity.getBigDecimal("batchqty")).compareTo(BigDecimal.ZERO) > 0) continue;
            error = ResManager.loadKDString((String)"\u63d0\u6279\u91cf\u653f\u7b56\u4e3a\u56fa\u5b9a\u6279\u91cf\uff0c\u6279\u91cf\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", (String)"MaterialPlanValidator_37", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(exdataEntity, error);
        }
    }

    private Map<String, Set<Long>> getAllMaterialIds() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(this.dataEntities.length);
        HashSet<Long> materialIdSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> idSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            String ctrlstrategy = obj.getString("ctrlstrategy");
            long masterId = obj.getLong("masterid.id");
            if (!"5".equals(ctrlstrategy)) continue;
            materialIdSet.add(masterId);
            if (obj.get("id") == null || obj.getLong("id") == 0L) continue;
            idSet.add(obj.getLong("id"));
        }
        map.put("idset", idSet);
        map.put("materialset", materialIdSet);
        return map;
    }

    private Map<Long, String> getAllSharedMaterial(Set<Long> materialIdSet, Set<Long> idSet) {
        HashMap<Long, String> allSharedMaterial = new HashMap<Long, String>(this.dataEntities.length);
        HashSet<Long> returnSet = new HashSet<Long>(this.dataEntities.length);
        if (!materialIdSet.isEmpty()) {
            QFilter masteridFilter = new QFilter("masterid", "in", materialIdSet);
            QFilter ctrlFilter = new QFilter("ctrlstrategy", "=", (Object)Character.valueOf('5'));
            try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"MaterialPlan", (String)"mpdm_materialplan", (String)"id,masterid, createorg.name createorg", (QFilter[])new QFilter[]{masteridFilter, ctrlFilter}, null);){
                while (dataset.hasNext()) {
                    Row row = dataset.next();
                    Long masterid = row.getLong("masterid");
                    String createOrg = "";
                    if (row.getString("createorg") != null) {
                        createOrg = row.getString("createorg");
                    }
                    allSharedMaterial.put(masterid, createOrg);
                    if (!idSet.contains(row.getLong("id"))) continue;
                    returnSet.add(row.getLong("id"));
                }
            }
            idSet.clear();
            idSet.addAll(returnSet);
        }
        return allSharedMaterial;
    }

    private void checkCtrlPolicy() {
        Map<String, Set<Long>> map = this.getAllMaterialIds();
        Set<Long> materialIdSet = map.get("materialset");
        Set<Long> idSet = map.get("idset");
        Map<Long, String> allSharedMaterial = this.getAllSharedMaterial(materialIdSet, idSet);
        HashSet<Long> duplicateSharedMaterials = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            String ctrlstrategy = obj.getString("ctrlstrategy");
            long masterId = obj.getLong("masterid.id");
            long id = 0L;
            if (obj.get("id") != null) {
                id = obj.getLong("id");
            }
            StringBuilder errorMessage = new StringBuilder(ResManager.loadKDString((String)"\u7269\u6599\uff1a", (String)"MaterialPlanValidator_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            String materialNum = obj.getString("masterid.number");
            if ("5".equals(ctrlstrategy) && allSharedMaterial.get(masterId) != null && (id == 0L || !idSet.contains(id))) {
                String orgName = allSharedMaterial.get(masterId);
                String info = String.format(ResManager.loadKDString((String)"\u5728\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u5df2\u7ecf\u5b58\u5728\u6709\u5168\u5c40\u5171\u4eab\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"MaterialPlanValidator_29", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), orgName);
                errorMessage.append(materialNum).append(info);
                this.addErrorMessage(dataEntity, errorMessage.toString());
                continue;
            }
            if (!"5".equals(ctrlstrategy) || id != 0L && idSet.contains(id)) continue;
            if (duplicateSharedMaterials.contains(masterId)) {
                errorMessage.append(materialNum).append(ResManager.loadKDString((String)"\u4e0d\u53ef\u91cd\u590d\u65b0\u589e\u63a7\u5236\u7b56\u7565\u4e3a\u5168\u5c40\u5171\u4eab\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"MaterialPlanValidator_24", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                this.addErrorMessage(dataEntity, errorMessage.toString());
                continue;
            }
            duplicateSharedMaterials.add(masterId);
        }
    }

    private int sign(Object newValue) {
        if (newValue == null) {
            return 0;
        }
        if (newValue instanceof BigDecimal) {
            return ((BigDecimal)newValue).compareTo(BigDecimal.ZERO) == 0 ? 0 : 1;
        }
        return 1;
    }

    private void checkInvLevel() {
        long masterId;
        long createOrgId;
        DynamicObject obj;
        HashMap orgToMaterials = new HashMap(16);
        for (Object dataEntity : this.dataEntities) {
            Set<Long> materialIds;
            obj = dataEntity.getDataEntity();
            createOrgId = obj.getLong("createorg.id");
            masterId = obj.getLong("masterid.id");
            if (orgToMaterials.get(createOrgId) != null) {
                materialIds = (Set)orgToMaterials.get(createOrgId);
                materialIds.add(masterId);
                continue;
            }
            materialIds = new HashSet(16);
            materialIds.add(masterId);
            orgToMaterials.put(createOrgId, materialIds);
        }
        for (Map.Entry entry : orgToMaterials.entrySet()) {
            Set<Long> mIds = this.dispatchService((Long)entry.getKey(), (Set)entry.getValue());
            orgToMaterials.put((Long)entry.getKey(), mIds);
        }
        for (Object dataEntity : this.dataEntities) {
            Set mIds;
            obj = dataEntity.getDataEntity();
            createOrgId = obj.getLong("createorg.id");
            masterId = obj.getLong("masterid.id");
            if (orgToMaterials.get(createOrgId) == null || !(mIds = (Set)orgToMaterials.get(createOrgId)).contains(masterId)) continue;
            this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7+\u7269\u6599\u5b58\u5728\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539\u5176\u4e2d\u4e00\u9879\u3002", (String)"MaterialPlanValidator_20", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
    }

    private Set<Long> dispatchService(Long org, Set<Long> mtSet) {
        return (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMPDMCheckInvLevelService", (String)"isexist", (Object[])new Object[]{org, mtSet});
    }

    private void checkPolicy() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            int max;
            int min;
            DynamicObject obj = dataEntity.getDataEntity();
            String lotpolicy = obj.getString(POLICY);
            int numCycle = this.sign(obj.get(DYNAMIC_CYCLE));
            int numFix = this.sign(obj.get(FIXED_PERIOD));
            int numSpec = this.sign(obj.get(SPEC_PERIOD));
            if (POLICY_PERIOD.equals(lotpolicy)) {
                if (numCycle + numFix + numSpec == 1) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6279\u91cf\u653f\u7b56\u4e3a\u5468\u671f\u6279\u91cf\u65f6\uff0c\u56fa\u5b9a\u5468\u671f\u3001\u52a8\u6001\u5468\u671f\u3001\u6307\u5b9a\u5468\u671f\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u503c\u3002", (String)"MaterialPlanValidator_25", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (POLICY_DIRECT.equals(lotpolicy)) {
                if (numCycle + numFix + numSpec == 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6279\u91cf\u653f\u7b56\u4e3a\u76f4\u63a5\u6279\u91cf\u65f6\uff0c\u56fa\u5b9a\u5468\u671f\u3001\u52a8\u6001\u5468\u671f\u3001\u6307\u5b9a\u5468\u671f\u4e0d\u80fd\u8d4b\u503c\u3002", (String)"MaterialPlanValidator_26", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!POLICY_FIX.equals(lotpolicy)) continue;
            if (numCycle + numFix + numSpec != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6279\u91cf\u653f\u7b56\u4e3a\u56fa\u5b9a\u6279\u91cf\u65f6\uff0c\u56fa\u5b9a\u5468\u671f\u3001\u52a8\u6001\u5468\u671f\u3001\u6307\u5b9a\u5468\u671f\u4e0d\u80fd\u8d4b\u503c\u3002", (String)"MaterialPlanValidator_27", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if ((min = this.sign(obj.get("minlotsize"))) + (max = this.sign(obj.get("maxlotsize"))) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6279\u91cf\u653f\u7b56\u4e3a\u56fa\u5b9a\u6279\u91cf\u65f6\uff0c\u6700\u5c0f\u6279\u91cf\u3001\u6700\u5927\u6279\u91cf\u4e0d\u80fd\u8d4b\u503c\u3002", (String)"MaterialPlanValidator_28", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            obj.set("partitionbase", obj.get("batchqty"));
        }
    }

    private void check() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            String e;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            BigDecimal batchQty = obj.getBigDecimal("batchqty");
            BigDecimal maxLotSize = obj.getBigDecimal("maxlotsize");
            BigDecimal minLotSize = obj.getBigDecimal("minlotsize");
            BigDecimal partitionBase = obj.getBigDecimal("partitionbase");
            if (minLotSize.compareTo(BigDecimal.ZERO) > 0 && maxLotSize.compareTo(BigDecimal.ZERO) > 0 && maxLotSize.compareTo(minLotSize) < 0) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u6700\u5c0f\u6279\u91cf\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u6279\u91cf\u3002", (String)"MaterialPlanValidator_31", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (maxLotSize.compareTo(BigDecimal.ZERO) > 0 && batchQty.compareTo(BigDecimal.ZERO) > 0 && maxLotSize.compareTo(batchQty) < 0) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u6700\u5927\u6279\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u6279\u91cf\u6570\u91cf/\u53d6\u6574\u500d\u6570\u3002", (String)"MaterialPlanValidator_32", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (partitionBase.compareTo(BigDecimal.ZERO) > 0 && minLotSize.compareTo(BigDecimal.ZERO) > 0 && partitionBase.compareTo(minLotSize) < 0) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5206\u5272\u57fa\u6570\u4e0d\u80fd\u5c0f\u4e8e\u6700\u5c0f\u6279\u91cf\u3002", (String)"MaterialPlanValidator_33", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if (partitionBase.compareTo(BigDecimal.ZERO) > 0 && maxLotSize.compareTo(BigDecimal.ZERO) > 0 && partitionBase.compareTo(maxLotSize) > 0) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5206\u5272\u57fa\u6570\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u6279\u91cf\u3002", (String)"MaterialPlanValidator_34", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            String planmode = obj.getString("planmode");
            BigDecimal reorderValue = obj.getBigDecimal("reorderpoint");
            BigDecimal maxValue = obj.getBigDecimal("max");
            BigDecimal minValue = obj.getBigDecimal("min");
            if ("E".equalsIgnoreCase(planmode)) {
                if (maxValue != null && maxValue.compareTo(BigDecimal.ZERO) == 0) {
                    String c = ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u65b9\u5f0f\u201d\u7b49\u4e8e\u201c\u6700\u5927\u6700\u5c0f\u5e93\u5b58\u201d\uff0c\u201c\u6700\u5927\u5e93\u5b58\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"MaterialPlanValidator_38", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(this.dataEntities[i], c);
                }
                if (minValue != null && minValue.compareTo(BigDecimal.ZERO) == 0) {
                    String d = ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u65b9\u5f0f\u201d\u7b49\u4e8e\u201c\u6700\u5927\u6700\u5c0f\u5e93\u5b58\u201d\uff0c\u201c\u6700\u5c0f\u5e93\u5b58\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"MaterialPlanValidator_39", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(this.dataEntities[i], d);
                }
                if (minValue != null && maxValue != null && minValue.compareTo(maxValue) >= 0) {
                    e = ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u65b9\u5f0f\u201d\u7b49\u4e8e\u201c\u6700\u5927\u6700\u5c0f\u5e93\u5b58\u201d\uff0c\u201c\u6700\u5c0f\u5e93\u5b58\u201d\u5fc5\u987b\u5c0f\u4e8e\u201c\u6700\u5927\u5e93\u5b58\u201d\u3002", (String)"MaterialPlanValidator_40", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(this.dataEntities[i], e);
                }
            } else if (maxValue != null && maxValue.compareTo(BigDecimal.ZERO) != 0 || minValue != null && minValue.compareTo(BigDecimal.ZERO) != 0) {
                e = ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u65b9\u5f0f\u201d\u4e0d\u7b49\u4e8e\u201c\u6700\u5927\u6700\u5c0f\u5e93\u5b58\u201d\uff0c\u201c\u6700\u5927\u5e93\u5b58\u201d\u3001 \u201c\u6700\u5c0f\u5e93\u5b58\u201d\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"MaterialPlanValidator_41", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(this.dataEntities[i], e);
            }
            if (POLICY_DIRECT.equalsIgnoreCase(planmode)) {
                if (reorderValue == null || reorderValue.compareTo(BigDecimal.ZERO) != 0) continue;
                String a = ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u65b9\u5f0f\u201d\u7b49\u4e8e\u201c\u518d\u8ba2\u8d27\u70b9\u201d\uff0c\u201c\u518d\u8ba2\u8d27\u70b9\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"MaterialPlanValidator_42", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(this.dataEntities[i], a);
                continue;
            }
            if (reorderValue == null || reorderValue.compareTo(BigDecimal.ZERO) == 0) continue;
            e = ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u65b9\u5f0f\u201d\u4e0d\u7b49\u4e8e\u201c\u518d\u8ba2\u8d27\u70b9\u201d\uff0c\u201c\u518d\u8ba2\u8d27\u70b9\u201d\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"MaterialPlanValidator_43", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(this.dataEntities[i], e);
        }
    }

    private void checkSupplyNetwork() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject materialPlan = dataEntity.getDataEntity();
            String materialAttr = materialPlan.getString("materialattr");
            boolean isCollaborativePart = "10060".equals(materialAttr);
            DynamicObject supplyNetwork = materialPlan.getDynamicObject("supplynetwork");
            if (isCollaborativePart || supplyNetwork == null) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7269\u6599\u5c5e\u6027\u4e0d\u4e3a\u201c\u5185\u534f\u4ef6\u201d\uff0c\u4e0d\u80fd\u5f55\u5165\u4f9b\u5e94\u7f51\u7edc\u3002", (String)"MaterialPlanValidator_30", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
    }
}

