/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.mftstock;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.utils.StockRefreshInvQtyUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StockRefreshInvQtyOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(StockRefreshInvQtyOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("supplyorgid");
        fieldKeys.add("warehouseid");
        fieldKeys.add("location");
        fieldKeys.add("materielmasterid");
        fieldKeys.add("batchno");
        fieldKeys.add("childauxpropertyid");
        fieldKeys.add("materialunitid");
        fieldKeys.add("supplymode");
        fieldKeys.add("supplierid");
        fieldKeys.add("entryconfiguredcode");
        fieldKeys.add("tracknumber");
        fieldKeys.add("avbbaseqty");
        fieldKeys.add("reservebaseqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        HashMap avbBaseQtyMap = new HashMap(16);
        HashMap reserveBaseQtyMap = new HashMap(16);
        HashMap avbBaseQtyEntryIdMap = new HashMap(16);
        HashMap reserveBaseQtyEntryIdMap = new HashMap(16);
        DynamicObject[] objs = e.getDataEntities();
        JSONArray filterArray = new JSONArray(16);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection stockentrys = obj.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockentry : stockentrys) {
                filterArray.add(StockRefreshInvQtyUtils.getStockEntryJSONObject((DynamicObject)stockentry, (DynamicObject)obj));
            }
        }
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5e93\u5b58\u67e5\u8be21");
        Map keyEntryIdMap = StockRefreshInvQtyUtils.getKeyEntryIdMap((JSONArray)filterArray, avbBaseQtyMap, reserveBaseQtyMap);
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5e93\u5b58\u67e5\u8be22" + keyEntryIdMap);
        StockRefreshInvQtyUtils.getKeyQtyMap((JSONArray)filterArray, avbBaseQtyMap, reserveBaseQtyMap);
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5e93\u5b58\u67e5\u8be23" + avbBaseQtyMap);
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5e93\u5b58\u67e5\u8be24" + reserveBaseQtyMap);
        StockRefreshInvQtyUtils.getEntryIdQtyMap((Map)keyEntryIdMap, avbBaseQtyMap, reserveBaseQtyMap, avbBaseQtyEntryIdMap, reserveBaseQtyEntryIdMap);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection stockentrys = obj.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockentry : stockentrys) {
                if (avbBaseQtyEntryIdMap.get(stockentry.getPkValue()) != null && reserveBaseQtyEntryIdMap.get(stockentry.getPkValue()) != null) {
                    stockentry.set("avbbaseqty", (Object)((BigDecimal)avbBaseQtyEntryIdMap.get(stockentry.getPkValue())).subtract((BigDecimal)reserveBaseQtyEntryIdMap.get(stockentry.getPkValue())));
                    stockentry.set("reservebaseqty", reserveBaseQtyEntryIdMap.get(stockentry.getPkValue()));
                    continue;
                }
                stockentry.set("avbbaseqty", (Object)BigDecimal.ZERO);
                stockentry.set("reservebaseqty", (Object)BigDecimal.ZERO);
            }
        }
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5e93\u5b58\u67e5\u8be25" + avbBaseQtyEntryIdMap);
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5e93\u5b58\u67e5\u8be26" + reserveBaseQtyEntryIdMap);
        SaveServiceHelper.save((DynamicObject[])objs);
    }
}

