/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.mftstock;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StockSaveTplOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("orderentryid");
        e.getFieldKeys().add("transactiontypeid");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("stockentry.srcbillid");
        e.getFieldKeys().add("stockentry.srcbillentryid");
        e.getFieldKeys().add("stockentry.demandqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] loads;
        super.beginOperationTransaction(e);
        DynamicObject[] stocks = e.getDataEntities();
        HashSet<Long> srcBillIdSet = new HashSet<Long>(16);
        HashMap<Long, BigDecimal> entryQtyMap = new HashMap<Long, BigDecimal>();
        for (DynamicObject stock : stocks) {
            if (this.checkSaveBill(stock).booleanValue()) continue;
            srcBillIdSet.add(stock.getLong("sourcebillid"));
            DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockEntry : stockEntrys) {
                Long srcEntryId = stockEntry.getLong("srcbillentryid");
                if (srcEntryId.equals(0L)) continue;
                BigDecimal demandqty = stockEntry.getBigDecimal("demandqty");
                BigDecimal qty = (BigDecimal)entryQtyMap.get(srcEntryId);
                if (qty == null) {
                    entryQtyMap.put(srcEntryId, demandqty);
                    continue;
                }
                entryQtyMap.put(srcEntryId, demandqty.add(qty));
            }
        }
        if (!srcBillIdSet.isEmpty() && !entryQtyMap.isEmpty() && (loads = BusinessDataServiceHelper.load((String)"mrp_planorder", (String)"entryentity.entrydroprequireqty", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIdSet)})) != null && loads.length > 0) {
            for (DynamicObject load : loads) {
                DynamicObjectCollection entrys = load.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    BigDecimal qty = (BigDecimal)entryQtyMap.get(entry.getPkValue());
                    BigDecimal reqqty = entry.getBigDecimal("entrydroprequireqty");
                    if (qty == null) continue;
                    entry.set("entrydroprequireqty", (Object)reqqty.add(qty));
                }
            }
            SaveServiceHelper.update((DynamicObject[])loads);
        }
    }

    private Boolean checkSaveBill(DynamicObject bill) {
        boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
        Object pkValue = bill.getPkValue();
        if (pkValue == null || pkValue.equals(0L) || !isFromDataBase) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

