/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.ordermerge;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.mftorder.OrderBookDateService;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.opplugin.botp.OrderToMergeConvertPlugin;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OrderMergeTplAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrderMergeTplAuditOp.class);
    Map<Object, DynamicObject> mergeOrderMap = new HashMap<Object, DynamicObject>(1);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("id");
        filds.add("mergeorderid");
        filds.add("billno");
        filds.add("isgentechok");
        filds.add("transactiontype");
        filds.add("srcentry");
        filds.add("srcentry.orderid");
        filds.add("mergeetentry.mergeordeno");
        filds.add("mergeetentry.ipidmerge");
        filds.add("mergeetentry.producttypemerge");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] orderMerges;
        logger.info("orderMerge audit beginOperationTransaction begin");
        long begintime = System.currentTimeMillis();
        String operationKey = e.getOperationKey();
        if (!StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey)) {
            return;
        }
        for (DynamicObject orderMerge : orderMerges = e.getDataEntities()) {
            long auditBegintime = System.currentTimeMillis();
            DynamicObjectCollection srcEntrys = orderMerge.getDynamicObjectCollection("srcentry");
            HashSet<String> orderids = new HashSet<String>(16);
            for (DynamicObject srcEntry : srcEntrys) {
                String orderid = srcEntry.getString("orderid");
                orderids.add(orderid);
            }
            logger.info("orderMerge audit begin generate order");
            this.mergeOrderMap = this.genOrder(orderMerge);
            long genOrdertime = System.currentTimeMillis();
            logger.info("orderMerge audit end generate order,cost time :" + TimeUnit.MILLISECONDS.toSeconds(genOrdertime - auditBegintime) + " s");
            logger.info("orderMerge audit end colse src order");
            this.closeSrcOrder(orderids);
            long end = System.currentTimeMillis();
            logger.info("orderMerge audit end colse src order,cost time :" + TimeUnit.MILLISECONDS.toSeconds(end - genOrdertime) + "s");
        }
        long endtime = System.currentTimeMillis();
        logger.info("orderMerge audit beginOperationTransaction end cost\uff1a" + TimeUnit.MILLISECONDS.toSeconds(endtime - begintime) + "s");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        logger.info("\u5de5\u5355\u5408\u5e76\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u5f00\u59cb\u8fdb\u5165 afterExecuteOperationTransaction ");
        String operationKey = e.getOperationKey();
        if (!StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey) && !StringUtils.equals((CharSequence)"genmantech", (CharSequence)operationKey)) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        boolean isprocedure = false;
        for (DynamicObject mergeOrder : dataEntities) {
            String mergedOrderid;
            DynamicObject targetOrder = this.mergeOrderMap.get(mergeOrder.getPkValue());
            if (targetOrder == null) {
                targetOrder = this.getOrder(mergeOrder);
            }
            if (targetOrder == null) continue;
            DynamicObjectCollection orderEntrys = targetOrder.getDynamicObjectCollection("treeentryentity");
            String string = mergedOrderid = mergeOrder.get("mergeorderid") == null ? "0" : mergeOrder.getString("mergeorderid");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)mergedOrderid)) continue;
            DynamicObject transactionType = mergeOrder.getDynamicObject("transactiontype");
            if (transactionType != null) {
                boolean bl = isprocedure = transactionType.get("isprocedure") == null ? false : transactionType.getBoolean("isprocedure");
            }
            if (!isprocedure) continue;
            DynamicObjectCollection mergeetentrys = mergeOrder.getDynamicObjectCollection("mergeetentry");
            String targetEntryid = "0";
            ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>(mergeetentrys.size());
            for (DynamicObject mergeetentry : mergeetentrys) {
                String productType = mergeetentry.getString("producttypemerge");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)productType)) continue;
                String mergeEntryid = mergeetentry.get("id") == null ? "0" : mergeetentry.getString("id");
                Object ipidmgId = mergeetentry.get("ipidmerge");
                for (DynamicObject orderEntry : orderEntrys) {
                    String srcorderentryid = orderEntry.get("srcorderentryid") == null ? "0" : orderEntry.getString("srcorderentryid");
                    if (!StringUtils.equals((CharSequence)mergeEntryid, (CharSequence)srcorderentryid)) continue;
                    targetEntryid = orderEntry.getPkValue().toString();
                }
                HashMap<Object, String> idNoMapping = new HashMap<Object, String>(16);
                Map<Long, String> srcOrderIds = this.getSrcOrderIds(mergeOrder.getPkValue(), ipidmgId, idNoMapping);
                HashMap<String, Object> entryParams = new HashMap<String, Object>(5);
                entryParams.put("mergedOrderid", mergedOrderid);
                entryParams.put("targetEntryid", targetEntryid);
                entryParams.put("srcOrderIds", srcOrderIds);
                entryParams.put("idNoMapping", idNoMapping);
                entryParams.put("mergeOrder", mergeOrder);
                entryList.add(entryParams);
            }
            this.genManuftech(entryList);
        }
        logger.info("\u5de5\u5355\u5408\u5e76\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u7ed3\u675f afterExecuteOperationTransaction ");
    }

    private DynamicObject getOrder(DynamicObject mergeOrder) {
        Object orderid = mergeOrder.get("mergeorderid");
        DynamicObject targetOrder = BusinessDataServiceHelper.loadSingle((Object)orderid, (String)"pom_mftorder", (String)"id,treeentryentity,treeentryentity.id,treeentryentity.srcorderentryid");
        return targetOrder;
    }

    private void genManuftech(List<Map<String, Object>> params) {
        logger.info("\u5de5\u5355\u5408\u5e76\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u5f00\u59cb\u8c03\u7528sfc\u5fae\u670d\u52a1\u3002");
        if (params == null || params.size() < 1) {
            return;
        }
        Map<String, Object> entryParams = params.get(0);
        DynamicObject mergeOrder = (DynamicObject)entryParams.get("mergeOrder");
        try {
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"MergeOrderGenTechnicsService", (String)"genManuftech", (Object[])new Object[]{params});
        }
        catch (Exception e) {
            logger.error("\u5de5\u5355\u5408\u5e76\u5355[" + mergeOrder.get("billno") + "]\u751f\u6210\u5408\u5e76\u5de5\u5e8f\u8ba1\u5212\u5f02\u5e38\uff1a" + e.getMessage());
            SqlBuilder sql = new SqlBuilder();
            sql.append("update t_pom_ordermerge set fisgentechok = '0' where fid = ? and fisgentechok = '1'", new Object[]{mergeOrder.getPkValue()});
            DB.update((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
            mergeOrder.set("isgentechok", (Object)false);
            throw new KDBizException(e.getMessage());
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_pom_ordermerge set fisgentechok = '1' where fid = ? and fisgentechok = '0'", new Object[]{mergeOrder.getPkValue()});
        DB.update((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
        mergeOrder.set("isgentechok", (Object)true);
        logger.info("\u5de5\u5355\u5408\u5e76\u5355[" + mergeOrder.get("billno") + "]\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u7ed3\u675f\u8c03\u7528sfc\u5fae\u670d\u52a1\u3002");
    }

    private void closeSrcOrder(Set<String> orderids) {
        Map orderMap = OrderOpUtils.getMftOrderDataMap(orderids.stream().map(k -> Long.parseLong(k)).collect(Collectors.toSet()), (String)"pom_mftorder");
        Date now = new Date();
        boolean bookDateEqualsBizDate = OrderBookDateService.bookDateEqualsBizDate();
        HashSet<Long> entryIds = new HashSet<Long>(16);
        HashSet<Long> transIDSet = new HashSet<Long>(16);
        for (DynamicObject order : orderMap.values()) {
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
            for (Object orderEntry : orderEntrys) {
                entryIds.add(Long.parseLong(orderEntry.getPkValue().toString()));
            }
            DynamicObject transactiontype = order.getDynamicObject("transactiontype");
            transIDSet.add(transactiontype.getLong("id"));
        }
        Map transactionTypeMap = TransactionTypeQueryHelper.getDataCacheBySet(transIDSet);
        Map bookdates = OrderBookDateService.makeupOrgDates(entryIds, (DynamicObject[])orderMap.values().toArray(new DynamicObject[orderMap.size()]));
        Map productOrgAndBookDateMap = (Map)bookdates.get("productOrgAndBookDateMap");
        Map maxInvOrgAndBookDateMap = (Map)bookdates.get("maxInvOrgAndBookDateMap");
        for (DynamicObject manubill : orderMap.values()) {
            manubill.set("billstatus", (Object)"D");
            DynamicObject transactiontype = (DynamicObject)transactionTypeMap.get(manubill.getDynamicObject("transactiontype").getPkValue());
            DynamicObjectCollection entryCol = manubill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entryCol) {
                String entityentryid = entry.getPkValue().toString();
                entry.set("bizstatus", (Object)"C");
                entry.set("closetime", (Object)now);
                Date closeBookDate = null;
                closeBookDate = bookDateEqualsBizDate ? now : OrderBookDateService.queryBookDateWithCompare((DynamicObject)manubill, (DynamicObject)entry, (Map)productOrgAndBookDateMap, (Map)maxInvOrgAndBookDateMap, (Date)now, (String)"closebookdate", (boolean)false, null, (boolean)true);
                entry.set("closebookdate", (Object)(closeBookDate != null ? DateUtils.getShortDate((Date)closeBookDate) : null));
                OrderMergeHelper.updateStatusByMainProduct((DynamicObjectCollection)entryCol, (String)entityentryid, (int)5, (boolean)true, (boolean)bookDateEqualsBizDate, (Date)closeBookDate);
                if (null == transactiontype || !transactiontype.getBoolean("closeclear")) continue;
                OrderMergeHelper.clearStockWipqty((Long)Long.parseLong(entityentryid), (String)"pom_mftorder");
            }
        }
        String stockName = EntityNameUtils.getEntityName((int)0, (int)1, (String)"pom_mftorder");
        String manftechName = EntityNameUtils.getEntityName((int)0, (int)2, (String)"pom_mftorder");
        this.invalidBill(stockName, "orderentryid", entryIds);
        this.invalidBill(manftechName, "mftentryseq", entryIds);
        SaveServiceHelper.update((DynamicObject[])orderMap.values().toArray(new DynamicObject[orderMap.size()]));
    }

    private Map<Object, DynamicObject> genOrder(DynamicObject orderMerge) {
        Object pkValue = orderMerge.getPkValue();
        Long mergeorderid = Long.parseLong(pkValue.toString());
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow selectedRow = new ListSelectedRow((Object)mergeorderid);
        selectedRows.add(selectedRow);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setAutoSave(false);
        ConvertOperationResult pushResult = OrderMergeHelper.pushTo(null, selectedRows, (String)"1487756624004214784", (String)"pom_ordermerge", (String)"pom_mftorder", (PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            String billMessage = "";
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                billMessage = billReport.getFailMessage();
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u5408\u5e76\u751f\u6210\u5de5\u5355\u5931\u8d25\uff1a%1$s", (String)"OrderMergeTplAuditOp_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), errMessage + billMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"pom_mftorder");
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        DynamicObjectCollection mergeEntryCollection = orderMerge.getDynamicObjectCollection("mergeetentry");
        HashMap<Object, DynamicObject> mergeOrderMap = new HashMap<Object, DynamicObject>(mergeEntryCollection.size());
        if (targetBillObjs != null && targetBillObjs.size() > 0) {
            DynamicObject mergeOrder = (DynamicObject)targetBillObjs.get(0);
            orderMerge.set("mergeorderid", mergeOrder.getPkValue());
            for (DynamicObject mergeEntry : mergeEntryCollection) {
                mergeEntry.set("mergeordeno", ((DynamicObject)targetBillObjs.get(0)).get("billno"));
            }
            mergeOrderMap.put(pkValue, mergeOrder);
        }
        SaveServiceHelper.update((DynamicObject)orderMerge);
        return mergeOrderMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, String> getSrcOrderIds(Object mgorderid, Object idIpid, Map<Object, String> idNoMapping) {
        HashMap<Long, String> orderIds = new HashMap<Long, String>(16);
        if (mgorderid == null || idIpid == null) {
            return orderIds;
        }
        try (DataSet dataSet = null;){
            SqlBuilder sql = new SqlBuilder();
            sql.append("select forderid,forderno,forderentryid from t_pom_mgsrcentry where fid = ? and fipid = ? ", new Object[]{mgorderid, idIpid});
            dataSet = DB.queryDataSet((String)OrderToMergeConvertPlugin.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
            for (Row row : dataSet) {
                orderIds.put(row.getLong("forderentryid"), row.get("forderid").toString());
                idNoMapping.put(row.getString("forderid"), row.getString("forderno"));
            }
        }
        return orderIds;
    }

    private void invalidBill(String stockName, String fieldName, Set<Long> orderEntryIdSet) {
        DynamicObject[] load;
        QFilter stockqfilter = new QFilter(fieldName, "in", orderEntryIdSet);
        for (DynamicObject stock : load = BusinessDataServiceHelper.load((String)stockName, (String)"id,billstatus,billno", (QFilter[])new QFilter[]{stockqfilter})) {
            stock.set("billstatus", (Object)"D");
        }
        SaveServiceHelper.save((DynamicObject[])load);
    }
}

