/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.ordermerge.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.TimeServiceHelper;

public class MergeOrderCheckHelper {
    public static void checkStock(DynamicObject[] stocks) {
        if (stocks == null || stocks.length < 2) {
            return;
        }
        HashSet<Object> orgSet = new HashSet<Object>(stocks.length);
        HashSet<Object> billTypeSet = new HashSet<Object>(stocks.length);
        HashSet<String> billStatusSet = new HashSet<String>(stocks.length);
        HashSet<Object> transacationSet = new HashSet<Object>(stocks.length);
        HashSet<Object> productSet = new HashSet<Object>(stocks.length);
        HashSet<Object> configCodeSet = new HashSet<Object>(stocks.length);
        HashSet<Object> trackNumberCodeSet = new HashSet<Object>(stocks.length);
        HashSet<Object> deptOrgSet = new HashSet<Object>(stocks.length);
        HashSet<Object> auxUnitSet = new HashSet<Object>(stocks.length);
        HashSet<Object> bomSet = new HashSet<Object>(stocks.length);
        HashSet<Object> processRouteSet = new HashSet<Object>(stocks.length);
        HashMap<Object, List<DynamicObject>> entryMap = new HashMap<Object, List<DynamicObject>>(16);
        for (int i = 0; i < stocks.length; ++i) {
            DynamicObject stock = stocks[i];
            String billNo = stock.get("billno") == null ? "" : stock.getString("billno");
            MergeOrderCheckHelper.checkHeadFields(orgSet, billTypeSet, billStatusSet, transacationSet, productSet, configCodeSet, trackNumberCodeSet, deptOrgSet, auxUnitSet, bomSet, processRouteSet, stock, billNo);
            DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockEntry : stockEntrys) {
                String pid;
                DynamicObject entryMaterial = stockEntry.getDynamicObject("materialid");
                String materialPk = entryMaterial.getPkValue().toString();
                DynamicObject entryconfiguredcode = stockEntry.getDynamicObject("entryconfiguredcode");
                String configuredcodePk = entryconfiguredcode == null ? "" : entryconfiguredcode.getPkValue().toString();
                String oprno = stockEntry.get("oprno") == null ? "" : stockEntry.getString("oprno");
                String processseq = stockEntry.get("processseq") == null ? "" : stockEntry.getString("processseq");
                String string = pid = stockEntry.get("pid") == null ? "0" : stockEntry.get("pid").toString();
                if (!StringUtils.equals((CharSequence)"0", (CharSequence)pid)) {
                    pid = "1";
                }
                String key = materialPk + configuredcodePk + oprno + processseq + pid;
                List entryObjects = entryMap.computeIfAbsent(key, k -> new ArrayList(10));
                entryObjects.add(stockEntry);
            }
        }
        MergeOrderCheckHelper.checkEntryFields(entryMap);
    }

    private static void checkEntryFields(Map<Object, List<DynamicObject>> entryMap) {
        for (List<DynamicObject> entrys : entryMap.values()) {
            if (entrys == null || entrys.size() < 2) continue;
            Date date = new Date();
            HashSet<Object> configCodeSet = new HashSet<Object>(16);
            HashSet<Object> bomreversionSet = new HashSet<Object>(16);
            HashSet<String> batchNoSet = new HashSet<String>(16);
            HashSet<String> qtyTypeSet = new HashSet<String>(16);
            HashSet<BigDecimal> useratioSet = new HashSet<BigDecimal>(16);
            HashSet<Boolean> reworkSet = new HashSet<Boolean>(16);
            HashSet<BigDecimal> qtynumeratorSet = new HashSet<BigDecimal>(16);
            HashSet<BigDecimal> qtydenominatorSet = new HashSet<BigDecimal>(16);
            HashSet<String> wastformulaSet = new HashSet<String>(16);
            HashSet<BigDecimal> fixscrapSet = new HashSet<BigDecimal>(16);
            HashSet<String> supplymodeSet = new HashSet<String>(16);
            HashSet<Object> supplierSet = new HashSet<Object>(16);
            HashSet<Object> supplyorgSet = new HashSet<Object>(16);
            HashSet<Object> warehouseSet = new HashSet<Object>(16);
            HashSet<Object> locationSet = new HashSet<Object>(16);
            HashSet<Boolean> isstockallotSet = new HashSet<Boolean>(16);
            HashSet<Object> outorgunitSet = new HashSet<Object>(16);
            HashSet<Object> outWarehouseSet = new HashSet<Object>(16);
            HashSet<Object> outlocationSet = new HashSet<Object>(16);
            HashSet<String> issuemodeSet = new HashSet<String>(16);
            HashSet<Boolean> isbulkmaterialSet = new HashSet<Boolean>(16);
            HashSet<String> isbackflushSet = new HashSet<String>(16);
            HashSet<String> backflushtimeSet = new HashSet<String>(16);
            HashSet<Boolean> iskeypartSet = new HashSet<Boolean>(16);
            HashSet<String> overissuecontrlSet = new HashSet<String>(16);
            HashSet<BigDecimal> issinhighlimitSet = new HashSet<BigDecimal>(16);
            HashSet<BigDecimal> issinlowlimitSet = new HashSet<BigDecimal>(16);
            HashSet<BigDecimal> leadtimeSet = new HashSet<BigDecimal>(16);
            HashSet<String> demanddateSet = new HashSet<String>(16);
            HashSet<Object> replaceplanSet = new HashSet<Object>(16);
            HashSet<Integer> prioritySet = new HashSet<Integer>(16);
            HashSet<Boolean> ismainreplaceSet = new HashSet<Boolean>(16);
            HashSet<String> oprnoSet = new HashSet<String>(16);
            HashSet<String> processseqSet = new HashSet<String>(16);
            for (DynamicObject entry : entrys) {
                DynamicObject replaceplan;
                DynamicObject outlocation;
                DynamicObject outWarehouse;
                DynamicObject outorgunit;
                DynamicObject location;
                DynamicObject warehouse;
                DynamicObject supplyorg;
                DynamicObject supplier;
                DynamicObject bomreversion;
                DynamicObject configCode;
                DynamicObject parent = (DynamicObject)entry.getParent();
                String billNo = parent.get("billno") == null ? "" : parent.getString("billno");
                int seq = entry.getInt("seq");
                DynamicObject dynamicObject = configCode = entry.get("entryconfiguredcode") == null ? null : entry.getDynamicObject("entryconfiguredcode");
                if (configCode != null) {
                    configCodeSet.add(configCode.getPkValue());
                } else {
                    configCodeSet.add(0L);
                }
                if (configCodeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u7ec4\u4ef6\u914d\u7f6e\u53f7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject2 = bomreversion = entry.get("bomreversion") == null ? null : entry.getDynamicObject("bomreversion");
                if (bomreversion != null) {
                    bomreversionSet.add(bomreversion.getPkValue());
                } else {
                    bomreversionSet.add(0L);
                }
                if (bomreversionSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201cBOM\u7248\u672c\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String batchNo = entry.get("batchno") == null ? "" : entry.getString("batchno");
                batchNoSet.add(batchNo);
                if (batchNoSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u6279\u53f7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String qtyType = entry.get("qtytype") == null ? "" : entry.getString("qtytype");
                qtyTypeSet.add(qtyType);
                if (qtyTypeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u7528\u91cf\u7c7b\u578b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                BigDecimal useratio = entry.get("useratio") == null ? BigDecimal.ZERO : entry.getBigDecimal("useratio");
                useratioSet.add(useratio);
                if (useratioSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u4f7f\u7528\u6bd4\u4f8b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_108", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                boolean rework = entry.get("rework") == null ? false : entry.getBoolean("rework");
                reworkSet.add(rework);
                if (reworkSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u8fd4\u5de5\u201d\u6807\u8bc6\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                BigDecimal qtynumerator = entry.get("qtynumerator") == null ? BigDecimal.ZERO : entry.getBigDecimal("qtynumerator");
                qtynumeratorSet.add(qtynumerator);
                if (qtynumeratorSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5206\u5b50\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                BigDecimal qtydenominator = entry.get("qtydenominator") == null ? BigDecimal.ZERO : entry.getBigDecimal("qtydenominator");
                qtydenominatorSet.add(qtydenominator);
                if (qtydenominatorSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5206\u6bcd\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String wastformula = entry.get("wastagerateformula") == null ? "" : entry.getString("wastagerateformula");
                wastformulaSet.add(wastformula);
                if (wastformulaSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u635f\u8017\u8ba1\u7b97\u516c\u5f0f\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                BigDecimal fixscrap = entry.get("fixscrap") == null ? BigDecimal.ZERO : entry.getBigDecimal("fixscrap");
                fixscrapSet.add(fixscrap);
                if (fixscrapSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u56fa\u5b9a\u635f\u8017\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String supplymode = entry.get("supplymode") == null ? "" : entry.getString("supplymode");
                supplymodeSet.add(supplymode);
                if (supplymodeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u8d27\u4e3b\u7c7b\u578b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject3 = supplier = entry.get("supplierid") == null ? null : entry.getDynamicObject("supplierid");
                if (supplier != null) {
                    supplierSet.add(supplier.getPkValue());
                } else {
                    supplierSet.add(0L);
                }
                if (supplierSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u8d27\u4e3b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_13", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject4 = supplyorg = entry.get("supplyorgid") == null ? null : entry.getDynamicObject("supplyorgid");
                if (supplyorg != null) {
                    supplyorgSet.add(supplyorg.getPkValue());
                } else {
                    supplyorgSet.add(0L);
                }
                if (supplyorgSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u4f9b\u8d27\u7ec4\u7ec7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_14", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject5 = warehouse = entry.get("warehouseid") == null ? null : entry.getDynamicObject("warehouseid");
                if (warehouse != null) {
                    warehouseSet.add(warehouse.getPkValue());
                } else {
                    warehouseSet.add(0L);
                }
                if (warehouseSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u4f9b\u8d27\u4ed3\u5e93\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_15", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject6 = location = entry.get("location") == null ? null : entry.getDynamicObject("location");
                if (location != null) {
                    locationSet.add(location.getPkValue());
                } else {
                    locationSet.add(0L);
                }
                if (locationSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u4f9b\u8d27\u4ed3\u4f4d\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_16", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                boolean isstockallot = entry.get("isstockallot") == null ? false : entry.getBoolean("isstockallot");
                isstockallotSet.add(isstockallot);
                if (isstockallotSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5907\u6599\u8c03\u62e8\u201d\u6807\u8bc6\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_17", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject7 = outorgunit = entry.get("outorgunitid") == null ? null : entry.getDynamicObject("outorgunitid");
                if (outorgunit != null) {
                    outorgunitSet.add(outorgunit.getPkValue());
                } else {
                    outorgunitSet.add(0L);
                }
                if (outorgunitSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u8c03\u51fa\u7ec4\u7ec7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_18", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject8 = outWarehouse = entry.get("outwarehouseid") == null ? null : entry.getDynamicObject("outwarehouseid");
                if (outWarehouse != null) {
                    outWarehouseSet.add(outWarehouse.getPkValue());
                } else {
                    outWarehouseSet.add(0L);
                }
                if (outWarehouseSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u8c03\u51fa\u4ed3\u5e93\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_19", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject9 = outlocation = entry.get("outlocation") == null ? null : entry.getDynamicObject("outlocation");
                if (outlocation != null) {
                    outlocationSet.add(outlocation.getPkValue());
                } else {
                    outlocationSet.add(0L);
                }
                if (outlocationSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u8c03\u51fa\u4ed3\u4f4d\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_20", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String issuemode = entry.get("issuemode") == null ? "" : entry.getString("issuemode");
                issuemodeSet.add(issuemode);
                if (issuemodeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u9886\u9001\u6599\u65b9\u5f0f\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_21", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                boolean isbulkmaterial = entry.get("isbulkmaterial") == null ? false : entry.getBoolean("isbulkmaterial");
                isbulkmaterialSet.add(isbulkmaterial);
                if (isbulkmaterialSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u6563\u88c5\u7269\u6599\u201d\u6807\u8bc6\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_22", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String isbackflush = entry.get("isbackflush") == null ? "" : entry.getString("isbackflush");
                isbackflushSet.add(isbackflush);
                if (isbackflushSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5012\u51b2\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_23", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String backflushtime = entry.get("backflushtime") == null ? "" : entry.getString("backflushtime");
                backflushtimeSet.add(backflushtime);
                if (backflushtimeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5012\u51b2\u65f6\u673a\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_24", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                boolean iskeypart = entry.get("iskeypart") == null ? false : entry.getBoolean("iskeypart");
                iskeypartSet.add(iskeypart);
                if (iskeypartSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5173\u952e\u4ef6\u201d\u6807\u8bc6\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_25", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String overissuecontrl = entry.get("overissuecontrl") == null ? "" : entry.getString("overissuecontrl");
                overissuecontrlSet.add(overissuecontrl);
                if (overissuecontrlSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u8d85\u53d1\u63a7\u5236\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_26", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                BigDecimal issinhighlimit = entry.get("issinhighlimit") == null ? BigDecimal.ZERO : entry.getBigDecimal("issinhighlimit");
                issinhighlimitSet.add(issinhighlimit);
                if (issinhighlimitSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u9886\u6599\u4e0a\u9650\u5141\u5dee\uff08%\uff09\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_27", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                BigDecimal issinlowlimit = entry.get("issinlowlimit") == null ? BigDecimal.ZERO : entry.getBigDecimal("issinlowlimit");
                issinlowlimitSet.add(issinlowlimit);
                if (issinlowlimitSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u9886\u6599\u4e0b\u9650\u5141\u5dee\uff08%\uff09\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_28", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                BigDecimal leadtime = entry.get("leadtime") == null ? BigDecimal.ZERO : entry.getBigDecimal("leadtime");
                leadtimeSet.add(leadtime);
                if (leadtimeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u63d0\u524d\u671f\u504f\u7f6e\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_29", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                Date demanddate = entry.get("demanddate") == null ? date : entry.getDate("demanddate");
                String dateStr = TimeServiceHelper.formatDate((Date)demanddate);
                demanddateSet.add(dateStr);
                if (demanddateSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u9700\u6c42\u65f6\u95f4\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_30", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject10 = replaceplan = entry.get("replaceplan") == null ? null : entry.getDynamicObject("replaceplan");
                if (replaceplan != null) {
                    replaceplanSet.add(replaceplan.getPkValue());
                } else {
                    replaceplanSet.add(0L);
                }
                if (replaceplanSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_81", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                int priority = entry.get("priority") == null ? 0 : entry.getInt("priority");
                prioritySet.add(priority);
                if (prioritySet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u66ff\u4ee3\u4f18\u5148\u7ea7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_32", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                boolean ismainreplace = entry.get("ismainreplace") == null ? false : entry.getBoolean("ismainreplace");
                ismainreplaceSet.add(ismainreplace);
                if (ismainreplaceSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u66ff\u4ee3\u4e3b\u6599\u201d\u6807\u8bc6\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_33", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String oprno = entry.get("oprno") == null ? "" : entry.getString("oprno");
                oprnoSet.add(oprno);
                if (oprnoSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u5931\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5de5\u5e8f\u53f7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_82", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
                }
                String processseq = entry.get("processseq") == null ? "" : entry.getString("processseq");
                processseqSet.add(processseq);
                if (processseqSet.size() <= 1) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5de5\u5e8f\u5e8f\u5217\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_83", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), seq));
            }
        }
    }

    private static void checkHeadFields(Set<Object> orgSet, Set<Object> billTypeSet, Set<String> billStatusSet, Set<Object> transacationSet, Set<Object> productSet, Set<Object> configCodeSet, Set<Object> trackNumberCodeSet, Set<Object> deptOrgSet, Set<Object> auxUnitSet, Set<Object> bomSet, Set<Object> processRouteSet, DynamicObject stock, String billNo) {
        DynamicObject processroute;
        DynamicObject bom;
        DynamicObject auxUnit;
        DynamicObject deptOrg;
        DynamicObject tracknumber;
        DynamicObject configCode;
        DynamicObject product;
        DynamicObject transaction;
        DynamicObject billType;
        DynamicObject orgObject;
        DynamicObject dynamicObject = orgObject = stock.get("org") == null ? null : stock.getDynamicObject("org");
        if (orgObject != null) {
            orgSet.add(orgObject.getPkValue());
        } else {
            orgSet.add(0L);
        }
        if (orgSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_34", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject2 = billType = stock.get("billtype") == null ? null : stock.getDynamicObject("billtype");
        if (billType != null) {
            billTypeSet.add(billType.getPkValue());
        } else {
            billTypeSet.add(0L);
        }
        if (billTypeSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201c\u5355\u636e\u7c7b\u578b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_35", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        String billStatus = stock.get("billstatus") == null ? "" : stock.getString("billstatus");
        billStatusSet.add(billStatus);
        if (billStatusSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201c\u5355\u636e\u72b6\u6001\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_36", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject3 = transaction = stock.get("transactiontypeid") == null ? null : stock.getDynamicObject("transactiontypeid");
        if (transaction != null) {
            transacationSet.add(transaction.getPkValue());
        } else {
            transacationSet.add(0L);
        }
        if (transacationSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201c\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_37", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject4 = product = stock.get("productid") == null ? null : stock.getDynamicObject("productid");
        if (product != null) {
            productSet.add(product.getPkValue());
        } else {
            productSet.add(0L);
        }
        if (productSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_38", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject5 = configCode = stock.get("configuredcode") == null ? null : stock.getDynamicObject("configuredcode");
        if (configCode != null) {
            configCodeSet.add(configCode.getPkValue());
        } else {
            configCodeSet.add(0L);
        }
        if (configCodeSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201c\u4ea7\u54c1\u914d\u7f6e\u53f7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_39", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject6 = tracknumber = stock.get("tracknumber") == null ? null : stock.getDynamicObject("tracknumber");
        if (tracknumber != null) {
            trackNumberCodeSet.add(tracknumber.getPkValue());
        } else {
            trackNumberCodeSet.add(0L);
        }
        if (trackNumberCodeSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201c\u8ddf\u8e2a\u53f7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_40", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject7 = deptOrg = stock.get("mftdeptorgid") == null ? null : stock.getDynamicObject("mftdeptorgid");
        if (deptOrg != null) {
            deptOrgSet.add(deptOrg.getPkValue());
        } else {
            deptOrgSet.add(0L);
        }
        if (deptOrgSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201c\u751f\u4ea7\u90e8\u95e8\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_41", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject8 = auxUnit = stock.get("billauxunit") == null ? null : stock.getDynamicObject("billauxunit");
        if (auxUnit != null) {
            auxUnitSet.add(auxUnit.getPkValue());
        } else {
            auxUnitSet.add(0L);
        }
        if (auxUnitSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201c\u8f85\u52a9\u5355\u4f4d\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_42", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject9 = bom = stock.get("bomid") == null ? null : stock.getDynamicObject("bomid");
        if (bom != null) {
            bomSet.add(bom.getPkValue());
        } else {
            bomSet.add(0L);
        }
        if (bomSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201cBOM\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_43", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject10 = processroute = stock.get("processroute") == null ? null : stock.getDynamicObject("processroute");
        if (processroute != null) {
            processRouteSet.add(processroute.getPkValue());
        } else {
            processRouteSet.add(0L);
        }
        if (processRouteSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5408\u5e76\u5931\u8d25\uff0c\u201c\u5de5\u827a\u8def\u7ebf\u201d\u4e0d\u4e00\u81f4\u3002", (String)"MergeOrderCheckHelper_44", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    public static void checkManuftech(DynamicObject[] manuftechs, Map<Object, String> idNoMapping) {
    }

    private static void checkProcessSeqEntry(Map<String, List<DynamicObject>> proentryMap) {
    }

    private static void checkManutechEntry(Map<String, List<DynamicObject>> entryMap) {
    }

    private static void checkManuftechHead(Set<Object> orgSet, Set<Object> billTypeSet, Set<String> planTypeSet, Set<String> billStatusSet, Set<Object> transacationSet, Set<Object> productSet, Set<Object> configCodeSet, Set<Object> trackNumberCodeSet, Set<Object> baseUnitSet, Set<Object> bomSet, Set<Object> processRouteSet, DynamicObject manuftech, String billNo) {
    }
}

