/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.ordermerge.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MergeOrderValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(MergeOrderValidator.class);

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (null == dataEntity || null == dataEntity.getDataEntity()) continue;
            DynamicObject mergeOrderBill = dataEntity.getDataEntity();
            DynamicObjectCollection srcEntrys = mergeOrderBill.getDynamicObjectCollection("srcentry");
            HashSet<Long> orderids = new HashSet<Long>(srcEntrys.size());
            for (DynamicObject srcEntry : srcEntrys) {
                long orderid = srcEntry.get("orderid") == null ? 0L : Long.parseLong(srcEntry.getString("orderid"));
                orderids.add(orderid);
            }
            if (orderids.size() < 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u5e76\u5de5\u5355\u539f\u5355\u5206\u5f55\u5de5\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"MergeOrderValidator_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            long mergebillId = Long.parseLong(mergeOrderBill.getPkValue().toString());
            Set orderOutResult = OrderMergeHelper.queryOrderOut(orderids);
            Map orderTechResult = OrderMergeHelper.queryTechMap(orderids);
            Set hasMergeOrders = OrderMergeHelper.queryMergeOrderOutExcept(orderids, (long)mergebillId);
            Set exisstockChange = OrderMergeHelper.queryStockChange(orderids);
            DynamicObject[] mftOrderDataMap = OrderMergeHelper.getMftOrderDataMap(orderids, (String)"pom_mftorder");
            if (mftOrderDataMap == null) {
                return;
            }
            HashSet<String> orderStatus = new HashSet<String>(orderids.size());
            HashSet<Long> orderOrg = new HashSet<Long>(orderids.size());
            HashSet<String> orderBillType = new HashSet<String>(orderids.size());
            HashSet<Long> orderTrasaction = new HashSet<Long>(orderids.size());
            for (DynamicObject orderBill : mftOrderDataMap) {
                List techBills;
                Long orderId;
                String billStatus;
                DynamicObject transactiontype;
                long pkValue = Long.parseLong(orderBill.getPkValue().toString());
                String billNo = orderBill.getString("billno");
                if (hasMergeOrders.size() > 0 && hasMergeOrders.contains(pkValue)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08%1$s\uff09\u5df2\u5b58\u5728\u5408\u5e76\u5de5\u5355\uff0c\u65e0\u6cd5\u5408\u5e76\u3002", (String)"MergeOrderValidator_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billNo));
                }
                if (exisstockChange.contains(pkValue)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08%1$s\uff09\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\uff0c\u65e0\u6cd5\u5408\u5e76\u3002", (String)"MergeOrderValidator_13", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billNo));
                }
                if ((transactiontype = orderBill.getDynamicObject("transactiontype")) != null && transactiontype.getBoolean("isinnerprocess")) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08%1$s\uff09\u7684\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u542f\u7528\u5185\u534f\u52a0\u5de5\u3002", (String)"MergeOrderValidator_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billNo));
                }
                long transactiontypePk = transactiontype == null ? 0L : Long.parseLong(transactiontype.getPkValue().toString());
                orderTrasaction.add(transactiontypePk);
                if (orderTrasaction.size() > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u5355\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e0d\u540c\uff0c\u65e0\u6cd5\u5408\u5e76\u3002", (String)"MergeOrderValidator_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
                long orgPk = orderBill.getDynamicObject("org") == null ? 0L : Long.parseLong(orderBill.getDynamicObject("org").getPkValue().toString());
                orderOrg.add(orgPk);
                if (orderOrg.size() > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u5355\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u76f8\u540c\uff0c\u65e0\u6cd5\u751f\u6210\u5408\u5e76\u5de5\u5355\u3002", (String)"MergeOrderValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
                String billType = orderBill.getString("billtype");
                orderBillType.add(billType);
                if (orderBillType.size() > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u5355\u5355\u636e\u7c7b\u578b\u4e0d\u76f8\u540c\uff0c\u65e0\u6cd5\u751f\u6210\u5408\u5e76\u5de5\u5355\u3002", (String)"MergeOrderValidator_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)"D", (CharSequence)(billStatus = orderBill.getString("billstatus")))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u5df2\u4f5c\u5e9f\uff0c\u53ea\u80fd\u5408\u5e76\u6682\u5b58\u3001\u63d0\u4ea4\u3001\u5ba1\u6838\u72b6\u6001\u7684\u5de5\u5355\u3002", (String)"MergeOrderValidator_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billNo));
                }
                orderStatus.add(billStatus);
                if (orderStatus.size() > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u5355\u72b6\u6001\u4e0d\u76f8\u540c\uff0c\u65e0\u6cd5\u751f\u6210\u5408\u5e76\u5de5\u5355\u3002", (String)"MergeOrderValidator_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
                if (orderOutResult.contains(orderId = Long.valueOf(Long.parseLong(orderBill.getPkValue().toString())))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u5b58\u5728\u5ba1\u6838\u72b6\u6001\u7684\u751f\u4ea7\u9886\u6599\u5355\u3001\u751f\u4ea7\u9000\u6599\u5355\u6216\u8005\u751f\u4ea7\u8865\u6599\u5355\uff0c\u65e0\u6cd5\u5408\u5e76\u3002", (String)"MergeOrderValidator_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billNo));
                }
                if (transactiontype != null && transactiontype.getBoolean("isprocedure") && (techBills = (List)orderTechResult.get(orderId)) != null && techBills.size() > 0) {
                    for (DynamicObject techBill : techBills) {
                        if (techBill.get("oprentryentity") == null) continue;
                        DynamicObjectCollection oprentryentitys = techBill.getDynamicObjectCollection("oprentryentity");
                        boolean flag = false;
                        for (DynamicObject oprentryentity : oprentryentitys) {
                            String oprstatus = oprentryentity.getString("oprstatus");
                            if (StringUtils.equals((CharSequence)"A", (CharSequence)oprstatus) || StringUtils.equals((CharSequence)"B", (CharSequence)oprstatus) || StringUtils.equals((CharSequence)"C", (CharSequence)oprstatus)) continue;
                            flag = true;
                        }
                        if (!flag) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u7684\u4e8b\u52a1\u7c7b\u578b\u542f\u7528\u5de5\u5e8f\u7ba1\u7406\uff0c\u5de5\u5e8f\u72b6\u6001\u4e0d\u4e3a\u201c\u521b\u5efa\u201d\u3001\u201c\u8ba1\u5212\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u65f6\uff0c\u65e0\u6cd5\u5408\u5e76\u3002", (String)"MergeOrderValidator_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billNo));
                    }
                }
                DynamicObjectCollection orderEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject orderEntry : orderEntrys) {
                    int seq = orderEntry.getInt("seq");
                    String producttype = orderEntry.getString("producttype");
                    String taskstatus = orderEntry.getString("taskstatus");
                    if (!StringUtils.equals((CharSequence)"A", (CharSequence)taskstatus)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u7b2c%2$s\u884c\u5206\u5f55\u4efb\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u672a\u5f00\u5de5\u201d\u3002", (String)"MergeOrderValidator_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billNo, seq));
                    }
                    String planstatus = orderEntry.getString("planstatus");
                    String bizstatus = orderEntry.getString("bizstatus");
                    if (StringUtils.equals((CharSequence)bizstatus, (CharSequence)"A")) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u7b2c%2$s\u884c\u5206\u5f55\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u6b63\u5e38\u201d\u3002", (String)"MergeOrderValidator_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billNo, seq));
                }
            }
        }
    }
}

