/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.prdsel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class FeatureDefinitionSaveVal
extends AbstractValidator {
    private static String REGEX = "^(\\+)?\\d+(\\.\\d+)?$";
    private static String LOSS_REGEX = "^(-?\\d+)(\\.\\d+)?$";
    private static final String AUXPROP = "auxprop";
    private static final String ENTRY_QYTY_NUMBERATOR = "entryqtynumerator";
    private static final String ENTRY_QYTY_DENOMINATOR = "entryqtydenominator";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        this.featureSaveValidate(dataEntities);
        DynamicObjectCollection collection = dataEntities[0].getDataEntity().getDynamicObjectCollection("treeentryentity");
        ArrayList<Long> list = new ArrayList<Long>(10);
        for (DynamicObject entryObj : collection) {
            boolean isDefualt = entryObj.getBoolean("isdefaultvalue");
            if (isDefualt) {
                list.add(Long.parseLong(entryObj.getPkValue().toString()));
            }
            if (list.size() <= 1) continue;
            this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u540c\u4e00\u5c42\u7ea7\u7684\u7279\u5f81\u503c\u4ec5\u5141\u8bb8\u4e00\u884c\u5206\u5f55\u8bbe\u7f6e\u4e3a\u9996\u9009\u3002", (String)"FeatureDefinitionSaveVal_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.uniquenessVal(dataEntities[0])) {
            this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u7279\u5f81\u503c\u5e94\u552f\u4e00\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199\u3002", (String)"FeatureDefinitionSaveVal_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
    }

    private void featureSaveValidate(ExtendedDataEntity[] dataEntities) {
        String regex = "^(?![0-9]+$)(?![_]+$)[A-Za-z0-9_-]+$";
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i].getDataEntity();
            String number = dataEntity.getString("number");
            if (!Pattern.matches(regex, number)) {
                this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u53ea\u53ef\u4ee5\u8f93\u5165\u5b57\u6bcd\u3001\u963f\u62c9\u4f2f\u6570\u5b57+\u4e0b\u5212\u7ebf\u201c_\u201d+\u201c-\u201d\uff0c\u4e14\u4e0d\u80fd\u8f93\u5165\u7eaf\u6570\u5b57\u3001\u7eaf\u4e0b\u5212\u7ebf\u6216\u7eaf\u201c-\u201d\u3002", (String)"FeatureDefinitionSaveVal_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection configEntryDOC = dataEntity.getDynamicObjectCollection("configentity");
            this.configEntryValidata(dataEntities[i], configEntryDOC, "featurerule");
            DynamicObjectCollection treeEntryDOC = dataEntity.getDynamicObjectCollection("treeentryentity");
            this.featureValueValidata(dataEntities[i], treeEntryDOC);
        }
    }

    private void featureValueValidata(ExtendedDataEntity dataEntity, DynamicObjectCollection featureValues) {
        String fieldName;
        if (featureValues == null) {
            return;
        }
        DynamicObject featureDef = dataEntity.getDataEntity();
        String number = featureDef.getString("number");
        String featureType = featureDef.getString("featuretype");
        int len = featureDef.getInt("length");
        int precision = featureDef.getInt("precision");
        boolean isAllowmulValue = featureDef.getBoolean("isallowmulvalue");
        boolean isAllownegative = featureDef.getBoolean("isallownegative");
        if ("A".equals(featureType)) {
            if (len <= 0 || len > 100) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u5b57\u7b26\uff0c\u957f\u5ea6\u5fc5\u987b\u6307\u5b9a\u4e14\u8303\u56f4\u5728(0,100]\u4e4b\u95f4\u3002", (String)"FeatureDefinitionSaveVal_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number));
            }
        } else if ("B".equals(featureType) && (precision < 0 || precision > 10)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u6570\u503c\u65f6\uff0c\u7cbe\u5ea6\u5fc5\u987b\u6307\u5b9a\u4e14\u8303\u56f4\u5728[0,10]\u4e4b\u95f4\u7684\u6574\u6570\u3002", (String)"FeatureDefinitionSaveVal_21", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number));
        }
        if (AUXPROP.equals(fieldName = featureDef.getString("fieldname")) && !"C".equals(featureType)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u5173\u8054\u5b57\u6bb5\u4e3a\u8f85\u52a9\u5c5e\u6027\uff0c\u7279\u5f81\u503c\u7c7b\u578b\u5fc5\u987b\u4e3a\u8f85\u52a9\u5c5e\u6027\u3002", (String)"FeatureDefinitionSaveVal_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number));
        } else if ((ENTRY_QYTY_NUMBERATOR.equals(fieldName) || ENTRY_QYTY_DENOMINATOR.equals(fieldName)) && !"B".equals(featureType)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u5173\u8054\u5b57\u6bb5\u4e3a\u7528\u91cf\u5206\u5b50\u6216\u7528\u91cf\u5206\u6bcd\uff0c\u7279\u5f81\u503c\u7c7b\u578b\u5fc5\u987b\u4e3a\u6570\u503c\u3002", (String)"FeatureDefinitionSaveVal_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number));
        }
        boolean isDefaultV = false;
        for (DynamicObject featureValRow : featureValues) {
            if (featureValRow == null) continue;
            String entryValue = featureValRow.getString("entryvalue");
            String entryValueName = featureValRow.getString("entryvaluename");
            int seq = featureValRow.getInt("seq");
            boolean isDefaultValue = featureValRow.getBoolean("isdefaultvalue");
            if (isDefaultValue) {
                if (!isDefaultV) {
                    isDefaultV = true;
                } else {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u201c\u7279\u5f81\u503c\u201d\u53ea\u80fd\u6709\u4e00\u4e2a\u9996\u9009\u3002", (String)"FeatureDefinitionSaveVal_18", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, seq));
                }
            }
            if ("A".equals(featureType)) {
                if (StringUtils.isEmpty((CharSequence)entryValue) || StringUtils.isEmpty((CharSequence)entryValueName)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u201c\u7279\u5f81\u503c\u7c7b\u578b\u201d\u4e3a\u5b57\u7b26\u65f6\uff0c\u7279\u5f81\u503c\u5206\u5f55\u7b2c%2$s\u884c\u201c\u7279\u5f81\u503c\u201d\u548c\u201c\u7279\u5f81\u503c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeatureDefinitionSaveVal_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, seq));
                } else if (entryValue.length() > len) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u201c\u7279\u5f81\u503c\u7c7b\u578b\u201d\u4e3a\u5b57\u7b26\uff0c\u7279\u5f81\u503c\u5206\u5f55\u7b2c%2$s\u884c\u201c\u7279\u5f81\u503c\u201d\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7%3$s\u3002", (String)"FeatureDefinitionSaveVal_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, seq, len));
                }
            } else if ("B".equals(featureType)) {
                if (StringUtils.isNotEmpty((CharSequence)entryValueName)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u6570\u503c\uff0c\u7279\u5f81\u503c\u5206\u5f55\u7b2c%2$s\u884c\u201c\u7279\u5f81\u503c\u540d\u79f0\u201d\u4e0d\u53ef\u5f55\u5165\u3002", (String)"FeatureDefinitionSaveVal_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, seq));
                }
                if (StringUtils.isNotEmpty((CharSequence)entryValue)) {
                    String sub;
                    if (isAllownegative && !Pattern.matches(LOSS_REGEX, entryValue)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u6570\u503c\uff0c\u7cbe\u5ea6\u4e3a%2$s\uff1b\u8bf7\u6ce8\u610f\uff0c\u7279\u5f81\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff1b\u7279\u5f81\u503c\u5206\u5f55\u7b2c%3$s\u884c\u201c\u7279\u5f81\u503c\u201d\u7cbe\u5ea6\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FeatureDefinitionSaveVal_22", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, precision, seq));
                        continue;
                    }
                    if (!isAllownegative && !Pattern.matches(REGEX, entryValue)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u6570\u503c\uff0c\u7cbe\u5ea6\u4e3a%2$s\uff1b\u8bf7\u6ce8\u610f\uff0c\u7279\u5f81\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff1b\u7279\u5f81\u503c\u5206\u5f55\u7b2c%3$s\u884c\u201c\u7279\u5f81\u503c\u201d\u7cbe\u5ea6\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FeatureDefinitionSaveVal_23", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, precision, seq));
                        continue;
                    }
                    String string = sub = entryValue.indexOf(".") > 0 ? entryValue.substring(entryValue.indexOf(".") + 1, entryValue.length()) : "";
                    if (StringUtils.isNotEmpty((CharSequence)sub) && sub.length() > precision) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u6570\u503c\u4e14\u7cbe\u5ea6\u4e3a%2$s\uff0c\u7279\u5f81\u503c\u5206\u5f55\u7b2c%3$s\u884c\u201c\u7279\u5f81\u503c\u201d\u7cbe\u5ea6\u6709\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u201c\u7279\u5f81\u503c\u201d\u3002", (String)"FeatureDefinitionSaveVal_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, precision, seq));
                    } else if (StringUtils.isEmpty((CharSequence)sub) && precision > 0 || StringUtils.isNotEmpty((CharSequence)sub) && sub.length() < precision) {
                        BigDecimal value = new BigDecimal(entryValue);
                        BigDecimal scaleValue = value.setScale(precision);
                        featureValRow.set("entryvalue", (Object)scaleValue);
                    }
                } else {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u7c7b\u578b\u4e3a\u6570\u503c\uff0c\u7cbe\u5ea6\u4e3a%2$s\uff1b\u7279\u5f81\u503c\u5206\u5f55\u7b2c%3$s\u884c\u201c\u7279\u5f81\u503c\u201d\u5fc5\u987b\u4e3a\u6570\u503c\u3002", (String)"FeatureDefinitionSaveVal_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, precision, seq));
                }
            }
            if (!StringUtils.isEmpty((CharSequence)entryValue.trim())) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u5b9a\u4e49\u201c%1$s\u201d\u7684\u7279\u5f81\u503c\u5206\u5f55\uff0c\u7279\u5f81\u503c\u5206\u5f55\u7b2c%2$s\u884c\u201c\u7279\u5f81\u503c\u201d\u5fc5\u5f55\u3002", (String)"FeatureDefinitionSaveVal_19", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, seq));
        }
    }

    private void configEntryValidata(ExtendedDataEntity dataEntity, DynamicObjectCollection configEntryDOC, String fieldName) {
        if (configEntryDOC == null) {
            return;
        }
        HashSet<Long> ruleSet = new HashSet<Long>(4);
        for (DynamicObject configDO : configEntryDOC) {
            DynamicObject featureRuleDO;
            if (configDO == null || (featureRuleDO = configDO.getDynamicObject(fieldName)) == null) continue;
            long featureRulePK = featureRuleDO.getLong("id");
            int ruleSeq = configDO.getInt("seq");
            String ruleNumber = featureRuleDO.getString("number");
            if (ruleSet.contains(featureRulePK)) {
                if (StringUtils.equals((CharSequence)"featurerule", (CharSequence)fieldName)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u89c4\u5219\u7b2c%1$s\u884c\u4e2d\u7684\u914d\u7f6e\u89c4\u5219%2$s\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FeatureDefinitionSaveVal_14", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ruleSeq, ruleNumber));
                    continue;
                }
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7279\u5f81\u503c\u7b2c%1$s\u884c\u4e2d\u7684\u914d\u7f6e\u89c4\u5219%2$s\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FeatureDefinitionSaveVal_15", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ruleSeq, ruleNumber));
                continue;
            }
            ruleSet.add(featureRulePK);
        }
    }

    private boolean uniquenessVal(ExtendedDataEntity dataEntitie) {
        boolean flag = true;
        DynamicObjectCollection collection = dataEntitie.getDataEntity().getDynamicObjectCollection("treeentryentity");
        String featureType = dataEntitie.getDataEntity().getString("featuretype");
        if (collection == null || collection.isEmpty()) {
            return flag;
        }
        HashSet<Object> valSet = new HashSet<Object>();
        for (DynamicObject e : collection) {
            Object entryVal = e.get("entryvalue");
            if (StringUtils.equals((CharSequence)"A", (CharSequence)featureType) && entryVal != null) {
                entryVal = entryVal.toString().toLowerCase();
            }
            if (valSet.contains(entryVal)) {
                flag = false;
                break;
            }
            valSet.add(entryVal);
        }
        return flag;
    }
}

