/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.proConfig;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class ConfigmatrixVal
extends AbstractValidator {
    private static final String ENTRY_FEATURE = "featureentry";
    private static final String ENTRY_MATRIX = "matrixentry";
    private static final String NUMBER = "number";
    private static final String ENTRY_ENTRYKEY = "entrykey";
    private static final String ENTRY_MATRIX_GROUP = "group";
    private static final String ENTRY_MATRIX_FEATURVALUEID = "featurevalueid";
    private static final String ENTRY_MATRIX_FEATURVALUE = "featurevalue";
    private static final String ENTRY_MATRIX_FEATURNAME = "featurevaluename";
    private static final String ENTRY_MATRIX_FEATURCOLID = "featurecolumnid";
    private static final String ENTRY_MATRIX_COLUMNNAME = "columnname";

    public void validate() {
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        switch (operateKey) {
            case "save": {
                this.saveVal(dataEntities);
                break;
            }
            case "submit": {
                this.saveVal(dataEntities);
                this.submitVal(dataEntities);
            }
        }
    }

    private void submitVal(ExtendedDataEntity[] dataEntities) {
        DynamicObject dataEntity;
        if (dataEntities == null) {
            return;
        }
        for (int i = 0; i < dataEntities.length && (dataEntity = dataEntities[i].getDataEntity()) != null; ++i) {
            String number = dataEntity.getString(NUMBER);
            DynamicObjectCollection featureEntryDOC = dataEntity.getDynamicObjectCollection(ENTRY_FEATURE);
            DynamicObjectCollection matrixEntryDOC = dataEntity.getDynamicObjectCollection(ENTRY_MATRIX);
            if (featureEntryDOC != null && !featureEntryDOC.isEmpty() || matrixEntryDOC != null && !matrixEntryDOC.isEmpty()) continue;
            this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u77e9\u9635\u201c%1$s\u201d\u7684\u201c\u7279\u5f81\u201d\u6216\u201c\u914d\u7f6e\u77e9\u9635\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConfigmatrixVal_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number));
            break;
        }
    }

    private void saveVal(ExtendedDataEntity[] dataEntities) {
        DynamicObject dataEntity;
        if (dataEntities == null) {
            return;
        }
        for (int i = 0; i < dataEntities.length && (dataEntity = dataEntities[i].getDataEntity()) != null; ++i) {
            DynamicObjectCollection matrixEntryDOC;
            String number = dataEntity.getString(NUMBER);
            DynamicObjectCollection featureEntryDOC = dataEntity.getDynamicObjectCollection(ENTRY_FEATURE);
            if ((featureEntryDOC == null || this.checkEntryKey(dataEntities[i], number, featureEntryDOC)) && (matrixEntryDOC = dataEntity.getDynamicObjectCollection(ENTRY_MATRIX)) != null && this.checkEntryMatrixVal(dataEntities[i], number, matrixEntryDOC)) continue;
        }
    }

    private boolean checkEntryMatrixVal(ExtendedDataEntity dataEntity, String number, DynamicObjectCollection matrixEntryDOC) {
        boolean checkFlag = true;
        if (matrixEntryDOC == null) {
            return checkFlag;
        }
        HashMap<String, Map> groupValMap = new HashMap<String, Map>(8);
        for (DynamicObject matrixEntryDO : matrixEntryDOC) {
            String group = matrixEntryDO.getString(ENTRY_MATRIX_GROUP);
            Map columnMap = groupValMap.getOrDefault(group, new HashMap(8));
            DynamicObject featureColumDO = matrixEntryDO.getDynamicObject(ENTRY_MATRIX_FEATURCOLID);
            Long featureColumnID = 0L;
            String featureType = "";
            if (featureColumDO != null) {
                featureColumnID = featureColumDO.getLong("id");
                featureType = featureColumDO.getString("featuretype");
            }
            Long featureValueID = matrixEntryDO.getLong(ENTRY_MATRIX_FEATURVALUEID);
            String featureValue = matrixEntryDO.getString(ENTRY_MATRIX_FEATURVALUE);
            if (StringUtils.equals((CharSequence)"A", (CharSequence)featureType) && StringUtils.isNotEmpty((CharSequence)featureValue)) {
                featureValue = featureValue.toLowerCase();
            }
            String featureName = matrixEntryDO.getString(ENTRY_MATRIX_FEATURNAME);
            String featureColumn = matrixEntryDO.getString(ENTRY_MATRIX_COLUMNNAME);
            Set valueSet = columnMap.getOrDefault(featureColumnID, new HashSet(8));
            if (StringUtils.isNotEmpty((CharSequence)featureValue) && valueSet.contains(featureValue)) {
                if (!StringUtils.equals((CharSequence)"A", (CharSequence)featureType)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u77e9\u9635\u201c%1$s\u201d\u7684\u77e9\u9635\u5217\u201c%2$s\u201d\u4e2d\u7279\u5f81\u503c\u201c%3$s\u201d\u4e0d\u53ef\u91cd\u590d\u3002", (String)"ConfigmatrixVal_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, featureColumn, matrixEntryDO.getString(ENTRY_MATRIX_FEATURVALUE)));
                } else {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u77e9\u9635\u201c%1$s\u201d\u7684\u77e9\u9635\u5217\u201c%2$s\u201d\u4e2d\u7279\u5f81\u503c\u201c%3$s\u201d\u4e0d\u53ef\u91cd\u590d\uff08\u4e0d\u533a\u5206\u5927\u5c0f\u5199\uff09\u3002", (String)"ConfigmatrixVal_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, featureColumn, matrixEntryDO.getString(ENTRY_MATRIX_FEATURVALUE)));
                }
                checkFlag = false;
                break;
            }
            valueSet.add(featureValue);
            columnMap.put(featureColumnID, valueSet);
            groupValMap.put(group, columnMap);
        }
        return checkFlag;
    }

    private boolean checkEntryKey(ExtendedDataEntity dataEntity, String number, DynamicObjectCollection featureEntryDOC) {
        boolean falg = true;
        if (featureEntryDOC == null || featureEntryDOC.isEmpty()) {
            return falg;
        }
        int count = 0;
        for (DynamicObject featureDO : featureEntryDOC) {
            boolean entryKey;
            if (featureDO == null || !(entryKey = featureDO.getBoolean(ENTRY_ENTRYKEY))) continue;
            ++count;
        }
        if (count == 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u77e9\u9635\u201c%1$s\u201d\u7684\u7279\u5f81\u4e2d\u9700\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u5173\u952e\u7279\u5f81\u3002", (String)"ConfigmatrixVal_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number));
            falg = false;
        }
        return falg;
    }
}

